/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.engine.core.EngineLauncher;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagerServlet
extends HttpServlet {
    private static final long serialVersionUID = -524782026223202293L;
    private static Log _logger;
    private EngineLauncher _oEngineLauncher;

    public void init(ServletConfig oServletConfig) throws ServletException {
        try {
            super.init(oServletConfig);
            _logger = LogFactory.getLog(ManagerServlet.class);
            this._oEngineLauncher = new EngineLauncher();
        }
        catch (Exception e) {
            _logger.fatal((Object)"Initialization failed", (Throwable)e);
        }
    }

    public void service(HttpServletRequest oRequest, HttpServletResponse oResponse) throws ServletException, IOException {
        block15: {
            try {
                Properties pConfig = this.cloneConfigurationFromRequest(oRequest);
                String sDo = oRequest.getParameter("do");
                if (sDo == null) {
                    String sGet = oRequest.getParameter("get");
                    if (sGet == null) {
                        _logger.error((Object)("Invalid request sent from IP: " + oRequest.getRemoteAddr()));
                        oResponse.sendError(400);
                    } else {
                        StringBuffer sbWarning = new StringBuffer("Invalid request with name: ");
                        sbWarning.append(sGet);
                        sbWarning.append(", sent from IP: ");
                        sbWarning.append(oRequest.getRemoteAddr());
                        _logger.error((Object)sbWarning.toString());
                        oResponse.sendError(400);
                    }
                } else if (sDo.equals("restart")) {
                    _logger.info((Object)("Performing restart request sent from IP: " + oRequest.getRemoteAddr()));
                    this._oEngineLauncher.restart(pConfig);
                } else if (sDo.equals("stop")) {
                    _logger.info((Object)("Performing stop request sent from IP: " + oRequest.getRemoteAddr()));
                    this._oEngineLauncher.stop();
                } else if (sDo.equals("start")) {
                    _logger.info((Object)("Performing start request sent from IP: " + oRequest.getRemoteAddr()));
                    this._oEngineLauncher.start(pConfig);
                } else {
                    StringBuffer sbWarning = new StringBuffer("Invalid request with name: ");
                    sbWarning.append(sDo);
                    sbWarning.append(", sent from IP: ");
                    sbWarning.append(oRequest.getRemoteAddr());
                    _logger.error((Object)sbWarning.toString());
                    oResponse.sendError(400);
                }
                if (!oResponse.isCommitted()) {
                    oResponse.sendError(200);
                }
            }
            catch (OAException e) {
                _logger.error((Object)"Error processing request", (Throwable)e);
                _logger.debug((Object)"try stopping the server");
                this._oEngineLauncher.stop();
                if (!oResponse.isCommitted()) {
                    oResponse.sendError(500);
                }
            }
            catch (Exception e) {
                _logger.fatal((Object)"Internal error", (Throwable)e);
                _logger.debug((Object)"try stopping the server");
                this._oEngineLauncher.stop();
                if (oResponse.isCommitted()) break block15;
                oResponse.sendError(500);
            }
        }
    }

    public void destroy() {
        try {
            super.destroy();
            _logger.info((Object)"Stopped: Manager Servlet");
        }
        catch (Exception e) {
            _logger.fatal((Object)"Could not destroy Manager Servlet", (Throwable)e);
        }
    }

    private Properties cloneConfigurationFromRequest(HttpServletRequest oRequest) {
        Properties configuration = new Properties();
        Enumeration keys = oRequest.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = oRequest.getParameter(key);
            configuration.put(key, value);
        }
        return configuration;
    }
}

