/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.engine.core.EngineLauncher;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asimba.utility.filesystem.PathTranslator;

public class OAContextListener
implements ServletContextListener {
    public static final String PROPERTIES_FILENAME = "asimba.properties";
    public static final String PROPERTIES_FILENAME_PROPERTY = "asimba.properties.file";
    public static final String MP_WEBAPP_ROOT = "webapp.root";
    private EngineLauncher _oEngineLauncher;
    private static Log _logger;

    public OAContextListener() {
        try {
            _logger = LogFactory.getLog(OAContextListener.class);
            this._oEngineLauncher = new EngineLauncher();
        }
        catch (Exception e) {
            _logger.error((Object)"Internal error while creating object", (Throwable)e);
        }
    }

    public void contextInitialized(ServletContextEvent oServletContextEvent) {
        Properties pConfig = new Properties();
        try {
            URL urlProperties;
            String sWebInf;
            File fConfig;
            String sImplVersion;
            _logger.info((Object)"Starting Asimba");
            Package pCurrent = OAContextListener.class.getPackage();
            String sSpecVersion = pCurrent.getSpecificationVersion();
            if (sSpecVersion != null) {
                _logger.info((Object)("Specification-Version: " + sSpecVersion));
            }
            if ((sImplVersion = pCurrent.getImplementationVersion()) != null) {
                _logger.info((Object)("Implementation-Version: " + sImplVersion));
            }
            ServletContext oServletContext = oServletContextEvent.getServletContext();
            Enumeration enumContextAttribs = oServletContext.getInitParameterNames();
            while (enumContextAttribs.hasMoreElements()) {
                String sName = (String)enumContextAttribs.nextElement();
                pConfig.put(sName, oServletContext.getInitParameter(sName));
            }
            if (pConfig.size() > 0) {
                _logger.info((Object)("Using configuration items found in servlet context: " + pConfig));
            }
            PathTranslator.getInstance().addKey(MP_WEBAPP_ROOT, oServletContext.getRealPath(""));
            String sPropertiesFilename = System.getProperty(PROPERTIES_FILENAME_PROPERTY);
            if (null != sPropertiesFilename && !"".equals(sPropertiesFilename) && (fConfig = new File(sPropertiesFilename)).exists()) {
                _logger.info((Object)("Reading Asimba properties from " + fConfig.getAbsolutePath()));
                pConfig.putAll((Map<?, ?>)this.getProperties(fConfig));
            }
            if ((sWebInf = oServletContext.getRealPath("WEB-INF")) != null) {
                _logger.info((Object)"Cannot find path in ServletContext for WEB-INF");
                StringBuffer sbConfigFile = new StringBuffer(sWebInf);
                if (!sbConfigFile.toString().endsWith(File.separator)) {
                    sbConfigFile.append(File.separator);
                }
                sbConfigFile.append(PROPERTIES_FILENAME);
                File fConfig2 = new File(sbConfigFile.toString());
                if (fConfig2.exists()) {
                    _logger.info((Object)("Updating configuration items with the items in file: " + fConfig2.toString()));
                    pConfig.putAll((Map<?, ?>)this.getProperties(fConfig2));
                } else {
                    _logger.info((Object)("No optional configuration properties (asimba.properties) file found at: " + fConfig2.toString()));
                }
            }
            if ((urlProperties = oServletContext.getClass().getClassLoader().getResource(PROPERTIES_FILENAME)) != null) {
                String sProperties = urlProperties.getFile();
                _logger.debug((Object)("Found 'asimba.properties' file in classpath: " + sProperties));
                File fProperties = new File(sProperties);
                if (fProperties != null && fProperties.exists()) {
                    _logger.info((Object)("Updating configuration items with the items in file: " + fProperties.getAbsolutePath()));
                    pConfig.putAll((Map<?, ?>)this.getProperties(fProperties));
                } else {
                    _logger.info((Object)("Could not resolve: " + fProperties.getAbsolutePath()));
                }
            } else {
                _logger.info((Object)"No optional 'asimba.properties' configuration file found in servlet context classpath");
            }
            if (!pConfig.containsKey("configuration.handler.filename")) {
                StringBuffer sbOAConfigFile = new StringBuffer(sWebInf);
                if (!sbOAConfigFile.toString().endsWith(File.separator)) {
                    sbOAConfigFile.append(File.separator);
                }
                sbOAConfigFile.append("conf");
                sbOAConfigFile.append(File.separator);
                sbOAConfigFile.append("asimba.xml");
                File fOAConfig = new File(sbOAConfigFile.toString());
                if (fOAConfig.exists()) {
                    pConfig.put("configuration.handler.filename", sbOAConfigFile.toString());
                    _logger.info((Object)("Setting 'configuration.handler.filename' configuration property with configuration file found at: " + fOAConfig.toString()));
                }
            }
            this._oEngineLauncher.start(pConfig);
            _logger.info((Object)"Started Engine with OAContextListener");
        }
        catch (Exception e) {
            _logger.error((Object)"Can't start Engine with OAContextListener", (Throwable)e);
            _logger.debug((Object)"try stopping the server");
            this._oEngineLauncher.stop();
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        PathTranslator.getInstance().removeKey(MP_WEBAPP_ROOT);
        this._oEngineLauncher.stop();
        _logger.info((Object)"Stopped Engine with OAContextListener");
    }

    private Properties getProperties(File oFile) throws OAException {
        Properties pConfig = new Properties();
        try {
            FileInputStream oFileInputStream = new FileInputStream(oFile);
            pConfig.load(oFileInputStream);
            oFileInputStream.close();
        }
        catch (Exception e) {
            _logger.error((Object)("Can't load properties file: " + oFile.toString()), (Throwable)e);
            throw new OAException(1);
        }
        return pConfig;
    }
}

