/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.ws.security;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.crypto.CryptoException;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.crypto.factory.AbstractSigningFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;

public class OACrypto
implements Crypto {
    private AbstractSigningFactory _factory;
    private static CertificateFactory _certFactory;
    private static Log _logger;

    public OACrypto() throws OAException {
        _logger = LogFactory.getLog(OACrypto.class);
        try {
            CryptoManager manager = Engine.getInstance().getCryptoManager();
            if (manager == null) {
                _logger.warn((Object)"Could not create OACrypto, OAS cryptomanager not initialized");
                throw new OAException(49);
            }
            this._factory = manager.getSigningFactory();
            if (this._factory == null) {
                _logger.warn((Object)"Could not create OACrypto, OAS signing not enabled");
                throw new OAException(49);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.error((Object)"Could not create OACrypto, due to internal error", (Throwable)e);
            throw new OAException(1);
        }
    }

    public OACrypto(Properties properties) throws OAException {
        this();
    }

    public OACrypto(Properties properties, ClassLoader loader) throws OAException {
        this();
    }

    public OACrypto(AbstractSigningFactory factory) {
        _logger = LogFactory.getLog(OACrypto.class);
        this._factory = factory;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        try {
            String alias = this._factory.getCertificateAlias(cert);
            if (alias == null) {
                Enumeration aliases = this._factory.getAliases();
                while (alias == null & aliases.hasMoreElements()) {
                    String tAlias = (String)aliases.nextElement();
                    X509Certificate tempCert = (X509Certificate)this._factory.getCertificate(alias);
                    if (!tempCert.equals(cert)) continue;
                    alias = tAlias;
                }
            }
            return alias;
        }
        catch (CryptoException e) {
            _logger.error((Object)"Could not retrieve alias for X509 certificate", (Throwable)e);
            throw new WSSecurityException(0);
        }
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        try {
            return this._factory.getAliasForX509Cert(issuer, null);
        }
        catch (OAException e) {
            _logger.error((Object)"Could not retrieve alias for issuer", (Throwable)e);
            throw new WSSecurityException(0);
        }
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        try {
            return this._factory.getAliasForX509Cert(issuer, serialNumber);
        }
        catch (OAException e) {
            _logger.error((Object)"Could not retrieve alias for issuer and serial number", (Throwable)e);
            throw new WSSecurityException(0);
        }
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        _logger.error((Object)"Could not retrieve alias for SubjectKeyIdentifier, not supported");
        throw new WSSecurityException(0);
    }

    public String getAliasForX509CertThumb(byte[] arg0) throws WSSecurityException {
        _logger.error((Object)"Could not retrieve alias for Thumbprint, not supported");
        throw new WSSecurityException(0);
    }

    public String[] getAliasesForDN(String arg0) throws WSSecurityException {
        _logger.error((Object)"Could not retrieve alias for Thumbprint, not supported");
        throw new WSSecurityException(0);
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        try {
            Vector<X509Certificate> list = new Vector<X509Certificate>();
            for (int i = 0; i < certs.length; ++i) {
                if (reverse) {
                    list.insertElementAt(certs[i], 0);
                    continue;
                }
                list.add(certs[i]);
            }
            CertPath path = this.getCertificateFactory().generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            _logger.warn((Object)"Could not encode certificate path", (Throwable)e);
            throw new WSSecurityException(7, "encodeError", null, (Throwable)e);
        }
        catch (CertificateException e) {
            _logger.warn((Object)"Could not generate certificate path", (Throwable)e);
            throw new WSSecurityException(7, "parseError", null, (Throwable)e);
        }
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (_certFactory == null) {
            try {
                Provider provider = this._factory.getKeyStore().getProvider();
                String sProvider = null;
                if (provider != null) {
                    sProvider = provider.getName();
                }
                _certFactory = sProvider == null || sProvider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType", null, (Throwable)e);
            }
        }
        return _certFactory;
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        try {
            if (alias.equals(this.getDefaultX509Alias())) {
                return new X509Certificate[]{(X509Certificate)this._factory.getCertificate()};
            }
            return new X509Certificate[]{(X509Certificate)this._factory.getCertificate(alias)};
        }
        catch (OAException e) {
            _logger.warn((Object)"Could not retrieve certificate", (Throwable)e);
            throw new WSSecurityException(0);
        }
    }

    public String getDefaultX509Alias() {
        return this._factory.getAlias();
    }

    public KeyStore getKeyStore() {
        return this._factory.getKeyStore();
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        if (!alias.equals(this.getDefaultX509Alias())) {
            _logger.warn((Object)"Could not retrieve private key, alias invalid");
            throw new WSSecurityException(0);
        }
        if (!password.equals(this._factory.getPrivateKeyPassword())) {
            _logger.warn((Object)"Could not retrieve private key, password invalid");
            throw new WSSecurityException(0);
        }
        return this._factory.getPrivateKey();
    }

    public byte[] getSKIBytesFromCert(X509Certificate arg0) throws WSSecurityException {
        _logger.error((Object)"Could not retrieve SKIBytes certificate, not supported");
        throw new WSSecurityException(0);
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        X509Certificate[] certs = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            CertPath path = this.getCertificateFactory().generateCertPath(in);
            List<? extends Certificate> certificates = path.getCertificates();
            certs = new X509Certificate[certificates.size()];
            int i = 0;
            int size = certificates.size();
            for (X509Certificate cert : certs) {
                certs[reverse ? size - 1 - i : i] = cert;
            }
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, (Throwable)e);
        }
        return certs;
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, (Throwable)e);
        }
        return cert;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        boolean ok = false;
        try {
            List<X509Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
            if (certs.length == 1) {
                String alias = this._factory.getAliasForX509Cert(certs[0].getIssuerDN().getName(), certs[0].getSerialNumber());
                if (alias == null) {
                    _logger.debug((Object)"Certificate not trusted");
                    return false;
                }
                X509Certificate cert = (X509Certificate)this._factory.getCertificate(alias);
                TrustAnchor anchor = new TrustAnchor(cert, cert.getExtensionValue("2.5.29.30"));
                set.add(anchor);
            } else {
                Enumeration aliases = this._factory.getAliases();
                while (aliases.hasMoreElements()) {
                    String alias = (String)aliases.nextElement();
                    X509Certificate cert = (X509Certificate)this._factory.getCertificate(alias);
                    TrustAnchor anchor = new TrustAnchor(cert, cert.getExtensionValue("2.5.29.30"));
                    set.add(anchor);
                }
            }
            PKIXParameters param = new PKIXParameters(set);
            param.setRevocationEnabled(false);
            Provider provider = this._factory.getKeyStore().getProvider();
            String sProvider = null;
            CertPathValidator certPathValidator = null;
            if (provider != null) {
                sProvider = provider.getName();
            }
            certPathValidator = sProvider == null || sProvider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", sProvider);
            certPathValidator.validate(path, param);
            ok = true;
        }
        catch (NoSuchProviderException e) {
            _logger.warn((Object)"No such provider", (Throwable)e);
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            _logger.warn((Object)"No such algorithm", (Throwable)e);
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            _logger.warn((Object)"Invalid algorithm param", (Throwable)e);
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (CertificateException e) {
            _logger.warn((Object)"Invalid certificate", (Throwable)e);
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (ClassCastException e) {
            _logger.warn((Object)"Certificate is not an X509Certificate", (Throwable)e);
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (CertPathValidatorException e) {
            _logger.warn((Object)"Could not validate Cert Path", (Throwable)e);
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (CryptoException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, (Throwable)e);
        }
        return ok;
    }
}

