/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.ws;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.profile.aselect.business.BusinessRuleException;
import com.alfaariss.oa.profile.aselect.business.beans.TGTInfo;
import com.alfaariss.oa.profile.aselect.business.requestor.RequestorService;
import com.alfaariss.oa.profile.aselect.ws.WSFault;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.policy.RampartPolicyData;

public class ASelectProfileWS {
    public static final String TARGET_NAMESPACE = "http://aselectws.openaselect.org/";
    public static final String AUTHENTICATE_RESPONSE = "authenticateResponse";
    public static final String VERIFY_CREDENTIALS_RESPONSE = "verifyCredentialsResponse";
    public static final String INIT_LOGOUT_RESPONSE = "sloResponse";
    public static final String LOGOUT_RESPONSE = "logoutResponse";
    private RequestorService _service;
    private Log _logger;
    private Engine _engine;

    public ASelectProfileWS() throws OAException {
        try {
            this._logger = LogFactory.getLog(ASelectProfileWS.class);
            this._logger.info((Object)"Starting: aselect ws profile");
            this._service = new RequestorService();
            this._engine = Engine.getInstance();
            this._service.start(this._engine.getConfigurationManager(), null);
            this._engine.addComponent((IComponent)this._service);
            if (!this._service.isInitialized()) {
                this._logger.info((Object)"Disabled: aselect ws profile");
            } else {
                this._logger.info((Object)"Started: aselect ws profile");
            }
        }
        catch (OAException e) {
            this._logger.fatal((Object)"Initialization failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Initialization failed, due to internal error", (Throwable)e);
            throw new OAException(1);
        }
    }

    public OMElement authenticate(OMElement request) throws AxisFault {
        String remoteAddr = null;
        try {
            if (!this._service.isInitialized()) {
                this._logger.warn((Object)"Service not initialized or disabled");
                throw new OAException(3);
            }
            MessageContext context = MessageContext.getCurrentMessageContext();
            if (context == null) {
                this._logger.warn((Object)"Could not retrieve message context");
                throw new OAException(1);
            }
            if (this._logger.isDebugEnabled()) {
                SOAPEnvelope envelope = context.getEnvelope();
                this._logger.debug((Object)envelope);
            }
            remoteAddr = (String)context.getProperty("REMOTE_ADDR");
            String oaID = null;
            OMElement om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "a-select-server"));
            if (om != null) {
                oaID = om.getText();
            } else {
                om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "aselectserver"));
                if (om != null) {
                    oaID = om.getText();
                }
            }
            String requestorID = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "app_id"));
            if (om != null) {
                requestorID = om.getText();
            }
            String requestorURL = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "app_url"));
            if (om != null) {
                requestorURL = om.getText();
            }
            String remoteOrganization = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "remote_organization"));
            if (om != null) {
                remoteOrganization = om.getText();
            }
            String sForcedLogon = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "forced_logon"));
            if (om != null) {
                sForcedLogon = om.getText();
            }
            String sPassive = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "passive"));
            if (om != null) {
                sPassive = om.getText();
            }
            String uid = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "uid"));
            if (om != null) {
                uid = om.getText();
            }
            String country = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "country"));
            if (om != null) {
                country = om.getText();
            }
            String language = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "language"));
            if (om != null) {
                language = om.getText();
            }
            ISession session = this._service.initiateAuthentication(oaID, requestorID, requestorURL, remoteOrganization, sForcedLogon, uid, remoteAddr, country, language, this.isSigned(context), sPassive);
            StringBuffer sbAsUrl = new StringBuffer(this._service.getRedirectURLBase());
            sbAsUrl.append("?request=login1&");
            sbAsUrl.append("a-select-server");
            sbAsUrl.append("=");
            sbAsUrl.append(oaID);
            sbAsUrl.append("&rid=").append(session.getId());
            OMFactory fac = context.getEnvelope().getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(TARGET_NAMESPACE, "oa");
            OMNamespace omNs1 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            OMNamespace omNs2 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
            OMElement authnResponse = fac.createOMElement(AUTHENTICATE_RESPONSE, omNs);
            authnResponse.declareNamespace(omNs1);
            authnResponse.declareNamespace(omNs2);
            authnResponse.addChild((OMNode)this.createParam(fac, "as_url", sbAsUrl.toString(), omNs, "xsd:string", omNs1));
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)authnResponse);
            }
            return authnResponse;
        }
        catch (BusinessRuleException e) {
            throw new WSFault(e);
        }
        catch (OAException e) {
            this._logger.error((Object)"Error while processing authenticate request", (Throwable)e);
            throw new WSFault(e);
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error while processing authenticate request", (Throwable)e);
            throw new WSFault(new OAException(1));
        }
    }

    public OMElement verifyCredentials(OMElement request) throws AxisFault {
        String remoteAddr = null;
        try {
            String asp;
            int iASPLevel;
            String sAttributes;
            long lExpiration;
            String uid;
            String authsp;
            int iAppLevel;
            if (!this._service.isInitialized()) {
                this._logger.warn((Object)"Service not initialized or disabled");
                throw new OAException(3);
            }
            MessageContext context = MessageContext.getCurrentMessageContext();
            if (context == null) {
                this._logger.warn((Object)"Could not retrieve message context");
                throw new OAException(1);
            }
            if (this._logger.isDebugEnabled()) {
                SOAPEnvelope envelope = context.getEnvelope();
                this._logger.debug((Object)envelope);
            }
            remoteAddr = (String)context.getProperty("REMOTE_ADDR");
            String sASelectServerResponseParam = "a-select-server";
            String oaID = null;
            OMElement om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "a-select-server"));
            if (om != null) {
                oaID = om.getText();
            } else {
                om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "aselectserver"));
                if (om != null) {
                    oaID = om.getText();
                    sASelectServerResponseParam = "aselectserver";
                }
            }
            String requestorID = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "app_id"));
            if (om != null) {
                requestorID = om.getText();
            }
            String rid = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "rid"));
            if (om != null) {
                rid = om.getText();
            }
            String credentials = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "aselect_credentials"));
            if (om != null) {
                credentials = om.getText();
            }
            TGTInfo info = this._service.verifyAuthentication(oaID, requestorID, rid, credentials, remoteAddr, this.isSigned(context));
            SOAPEnvelope envelope = context.getEnvelope();
            OMFactory fac = envelope.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(TARGET_NAMESPACE, "oa");
            OMNamespace omNs1 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            OMNamespace omNs2 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
            OMElement response = fac.createOMElement(VERIFY_CREDENTIALS_RESPONSE, omNs);
            response.declareNamespace(omNs1);
            response.declareNamespace(omNs2);
            response.addChild((OMNode)this.createParam(fac, "result_code", info.getResultCode(), omNs, "xsd:string", omNs1));
            response.addChild((OMNode)this.createParam(fac, sASelectServerResponseParam, oaID, omNs, "xsd:string", omNs1));
            String organization = info.getOrganization();
            if (organization != null) {
                response.addChild((OMNode)this.createParam(fac, "organization", organization, omNs, "xsd:string", omNs1));
            }
            if ((iAppLevel = info.getAppLevel()) > 0) {
                response.addChild((OMNode)this.createParam(fac, "app_level", Integer.toString(iAppLevel), omNs, "xsd:integer", omNs1));
            }
            int iAuthSPLevel = info.getAuthspLevel();
            if (iAppLevel > 0) {
                response.addChild((OMNode)this.createParam(fac, "authsp_level", Integer.toString(iAuthSPLevel), omNs, "xsd:integer", omNs1));
            }
            if ((authsp = info.getAuthsp()) != null) {
                response.addChild((OMNode)this.createParam(fac, "authsp", authsp, omNs, "xsd:string", omNs1));
            }
            if ((uid = info.getUid()) != null) {
                response.addChild((OMNode)this.createParam(fac, "uid", uid, omNs, "xsd:string", omNs1));
            }
            if ((lExpiration = info.getExpiration()) > 0L) {
                response.addChild((OMNode)this.createParam(fac, "tgt_exp_time", Long.toString(lExpiration), omNs, "xsd:long", omNs1));
            }
            if ((sAttributes = info.getAttributes()) != null) {
                response.addChild((OMNode)this.createParam(fac, "attributes", sAttributes, omNs, "xsd:string", omNs1));
            }
            if ((iASPLevel = info.getAuthspLevel()) > 0) {
                response.addChild((OMNode)this.createParam(fac, "asp_level", Integer.toString(iASPLevel), omNs, "xsd:integer", omNs1));
            }
            if ((asp = info.getAsp()) != null) {
                response.addChild((OMNode)this.createParam(fac, "asp", asp, omNs, "xsd:string", omNs1));
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)response);
            }
            return response;
        }
        catch (BusinessRuleException e) {
            throw new WSFault(e);
        }
        catch (OAException e) {
            this._logger.error((Object)"Error while processing verifyCredentials request", (Throwable)e);
            throw new WSFault(e);
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error while processing verifyCredentials request", (Throwable)e);
            throw new WSFault(new OAException(1));
        }
    }

    public OMElement slo(OMElement request) throws AxisFault {
        String remoteAddr = null;
        try {
            if (!this._service.isInitialized()) {
                this._logger.warn((Object)"Service not initialized or disabled");
                throw new OAException(3);
            }
            MessageContext context = MessageContext.getCurrentMessageContext();
            if (context == null) {
                this._logger.warn((Object)"Could not retrieve message context");
                throw new OAException(1);
            }
            if (this._logger.isDebugEnabled()) {
                SOAPEnvelope envelope = context.getEnvelope();
                this._logger.debug((Object)envelope);
            }
            remoteAddr = (String)context.getProperty("REMOTE_ADDR");
            String oaID = null;
            OMElement om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "a-select-server"));
            if (om != null) {
                oaID = om.getText();
            } else {
                om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "aselectserver"));
                if (om != null) {
                    oaID = om.getText();
                }
            }
            String requestorID = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "app_id"));
            if (om != null) {
                requestorID = om.getText();
            }
            String credentials = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "aselect_credentials"));
            if (om != null) {
                credentials = om.getText();
            }
            String requestorURL = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "app_url"));
            if (om != null) {
                requestorURL = om.getText();
            }
            ISession logoutSession = this._service.slo(oaID, requestorID, credentials, requestorURL, remoteAddr, this.isSigned(context));
            StringBuffer sbAsUrl = new StringBuffer(this._service.getRedirectURLBase());
            sbAsUrl.append("?request=logout&");
            sbAsUrl.append("a-select-server");
            sbAsUrl.append("=");
            sbAsUrl.append(oaID);
            sbAsUrl.append("&rid=").append(logoutSession.getId());
            OMFactory fac = context.getEnvelope().getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(TARGET_NAMESPACE, "oa");
            OMNamespace omNs1 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            OMNamespace omNs2 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
            OMElement logoutResponse = fac.createOMElement(INIT_LOGOUT_RESPONSE, omNs);
            logoutResponse.declareNamespace(omNs1);
            logoutResponse.declareNamespace(omNs2);
            logoutResponse.addChild((OMNode)this.createParam(fac, "as_url", sbAsUrl.toString(), omNs, "xsd:string", omNs1));
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)logoutResponse);
            }
            return logoutResponse;
        }
        catch (BusinessRuleException e) {
            throw new WSFault(e);
        }
        catch (OAException e) {
            this._logger.error((Object)"Error while processing logout initiation request", (Throwable)e);
            throw new WSFault(e);
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error while processing logout initiation request", (Throwable)e);
            throw new WSFault(new OAException(1));
        }
    }

    public OMElement logout(OMElement request) throws AxisFault {
        String remoteAddr = null;
        try {
            if (!this._service.isInitialized()) {
                this._logger.warn((Object)"Service not initialized or disabled");
                throw new OAException(3);
            }
            MessageContext context = MessageContext.getCurrentMessageContext();
            if (context == null) {
                this._logger.warn((Object)"Could not retrieve message context");
                throw new OAException(1);
            }
            if (this._logger.isDebugEnabled()) {
                SOAPEnvelope envelope = context.getEnvelope();
                this._logger.debug((Object)envelope);
            }
            remoteAddr = (String)context.getProperty("REMOTE_ADDR");
            String requestorID = null;
            OMElement om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "app_id"));
            if (om != null) {
                requestorID = om.getText();
            }
            String credentials = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "aselect_credentials"));
            if (om != null) {
                credentials = om.getText();
            }
            String reason = null;
            om = request.getFirstChildWithName(new QName(TARGET_NAMESPACE, "reason"));
            if (om != null) {
                reason = om.getText();
            }
            String result = this._service.logout(requestorID, credentials, remoteAddr, this.isSigned(context), reason);
            OMFactory fac = context.getEnvelope().getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(TARGET_NAMESPACE, "oa");
            OMNamespace omNs1 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            OMNamespace omNs2 = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
            OMElement logoutResponse = fac.createOMElement(LOGOUT_RESPONSE, omNs);
            logoutResponse.declareNamespace(omNs1);
            logoutResponse.declareNamespace(omNs2);
            logoutResponse.addChild((OMNode)this.createParam(fac, "result_code", result, omNs, "xsd:string", omNs1));
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)logoutResponse);
            }
            return logoutResponse;
        }
        catch (BusinessRuleException e) {
            throw new WSFault(e);
        }
        catch (OAException e) {
            this._logger.error((Object)"Error while processing logout request", (Throwable)e);
            throw new WSFault(e);
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error while processing logout request", (Throwable)e);
            throw new WSFault(new OAException(1));
        }
    }

    protected void finalize() throws Throwable {
        try {
            this._service.stop();
            this._engine.removeComponent((IComponent)this._service);
            this._logger.info((Object)"Stopped: aselect ws profile");
            super.finalize();
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Could not stop aselect ws profile properly", (Throwable)e);
        }
    }

    private OMElement createParam(OMFactory fac, String name, String value, OMNamespace omNs, String type, OMNamespace typeNs) {
        OMElement param = fac.createOMElement(name, omNs);
        param.addAttribute("type", type, typeNs);
        param.addChild((OMNode)fac.createOMText((OMContainer)param, value));
        return param;
    }

    private boolean isSigned(MessageContext context) {
        boolean signed = false;
        try {
            RampartPolicyData rpd;
            RampartMessageData rmd = new RampartMessageData(context, true);
            if (rmd != null && (rpd = rmd.getPolicyData()) != null) {
                signed = rpd.isSignBody();
            }
        }
        catch (RampartException e) {
            this._logger.warn((Object)"Could not determine signing, presuming message not signed", (Throwable)e);
        }
        this._logger.debug((Object)("request was signed: " + signed));
        return signed;
    }
}

