/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.processor.handler;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.RequestorEvent;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.requestor.factory.IRequestorPoolFactory;
import com.alfaariss.oa.engine.core.server.Server;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.profile.aselect.ASelectException;
import com.alfaariss.oa.profile.aselect.binding.IBinding;
import com.alfaariss.oa.profile.aselect.binding.IRequest;
import com.alfaariss.oa.profile.aselect.processor.ASelectProcessor;
import com.alfaariss.oa.profile.aselect.processor.handler.ASelectUserException;
import com.alfaariss.oa.util.ModifiedBase64;
import com.alfaariss.oa.util.logging.RequestorEventLogItem;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.validation.SessionValidator;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrowserHandler
implements IAuthority {
    public static final String ALIAS_TYPE_CREDENTIALS = "aselect_credentials";
    private static final String SSO_LOGOUT_URI = "logout";
    private static final String PROPERTY_LOCAL_ERROR_HANDLING = ".local_error_handling";
    private static final String PROPERTY_REDIRECT_PAGE = ".redirectreset";
    private Log _logger;
    private Log _eventLogger;
    private Server _server;
    private ISessionFactory _sessionFactory;
    private ITGTAliasStore _aliasStoreSPRole;
    private SecureRandom _oSecureRandom;
    private IRequestorPoolFactory _requestorPoolFactory;
    private String _sRedirectURL;
    private String _sWebSSOPath;
    private String _sWebSSOUrl;
    private String _sErrorJspPath;
    private boolean _bLocalErrorHandling;
    private String _sProfileID;
    private String _sRedirectJspPath;

    public BrowserHandler(String sRedirectURL, String sWebSSOPath, String sWebSSOUrl, String sErrorJspPath, boolean bLocalErrorHandling, String sProfileID, String sRedirectJspPath) throws OAException {
        try {
            this._logger = LogFactory.getLog(BrowserHandler.class);
            this._eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
            this._sProfileID = sProfileID;
            Engine engine = Engine.getInstance();
            this._server = engine.getServer();
            this._sessionFactory = engine.getSessionFactory();
            ITGTFactory tgtFactory = engine.getTGTFactory();
            this._aliasStoreSPRole = tgtFactory.getAliasStoreSP();
            if (this._aliasStoreSPRole != null) {
                try {
                    this._aliasStoreSPRole.isAlias(ALIAS_TYPE_CREDENTIALS, "test_sp", "test_alias");
                    this._logger.info((Object)"TGT Factory supports SP Role alias storage; credentials will be stored as TGT alias of type: aselect_credentials");
                }
                catch (OAException e) {
                    this._logger.info((Object)"TGT Factory has alias support, but doesn't support alias of type: aselect_credentials");
                }
            } else {
                this._logger.info((Object)"TGT Factory doesn't support SP Role alias storage: credentials will not be stored as TGT alias");
            }
            CryptoManager oCryptoManager = engine.getCryptoManager();
            if (oCryptoManager == null) {
                this._logger.error((Object)"No crypto manager available");
                throw new OAException(2);
            }
            this._oSecureRandom = oCryptoManager.getSecureRandom();
            this._sRedirectURL = sRedirectURL;
            this._sWebSSOPath = sWebSSOPath;
            this._sWebSSOUrl = sWebSSOUrl;
            this._sErrorJspPath = sErrorJspPath;
            this._bLocalErrorHandling = bLocalErrorHandling;
            this._sRedirectJspPath = sRedirectJspPath;
            this._requestorPoolFactory = engine.getRequestorPoolFactory();
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
            throw new OAException(1);
        }
    }

    public void login1(HttpServletRequest oServletRequest, HttpServletResponse oServletResponse, IBinding oBinding) throws ASelectException {
        ISession oSession = null;
        try {
            IRequest oRequest = oBinding.getRequest();
            String sASelectServer = (String)oRequest.getParameter("a-select-server");
            if (sASelectServer == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("a-select-server");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            String sRID = (String)oRequest.getParameter("rid");
            if (sRID == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("rid");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (!SessionValidator.validateDefaultSessionId((String)sRID)) {
                StringBuffer sbError = new StringBuffer("Invalid '");
                sbError.append("rid");
                sbError.append("' in request: ");
                sbError.append(sRID);
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (!this._server.getID().equals(sASelectServer)) {
                StringBuffer sbError = new StringBuffer("The Server ID doesn't correspond to the supplied '");
                sbError.append("a-select-server");
                sbError.append("' parameter: ");
                sbError.append(sASelectServer);
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0033");
            }
            oSession = this._sessionFactory.retrieve((Object)sRID);
            if (oSession == null) {
                this._logger.debug((Object)("No session found with id: " + sRID));
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (oSession.isExpired()) {
                StringBuffer sbError = new StringBuffer("Expired session with id '");
                sbError.append(sRID);
                sbError.append("' found in request sent from IP: ");
                sbError.append(oServletRequest.getRemoteAddr());
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0102");
            }
            StringBuffer sbProfileURL = new StringBuffer();
            if (this._sRedirectURL == null) {
                sbProfileURL.append(oRequest.getRequestedURL());
            } else {
                sbProfileURL.append(this._sRedirectURL);
            }
            sbProfileURL.append("?");
            sbProfileURL.append("a-select-server");
            sbProfileURL.append("=");
            sbProfileURL.append(URLEncoder.encode(this._server.getID(), "UTF-8"));
            sbProfileURL.append("&");
            sbProfileURL.append("rid");
            sbProfileURL.append("=");
            sbProfileURL.append(URLEncoder.encode(sRID, "UTF-8"));
            oSession.setProfileURL(sbProfileURL.toString());
            oServletRequest.setAttribute("asid", (Object)oSession);
            RequestDispatcher oDispatcher = oServletRequest.getRequestDispatcher(this._sWebSSOPath);
            if (oDispatcher == null) {
                this._logger.warn((Object)("There is no requestor dispatcher supported with name: " + this._sWebSSOPath));
                throw new ASelectUserException(UserEvent.INTERNAL_ERROR, "0001");
            }
            oDispatcher.forward((ServletRequest)oServletRequest, (ServletResponse)oServletResponse);
        }
        catch (ASelectUserException e) {
            UserEvent event = e.getEvent();
            String sCode = e.getMessage();
            if (oSession != null) {
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oServletRequest.getRemoteAddr(), event, (IAuthority)this, sCode));
            } else {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, event, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, sCode));
            }
            this.showErrorPage(oServletRequest, oServletResponse, event, sCode, oSession);
        }
        catch (OAException e) {
            this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, e.getMessage()));
            this._logger.error((Object)"Exception occurred during 'login1' process", (Throwable)e);
            throw new ASelectException(e.getMessage());
        }
        catch (Exception e) {
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, null));
            }
            this._logger.fatal((Object)"Internal error during 'login1' process", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    public void authenticate(HttpServletRequest oServletRequest, HttpServletResponse oServletResponse, IBinding oBinding) throws ASelectException {
        ISession oSession = null;
        try {
            IRequest oRequest = oBinding.getRequest();
            String sASelectServer = (String)oRequest.getParameter("a-select-server");
            if (sASelectServer == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("a-select-server");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            String sRID = (String)oRequest.getParameter("rid");
            if (sRID == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("rid");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (!SessionValidator.validateDefaultSessionId((String)sRID)) {
                StringBuffer sbError = new StringBuffer("Invalid '");
                sbError.append("rid");
                sbError.append("' in request: ");
                sbError.append(sRID);
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (!this._server.getID().equals(sASelectServer)) {
                StringBuffer sbError = new StringBuffer("The Server ID doesn't correspond to the supplied '");
                sbError.append("a-select-server");
                sbError.append("' parameter: ");
                sbError.append(sASelectServer);
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0033");
            }
            oSession = this._sessionFactory.retrieve((Object)sRID);
            if (oSession == null) {
                this._logger.debug((Object)("No session found with id: " + sRID));
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (oSession.isExpired()) {
                StringBuffer sbError = new StringBuffer("Expired session with id '");
                sbError.append(sRID);
                sbError.append("' found in request sent from IP: ");
                sbError.append(oServletRequest.getRemoteAddr());
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.SESSION_EXPIRED, "0102");
            }
            SessionState oUserState = oSession.getState();
            RequestorPool requestorPool = this._requestorPoolFactory.getRequestorPool(oSession.getRequestorId());
            if (this.doLocalErrorHandling(requestorPool) && !oUserState.equals((Object)SessionState.AUTHN_OK)) {
                switch (oUserState) {
                    case AUTHN_FAILED: 
                    case PRE_AUTHZ_FAILED: 
                    case POST_AUTHZ_FAILED: 
                    case AUTHN_SELECTION_FAILED: {
                        throw new ASelectException("0003");
                    }
                    case USER_BLOCKED: {
                        throw new ASelectException("9001");
                    }
                    case USER_UNKNOWN: {
                        throw new ASelectException("0002");
                    }
                    case USER_CANCELLED: {
                        throw new ASelectException("0040");
                    }
                    case PASSIVE_FAILED: {
                        throw new ASelectException("9921");
                    }
                }
                throw new ASelectException("0001");
            }
            ISessionAttributes oAttributes = oSession.getAttributes();
            String sRequestorUrl = (String)oAttributes.get(ASelectProcessor.class, "requestor_url");
            if (sRequestorUrl == null) {
                this._logger.debug((Object)"No session attribute found with with name: requestor_url");
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            byte[] baRandom = new byte[256];
            this._oSecureRandom.nextBytes(baRandom);
            String sCredentials = new String(ModifiedBase64.encode((byte[])baRandom, (String)"UTF-8"));
            oAttributes.put(ASelectProcessor.class, "credentials", (Object)sCredentials);
            if (this._aliasStoreSPRole != null && oSession.getTGTId() != null) {
                this._logger.debug((Object)"Setting TGT alias with name aselect_credentials");
                this._aliasStoreSPRole.putAlias(ALIAS_TYPE_CREDENTIALS, oSession.getRequestorId(), oSession.getTGTId(), sCredentials);
            }
            StringBuffer sbRedirect = new StringBuffer(sRequestorUrl);
            if (sRequestorUrl.indexOf("?") == -1) {
                sbRedirect.append("?");
            } else {
                sbRedirect.append("&");
            }
            sbRedirect.append(ALIAS_TYPE_CREDENTIALS);
            sbRedirect.append("=");
            sbRedirect.append(URLEncoder.encode(sCredentials, "UTF-8"));
            sbRedirect.append("&");
            sbRedirect.append("rid");
            sbRedirect.append("=");
            sbRedirect.append(URLEncoder.encode(sRID, "UTF-8"));
            sbRedirect.append("&");
            sbRedirect.append("a-select-server");
            sbRedirect.append("=");
            sbRedirect.append(URLEncoder.encode(this._server.getID(), "UTF-8"));
            if (!oUserState.equals((Object)SessionState.AUTHN_OK)) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.AUTHN_FAILED, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.AUTHN_SUCCESSFUL, (IAuthority)this, null));
            }
            oSession.persist();
            IRequestor requestor = this._requestorPoolFactory.getRequestor(oSession.getRequestorId());
            if (this.doRedirectWithPage(requestor, requestorPool)) {
                this.forwardToAutoRedirect(oServletRequest, oServletResponse, sbRedirect.toString(), requestor);
            } else {
                oServletResponse.sendRedirect(sbRedirect.toString());
            }
        }
        catch (ASelectUserException e) {
            UserEvent event = e.getEvent();
            String sCode = e.getMessage();
            if (oSession != null) {
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oServletRequest.getRemoteAddr(), event, (IAuthority)this, sCode));
            } else {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, event, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, sCode));
            }
            this.showErrorPage(oServletRequest, oServletResponse, event, sCode, oSession);
        }
        catch (ASelectException e) {
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.AUTHN_FAILED, (IAuthority)this, e.getMessage()));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.AUTHN_FAILED, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, e.getMessage()));
            }
            this.showErrorPage(oServletRequest, oServletResponse, null, e.getMessage(), oSession);
        }
        catch (OAException e) {
            this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, e.getMessage()));
            this._logger.error((Object)"Exception occurred during 'authenticate' process", (Throwable)e);
            throw new ASelectException(e.getMessage());
        }
        catch (Exception e) {
            if (oSession != null) {
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oServletRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "authentication finalization"));
            } else {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "authentication finalization"));
            }
            this._logger.fatal((Object)"Internal error during authenticate request process initiated by the Web SSO", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    public void userinformation(HttpServletRequest oServletRequest, HttpServletResponse oServletResponse) throws ASelectException {
        block7: {
            try {
                if (this._sWebSSOUrl != null) {
                    this._logger.debug((Object)("Redirect to web sso: " + this._sWebSSOUrl));
                    try {
                        oServletResponse.sendRedirect(this._sWebSSOUrl);
                        break block7;
                    }
                    catch (Exception e) {
                        this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "user information"));
                        this._logger.fatal((Object)"Internal error during user information request process", (Throwable)e);
                        throw new ASelectException("0001");
                    }
                }
                this._logger.debug((Object)("Forward to web sso: " + this._sWebSSOPath));
                RequestDispatcher oDispatcher = oServletRequest.getRequestDispatcher(this._sWebSSOPath);
                if (oDispatcher == null) {
                    this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "user information"));
                    this._logger.warn((Object)("There is no requestor dispatcher supported with name: " + this._sWebSSOPath));
                    throw new ASelectException("0001");
                }
                oDispatcher.forward((ServletRequest)oServletRequest, (ServletResponse)oServletResponse);
            }
            catch (ASelectException e) {
                throw e;
            }
            catch (Exception e) {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "user information"));
                this._logger.fatal((Object)"Internal error during user information request process", (Throwable)e);
                throw new ASelectException("0001");
            }
        }
    }

    public String getAuthority() {
        return "A-Select Profile";
    }

    public void logout(HttpServletRequest oServletRequest, HttpServletResponse oServletResponse, IBinding oBinding) throws ASelectException {
        ISession session = null;
        try {
            IRequest oRequest = oBinding.getRequest();
            String sASelectServer = (String)oRequest.getParameter("a-select-server");
            if (sASelectServer == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("a-select-server");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            String sRID = (String)oRequest.getParameter("rid");
            if (sRID == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("rid");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (!SessionValidator.validateDefaultSessionId((String)sRID)) {
                StringBuffer sbError = new StringBuffer("Invalid '");
                sbError.append("rid");
                sbError.append("' in request: ");
                sbError.append(sRID);
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (!this._server.getID().equals(sASelectServer)) {
                StringBuffer sbError = new StringBuffer("The Server ID doesn't correspond to the supplied '");
                sbError.append("a-select-server");
                sbError.append("' parameter: ");
                sbError.append(sASelectServer);
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0033");
            }
            session = this._sessionFactory.retrieve((Object)sRID);
            if (session == null) {
                this._logger.debug((Object)("No session found with id: " + sRID));
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0030");
            }
            if (session.isExpired()) {
                StringBuffer sbError = new StringBuffer("Expired session with id '");
                sbError.append(sRID);
                sbError.append("' found in request sent from IP: ");
                sbError.append(oServletRequest.getRemoteAddr());
                this._logger.debug((Object)sbError.toString());
                throw new ASelectUserException(UserEvent.REQUEST_INVALID, "0102");
            }
            switch (session.getState()) {
                case USER_LOGOUT_SUCCESS: {
                    String sRequestorURL = (String)session.getAttributes().get(ASelectProcessor.class, "requestor_url");
                    this._eventLogger.info((Object)new UserEventLogItem(session, oServletRequest.getRemoteAddr(), UserEvent.USER_LOGGED_OUT, (IAuthority)this, null));
                    this._logger.debug((Object)("Logout succeeded, redirect user back to requestor: " + sRequestorURL));
                    oServletResponse.sendRedirect(sRequestorURL);
                    break;
                }
                case USER_LOGOUT_PARTIAL: 
                case USER_LOGOUT_FAILED: {
                    throw new ASelectUserException(UserEvent.USER_LOGOUT_FAILED, "9911");
                }
                case USER_LOGOUT_IN_PROGRESS: {
                    oServletRequest.setAttribute("asid", (Object)session);
                    StringBuffer sbForward = new StringBuffer(this._sWebSSOPath);
                    if (!this._sWebSSOPath.endsWith("/")) {
                        sbForward.append("/");
                    }
                    sbForward.append(SSO_LOGOUT_URI);
                    this._logger.debug((Object)("Forwarding user to: " + sbForward.toString()));
                    RequestDispatcher oDispatcher = oServletRequest.getRequestDispatcher(sbForward.toString());
                    if (oDispatcher == null) {
                        this._logger.warn((Object)("There is no requestor dispatcher supported with name: " + sbForward.toString()));
                        throw new ASelectUserException(UserEvent.INTERNAL_ERROR, "0001");
                    }
                    oDispatcher.forward((ServletRequest)oServletRequest, (ServletResponse)oServletResponse);
                    break;
                }
                default: {
                    StringBuffer sbProfileURL = new StringBuffer();
                    if (this._sRedirectURL == null) {
                        sbProfileURL.append(oRequest.getRequestedURL());
                    } else {
                        sbProfileURL.append(this._sRedirectURL);
                    }
                    sbProfileURL.append("?request=logout&");
                    sbProfileURL.append("a-select-server");
                    sbProfileURL.append("=");
                    sbProfileURL.append(URLEncoder.encode(this._server.getID(), "UTF-8"));
                    sbProfileURL.append("&");
                    sbProfileURL.append("rid");
                    sbProfileURL.append("=");
                    sbProfileURL.append(URLEncoder.encode(sRID, "UTF-8"));
                    session.setProfileURL(sbProfileURL.toString());
                    oServletRequest.setAttribute("asid", (Object)session);
                    StringBuffer sbForward = new StringBuffer(this._sWebSSOPath);
                    if (!this._sWebSSOPath.endsWith("/")) {
                        sbForward.append("/");
                    }
                    sbForward.append(SSO_LOGOUT_URI);
                    this._logger.debug((Object)("Forwarding user to: " + sbForward.toString()));
                    RequestDispatcher oDispatcher = oServletRequest.getRequestDispatcher(sbForward.toString());
                    if (oDispatcher == null) {
                        this._logger.warn((Object)("There is no requestor dispatcher supported with name: " + sbForward.toString()));
                        throw new ASelectUserException(UserEvent.INTERNAL_ERROR, "0001");
                    }
                    this._eventLogger.info((Object)new UserEventLogItem(session, oServletRequest.getRemoteAddr(), UserEvent.USER_LOGOUT_IN_PROGRESS, (IAuthority)this, null));
                    oDispatcher.forward((ServletRequest)oServletRequest, (ServletResponse)oServletResponse);
                    break;
                }
            }
        }
        catch (ASelectUserException e) {
            UserEvent event = e.getEvent();
            String sCode = e.getMessage();
            if (session != null) {
                this._eventLogger.info((Object)new UserEventLogItem(session, oServletRequest.getRemoteAddr(), event, (IAuthority)this, sCode));
            } else {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, event, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, sCode));
            }
            this.showErrorPage(oServletRequest, oServletResponse, event, sCode, session);
        }
        catch (OAException e) {
            this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, e.getMessage()));
            this._logger.error((Object)"Exception occurred during 'logout' process", (Throwable)e);
            throw new ASelectException(e.getMessage());
        }
        catch (Exception e) {
            this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, SSO_LOGOUT_URI));
            this._logger.fatal((Object)"Internal error during logout request process", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    private void showErrorPage(HttpServletRequest oServletRequest, HttpServletResponse oServletResponse, UserEvent oEvent, String sCode, ISession oSession) throws ASelectException {
        try {
            if (oEvent != null) {
                oServletRequest.setAttribute("userEvent", (Object)oEvent);
            }
            Vector<String> details = new Vector<String>();
            details.add(sCode);
            oServletRequest.setAttribute("details", details);
            if (oSession != null) {
                IRequestor oRequestor;
                String sRequestorID = oSession.getRequestorId();
                if (sRequestorID != null && (oRequestor = this._requestorPoolFactory.getRequestor(sRequestorID)) != null) {
                    oServletRequest.setAttribute("requestor", (Object)oRequestor);
                }
                oServletRequest.setAttribute("sessionLocale", (Object)oSession.getLocale());
                oServletRequest.setAttribute("asid", (Object)oSession.getId());
            }
            oServletRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
            RequestDispatcher oDispatcher = oServletRequest.getRequestDispatcher(this._sErrorJspPath);
            if (oDispatcher != null) {
                oDispatcher.forward((ServletRequest)oServletRequest, (ServletResponse)oServletResponse);
            }
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during showing the error page", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    private boolean doLocalErrorHandling(RequestorPool pool) {
        String value;
        if (pool != null && (value = (String)pool.getProperty(this._sProfileID + PROPERTY_LOCAL_ERROR_HANDLING)) != null) {
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
            if ("FALSE".equalsIgnoreCase(value)) {
                return false;
            }
            StringBuffer sbDebug = new StringBuffer("Invalid requestorpool property '");
            sbDebug.append(this._sProfileID);
            sbDebug.append(PROPERTY_LOCAL_ERROR_HANDLING);
            sbDebug.append("' available for requestorpool with ID '");
            sbDebug.append(pool.getID());
            sbDebug.append("': ");
            this._logger.debug((Object)sbDebug.toString());
        }
        return this._bLocalErrorHandling;
    }

    private boolean doRedirectWithPage(IRequestor requestor, RequestorPool requestorPool) {
        StringBuffer sbDebug;
        String value;
        if (requestor != null && (value = (String)requestor.getProperty(this._sProfileID + PROPERTY_REDIRECT_PAGE)) != null) {
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
            if ("FALSE".equalsIgnoreCase(value)) {
                return false;
            }
            sbDebug = new StringBuffer("Invalid requestor property '");
            sbDebug.append(this._sProfileID);
            sbDebug.append(PROPERTY_REDIRECT_PAGE);
            sbDebug.append("' available for requestor with ID '");
            sbDebug.append(requestor.getID());
            sbDebug.append("': ");
            this._logger.debug((Object)sbDebug.toString());
        }
        if (requestorPool != null && (value = (String)requestorPool.getProperty(this._sProfileID + PROPERTY_REDIRECT_PAGE)) != null) {
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
            if ("FALSE".equalsIgnoreCase(value)) {
                return false;
            }
            sbDebug = new StringBuffer("Invalid requestorpool property '");
            sbDebug.append(this._sProfileID);
            sbDebug.append(PROPERTY_REDIRECT_PAGE);
            sbDebug.append("' available for requestorpool with ID '");
            sbDebug.append(requestorPool.getID());
            sbDebug.append("': ");
            this._logger.debug((Object)sbDebug.toString());
        }
        return false;
    }

    private void forwardToAutoRedirect(HttpServletRequest oServletRequest, HttpServletResponse oServletResponse, String sRedirect, IRequestor oRequestor) throws ASelectException {
        try {
            oServletRequest.setAttribute("redirect", (Object)sRedirect);
            if (oRequestor != null) {
                oServletRequest.setAttribute("requestor", (Object)oRequestor);
            }
            oServletRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
            RequestDispatcher oDispatcher = oServletRequest.getRequestDispatcher(this._sRedirectJspPath);
            if (oDispatcher != null) {
                oDispatcher.forward((ServletRequest)oServletRequest, (ServletResponse)oServletResponse);
            }
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during forward to auto redirect page", (Throwable)e);
            throw new ASelectException("0001");
        }
    }
}

