/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.processor;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IService;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.profile.IRequestorProfile;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authentication.factory.IAuthenticationProfileFactory;
import com.alfaariss.oa.profile.aselect.ASelectException;
import com.alfaariss.oa.profile.aselect.binding.BindingFactory;
import com.alfaariss.oa.profile.aselect.binding.IBinding;
import com.alfaariss.oa.profile.aselect.binding.IRequest;
import com.alfaariss.oa.profile.aselect.logout.LogoutManager;
import com.alfaariss.oa.profile.aselect.processor.handler.BrowserHandler;
import com.alfaariss.oa.profile.aselect.processor.handler.idp.IDPHandler;
import com.alfaariss.oa.profile.aselect.processor.handler.sp.SPHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ASelectProcessor
implements IRequestorProfile,
IService {
    public static final String CHARSET = "UTF-8";
    public static final int CREDENTIALS_LENGTH = 256;
    public static final String AUTHORITY_NAME = "A-Select Profile";
    public static final String SESSION_REQUESTOR_URL = "requestor_url";
    public static final String SESSION_REQUIRED_LEVEL = "required_level";
    public static final String SESSION_CREDENTIALS = "credentials";
    public static final String PARAM_RID = "rid";
    public static final String PARAM_ASELECTSERVER = "a-select-server";
    public static final String PARAM_ASELECTSERVER_ALTERATIVE = "aselectserver";
    public static final String PARAM_APPID = "app_id";
    public static final String PARAM_REQUESTORID = "requestor";
    public static final String PARAM_APPURL = "app_url";
    public static final String PARAM_ASELECT_URL = "as_url";
    public static final String PARAM_UID = "uid";
    public static final String PARAM_COUNTRY = "country";
    public static final String PARAM_LANGUAGE = "language";
    public static final String PARAM_FORCED_LOGON = "forced_logon";
    public static final String PARAM_REMOTE_ORGANIZATION = "remote_organization";
    public static final String PARAM_ASELECT_CREDENTIALS = "aselect_credentials";
    public static final String PARAM_RESULT_CODE = "result_code";
    public static final String PARAM_ORGANIZATION = "organization";
    public static final String PARAM_AUTHSP = "authsp";
    public static final String PARAM_AUTHSP_LEVEL = "authsp_level";
    public static final String PARAM_ASP = "asp";
    public static final String PARAM_ASP_LEVEL = "asp_level";
    public static final String PARAM_APP_LEVEL = "app_level";
    public static final String PARAM_TGT_EXP_TIME = "tgt_exp_time";
    public static final String PARAM_ATTRIBUTES = "attributes";
    public static final String PARAM_SIGNATURE = "signature";
    public static final String PARAM_REQUIRED_LEVEL = "required_level";
    public static final String PARAM_LOCAL_IDP = "local_organization";
    public static final String PARAM_LOCAL_IDP_URL = "local_as_url";
    public static final String PARAM_REASON = "reason";
    public static final String PARAM_PASSIVE = "passive";
    public static final String VALUE_REASON_TIMEOUT = "timeout";
    private static final String DEFAULT_JSP_ERROR = "/ui/profiles/aselect/error.jsp";
    private static final String DEFAULT_SSO_PATH = "/sso";
    private static final String DEFAULT_JSP_REDIRECT = "/ui/profiles/aselect/redirectreset.jsp";
    private String _sID;
    private Log _logger = LogFactory.getLog(ASelectProcessor.class);
    private BindingFactory _bindingFactory = new BindingFactory();
    private SPHandler _oSPHandler;
    private IDPHandler _oIDPHandler;
    private BrowserHandler _oBrowserHandler;
    private LogoutManager _oLogoutHandler;
    private IConfigurationManager _configurationManager;
    private String _sJSPError;
    private String _sRedirectJspPath;
    private boolean _bLocalErrorHandling;
    private String _sWebSSOPath;
    private String _sWebSSOURL;

    public void service(HttpServletRequest oServletRequest, HttpServletResponse oServletResponse) throws OAException {
        block31: {
            try {
                IBinding oBinding = this._bindingFactory.getBinding(oServletRequest, oServletResponse);
                if (oBinding == null) {
                    this._logger.error((Object)("Invalid request sent from IP: " + oServletRequest.getRemoteAddr()));
                    throw new ASelectException("0030");
                }
                IRequest oRequest = oBinding.getRequest();
                String sLocalOrganization = (String)oRequest.getParameter(PARAM_LOCAL_IDP);
                String sAppID = (String)oRequest.getParameter(PARAM_APPID);
                String sRequestorID = (String)oRequest.getParameter(PARAM_REQUESTORID);
                String sASelectCredentials = (String)oRequest.getParameter(PARAM_ASELECT_CREDENTIALS);
                String sRID = (String)oRequest.getParameter(PARAM_RID);
                String sRequest = (String)oRequest.getParameter("request");
                if (sRequest == null && sRID != null) {
                    this._logger.debug((Object)("Performing Browser request initiated by the Web SSO sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oBrowserHandler.authenticate(oServletRequest, oServletResponse, oBinding);
                    break block31;
                }
                if (sRequest == null && sRID == null) {
                    this._logger.debug((Object)("Performing user information Browser request sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oBrowserHandler.userinformation(oServletRequest, oServletResponse);
                    break block31;
                }
                if (sRequest == null) {
                    this._logger.error((Object)("No request parameter found in sent from IP: " + oServletRequest.getRemoteAddr()));
                    throw new ASelectException("0030");
                }
                if (sRequest.equals("authenticate") && this._oIDPHandler.isEnabled() && sLocalOrganization != null) {
                    this._logger.debug((Object)("Performing 'authenticate' IDP request sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oIDPHandler.authenticate(oServletRequest, oBinding);
                    break block31;
                }
                if (sRequest.equals("authenticate") && this._oSPHandler.isEnabled()) {
                    this._logger.debug((Object)("Performing 'authenticate' SP request sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oSPHandler.authenticate(oServletRequest, oBinding);
                    break block31;
                }
                if (sRequest.equals("verify_credentials") && this._oIDPHandler.isEnabled() && sLocalOrganization != null) {
                    this._logger.debug((Object)("Performing 'verify_credentials' IDP request sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oIDPHandler.verifyCredentials(oServletRequest, oBinding);
                    break block31;
                }
                if (sRequest.equals("verify_credentials")) {
                    this._logger.debug((Object)("Performing 'verify_credentials' SP request sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oSPHandler.verifyCredentials(oServletRequest, oBinding);
                    break block31;
                }
                if (sRequest.equals("login1")) {
                    this._logger.debug((Object)("Performing 'login1' Browser request sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oBrowserHandler.login1(oServletRequest, oServletResponse, oBinding);
                    break block31;
                }
                if (sRequest.equals("logout") && sASelectCredentials != null && sLocalOrganization != null) {
                    if (this._oIDPHandler.isEnabled()) {
                        this._logger.debug((Object)("Performing 'synchronous logout' request sent from IP: " + oServletRequest.getRemoteAddr()));
                        this._oIDPHandler.doOrganizationSynchronousLogout(oServletRequest, oBinding, sLocalOrganization, sASelectCredentials);
                    } else {
                        this._logger.debug((Object)"Could not process request: IDP handler disabled");
                    }
                    break block31;
                }
                if (sRequest.equals("logout") && sASelectCredentials != null && (sAppID != null || sRequestorID != null)) {
                    if (this._oSPHandler.isEnabled()) {
                        this._logger.debug((Object)("Performing 'synchronous logout' request sent from IP: " + oServletRequest.getRemoteAddr()));
                        this._oSPHandler.doRequestorSynchronousLogout(oServletRequest, oBinding, sRequestorID, sAppID, sASelectCredentials);
                    } else {
                        this._logger.debug((Object)"Could not process request: SP handler disabled");
                    }
                    break block31;
                }
                if (sRequest.equals("logout") && sRID != null) {
                    this._logger.debug((Object)("Performing 'asynchronous logout' Browser request sent from IP: " + oServletRequest.getRemoteAddr()));
                    this._oBrowserHandler.logout(oServletRequest, oServletResponse, oBinding);
                    break block31;
                }
                if (sRequest.equals("slo") && sLocalOrganization != null) {
                    if (this._oIDPHandler.isEnabled()) {
                        this._logger.debug((Object)("Performing 'asynchronous init logout' IDP request sent from IP: " + oServletRequest.getRemoteAddr()));
                        this._oIDPHandler.slo(oServletRequest, oBinding);
                    } else {
                        this._logger.debug((Object)"Could not process request: IDP handler disabled");
                    }
                    break block31;
                }
                if (sRequest.equals("slo")) {
                    if (this._oSPHandler.isEnabled()) {
                        this._logger.debug((Object)("Performing 'asynchronous init logout' SP request sent from IP: " + oServletRequest.getRemoteAddr()));
                        this._oSPHandler.slo(oServletRequest, oBinding);
                    } else {
                        this._logger.debug((Object)"Could not process request: SP handler disabled");
                    }
                    break block31;
                }
                if (this._logger.isDebugEnabled()) {
                    if (this._oSPHandler != null) {
                        this._logger.debug((Object)("SP Handler enabled: " + this._oSPHandler.isEnabled()));
                    }
                    if (this._oIDPHandler != null) {
                        this._logger.debug((Object)("IDP Handler enabled: " + this._oIDPHandler.isEnabled()));
                    }
                }
                StringBuffer sbWarning = new StringBuffer("Invalid request with name: ");
                sbWarning.append(sRequest);
                sbWarning.append(", sent from IP: ");
                sbWarning.append(oServletRequest.getRemoteAddr());
                this._logger.error((Object)sbWarning.toString());
                throw new ASelectException("0030");
            }
            catch (ASelectException e) {
                try {
                    if (!oServletResponse.isCommitted()) {
                        oServletResponse.sendError(400);
                    }
                }
                catch (IOException e1) {
                    this._logger.warn((Object)"Could not send response", (Throwable)e1);
                }
            }
            catch (Exception e) {
                this._logger.fatal((Object)"Internal error during request process", (Throwable)e);
                throw new OAException(1);
            }
        }
    }

    public void init(ServletContext context, IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            this._configurationManager = oConfigurationManager;
            this._sID = this._configurationManager.getParam(eConfig, "id");
            if (this._sID == null) {
                this._logger.error((Object)"No 'id' parameter found in 'profile' section");
                throw new OAException(17);
            }
            String sRedirectURL = oConfigurationManager.getParam(eConfig, "redirect_url");
            if (sRedirectURL == null) {
                this._logger.info((Object)"No optional 'redirect_url' parameter found in 'profile' section with id='aselect' in configuration");
            } else {
                try {
                    new URL(sRedirectURL);
                }
                catch (MalformedURLException e) {
                    this._logger.error((Object)("The supplied 'redirect_url' parameter isn't an URL: " + sRedirectURL), (Throwable)e);
                    throw new OAException(1);
                }
                this._logger.info((Object)("Using configured 'redirect_url' parameter: " + sRedirectURL));
            }
            Element eRedirectJSP = oConfigurationManager.getSection(eConfig, "redirectreset_jsp");
            if (eRedirectJSP == null) {
                this._logger.info((Object)"No optional 'redirectreset_jsp' parameter found in 'profile' section with id='aselect' in configuration, using default");
                this._sRedirectJspPath = DEFAULT_JSP_REDIRECT;
            } else {
                this._sRedirectJspPath = oConfigurationManager.getParam(eRedirectJSP, "path");
                if (this._sRedirectJspPath == null) {
                    this._logger.error((Object)"No 'path' parameter found in 'redirectreset_jsp' section in configuration");
                    throw new OAException(17);
                }
                this._logger.info((Object)("Using configured redirect reset JSP: " + this._sRedirectJspPath));
            }
            this.readConfigError(oConfigurationManager, eConfig);
            this.readConfigWebSSO(oConfigurationManager, eConfig);
            this._oBrowserHandler = new BrowserHandler(sRedirectURL, this._sWebSSOPath, this._sWebSSOURL, this._sJSPError, this._bLocalErrorHandling, this._sID, this._sRedirectJspPath);
            Element eAuthentication = oConfigurationManager.getSection(eConfig, "authentication");
            if (eAuthentication == null) {
                this._logger.error((Object)"No 'authentication' section found in 'profile' section with id='aselect' in configuration");
                throw new OAException(17);
            }
            String sDefaultAuthSPLevel = oConfigurationManager.getParam(eAuthentication, PARAM_AUTHSP_LEVEL);
            if (sDefaultAuthSPLevel == null) {
                this._logger.error((Object)"No default 'authsp_level' item in 'profile' section with id='aselect' found in configuration");
                throw new OAException(17);
            }
            int iDefaultAuthSPLevel = -1;
            try {
                iDefaultAuthSPLevel = Integer.parseInt(sDefaultAuthSPLevel);
            }
            catch (NumberFormatException e) {
                this._logger.error((Object)("Invalid default 'authsp_level' item found in configuration: " + sDefaultAuthSPLevel), (Throwable)e);
                throw new OAException(2);
            }
            this._logger.info((Object)("Configured default 'authsp_level': " + sDefaultAuthSPLevel));
            Hashtable<String, Integer> htAuthSPLevels = this.readConfigAuthNLevels(oConfigurationManager, eAuthentication);
            Element eRequesthandlers = this._configurationManager.getSection(eConfig, "requesthandlers");
            if (eRequesthandlers == null) {
                this._logger.error((Object)"No 'requesthandlers' section found in 'profile' section with id='aselect' in configuration");
                throw new OAException(17);
            }
            Element eSP = this._configurationManager.getSection(eRequesthandlers, "sp");
            if (eSP == null) {
                this._logger.warn((Object)"No optional 'sp' section found in 'requesthandlers' section in configuration");
            }
            this._oSPHandler = new SPHandler(this._configurationManager, eSP, sRedirectURL, htAuthSPLevels, iDefaultAuthSPLevel, this._sID);
            Element eIDP = this._configurationManager.getSection(eRequesthandlers, "idp");
            if (eIDP == null) {
                this._logger.warn((Object)"No optional 'idp' section found in 'requesthandlers' section in configuration");
            }
            this._oIDPHandler = new IDPHandler(this._configurationManager, eIDP, sRedirectURL, htAuthSPLevels, iDefaultAuthSPLevel, this._sID);
            Element eLogout = this._configurationManager.getSection(eConfig, "logout");
            this._oLogoutHandler = new LogoutManager(this._sID, this._configurationManager, eLogout);
            if (this._oLogoutHandler.isEnabled()) {
                Engine.getInstance().getTGTFactory().addListener((ITGTListener)this._oLogoutHandler);
                this._logger.info((Object)"Outgoing synchronous logout: enabled");
            } else {
                this._logger.info((Object)"Outgoing synchronous logout: disabled");
                this._oLogoutHandler = null;
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during request process", (Throwable)e);
            throw new OAException(1);
        }
    }

    public void destroy() {
        if (this._oLogoutHandler != null) {
            try {
                Engine.getInstance().getTGTFactory().removeListener((ITGTListener)this._oLogoutHandler);
            }
            catch (OAException e) {
                this._logger.error((Object)"Could not remove the logout handler as TGT listener", (Throwable)e);
            }
        }
        this._oIDPHandler = null;
        this._oSPHandler = null;
        this._oBrowserHandler = null;
    }

    public String getID() {
        return this._sID;
    }

    private void readConfigError(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        this._bLocalErrorHandling = false;
        this._sJSPError = DEFAULT_JSP_ERROR;
        Element eError = oConfigurationManager.getSection(eConfig, "error");
        if (eError == null) {
            this._logger.warn((Object)("No optional 'error' section found in 'profile' section with id='" + this._sID + "' in configuration, using defaults"));
        } else {
            Element eJsp = oConfigurationManager.getSection(eError, "jsp");
            if (eJsp == null) {
                this._logger.warn((Object)"No optional 'jsp' section found in 'error' section in configuration, using defaults");
            } else {
                this._sJSPError = oConfigurationManager.getParam(eJsp, "path");
                if (this._sJSPError == null) {
                    this._logger.error((Object)"No 'path' parameter found in 'jsp' section in configuration");
                    throw new OAException(17);
                }
            }
            Element eHandling = oConfigurationManager.getSection(eError, "handling");
            if (eHandling != null) {
                String sLocal = oConfigurationManager.getParam(eHandling, "local");
                if (sLocal == null) {
                    this._logger.error((Object)"No 'local' parameter found in 'handling' section in configuration");
                    throw new OAException(17);
                }
                if (sLocal.equalsIgnoreCase("true")) {
                    this._bLocalErrorHandling = true;
                } else if (!sLocal.equalsIgnoreCase("false")) {
                    this._logger.error((Object)("Wrong 'local' parameter found in 'handling' section in configuration; must be TRUE or FALSE: " + sLocal));
                    throw new OAException(17);
                }
            }
        }
        this._logger.info((Object)("Using local error handling: " + this._bLocalErrorHandling));
        this._logger.info((Object)("Using error handling: " + this._sJSPError));
    }

    private Hashtable<String, Integer> readConfigAuthNLevels(IConfigurationManager oConfigurationManager, Element eAuthentication) throws OAException {
        IAuthenticationProfileFactory authNProfileFactory = Engine.getInstance().getAuthenticationProfileFactory();
        Hashtable<String, Integer> htAuthSPLevels = new Hashtable<String, Integer>();
        Element eAuthNProfile = oConfigurationManager.getSection(eAuthentication, "profile");
        while (eAuthNProfile != null) {
            String sAuthNProfileID = oConfigurationManager.getParam(eAuthNProfile, "id");
            if (sAuthNProfileID == null) {
                this._logger.error((Object)"No 'id' item in 'profile' section found in configuration");
                throw new OAException(17);
            }
            if (authNProfileFactory.getProfile(sAuthNProfileID) == null) {
                this._logger.error((Object)("The configured 'id' doesn't exist as an authentication profile: " + sAuthNProfileID));
                throw new OAException(2);
            }
            String sAuthSPLevel = oConfigurationManager.getParam(eAuthNProfile, PARAM_AUTHSP_LEVEL);
            if (sAuthSPLevel == null) {
                this._logger.error((Object)("No 'authsp_level' item in 'profile' section found in configuration for profile id: " + sAuthNProfileID));
                throw new OAException(17);
            }
            Integer intAuthSPLevel = null;
            try {
                intAuthSPLevel = Integer.parseInt(sAuthSPLevel);
            }
            catch (NumberFormatException e) {
                StringBuffer sbError = new StringBuffer("Invalid 'authsp_level' item in 'profile' section found in configuration for profile id '");
                sbError.append(sAuthNProfileID);
                sbError.append("' level isn't a number: ");
                sbError.append(sAuthSPLevel);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new OAException(2);
            }
            if (htAuthSPLevels.containsKey(sAuthNProfileID)) {
                this._logger.warn((Object)("The configured authentication profile doesn't have an unique id: " + sAuthNProfileID));
                throw new OAException(2);
            }
            htAuthSPLevels.put(sAuthNProfileID, intAuthSPLevel);
            StringBuffer sbInfo = new StringBuffer("Configured: authsp_level=");
            sbInfo.append(sAuthSPLevel);
            sbInfo.append(" for authentication profile with id: ");
            sbInfo.append(sAuthNProfileID);
            this._logger.info((Object)sbInfo.toString());
            eAuthNProfile = oConfigurationManager.getNextSection(eAuthNProfile);
        }
        return htAuthSPLevels;
    }

    private void readConfigWebSSO(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        this._sWebSSOPath = DEFAULT_SSO_PATH;
        this._sWebSSOURL = null;
        Element eWebSSO = oConfigurationManager.getSection(eConfig, "websso");
        if (eWebSSO == null) {
            this._logger.warn((Object)("No optional 'websso' section found in 'profile' section with id='" + this._sID + "' in configuration, using defaults"));
        } else {
            String sWebSSOUrl;
            String sWebSSOPath = oConfigurationManager.getParam(eWebSSO, "path");
            if (sWebSSOPath == null) {
                this._logger.warn((Object)"No optional 'path' parameter found in 'websso' section in configuration, using default");
            }
            if ((sWebSSOUrl = oConfigurationManager.getParam(eWebSSO, "url")) == null) {
                this._logger.warn((Object)"No optional 'url' parameter found in 'websso' section in configuration, only using forwards");
            } else {
                this._logger.info((Object)("Using configured WebSSO URL: " + sWebSSOUrl));
            }
        }
        this._logger.info((Object)("Using configured WebSSO path: " + this._sWebSSOPath));
    }
}

