/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.logout;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.api.tgt.TGTListenerEvent;
import com.alfaariss.oa.api.tgt.TGTListenerException;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.requestor.factory.IRequestorPoolFactory;
import com.alfaariss.oa.engine.core.server.Server;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.profile.aselect.logout.LogoutTarget;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class LogoutManager
implements ITGTListener,
IAuthority {
    private static final String AUTHORITY_NAME = "ASelectProfileLogoutManager_";
    private static final String PROPERTY_LOGOUT_TARGET = ".logout.target";
    private static final String PROPERTY_LOGOUT_SIGNING = ".logout.signing";
    private static Log _logger;
    private static Log _eventLogger;
    private ITGTAliasStore _aliasStoreSPRole;
    private IRequestorPoolFactory _requestorPoolFactory;
    private CryptoManager _cryptoManager;
    private Server _server;
    private String _sProfileID;
    private HttpClient _httpClient;
    private boolean _bEnabled;

    public LogoutManager(String profileID, IConfigurationManager configurationManager, Element config) throws OAException {
        try {
            String sEnabled;
            _logger = LogFactory.getLog(LogoutManager.class);
            _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
            this._bEnabled = true;
            if (config != null && (sEnabled = configurationManager.getParam(config, "enabled")) != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new OAException(17);
                }
            }
            if (!this._bEnabled) {
                _logger.info((Object)"Logout Manager: disabled");
            } else {
                Engine engine = Engine.getInstance();
                ITGTFactory tgtFactory = engine.getTGTFactory();
                this._aliasStoreSPRole = tgtFactory.getAliasStoreSP();
                this._requestorPoolFactory = engine.getRequestorPoolFactory();
                this._cryptoManager = engine.getCryptoManager();
                this._server = engine.getServer();
                this._sProfileID = profileID;
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                this._httpClient = new HttpClient((HttpConnectionManager)connectionManager);
                if (config != null) {
                    Element eHTTP = configurationManager.getSection(config, "http");
                    if (eHTTP != null) {
                        this.readHTTPConfig(configurationManager, eHTTP);
                    } else {
                        _logger.info((Object)"No optional 'http' section configured, using default http connection settings");
                    }
                }
                _logger.info((Object)"Logout Manager: enabled");
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Could not create logout manager", (Throwable)e);
            throw new OAException(1);
        }
    }

    public void processTGTEvent(TGTListenerEvent event, ITGT tgt) throws TGTListenerException {
        if (!this._bEnabled) {
            return;
        }
        switch (event) {
            case ON_EXPIRE: 
            case ON_REMOVE: {
                Vector<TGTEventError> listEventErrors = new Vector<TGTEventError>();
                if (this._aliasStoreSPRole != null) {
                    listEventErrors.addAll(this.processRemove(tgt, event));
                }
                if (listEventErrors.isEmpty()) break;
                throw new TGTListenerException(listEventErrors);
            }
        }
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    public String getAuthority() {
        return AUTHORITY_NAME + this._sProfileID;
    }

    private List<TGTEventError> processRemove(ITGT tgt, TGTListenerEvent event) {
        Vector<TGTEventError> listEventErrors = new Vector<TGTEventError>();
        Vector<LogoutTarget> listLogoutTargets = new Vector<LogoutTarget>();
        HashMap mapTargets = new HashMap();
        for (String sRequestor : tgt.getRequestorIDs()) {
            UserEventLogItem logItem;
            TGTEventError error;
            IRequestor requestor = null;
            try {
                String sLogoutURL;
                String sCredentials;
                if (mapTargets.containsKey(sRequestor) || (sCredentials = this._aliasStoreSPRole.getAlias("aselect_credentials", sRequestor, tgt.getId())) == null || (sLogoutURL = (String)(requestor = this._requestorPoolFactory.getRequestor(sRequestor)).getProperty(this._sProfileID + PROPERTY_LOGOUT_TARGET)) == null) continue;
                String sSigning = (String)requestor.getProperty(this._sProfileID + PROPERTY_LOGOUT_SIGNING);
                new URL(sLogoutURL);
                String sLocation = this.generateSLogout(sLogoutURL, sCredentials, Boolean.valueOf(sSigning), event);
                LogoutTarget lt = new LogoutTarget(requestor, sLocation, tgt);
                listLogoutTargets.add(lt);
            }
            catch (MalformedURLException e) {
                error = null;
                error = requestor != null ? new TGTEventError(UserEvent.INTERNAL_ERROR, requestor.getFriendlyName()) : new TGTEventError(UserEvent.INTERNAL_ERROR);
                listEventErrors.add(error);
                logItem = new UserEventLogItem(null, tgt.getId(), null, UserEvent.INTERNAL_ERROR, tgt.getUser().getID(), tgt.getUser().getOrganization(), null, sRequestor, (IAuthority)this, null);
                _eventLogger.info((Object)logItem);
            }
            catch (OAException e) {
                error = null;
                error = requestor != null ? new TGTEventError(UserEvent.INTERNAL_ERROR, requestor.getFriendlyName()) : new TGTEventError(UserEvent.INTERNAL_ERROR);
                listEventErrors.add(error);
                logItem = new UserEventLogItem(null, tgt.getId(), null, UserEvent.INTERNAL_ERROR, tgt.getUser().getID(), tgt.getUser().getOrganization(), null, sRequestor, (IAuthority)this, null);
                _eventLogger.info((Object)logItem);
            }
        }
        for (LogoutTarget lt : listLogoutTargets) {
            UserEvent result = this.sendSLogout(lt.getTargetURL());
            if (result != UserEvent.USER_LOGGED_OUT) {
                listEventErrors.add(new TGTEventError(result, lt.getRequestor().getFriendlyName()));
            }
            UserEventLogItem logItem = new UserEventLogItem(null, lt.getTGTID(), null, result, lt.getUserID(), lt.getUserOrganization(), null, lt.getRequestor().getID(), (IAuthority)this, null);
            _eventLogger.info((Object)logItem);
        }
        return listEventErrors;
    }

    private String generateSLogout(String sLogoutURL, String sCredentials, boolean sign, TGTListenerEvent event) throws OAException {
        String logoutCall = null;
        try {
            HashMap<String, String> mapRequest = new HashMap<String, String>();
            mapRequest.put("local_organization", this._server.getOrganization().getID());
            mapRequest.put("aselect_credentials", sCredentials);
            if (event == TGTListenerEvent.ON_EXPIRE) {
                mapRequest.put("reason", "timeout");
            }
            if (sign) {
                String signature = this.createSignature(mapRequest);
                mapRequest.put("signature", signature);
            }
            mapRequest.put("request", "logout");
            StringBuffer sbMessage = new StringBuffer(sLogoutURL);
            if (!sLogoutURL.contains("?")) {
                sbMessage.append("?");
            }
            for (String key : mapRequest.keySet()) {
                if (!sbMessage.toString().endsWith("&") && !sbMessage.toString().endsWith("?")) {
                    sbMessage.append("&");
                }
                sbMessage.append(key);
                sbMessage.append("=");
                sbMessage.append(URLEncoder.encode((String)mapRequest.get(key), "UTF-8"));
            }
            logoutCall = sbMessage.toString();
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.error((Object)"Could not generate logout call", (Throwable)e);
            throw new OAException(1);
        }
        return logoutCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserEvent sendSLogout(String logoutCall) {
        UserEvent userEvent;
        GetMethod method = null;
        try {
            method = new GetMethod(logoutCall);
            _logger.debug((Object)("Sending message: " + logoutCall));
            int statusCode = this._httpClient.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                StringBuffer sbWarn = new StringBuffer("Received invalid http status '");
                sbWarn.append(method.getStatusLine());
                sbWarn.append("' while sending: ");
                sbWarn.append(logoutCall);
                _logger.warn((Object)sbWarn.toString());
                throw new OAException(33);
            }
            byte[] responseBody = method.getResponseBody();
            if (responseBody != null) {
                String sResponseMessage = new String(responseBody).trim();
                _logger.debug((Object)("Received response: " + sResponseMessage));
                Hashtable<String, String> htResponse = this.convertCGI(sResponseMessage);
                String sResultCode = htResponse.get("result_code");
                if (sResultCode == null) {
                    _logger.debug((Object)"No result code in response, logout failed");
                    UserEvent userEvent2 = UserEvent.USER_LOGOUT_FAILED;
                    return userEvent2;
                }
                if (!sResultCode.equals("0000")) {
                    if (sResultCode.equals("9912")) {
                        _logger.debug((Object)"Logout parially in response from server");
                        UserEvent userEvent3 = UserEvent.USER_LOGOUT_PARTIALLY;
                        return userEvent3;
                    }
                    _logger.debug((Object)("Logout failed, result code: " + sResultCode));
                    UserEvent userEvent4 = UserEvent.USER_LOGOUT_FAILED;
                    return userEvent4;
                }
            }
        }
        catch (OAException e) {
            userEvent = UserEvent.USER_LOGOUT_FAILED;
            return userEvent;
        }
        catch (Exception e) {
            _logger.warn((Object)"Could not send synchronous logout", (Throwable)e);
            userEvent = UserEvent.USER_LOGOUT_FAILED;
            return userEvent;
        }
        finally {
            try {
                if (method != null) {
                    method.releaseConnection();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close the connection reader", (Throwable)e);
            }
        }
        return UserEvent.USER_LOGGED_OUT;
    }

    private void readHTTPConfig(IConfigurationManager configurationManager, Element config) throws OAException {
        String sConnectionTimeout = configurationManager.getParam(config, "connection_timeout");
        if (sConnectionTimeout == null) {
            _logger.info((Object)"No 'connection_timeout' parameter found in configuration, using default");
        } else {
            try {
                int iConnectionTimeout = Integer.parseInt(sConnectionTimeout);
                this._httpClient.getParams().setParameter("http.connection.timeout", (Object)new Integer(iConnectionTimeout));
            }
            catch (NumberFormatException e) {
                _logger.error((Object)("Invalid 'connection_timeout' parameter found in configuration, not a number: " + sConnectionTimeout), (Throwable)e);
                throw new OAException(2);
            }
        }
        String sSocketTimeout = configurationManager.getParam(config, "socket_timeout");
        if (sSocketTimeout == null) {
            _logger.info((Object)"No 'socket_timeout' parameter found in configuration, using an infinite timeout");
        } else {
            try {
                int iSocketTimeout = Integer.parseInt(sSocketTimeout);
                this._httpClient.getParams().setParameter("http.socket.timeout", (Object)new Integer(iSocketTimeout));
            }
            catch (NumberFormatException e) {
                _logger.error((Object)("Invalid 'socket_timeout' parameter found in configuration, not a number: " + sSocketTimeout), (Throwable)e);
                throw new OAException(2);
            }
        }
    }

    private String createSignature(Map<String, String> mapRequest) throws OAException {
        String sSignature = null;
        try {
            if (this._cryptoManager == null) {
                _logger.warn((Object)"No crypto manager available");
                throw new OAException(1);
            }
            Signature signature = this._cryptoManager.getSignature();
            if (signature == null) {
                _logger.warn((Object)"No signature object found");
                throw new OAException(1);
            }
            StringBuffer sbSignatureData = new StringBuffer();
            TreeSet<String> sortedSet = new TreeSet<String>(mapRequest.keySet());
            for (String sKey : sortedSet) {
                sbSignatureData.append(mapRequest.get(sKey));
            }
            PrivateKey keyPrivate = this._cryptoManager.getPrivateKey();
            if (keyPrivate == null) {
                _logger.error((Object)"No private key available");
                throw new OAException(1);
            }
            signature.initSign(keyPrivate);
            signature.update(sbSignatureData.toString().getBytes("UTF-8"));
            byte[] baSignature = signature.sign();
            byte[] baEncSignature = Base64.encodeBase64((byte[])baSignature);
            sSignature = new String(baEncSignature, "UTF-8");
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)("Could not create signature for data: " + mapRequest), (Throwable)e);
            throw new OAException(1);
        }
        return sSignature;
    }

    private Hashtable<String, String> convertCGI(String sMessage) throws OAException {
        Hashtable<String, String> htResult = new Hashtable<String, String>();
        try {
            if (sMessage.trim().length() == 0) {
                return htResult;
            }
            String[] saMessage = sMessage.split("&");
            for (int i = 0; i < saMessage.length; ++i) {
                String sPart = saMessage[i];
                int iIndex = sPart.indexOf(61);
                String sKey = sPart.substring(0, iIndex);
                sKey = sKey.trim();
                String sValue = sPart.substring(iIndex + 1);
                sValue = URLDecoder.decode(sValue.trim(), "UTF-8");
                if (htResult.containsKey(sKey)) {
                    _logger.error((Object)("Key is not unique in message: " + sKey));
                    throw new OAException(1);
                }
                htResult.put(sKey, sValue);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during conversion of message: " + sMessage), (Throwable)e);
            throw new OAException(1);
        }
        return htResult;
    }
}

