/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.business.requestor;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.RequestorEvent;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.api.tgt.TGTListenerException;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authentication.AuthenticationException;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import com.alfaariss.oa.engine.core.authentication.factory.IAuthenticationProfileFactory;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.user.UserException;
import com.alfaariss.oa.profile.aselect.business.AbstractOAService;
import com.alfaariss.oa.profile.aselect.business.AuthNException;
import com.alfaariss.oa.profile.aselect.business.BusinessRuleException;
import com.alfaariss.oa.profile.aselect.business.beans.TGTInfo;
import com.alfaariss.oa.profile.aselect.business.requestor.IRequestorService;
import com.alfaariss.oa.profile.aselect.processor.ASelectProcessor;
import com.alfaariss.oa.profile.aselect.processor.handler.ASelectRequestorPool;
import com.alfaariss.oa.util.logging.RequestorEventLogItem;
import com.alfaariss.oa.util.session.ProxyAttributes;
import com.alfaariss.oa.util.validation.LocaleValidator;
import com.alfaariss.oa.util.validation.SessionValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.w3c.dom.Element;

public class RequestorService
extends AbstractOAService
implements IRequestorService {
    public static final String AUTHORITY_NAME = "A-Select WS Profile";
    private static final String PROPERTY_APP_LEVEL = "aselect.app_level";
    private static final String PROPERTY_UID_ATTRIBUTE = "aselect.uid.attribute";
    private static final String PROPERTY_UID_OPAQUE_ENABLED = "aselect.uid.opaque.enabled";
    private static final String PROPERTY_UID_OPAQUE_SALT = "aselect.uid.opaque.salt";
    private static final String PROPERTY_AUTHSP_LEVEL = "aselect.authsp_level";
    private boolean _initialized = false;
    private boolean _forceRequestorID = false;
    private Hashtable<String, Integer> _htAuthSPLevels;
    private int _iDefaultAuthSPLevel;
    private Hashtable<String, ASelectRequestorPool> _htASelectRequestorPools;
    private int _iDefaultAppLevel;
    private String _sRedirectURL;

    @Override
    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        block36: {
            Element eWS = null;
            boolean bEnabled = false;
            try {
                Element eAuthentication;
                super.start(oConfigurationManager, eConfig);
                if (this._eOASection != null && (eWS = oConfigurationManager.getSection(this._eOASection, "ws")) != null) {
                    String sEnabled = this._configurationManager.getParam(eWS, "enabled");
                    if (sEnabled != null) {
                        if (sEnabled.equalsIgnoreCase("TRUE")) {
                            bEnabled = true;
                        } else if (!sEnabled.equalsIgnoreCase("FALSE")) {
                            this._logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                            throw new UserException(17);
                        }
                    } else {
                        bEnabled = true;
                    }
                }
                if (!bEnabled) break block36;
                this._sRedirectURL = oConfigurationManager.getParam(this._eOASection, "redirect_url");
                if (this._sRedirectURL == null) {
                    this._logger.warn((Object)"No 'redirect_url' parameter found in 'profile' section with id='aselect' in configuration");
                    throw new OAException(17);
                }
                try {
                    new URL(this._sRedirectURL);
                }
                catch (MalformedURLException e) {
                    this._logger.error((Object)("The supplied 'redirect_url' parameter isn't a URL: " + this._sRedirectURL));
                    throw new OAException(17);
                }
                this._logger.info((Object)("Using configured 'redirect_url' parameter: " + this._sRedirectURL));
                String sForced = oConfigurationManager.getParam(eWS, "force_requestor_id");
                if (sForced != null) {
                    if (sForced.equalsIgnoreCase("true")) {
                        this._logger.info((Object)"Force requestor ID is enabled");
                        this._forceRequestorID = true;
                    } else if (!sForced.equalsIgnoreCase("false")) {
                        this._logger.warn((Object)("Wrong 'force_requestor_id' parameter found in 'ws' section; must be TRUE or FALSE: " + sForced));
                        throw new OAException(17);
                    }
                }
                if (!this._forceRequestorID) {
                    this._logger.info((Object)"Force requestor ID is disabled");
                }
                if ((eAuthentication = oConfigurationManager.getSection(this._eOASection, "authentication")) == null) {
                    this._logger.error((Object)"No 'authentication' section found in 'profile' section with id='aselect' in configuration");
                    throw new OAException(17);
                }
                Element eRequesthandlers = this._configurationManager.getSection(this._eOASection, "requesthandlers");
                if (eRequesthandlers == null) {
                    this._logger.error((Object)"No 'requesthandlers' section found in 'profile' section with id='aselect' in configuration");
                    throw new OAException(17);
                }
                Element eSP = this._configurationManager.getSection(eRequesthandlers, "sp");
                if (eSP == null) {
                    this._logger.error((Object)"No 'sp' section found in 'requesthandlers' section in configuration");
                    throw new OAException(17);
                }
                String sDefaultAppLevel = oConfigurationManager.getParam(eSP, "app_level");
                if (sDefaultAppLevel == null) {
                    this._logger.error((Object)"No default 'app_level' item in handler section found in configuration");
                    throw new OAException(17);
                }
                try {
                    this._iDefaultAppLevel = Integer.valueOf(sDefaultAppLevel);
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)("The configured default 'app_level' parameter isn't a number: " + sDefaultAppLevel), (Throwable)e);
                    throw new OAException(2);
                }
                this._logger.info((Object)("Configured default 'app_level': " + sDefaultAppLevel));
                this._htASelectRequestorPools = new Hashtable();
                Element eRequestorPool = oConfigurationManager.getSection(eSP, "requestorpool");
                while (eRequestorPool != null) {
                    ASelectRequestorPool oASRequestorPool = new ASelectRequestorPool(oConfigurationManager, eRequestorPool);
                    String sPoolId = oASRequestorPool.getID();
                    if (this._htASelectRequestorPools.containsKey(sPoolId)) {
                        this._logger.warn((Object)("The configured 'requestorpool' doesn't have a unique id: " + sPoolId));
                        throw new OAException(2);
                    }
                    if (!this._requestorPoolFactory.isPool(sPoolId)) {
                        this._logger.warn((Object)("The configured 'requestorpool' doesn't exist as a requestor pool: " + sPoolId));
                        throw new OAException(2);
                    }
                    this._htASelectRequestorPools.put(sPoolId, oASRequestorPool);
                    this._logger.info((Object)("Configured: " + oASRequestorPool));
                    eRequestorPool = oConfigurationManager.getNextSection(eRequestorPool);
                }
                String sDefaultAuthSPLevel = oConfigurationManager.getParam(eAuthentication, "authsp_level");
                if (sDefaultAuthSPLevel == null) {
                    this._logger.error((Object)"No default 'authsp_level' item found in 'profile' section with id='aselect' in configuration");
                    throw new OAException(17);
                }
                this._iDefaultAuthSPLevel = -1;
                try {
                    this._iDefaultAuthSPLevel = Integer.parseInt(sDefaultAuthSPLevel);
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)("Invalid default 'authsp_level' item found in configuration: " + sDefaultAuthSPLevel));
                    throw new OAException(2);
                }
                this._logger.info((Object)("Configured default 'authsp_level': " + this._iDefaultAuthSPLevel));
                Engine oAEEngine = Engine.getInstance();
                IAuthenticationProfileFactory authNProfileFactory = oAEEngine.getAuthenticationProfileFactory();
                this._htAuthSPLevels = new Hashtable();
                Element eAuthNProfile = oConfigurationManager.getSection(eAuthentication, "profile");
                while (eAuthNProfile != null) {
                    String sAuthNProfileID = oConfigurationManager.getParam(eAuthNProfile, "id");
                    if (sAuthNProfileID == null) {
                        this._logger.error((Object)"No 'id' item in 'profile' section found in configuration");
                        throw new OAException(17);
                    }
                    if (authNProfileFactory.getProfile(sAuthNProfileID) == null) {
                        this._logger.error((Object)("The configured 'id' doesn't exist as an authentication profile: " + sAuthNProfileID));
                        throw new OAException(2);
                    }
                    String sAuthSPLevel = oConfigurationManager.getParam(eAuthNProfile, "authsp_level");
                    if (sAuthSPLevel == null) {
                        this._logger.error((Object)("No 'authsp_level' item in 'profile' section found in configuration for profile id: " + sAuthNProfileID));
                        throw new OAException(17);
                    }
                    Integer intAuthSPLevel = null;
                    try {
                        intAuthSPLevel = Integer.parseInt(sAuthSPLevel);
                    }
                    catch (NumberFormatException e) {
                        StringBuffer sbError = new StringBuffer("Invalid 'authsp_level' item in 'profile' section found in configuration for profile id '");
                        sbError.append(sAuthNProfileID);
                        sbError.append("' level isn't a number: ");
                        sbError.append(sAuthSPLevel);
                        this._logger.error((Object)sbError.toString(), (Throwable)e);
                        throw new OAException(2);
                    }
                    if (this._htAuthSPLevels.containsKey(sAuthNProfileID)) {
                        this._logger.warn((Object)("The configured authentication profile doesn't have a unique id: " + sAuthNProfileID));
                        throw new OAException(2);
                    }
                    this._htAuthSPLevels.put(sAuthNProfileID, intAuthSPLevel);
                    StringBuffer sbInfo = new StringBuffer("Configured: authsp_level=");
                    sbInfo.append(sAuthSPLevel);
                    sbInfo.append(" for authentication profile with id: ");
                    sbInfo.append(sAuthNProfileID);
                    this._logger.info((Object)sbInfo.toString());
                    eAuthNProfile = oConfigurationManager.getNextSection(eAuthNProfile);
                }
                this._initialized = true;
            }
            catch (OAException e) {
                this._logger.error((Object)"Could not start A-Select WS service", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this._logger.fatal((Object)"Could not start A-Select WS service due to internal error", (Throwable)e);
                throw new OAException(1);
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this._initialized;
    }

    public String getAuthority() {
        return AUTHORITY_NAME;
    }

    @Override
    public ISession initiateAuthentication(String sOaID, String sRequestorID, String sRequestorURL, String sRemoteOrganization, String sForcedLogon, String sUID, String sRemoteAddr, String sCountry, String sLanguage, boolean isSigned, String sPassive) throws BusinessRuleException, OAException {
        ISession oSession = null;
        try {
            if (!this.isInitialized()) {
                this._logger.warn((Object)"OA Requestor Service not initialized");
                throw new OAException(3);
            }
            if (sOaID == null) {
                this._logger.debug((Object)"No oa server ID found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sRequestorID == null) {
                this._logger.debug((Object)"No requestor ID found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sRequestorURL == null) {
                this._logger.debug((Object)"No requestor URL found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            try {
                new URL(sRequestorURL);
            }
            catch (MalformedURLException e) {
                this._logger.debug((Object)"Invalid requestor URL found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0032");
            }
            boolean forcedLogon = false;
            if (sForcedLogon != null) {
                if (sForcedLogon.equalsIgnoreCase("true")) {
                    forcedLogon = true;
                } else if (!sForcedLogon.equalsIgnoreCase("false")) {
                    this._logger.debug((Object)("Invalid forced logon parameter found: " + sForcedLogon));
                    throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
                }
            }
            boolean passive = false;
            if (sPassive != null) {
                if (sPassive.equalsIgnoreCase("true")) {
                    passive = true;
                } else if (!sPassive.equalsIgnoreCase("false")) {
                    this._logger.debug((Object)("Invalid forced logon parameter found: " + sPassive));
                    throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
                }
            }
            if (!this._OAServer.getID().equals(sOaID)) {
                this._logger.debug((Object)("Supplied OA Server ID doesn't correspond: " + sOaID));
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0033");
            }
            IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sRequestorID);
            if (oRequestor == null) {
                StringBuffer sbError = new StringBuffer("Unknown requestor found in request: ");
                sbError.append(sRequestorID);
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0031");
            }
            if (!oRequestor.isEnabled()) {
                this._logger.debug((Object)("Disabled requestor found in request: " + sRequestorID));
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0031");
            }
            RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(oRequestor.getID());
            if (oRequestorPool == null) {
                this._logger.warn((Object)("Requestor not available in a pool: " + oRequestor.getID()));
                throw new OAException(1);
            }
            if (!oRequestorPool.isEnabled()) {
                StringBuffer sbError = new StringBuffer("Requestor '");
                sbError.append(oRequestor.getID());
                sbError.append("' is found in a disabled requestor pool: ");
                sbError.append(oRequestorPool.getID());
                this._logger.warn((Object)sbError.toString());
                throw new OAException(1);
            }
            ASelectRequestorPool oASRequestorPool = this._htASelectRequestorPools.get(oRequestorPool.getID());
            if (!isSigned && this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                StringBuffer sbError = new StringBuffer("Requestor '");
                sbError.append(oRequestor.getID());
                sbError.append("' requires signing and the message is not signed");
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            oSession = this._SessionFactory.createSession(sRequestorID);
            oSession.setForcedAuthentication(forcedLogon);
            oSession.setPassive(passive);
            ISessionAttributes oAttributes = oSession.getAttributes();
            oAttributes.put(ASelectProcessor.class, "requestor_url", (Object)sRequestorURL);
            if (sUID != null) {
                if (sUID.length() <= 0) {
                    this._logger.debug((Object)"Invalid uid found in request");
                    throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
                }
                oSession.setForcedUserID(sUID);
            } else {
                this._logger.debug((Object)"No optional user ID found in request");
            }
            if (sRemoteOrganization != null) {
                Vector<String> cOrganizations = new Vector<String>();
                cOrganizations.add(sRemoteOrganization);
                oAttributes.put(ProxyAttributes.class, "forced_organizations", cOrganizations);
            } else {
                this._logger.debug((Object)"No optional remote organization found in request");
            }
            Locale oLocale = null;
            if (sCountry == null) {
                this._logger.debug((Object)"No optional country found in request");
            } else if (!LocaleValidator.validateCountry((String)sCountry)) {
                StringBuffer sbError = new StringBuffer("Invalid country found in request: ");
                sbError.append(sCountry);
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sLanguage == null) {
                this._logger.debug((Object)"No optional language found in request");
                if (sCountry != null) {
                    oLocale = new Locale(Locale.getDefault().getLanguage(), sCountry);
                }
            } else {
                if (!LocaleValidator.validateLanguage((String)sLanguage)) {
                    StringBuffer sbError = new StringBuffer("Invalid language found in request: ");
                    sbError.append(sLanguage);
                    this._logger.debug((Object)sbError.toString());
                    throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
                }
                oLocale = sCountry != null ? new Locale(sLanguage, sCountry) : new Locale(sLanguage);
            }
            oSession.setLocale(oLocale);
            oSession.persist();
            this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.AUTHN_INITIATION_SUCCESSFUL, (IAuthority)this, null));
        }
        catch (BusinessRuleException e) {
            this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, e.getEvent(), null, sRemoteAddr, null, (IAuthority)this, e.getMessage()));
            throw e;
        }
        catch (OAException e) {
            this._logger.warn((Object)"Internal error during initiation of the authentication process", (Throwable)e);
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            }
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during initiation of the authentication process", (Throwable)e);
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            }
            throw new OAException(1, (Throwable)e);
        }
        return oSession;
    }

    @Override
    public TGTInfo verifyAuthentication(String sOaID, String sRequestorID, String sRID, String sCredentials, String sRemoteAddr, boolean isSigned) throws BusinessRuleException, OAException, AuthNException {
        TGTInfo info = null;
        ISession oSession = null;
        try {
            if (!this.isInitialized()) {
                this._logger.warn((Object)"A-Select WS Requestor Service not initialized");
                throw new OAException(3);
            }
            if (sRID == null) {
                this._logger.debug((Object)"No rid found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sOaID == null) {
                this._logger.debug((Object)"No oa server ID found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (this._forceRequestorID && sRequestorID == null) {
                this._logger.debug((Object)"No requestor ID found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (!SessionValidator.validateDefaultSessionId((String)sRID)) {
                this._logger.debug((Object)"Invalid rid found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sCredentials == null) {
                this._logger.debug((Object)"No credentials found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (!this._OAServer.getID().equals(sOaID)) {
                StringBuffer sbError = new StringBuffer("The OA Server ID doesn't correspond to the supplied oa ID: ");
                sbError.append(sOaID);
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0033");
            }
            oSession = this._SessionFactory.retrieve((Object)sRID);
            if (oSession == null) {
                this._logger.debug((Object)("No session found with id: " + sRID));
                throw new BusinessRuleException(RequestorEvent.SESSION_INVALID, "0102");
            }
            if (oSession.isExpired()) {
                this._logger.debug((Object)("Session expired with id: " + sRID));
                throw new BusinessRuleException(RequestorEvent.SESSION_EXPIRED, "0102");
            }
            String sOrigionalRequestor = oSession.getRequestorId();
            if (sRequestorID != null && !sOrigionalRequestor.equals(sRequestorID)) {
                this._logger.debug((Object)"Supplied requestor ID does not match original requestor");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            ISessionAttributes oAttributes = oSession.getAttributes();
            String sRequestorUrl = (String)oAttributes.get(ASelectProcessor.class, "requestor_url");
            if (sRequestorUrl == null) {
                this._logger.warn((Object)"No session attribute found with with name: requestor_url");
                throw new OAException(1);
            }
            String sSessionCredentials = (String)oAttributes.get(ASelectProcessor.class, "credentials");
            if (sSessionCredentials == null) {
                this._logger.debug((Object)"No valid credentials in session");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0007");
            }
            if (!sSessionCredentials.equals(sCredentials)) {
                StringBuffer sbWarn = new StringBuffer("Credentials in session (");
                sbWarn.append(sSessionCredentials);
                sbWarn.append(") doesn't correspond to credentials in request: ");
                sbWarn.append(sCredentials);
                this._logger.debug((Object)sbWarn.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0007");
            }
            switch (oSession.getState()) {
                case AUTHN_OK: {
                    IAuthenticationProfile oAuthNProfile;
                    IUser oUser = oSession.getUser();
                    if (oUser == null) {
                        this._logger.warn((Object)"No User found in session");
                        throw new OAException(1);
                    }
                    IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sOrigionalRequestor);
                    if (oRequestor == null) {
                        this._logger.warn((Object)("No Requestor found with id: " + sOrigionalRequestor));
                        throw new OAException(1);
                    }
                    RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(sOrigionalRequestor);
                    if (oRequestorPool == null) {
                        this._logger.warn((Object)("No Requestor Pool found for requestor id: " + sOrigionalRequestor));
                        throw new OAException(1);
                    }
                    ASelectRequestorPool oASRequestorPool = this._htASelectRequestorPools.get(oRequestorPool.getID());
                    if (!isSigned && this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                        StringBuffer sbError = new StringBuffer("Requestor '");
                        sbError.append(oRequestor.getID());
                        sbError.append("' requires signing and the message is not signed");
                        this._logger.debug((Object)sbError.toString());
                        throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
                    }
                    String sAppLevel = this.getAppLevel(oRequestorPool, oASRequestorPool, oRequestor);
                    int iAppLevel = Integer.valueOf(sAppLevel);
                    long lTGTExpireTime = 0L;
                    String sAuthNProfile = null;
                    ITGT oTGT = null;
                    String sTGTID = oSession.getTGTId();
                    if (sTGTID != null) {
                        oTGT = this._tgtFactory.retrieve((Object)sTGTID);
                        if (oTGT == null) {
                            this._logger.warn((Object)"No TGT ID found in session");
                            throw new OAException(1);
                        }
                        lTGTExpireTime = oTGT.getTgtExpTime().getTime();
                        sAuthNProfile = this.getHighestAuthNProfile(oTGT.getAuthNProfileIDs());
                        if (sAuthNProfile == null && (oAuthNProfile = oSession.getSelectedAuthNProfile()) != null) {
                            sAuthNProfile = oAuthNProfile.getID();
                        }
                        if (sAuthNProfile == null) {
                            sAuthNProfile = (String)oTGT.getAuthNProfileIDs().get(0);
                        }
                    } else {
                        oAuthNProfile = oSession.getSelectedAuthNProfile();
                        if (oAuthNProfile == null) {
                            this._logger.warn((Object)"No authentication profile found in Session");
                            throw new OAException(1);
                        }
                        sAuthNProfile = oAuthNProfile.getID();
                    }
                    int iAuthSPLevel = this.getAuthSPLevel(sAuthNProfile);
                    String sUid = null;
                    try {
                        sUid = this.getUid(oUser, oASRequestorPool, oRequestorPool, oRequestor);
                    }
                    catch (AuthNException e) {
                        if (oTGT != null) {
                            oTGT.removeRequestorID(oRequestor.getID());
                            this._aliasStoreSP.removeAlias("aselect_credentials", oRequestor.getID(), sCredentials);
                            if (oTGT.getRequestorIDs().size() == 0) {
                                oTGT.expire();
                                oTGT.persist();
                            }
                        }
                        throw e;
                    }
                    String sAttributes = null;
                    IAttributes attributes = oUser.getAttributes();
                    if (attributes != null && attributes.size() > 0) {
                        sAttributes = this.serializeAttributes(attributes);
                    }
                    info = new TGTInfo(this._OAServer.getID(), oUser.getOrganization(), iAppLevel, iAuthSPLevel, sAuthNProfile, sUid, lTGTExpireTime);
                    info.setAttributes(sAttributes);
                    this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.TOKEN_DEREFERENCE_SUCCESSFUL, (IAuthority)this, null));
                    oSession.expire();
                    oSession.persist();
                    break;
                }
                case USER_CANCELLED: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("0040");
                }
                case AUTHN_FAILED: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("0003");
                }
                case PRE_AUTHZ_FAILED: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("0003");
                }
                case POST_AUTHZ_FAILED: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("0003");
                }
                case AUTHN_SELECTION_FAILED: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("0003");
                }
                case USER_BLOCKED: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("9001");
                }
                case USER_UNKNOWN: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("0002");
                }
                case PASSIVE_FAILED: {
                    this._logger.debug((Object)("Authentication failed: " + oSession.getState().name()));
                    throw new AuthNException("9921");
                }
                default: {
                    this._logger.warn((Object)("Authentication failed, due to invalid session state: " + oSession.getState().name()));
                    throw new AuthNException("0001");
                }
            }
        }
        catch (AuthNException e) {
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, e.getEvent(), (IAuthority)this, e.getMessage()));
                info = new TGTInfo(e.getMessage());
                oSession.expire();
                oSession.persist();
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, e.getEvent(), null, sRemoteAddr, null, (IAuthority)this, e.getMessage()));
                info = new TGTInfo(e.getMessage());
            }
        }
        catch (BusinessRuleException e) {
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, e.getEvent(), (IAuthority)this, e.getMessage()));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, e.getEvent(), null, sRemoteAddr, null, (IAuthority)this, e.getMessage()));
            }
            throw e;
        }
        catch (OAException e) {
            this._logger.warn((Object)"Internal error during verification of the authentication process", (Throwable)e);
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            }
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during verification of the authentication process", (Throwable)e);
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            }
            throw new OAException(1, (Throwable)e);
        }
        return info;
    }

    @Override
    public ISession slo(String sOaID, String sRequestorID, String sCredentials, String sRequestorURL, String sRemoteAddr, boolean isSigned) throws BusinessRuleException, OAException {
        ISession oSession = null;
        try {
            if (!this.isInitialized()) {
                this._logger.warn((Object)"OA Requestor Service not initialized");
                throw new OAException(3);
            }
            if (sOaID == null) {
                this._logger.debug((Object)"No oa server ID found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sRequestorID == null) {
                this._logger.debug((Object)"No requestor ID found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sCredentials == null) {
                this._logger.debug((Object)"No cerdentials found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sRequestorURL != null) {
                StringBuffer sbDebug = new StringBuffer("Optional '");
                sbDebug.append("app_url");
                sbDebug.append("' found in request: ");
                sbDebug.append(sRequestorURL);
                this._logger.debug((Object)sbDebug.toString());
                try {
                    new URL(sRequestorURL);
                }
                catch (MalformedURLException e) {
                    this._logger.debug((Object)"Invalid requestor URL found in request");
                    throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0032");
                }
            } else {
                sRequestorURL = this._sRedirectURL;
            }
            if (!this._OAServer.getID().equals(sOaID)) {
                this._logger.debug((Object)"The oa ID doesn't correspond.");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0033");
            }
            IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sRequestorID);
            if (oRequestor == null) {
                StringBuffer sbError = new StringBuffer("Unknown requestor found in request: ");
                sbError.append(sRequestorID);
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0031");
            }
            if (!oRequestor.isEnabled()) {
                this._logger.debug((Object)("Disabled requestor found in request: " + sRequestorID));
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0031");
            }
            RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(oRequestor.getID());
            if (oRequestorPool == null) {
                this._logger.warn((Object)("Requestor not available in a pool: " + oRequestor.getID()));
                throw new OAException(1);
            }
            if (!oRequestorPool.isEnabled()) {
                StringBuffer sbError = new StringBuffer("Requestor '");
                sbError.append(oRequestor.getID());
                sbError.append("' is found in a disabled requestor pool: ");
                sbError.append(oRequestorPool.getID());
                this._logger.warn((Object)sbError.toString());
                throw new OAException(1);
            }
            ASelectRequestorPool oASRequestorPool = this._htASelectRequestorPools.get(oRequestorPool.getID());
            if (!isSigned && this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                StringBuffer sbError = new StringBuffer("Requestor '");
                sbError.append(oRequestor.getID());
                sbError.append("' requires signing and the message is not signed");
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (!this._aliasStoreSP.isAlias("aselect_credentials", sRequestorID, sCredentials)) {
                this._logger.debug((Object)("Unknown credentials supplied in request: " + sCredentials));
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0007");
            }
            oSession = this._SessionFactory.createSession(sRequestorID);
            ISessionAttributes oAttributes = oSession.getAttributes();
            oAttributes.put(ASelectProcessor.class, "requestor_url", (Object)sRequestorURL);
            oSession.persist();
            this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.LOGOUT_INITIATION_SUCCESSFUL, (IAuthority)this, null));
        }
        catch (BusinessRuleException e) {
            this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, e.getEvent(), null, sRemoteAddr, null, (IAuthority)this, e.getMessage()));
            throw e;
        }
        catch (OAException e) {
            this._logger.warn((Object)"Internal error during initiation of the logout process", (Throwable)e);
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            }
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during initiation of the logout process", (Throwable)e);
            if (oSession != null) {
                this._eventLogger.info((Object)new RequestorEventLogItem(oSession, sRemoteAddr, RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            }
            throw new OAException(1, (Throwable)e);
        }
        return oSession;
    }

    @Override
    public String logout(String sRequestorID, String sCredentials, String sRemoteAddr, boolean isSigned, String reason) throws BusinessRuleException, OAException {
        try {
            ITGT tgt;
            if (!this.isInitialized()) {
                this._logger.warn((Object)"OA Requestor Service not initialized");
                throw new OAException(3);
            }
            if (sRequestorID == null) {
                this._logger.debug((Object)"No requestor ID found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (sCredentials == null) {
                this._logger.debug((Object)"No credentials found in request");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (reason != null && !"timeout".equalsIgnoreCase(reason)) {
                this._logger.debug((Object)("Invalid reason in request from SP with id: " + sRequestorID));
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sRequestorID);
            if (oRequestor == null) {
                StringBuffer sbError = new StringBuffer("Unknown requestor found in request: ");
                sbError.append(sRequestorID);
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0031");
            }
            if (!oRequestor.isEnabled()) {
                this._logger.debug((Object)("Disabled requestor found in request: " + sRequestorID));
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0031");
            }
            RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(oRequestor.getID());
            if (oRequestorPool == null) {
                this._logger.warn((Object)("Requestor not available in a pool: " + oRequestor.getID()));
                throw new OAException(1);
            }
            if (!oRequestorPool.isEnabled()) {
                StringBuffer sbError = new StringBuffer("Requestor '");
                sbError.append(oRequestor.getID());
                sbError.append("' is found in a disabled requestor pool: ");
                sbError.append(oRequestorPool.getID());
                this._logger.warn((Object)sbError.toString());
                throw new OAException(1);
            }
            ASelectRequestorPool oASRequestorPool = this._htASelectRequestorPools.get(oRequestorPool.getID());
            if (!isSigned && this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                StringBuffer sbError = new StringBuffer("Requestor '");
                sbError.append(oRequestor.getID());
                sbError.append("' requires signing and the message is not signed");
                this._logger.debug((Object)sbError.toString());
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "0030");
            }
            if (this._aliasStoreSP == null) {
                this._logger.debug((Object)"TGT Factory has no SP alias support");
                throw new BusinessRuleException(RequestorEvent.REQUEST_INVALID, "9911");
            }
            String sTGTID = this._aliasStoreSP.getTGTID("aselect_credentials", oRequestor.getID(), sCredentials);
            RequestorEvent event = RequestorEvent.LOGOUT_SUCCESS;
            if (sTGTID != null && (tgt = this._tgtFactory.retrieve((Object)sTGTID)) != null && !tgt.isExpired()) {
                this._aliasStoreSP.removeAlias("aselect_credentials", oRequestor.getID(), sCredentials);
                if (reason != null && tgt.getRequestorIDs().size() > 1) {
                    tgt.removeRequestorID(oRequestor.getID());
                    tgt.persist();
                    event = RequestorEvent.LOGOUT_PARTIALLY;
                } else {
                    try {
                        if (reason != null) {
                            tgt.clean();
                        } else {
                            tgt.expire();
                            tgt.persist();
                        }
                    }
                    catch (TGTListenerException e) {
                        event = this.getLogoutError(e.getErrors());
                    }
                }
            }
            String aselectError = null;
            switch (event) {
                case LOGOUT_SUCCESS: {
                    aselectError = "0000";
                    break;
                }
                case LOGOUT_PARTIALLY: {
                    aselectError = "9912";
                    break;
                }
                default: {
                    aselectError = "9911";
                }
            }
            this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, event, null, sRemoteAddr, null, (IAuthority)this, aselectError));
            return aselectError;
        }
        catch (BusinessRuleException e) {
            this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, e.getEvent(), null, sRemoteAddr, null, (IAuthority)this, e.getMessage()));
            throw e;
        }
        catch (OAException e) {
            this._logger.warn((Object)"Internal error during the logout process", (Throwable)e);
            this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during the logout process", (Throwable)e);
            this._eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, sRemoteAddr, null, (IAuthority)this, null));
            throw new OAException(1, (Throwable)e);
        }
    }

    public String getRedirectURLBase() {
        return this._sRedirectURL;
    }

    @Override
    public void stop() {
        this._initialized = false;
        this._sRedirectURL = null;
        super.stop();
    }

    private String getHighestAuthNProfile(List<String> listAuthNProfileIDs) throws OAException {
        String sHighestProfile = null;
        int iMaxLevel = -1;
        for (String sAuthNProfileID : listAuthNProfileIDs) {
            if (this._htAuthSPLevels.containsKey(sAuthNProfileID)) {
                int iAuthNProfileID = this._htAuthSPLevels.get(sAuthNProfileID);
                if (iAuthNProfileID <= iMaxLevel) continue;
                iMaxLevel = iAuthNProfileID;
                sHighestProfile = sAuthNProfileID;
                continue;
            }
            AuthenticationProfile authnProfile = null;
            try {
                authnProfile = this._authenticationProfileFactory.getProfile(sAuthNProfileID);
            }
            catch (AuthenticationException e) {
                this._logger.error((Object)("Authentication profile not available: " + sAuthNProfileID));
                throw new OAException(1);
            }
            String sLevel = (String)authnProfile.getProperty(PROPERTY_AUTHSP_LEVEL);
            if (sLevel == null) continue;
            try {
                int iAuthNProfileID = Integer.valueOf(sLevel);
                if (iAuthNProfileID <= iMaxLevel) continue;
                iMaxLevel = iAuthNProfileID;
                sHighestProfile = sAuthNProfileID;
            }
            catch (NumberFormatException e) {
                StringBuffer sbError = new StringBuffer("Invalid value of the '");
                sbError.append(PROPERTY_AUTHSP_LEVEL);
                sbError.append("' property available: ");
                sbError.append(sLevel);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        }
        return sHighestProfile;
    }

    private Integer getAuthSPLevel(String sAuthNProfileID) throws OAException {
        Integer intAuthSPLevel = this._iDefaultAuthSPLevel;
        if (this._htAuthSPLevels.containsKey(sAuthNProfileID)) {
            intAuthSPLevel = this._htAuthSPLevels.get(sAuthNProfileID);
        } else {
            AuthenticationProfile authnProfile = null;
            try {
                authnProfile = this._authenticationProfileFactory.getProfile(sAuthNProfileID);
            }
            catch (AuthenticationException e) {
                this._logger.error((Object)("Authentication profile not available: " + sAuthNProfileID));
                throw new OAException(1);
            }
            String sLevel = (String)authnProfile.getProperty(PROPERTY_AUTHSP_LEVEL);
            if (sLevel != null) {
                try {
                    intAuthSPLevel = new Integer(sLevel);
                }
                catch (NumberFormatException e) {
                    StringBuffer sbError = new StringBuffer("Invalid value of the '");
                    sbError.append(PROPERTY_AUTHSP_LEVEL);
                    sbError.append("' property available: ");
                    sbError.append(sLevel);
                    this._logger.error((Object)sbError.toString());
                    throw new OAException(1);
                }
            }
        }
        return intAuthSPLevel;
    }

    private String serializeAttributes(IAttributes oAttributes) throws OAException {
        String sReturn = null;
        try {
            StringBuffer sbCGI = new StringBuffer();
            Enumeration enumGatheredAttributes = oAttributes.getNames();
            while (enumGatheredAttributes.hasMoreElements()) {
                StringBuffer sbPart = new StringBuffer();
                String sKey = (String)enumGatheredAttributes.nextElement();
                Object oValue = oAttributes.get(sKey);
                if (oValue instanceof Vector) {
                    Vector vValue = (Vector)oValue;
                    Enumeration eEnum = vValue.elements();
                    while (eEnum.hasMoreElements()) {
                        String sValue = (String)eEnum.nextElement();
                        sbPart.append(URLEncoder.encode(sKey + "[]", "UTF-8"));
                        sbPart.append("=");
                        sbPart.append(URLEncoder.encode(sValue, "UTF-8"));
                        if (!eEnum.hasMoreElements()) continue;
                        sbPart.append("&");
                    }
                } else if (oValue instanceof String) {
                    String sValue = (String)oValue;
                    sbPart.append(URLEncoder.encode(sKey, "UTF-8"));
                    sbPart.append("=");
                    sbPart.append(URLEncoder.encode(sValue, "UTF-8"));
                } else {
                    StringBuffer sbDebug = new StringBuffer("Attribute '");
                    sbDebug.append(sKey);
                    sbDebug.append("' has an unsupported value; is not a String: ");
                    sbDebug.append(oValue);
                    this._logger.debug((Object)sbDebug.toString());
                }
                if (sbPart.length() > 0 && sbCGI.length() > 0) {
                    sbCGI.append("&");
                }
                sbCGI.append(sbPart);
            }
            if (sbCGI.length() > 0) {
                byte[] baCGI = Base64.encodeBase64((byte[])sbCGI.toString().getBytes("UTF-8"));
                sReturn = new String(baCGI, "UTF-8");
            }
        }
        catch (Exception e) {
            this._logger.fatal((Object)("Could not serialize attributes: " + oAttributes.toString()), (Throwable)e);
            throw new OAException(1);
        }
        return sReturn;
    }

    private String getUid(IUser oUser, ASelectRequestorPool oASRequestorPool, RequestorPool oRequestorPool, IRequestor oRequestor) throws OAException, AuthNException {
        String sUid = oUser.getID();
        String sUidAttribute = (String)oRequestor.getProperty(PROPERTY_UID_ATTRIBUTE);
        if (sUidAttribute == null) {
            if (oASRequestorPool != null) {
                sUidAttribute = oASRequestorPool.getUidAttribute();
            }
            if (sUidAttribute == null) {
                sUidAttribute = (String)oRequestorPool.getProperty(PROPERTY_UID_ATTRIBUTE);
            }
        }
        if (sUidAttribute != null) {
            IAttributes oAttributes = oUser.getAttributes();
            sUid = (String)oAttributes.get(sUidAttribute);
            if (sUid == null) {
                StringBuffer sbError = new StringBuffer("Missing required attribute (");
                sbError.append(sUidAttribute);
                sbError.append(") to resolve uid for user with ID: ");
                sbError.append(oUser.getID());
                this._logger.warn((Object)sbError.toString());
                throw new AuthNException("9901");
            }
            oAttributes.remove(sUidAttribute);
        }
        boolean bOpaqueUID = false;
        String sUIDOpaque = (String)oRequestor.getProperty(PROPERTY_UID_OPAQUE_ENABLED);
        if (sUIDOpaque != null) {
            if ("TRUE".equalsIgnoreCase(sUIDOpaque)) {
                bOpaqueUID = true;
            } else if (!"FALSE".equalsIgnoreCase(sUIDOpaque)) {
                StringBuffer sbError = new StringBuffer("Invalid value for requestor property '");
                sbError.append(PROPERTY_UID_OPAQUE_ENABLED);
                sbError.append("': ");
                sbError.append(sUIDOpaque);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        } else {
            if (oASRequestorPool != null) {
                bOpaqueUID = oASRequestorPool.isUidOpaque();
            }
            if (!bOpaqueUID && (sUIDOpaque = (String)oRequestorPool.getProperty(PROPERTY_UID_OPAQUE_ENABLED)) != null) {
                if ("TRUE".equalsIgnoreCase(sUIDOpaque)) {
                    bOpaqueUID = true;
                } else if (!"FALSE".equalsIgnoreCase(sUIDOpaque)) {
                    StringBuffer sbError = new StringBuffer("Invalid value for '");
                    sbError.append(PROPERTY_UID_OPAQUE_ENABLED);
                    sbError.append("' requestor pool attribute: ");
                    sbError.append(sUIDOpaque);
                    this._logger.error((Object)sbError.toString());
                    throw new OAException(1);
                }
            }
        }
        if (bOpaqueUID) {
            String sSalt = (String)oRequestor.getProperty(PROPERTY_UID_OPAQUE_SALT);
            if (sSalt == null) {
                if (oASRequestorPool != null) {
                    sSalt = oASRequestorPool.getUidOpaqueSalt();
                }
                if (sSalt == null) {
                    sSalt = (String)oRequestorPool.getProperty(PROPERTY_UID_OPAQUE_SALT);
                }
            }
            if (sSalt != null) {
                sUid = sUid + sSalt;
            }
            MessageDigest oMessageDigest = this._cryptoManager.getMessageDigest();
            try {
                oMessageDigest.update(sUid.getBytes("UTF-8"));
                sUid = RequestorService.toHexString(oMessageDigest.digest());
            }
            catch (Exception e) {
                this._logger.warn((Object)("Unable to generate SHA1 hash from user ID: " + sUid));
                throw new OAException(1);
            }
        }
        return sUid;
    }

    private String getAppLevel(RequestorPool oRequestorPool, ASelectRequestorPool oASRequestorPool, IRequestor oRequestor) throws OAException {
        String sAppLevel = String.valueOf(this._iDefaultAppLevel);
        int iAppLevel = -1;
        String appLevel = (String)oRequestor.getProperty(PROPERTY_APP_LEVEL);
        if (appLevel != null) {
            try {
                iAppLevel = Integer.valueOf(appLevel);
            }
            catch (NumberFormatException e) {
                StringBuffer sbError = new StringBuffer("The configured requestor property (");
                sbError.append(PROPERTY_APP_LEVEL);
                sbError.append(") value isn't a number: ");
                sbError.append(appLevel);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new OAException(1);
            }
        }
        if (oASRequestorPool != null) {
            iAppLevel = oASRequestorPool.getAppLevel();
        }
        if (iAppLevel == -1 && (appLevel = (String)oRequestorPool.getProperty(PROPERTY_APP_LEVEL)) != null) {
            try {
                iAppLevel = Integer.valueOf(appLevel);
            }
            catch (NumberFormatException e) {
                StringBuffer sbError = new StringBuffer("The configured requestorpool property (");
                sbError.append(PROPERTY_APP_LEVEL);
                sbError.append(") value isn't a number: ");
                sbError.append(appLevel);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new OAException(1);
            }
        }
        if (iAppLevel > 0) {
            sAppLevel = String.valueOf(iAppLevel);
        }
        return sAppLevel;
    }

    private RequestorEvent getLogoutError(List<TGTEventError> listErrors) {
        RequestorEvent event = RequestorEvent.LOGOUT_FAILED;
        block3: for (TGTEventError eventError : listErrors) {
            switch (eventError.getCode()) {
                case USER_LOGOUT_PARTIALLY: {
                    event = RequestorEvent.LOGOUT_PARTIALLY;
                    continue block3;
                }
            }
            return RequestorEvent.LOGOUT_FAILED;
        }
        return event;
    }

    private static String toHexString(byte[] baBytes) {
        char[] ca = Hex.encodeHex((byte[])baBytes);
        String s = new String(ca).toUpperCase();
        return s;
    }
}

