/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.business;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authentication.factory.IAuthenticationProfileFactory;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.requestor.factory.IRequestorPoolFactory;
import com.alfaariss.oa.engine.core.server.Server;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.profile.aselect.processor.handler.ASelectRequestorPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public abstract class AbstractOAService
implements IComponent {
    protected IConfigurationManager _configurationManager;
    protected Element _eOASection;
    protected ISessionFactory _SessionFactory;
    protected ITGTFactory _tgtFactory;
    protected IRequestorPoolFactory _requestorPoolFactory;
    protected IAuthenticationProfileFactory _authenticationProfileFactory;
    protected CryptoManager _cryptoManager;
    protected Log _logger = LogFactory.getLog(this.getClass());
    protected Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    protected Server _OAServer;
    protected ITGTAliasStore _aliasStoreSP;
    private static final String PROPERTY_SIGN_REQUESTS = "aselect.sign.requests";

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        this._configurationManager = oConfigurationManager;
        Element eProfiles = this._configurationManager.getSection(eConfig, "profiles");
        if (eProfiles == null) {
            this._logger.error((Object)"No 'profiles' section found in configuration");
            throw new OAException(17);
        }
        this._eOASection = this._configurationManager.getSection(eProfiles, "profile", "id=aselect");
        if (this._eOASection == null) {
            this._logger.info((Object)"No 'aselect' section found in 'profiles' section in configuration, profile is disabled");
        } else {
            Engine oaEngine = Engine.getInstance();
            this._OAServer = oaEngine.getServer();
            this._SessionFactory = oaEngine.getSessionFactory();
            this._tgtFactory = oaEngine.getTGTFactory();
            this._requestorPoolFactory = oaEngine.getRequestorPoolFactory();
            this._authenticationProfileFactory = oaEngine.getAuthenticationProfileFactory();
            this._cryptoManager = oaEngine.getCryptoManager();
            if (this._cryptoManager == null) {
                this._logger.error((Object)"No crypto manager available");
                throw new OAException(2);
            }
            this._aliasStoreSP = this._tgtFactory.getAliasStoreSP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        AbstractOAService abstractOAService = this;
        synchronized (abstractOAService) {
            this.stop();
            this.start(this._configurationManager, eConfig);
        }
    }

    public void stop() {
        this._eOASection = null;
        this._OAServer = null;
        this._SessionFactory = null;
        this._requestorPoolFactory = null;
        this._authenticationProfileFactory = null;
        this._tgtFactory = null;
        this._logger.info((Object)(this.getClass().getSimpleName() + " Stopped"));
    }

    protected boolean doSigning(RequestorPool oRequestorPool, ASelectRequestorPool oASRequestorPool, IRequestor oRequestor) throws OAException {
        String sEnabled = (String)oRequestor.getProperty(PROPERTY_SIGN_REQUESTS);
        if (sEnabled != null) {
            if ("TRUE".equalsIgnoreCase(sEnabled)) {
                return true;
            }
            if (!"FALSE".equalsIgnoreCase(sEnabled)) {
                StringBuffer sbError = new StringBuffer("The configured requestor property (");
                sbError.append(PROPERTY_SIGN_REQUESTS);
                sbError.append(") value isn't a boolean: ");
                sbError.append(sEnabled);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        }
        if (oASRequestorPool != null && oASRequestorPool.doSigning()) {
            return true;
        }
        sEnabled = (String)oRequestorPool.getProperty(PROPERTY_SIGN_REQUESTS);
        if (sEnabled != null) {
            if ("TRUE".equalsIgnoreCase(sEnabled)) {
                return true;
            }
            if (!"FALSE".equalsIgnoreCase(sEnabled)) {
                StringBuffer sbError = new StringBuffer("The configured requestorpool property (");
                sbError.append(PROPERTY_SIGN_REQUESTS);
                sbError.append(") value isn't a boolean: ");
                sbError.append(sEnabled);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        }
        return false;
    }
}

