/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.binding.protocol.cgi;

import com.alfaariss.oa.profile.aselect.binding.BindingException;
import com.alfaariss.oa.profile.aselect.binding.IResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CGIResponse
implements IResponse {
    private static Log _logger;
    private StringBuffer _sbResponse;
    private HttpServletResponse _servletResponse;

    public CGIResponse(HttpServletResponse oResponse) {
        _logger = LogFactory.getLog(CGIResponse.class);
        this._servletResponse = oResponse;
        this._sbResponse = new StringBuffer();
    }

    @Override
    public void send() throws BindingException {
        ServletOutputStream oOutputStream = null;
        try {
            oOutputStream = this._servletResponse.getOutputStream();
            oOutputStream.write(this._sbResponse.toString().getBytes("UTF-8"));
            _logger.debug((Object)this._sbResponse.toString());
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during send: " + this._sbResponse.toString()), (Throwable)e);
            throw new BindingException(1);
        }
        finally {
            try {
                if (oOutputStream != null) {
                    oOutputStream.close();
                }
            }
            catch (IOException e) {
                _logger.fatal((Object)("Internal error during send: " + this._sbResponse.toString()), (Throwable)e);
                throw new BindingException(1);
            }
        }
    }

    @Override
    public void setParameter(String sName, Object oValue) throws BindingException {
        try {
            sName = URLEncoder.encode(sName, "UTF-8");
            if (this._sbResponse.length() > 0) {
                this._sbResponse.append("&");
            }
            if (oValue instanceof Vector) {
                StringBuffer sbEncName = new StringBuffer(sName);
                sbEncName.append("%5B%5D");
                sbEncName.append("=");
                if (this._sbResponse.indexOf(sbEncName.toString()) > -1) {
                    _logger.error((Object)("The response already contains an array parameter with name: " + sName));
                    throw new BindingException(1);
                }
                Vector vValues = (Vector)oValue;
                for (int i = 0; i < vValues.size(); ++i) {
                    if (i > 0) {
                        this._sbResponse.append("&");
                    }
                    this._sbResponse.append(sbEncName.toString());
                    this._sbResponse.append(URLEncoder.encode((String)vValues.get(i), "UTF-8"));
                }
            } else {
                if (this._sbResponse.indexOf(sName + "=") > -1) {
                    _logger.error((Object)("The response already contains a parameter with name: " + sName));
                    throw new BindingException(1);
                }
                this._sbResponse.append(sName);
                this._sbResponse.append("=");
                this._sbResponse.append(URLEncoder.encode((String)oValue, "UTF-8"));
            }
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Internal error while setting parameter '");
            sbError.append(sName);
            sbError.append("' with value:");
            sbError.append(oValue);
            _logger.fatal((Object)sbError.toString(), (Throwable)e);
            throw new BindingException(1);
        }
    }
}

