/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.ws.security;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.crypto.factory.AbstractSigningFactory;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;

public class PWCBHandler
implements CallbackHandler {
    private static Log _logger = LogFactory.getLog(PWCBHandler.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        try {
            CryptoManager manager = Engine.getInstance().getCryptoManager();
            if (manager == null) {
                _logger.warn((Object)"Could not create OACrypto, OAS cryptomanager not initialized");
                throw new OAException(49);
            }
            AbstractSigningFactory asf = manager.getSigningFactory();
            if (asf == null) {
                _logger.warn((Object)"Could not create OACrypto, OAS signing not enabled");
                throw new OAException(49);
            }
            for (Callback callback : callbacks) {
                if (callback instanceof WSPasswordCallback) {
                    WSPasswordCallback pc = (WSPasswordCallback)callback;
                    if (pc.getUsage() == 3) {
                        String password;
                        if (!asf.getAlias().equals(pc.getIdentifier()) || (password = asf.getPrivateKeyPassword()) == null) continue;
                        pc.setPassword(password);
                        continue;
                    }
                    _logger.warn((Object)("The callback usage is not supported: " + pc.getUsage()));
                    throw new UnsupportedCallbackException(callback, "Unrecognized Callback usage");
                }
                _logger.warn((Object)("The callback is not supported: " + callback));
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
        catch (OAException e) {
            _logger.error((Object)"OAS not properly initialized", (Throwable)e);
            throw new IOException("OAS not properly initialized");
        }
    }
}

