/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.processor.handler.idp;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.RequestorEvent;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.profile.aselect.ASelectException;
import com.alfaariss.oa.profile.aselect.binding.IBinding;
import com.alfaariss.oa.profile.aselect.binding.IRequest;
import com.alfaariss.oa.profile.aselect.binding.IResponse;
import com.alfaariss.oa.profile.aselect.processor.ASelectProcessor;
import com.alfaariss.oa.profile.aselect.processor.handler.ASelectRequestorPool;
import com.alfaariss.oa.profile.aselect.processor.handler.AbstractAPIHandler;
import com.alfaariss.oa.util.logging.RequestorEventLogItem;
import com.alfaariss.oa.util.session.ProxyAttributes;
import com.alfaariss.oa.util.validation.LocaleValidator;
import com.alfaariss.oa.util.validation.SessionValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class IDPHandler
extends AbstractAPIHandler {
    private static final String SESSION_PROXY_ARP_TARGET = "arp_target";
    private static final String PARAM_ARP_TARGET = "arp_target";

    public IDPHandler(IConfigurationManager oConfigurationManager, Element eConfig, String sRedirectURL, Hashtable<String, Integer> htAuthSPLevels, int iDefaultAuthSPLevel, String sProfileID) throws OAException {
        super(oConfigurationManager, eConfig, sRedirectURL, htAuthSPLevels, iDefaultAuthSPLevel, sProfileID);
        try {
            if (!this._bEnabled) {
                this._logger.info((Object)"IDP handler: disabled");
                return;
            }
            this._logger.info((Object)"Started: IDP Handler");
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
            throw new OAException(1);
        }
    }

    public void authenticate(HttpServletRequest oServletRequest, IBinding oBinding) throws ASelectException {
        ISession oSession = null;
        RequestorEventLogItem oLogItem = null;
        try {
            IResponse oResponse;
            String sArpTarget;
            StringBuffer sbError;
            StringBuffer sbError2;
            StringBuffer sbError3;
            String sCountry;
            IRequest oRequest = oBinding.getRequest();
            String sASelectServer = (String)oRequest.getParameter("a-select-server");
            if (sASelectServer == null) {
                StringBuffer sbError4 = new StringBuffer("No '");
                sbError4.append("a-select-server");
                sbError4.append("' found in request");
                this._logger.debug((Object)sbError4.toString());
                throw new ASelectException("0030");
            }
            String sLocalIdp = (String)oRequest.getParameter("local_organization");
            if (sLocalIdp == null) {
                StringBuffer sbError5 = new StringBuffer("No '");
                sbError5.append("local_organization");
                sbError5.append("' found in request");
                this._logger.debug((Object)sbError5.toString());
                throw new ASelectException("0030");
            }
            String sLocalIdpUrl = (String)oRequest.getParameter("local_as_url");
            if (sLocalIdpUrl == null) {
                StringBuffer sbError6 = new StringBuffer("No '");
                sbError6.append("local_as_url");
                sbError6.append("' found in request");
                this._logger.debug((Object)sbError6.toString());
                throw new ASelectException("0030");
            }
            int iRequiredLevel = -1;
            String sRequiredLevel = (String)oRequest.getParameter("required_level");
            if (sRequiredLevel == null) {
                StringBuffer sbError7 = new StringBuffer("No '");
                sbError7.append("required_level");
                sbError7.append("' found in request");
                this._logger.debug((Object)sbError7.toString());
                throw new ASelectException("0030");
            }
            try {
                iRequiredLevel = Integer.parseInt(sRequiredLevel);
            }
            catch (NumberFormatException e) {
                StringBuffer sbError8 = new StringBuffer("Invalid '");
                sbError8.append("required_level");
                sbError8.append("' found in request: ");
                sbError8.append(sRequiredLevel);
                this._logger.debug((Object)sbError8.toString(), (Throwable)e);
                throw new ASelectException("0030");
            }
            String sUid = (String)oRequest.getParameter("uid");
            if (sUid != null) {
                StringBuffer sbError9 = new StringBuffer("Optional '");
                sbError9.append("uid");
                sbError9.append("' found in request: ");
                sbError9.append(sUid);
                this._logger.debug((Object)sbError9.toString());
            }
            if ((sCountry = (String)oRequest.getParameter("country")) == null) {
                sbError3 = new StringBuffer("No optional '");
                sbError3.append("country");
                sbError3.append("' found in request");
                this._logger.debug((Object)sbError3.toString());
            } else {
                if (!LocaleValidator.validateCountry((String)sCountry)) {
                    StringBuffer sbError10 = new StringBuffer("Invalid '");
                    sbError10.append("country");
                    sbError10.append("' found in request: ");
                    sbError10.append(sCountry);
                    this._logger.debug((Object)sbError10.toString());
                    throw new ASelectException("0030");
                }
                sbError3 = new StringBuffer("Optional '");
                sbError3.append("country");
                sbError3.append("' found in request: ");
                sbError3.append(sCountry);
                this._logger.debug((Object)sbError3.toString());
            }
            String sLanguage = (String)oRequest.getParameter("language");
            if (sLanguage == null) {
                sbError2 = new StringBuffer("No optional '");
                sbError2.append("language");
                sbError2.append("' found in request");
                this._logger.debug((Object)sbError2.toString());
            } else {
                if (!LocaleValidator.validateLanguage((String)sLanguage)) {
                    StringBuffer sbError11 = new StringBuffer("Invalid '");
                    sbError11.append("language");
                    sbError11.append("' found in request: ");
                    sbError11.append(sLanguage);
                    this._logger.debug((Object)sbError11.toString());
                    throw new ASelectException("0030");
                }
                sbError2 = new StringBuffer("Optional '");
                sbError2.append("language");
                sbError2.append("' found in request: ");
                sbError2.append(sLanguage);
                this._logger.debug((Object)sbError2.toString());
            }
            boolean bForcedLogon = false;
            String sForcedLogon = (String)oRequest.getParameter("forced_logon");
            if (sForcedLogon == null) {
                sbError = new StringBuffer("No optional '");
                sbError.append("forced_logon");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
            } else if (sForcedLogon.equalsIgnoreCase("true")) {
                bForcedLogon = true;
            } else {
                if (!sForcedLogon.equalsIgnoreCase("false")) {
                    StringBuffer sbError12 = new StringBuffer("Invalid '");
                    sbError12.append("forced_logon");
                    sbError12.append("' found in request; the value must be TRUE or FALSE, but is: ");
                    sbError12.append(sForcedLogon);
                    this._logger.debug((Object)sbError12.toString());
                    throw new ASelectException("0030");
                }
                sbError = new StringBuffer("Optional '");
                sbError.append("forced_logon");
                sbError.append("' found in request: ");
                sbError.append(sForcedLogon);
                this._logger.debug((Object)sbError.toString());
            }
            boolean bPassive = false;
            String sPassive = (String)oRequest.getParameter("passive");
            if (sPassive == null) {
                StringBuffer sbError13 = new StringBuffer("No optional '");
                sbError13.append("passive");
                sbError13.append("' found in request");
                this._logger.debug((Object)sbError13.toString());
            } else if (sPassive.equalsIgnoreCase("true")) {
                bPassive = true;
            } else {
                if (!sPassive.equalsIgnoreCase("false")) {
                    StringBuffer sbError14 = new StringBuffer("Invalid '");
                    sbError14.append("passive");
                    sbError14.append("' found in request; the value must be TRUE or FALSE, but is: ");
                    sbError14.append(sPassive);
                    this._logger.debug((Object)sbError14.toString());
                    throw new ASelectException("0030");
                }
                StringBuffer sbDebug = new StringBuffer("Optional '");
                sbDebug.append("passive");
                sbDebug.append("' found in request: ");
                sbDebug.append(sPassive);
                this._logger.debug((Object)sbDebug.toString());
            }
            String sRemoteOrganization = (String)oRequest.getParameter("remote_organization");
            if (sRemoteOrganization != null) {
                StringBuffer sbError15 = new StringBuffer("Optional '");
                sbError15.append("remote_organization");
                sbError15.append("' found in request: ");
                sbError15.append(sRemoteOrganization);
                this._logger.debug((Object)sbError15.toString());
            }
            if ((sArpTarget = (String)oRequest.getParameter("arp_target")) != null) {
                StringBuffer sbError16 = new StringBuffer("Optional '");
                sbError16.append("arp_target");
                sbError16.append("' found in request: ");
                sbError16.append(sArpTarget);
                this._logger.debug((Object)sbError16.toString());
            }
            if ((oResponse = oBinding.getResponse()) == null) {
                this._logger.error((Object)"No response for request");
                throw new ASelectException("0001");
            }
            String sResultCode = "0001";
            try {
                int iAppLevel;
                if (!this._OAServer.getID().equals(sASelectServer)) {
                    StringBuffer sbError17 = new StringBuffer("The server ID doesn't correspond to the supplied '");
                    sbError17.append("a-select-server");
                    sbError17.append("' parameter: ");
                    sbError17.append(sASelectServer);
                    this._logger.debug((Object)sbError17.toString());
                    throw new ASelectException("0030");
                }
                IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sLocalIdp);
                if (oRequestor == null) {
                    StringBuffer sbError18 = new StringBuffer("Unknown '");
                    sbError18.append("local_organization");
                    sbError18.append("' found in request: ");
                    sbError18.append(sLocalIdp);
                    this._logger.debug((Object)sbError18.toString());
                    throw new ASelectException("0031");
                }
                if (!oRequestor.isEnabled()) {
                    StringBuffer sbError19 = new StringBuffer("Disabled '");
                    sbError19.append("local_organization");
                    sbError19.append("' found in request: ");
                    sbError19.append(sLocalIdp);
                    this._logger.debug((Object)sbError19.toString());
                    throw new ASelectException("0031");
                }
                RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(oRequestor.getID());
                if (oRequestorPool == null) {
                    this._logger.warn((Object)("Requestor not available in a pool: " + oRequestor.getID()));
                    throw new ASelectException("0001");
                }
                if (!oRequestorPool.isEnabled()) {
                    StringBuffer sbError20 = new StringBuffer("Requestor '");
                    sbError20.append(sLocalIdp);
                    sbError20.append("' is found in a disabled requestor pool: ");
                    sbError20.append(oRequestorPool.getID());
                    this._logger.warn((Object)sbError20.toString());
                    throw new ASelectException("0001");
                }
                ASelectRequestorPool oASRequestorPool = (ASelectRequestorPool)this._htASelectRequestorPools.get(oRequestorPool.getID());
                if (this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                    String sSignature = (String)oRequest.getParameter("signature");
                    if (sSignature == null) {
                        StringBuffer sbError21 = new StringBuffer("No '");
                        sbError21.append("signature");
                        sbError21.append("' found in request");
                        this._logger.debug((Object)sbError21.toString());
                        throw new ASelectException("0030");
                    }
                    StringBuffer sbSignature = new StringBuffer(sASelectServer);
                    if (sArpTarget != null) {
                        sbSignature.append(sArpTarget);
                    }
                    if (sCountry != null) {
                        sbSignature.append(sCountry);
                    }
                    if (sForcedLogon != null) {
                        sbSignature.append(sForcedLogon);
                    }
                    if (sLanguage != null) {
                        sbSignature.append(sLanguage);
                    }
                    sbSignature.append(sLocalIdpUrl).append(sLocalIdp);
                    if (sPassive != null) {
                        sbSignature.append(sPassive);
                    }
                    if (sRemoteOrganization != null) {
                        sbSignature.append(sRemoteOrganization);
                    }
                    sbSignature.append(sRequiredLevel);
                    if (sUid != null) {
                        sbSignature.append(sUid);
                    }
                    if (!this.verifySignature(sSignature, oRequestor.getID(), sbSignature.toString())) {
                        this._logger.error((Object)("Invalid signature for request from requestor with id: " + oRequestor.getID()));
                        throw new ASelectException("0030");
                    }
                }
                try {
                    new URL(sLocalIdpUrl);
                }
                catch (MalformedURLException e) {
                    StringBuffer sbError22 = new StringBuffer("The supplied '");
                    sbError22.append("local_as_url");
                    sbError22.append("' parameter isn't a URL: ");
                    sbError22.append(sLocalIdpUrl);
                    this._logger.debug((Object)sbError22.toString(), (Throwable)e);
                    throw new ASelectException("0032");
                }
                oSession = this._sessionFactory.createSession(sLocalIdp);
                oSession.setForcedAuthentication(bForcedLogon);
                oSession.setPassive(bPassive);
                ISessionAttributes oAttributes = oSession.getAttributes();
                oAttributes.put(ASelectProcessor.class, "requestor_url", (Object)sLocalIdpUrl);
                int iConfiguredAppLevel = this._iDefaultAppLevel;
                if (oASRequestorPool != null && (iAppLevel = oASRequestorPool.getAppLevel()) > 0) {
                    iConfiguredAppLevel = iAppLevel;
                }
                if (iRequiredLevel > iConfiguredAppLevel) {
                    StringBuffer sbWarn = new StringBuffer("Not supported required level (");
                    sbWarn.append(iRequiredLevel);
                    sbWarn.append(") from requestor with id: ");
                    sbWarn.append(oRequestor.getID());
                    this._logger.warn((Object)sbWarn.toString());
                    throw new ASelectException("0035");
                }
                oAttributes.put(ProxyAttributes.class, "required_level", (Object)sRequiredLevel);
                if (sUid != null) {
                    oSession.setForcedUserID(sUid);
                }
                if (sArpTarget != null) {
                    oAttributes.put(ProxyAttributes.class, "arp_target", (Object)sArpTarget);
                }
                if (sRemoteOrganization != null) {
                    Vector<String> cOrganizations = new Vector<String>();
                    cOrganizations.add(sRemoteOrganization);
                    oAttributes.put(ProxyAttributes.class, "forced_organizations", cOrganizations);
                }
                Locale oLocale = null;
                if (sLanguage != null) {
                    oLocale = sCountry != null ? new Locale(sLanguage, sCountry) : new Locale(sLanguage);
                } else if (sCountry != null) {
                    oLocale = new Locale(Locale.getDefault().getLanguage(), sCountry);
                }
                oSession.setLocale(oLocale);
                String sAsUrl = this._sRedirectURL;
                if (sAsUrl == null) {
                    sAsUrl = oRequest.getRequestedURL();
                }
                StringBuffer sbAsUrl = new StringBuffer(sAsUrl);
                sbAsUrl.append("?request=login1");
                oSession.persist();
                oResponse.setParameter("as_url", sbAsUrl.toString());
                oResponse.setParameter("rid", oSession.getId());
                sResultCode = "0000";
            }
            catch (ASelectException e) {
                sResultCode = e.getMessage();
                if (sResultCode.equals("0030")) {
                    throw e;
                }
                oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), sLocalIdp, (IAuthority)this, "request=authenticate: " + sResultCode);
            }
            oResponse.setParameter("result_code", sResultCode);
            oResponse.setParameter("a-select-server", this._OAServer.getID());
            if (oLogItem == null) {
                oLogItem = new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.AUTHN_INITIATION_SUCCESSFUL, (IAuthority)this, "request=authenticate: IDP");
            }
            this._eventLogger.info((Object)oLogItem);
            oResponse.send();
        }
        catch (ASelectException e) {
            oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=authenticate: " + e.getMessage());
            this._eventLogger.info((Object)oLogItem);
            throw e;
        }
        catch (OAException e) {
            oLogItem = oSession != null ? new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.REQUEST_INVALID, (IAuthority)this, "request=authenticate: " + e.getMessage()) : new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=authenticate: " + e.getMessage());
            this._eventLogger.info((Object)oLogItem);
            throw new ASelectException(e.getMessage());
        }
        catch (Exception e) {
            oLogItem = oSession != null ? new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.INTERNAL_ERROR, (IAuthority)this, "request=authenticate") : new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=authenticate");
            this._eventLogger.info((Object)oLogItem);
            this._logger.fatal((Object)"Internal error during 'authenticate' process", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    public void verifyCredentials(HttpServletRequest oServletRequest, IBinding oBinding) throws ASelectException {
        ISession oSession = null;
        RequestorEventLogItem oLogItem = null;
        try {
            IRequest oRequest = oBinding.getRequest();
            String sASelectServer = (String)oRequest.getParameter("a-select-server");
            if (sASelectServer == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("a-select-server");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            String sRID = (String)oRequest.getParameter("rid");
            if (sRID == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("rid");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            if (!SessionValidator.validateDefaultSessionId((String)sRID)) {
                StringBuffer sbError = new StringBuffer("Invalid '");
                sbError.append("rid");
                sbError.append("' in request: ");
                sbError.append(sRID);
                this._logger.warn((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            String sCredentials = (String)oRequest.getParameter("aselect_credentials");
            if (sCredentials == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("aselect_credentials");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            if (!this._OAServer.getID().equals(sASelectServer)) {
                StringBuffer sbError = new StringBuffer("The server ID doesn't correspond to the supplied '");
                sbError.append("a-select-server");
                sbError.append("' parameter: ");
                sbError.append(sASelectServer);
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0033");
            }
            oSession = this._sessionFactory.retrieve((Object)sRID);
            if (oSession == null) {
                this._logger.debug((Object)("No session found with id: " + sRID));
                throw new ASelectException("0030");
            }
            if (oSession.isExpired()) {
                StringBuffer sbError = new StringBuffer("Expired session with id '");
                sbError.append(sRID);
                sbError.append("' found in request sent from IP: ");
                sbError.append(oServletRequest.getRemoteAddr());
                this._logger.warn((Object)sbError.toString());
                throw new ASelectException("0102");
            }
            ISessionAttributes oAttributes = oSession.getAttributes();
            String sSessionCredentials = (String)oAttributes.get(ASelectProcessor.class, "credentials");
            if (sSessionCredentials == null) {
                this._logger.debug((Object)"No session attribute found with with name: credentials");
                throw new ASelectException("0001");
            }
            if (!sSessionCredentials.equals(sCredentials)) {
                StringBuffer sbWarn = new StringBuffer("Credentials in session (");
                sbWarn.append(sSessionCredentials);
                sbWarn.append(") doesn't correspond to credentials in request: ");
                sbWarn.append(sCredentials);
                this._logger.debug((Object)sbWarn.toString());
                throw new ASelectException("0007");
            }
            IResponse oResponse = oBinding.getResponse();
            String sResultCode = "0001";
            try {
                switch (oSession.getState()) {
                    case AUTHN_OK: {
                        IAuthenticationProfile oAuthNProfile;
                        IUser oUser = oSession.getUser();
                        if (oUser == null) {
                            this._logger.debug((Object)"No User found in session");
                            throw new ASelectException("0001");
                        }
                        RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(oSession.getRequestorId());
                        if (oRequestorPool == null) {
                            this._logger.debug((Object)("No Requestor Pool found for requestor id: " + oSession.getRequestorId()));
                            throw new ASelectException("0001");
                        }
                        IRequestor oRequestor = this._requestorPoolFactory.getRequestor(oSession.getRequestorId());
                        if (oRequestor == null) {
                            this._logger.debug((Object)("No Requestor found with id: " + oSession.getRequestorId()));
                            throw new ASelectException("0001");
                        }
                        ASelectRequestorPool oASRequestorPool = (ASelectRequestorPool)this._htASelectRequestorPools.get(oRequestorPool.getID());
                        String sAppLevel = this.getAppLevel(oRequestorPool, oASRequestorPool, oRequestor);
                        if (this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                            String sSignature = (String)oRequest.getParameter("signature");
                            String sLocalIdp = oRequestor.getID();
                            if (sSignature == null) {
                                StringBuffer sbError = new StringBuffer("No '");
                                sbError.append("signature");
                                sbError.append("' found in request");
                                this._logger.debug((Object)sbError.toString());
                                throw new ASelectException("0030");
                            }
                            StringBuffer sbSignature = new StringBuffer(sASelectServer);
                            sbSignature.append(sCredentials);
                            sbSignature.append(sLocalIdp);
                            sbSignature.append(sRID);
                            if (!this.verifySignature(sSignature, sLocalIdp, sbSignature.toString())) {
                                this._logger.error((Object)("Invalid signature for request from requestor with id: " + oRequestor.getID()));
                                throw new ASelectException("0030");
                            }
                        }
                        String sAuthNProfile = null;
                        long lTGTExpireTime = 0L;
                        ITGT oTGT = null;
                        String sTGTID = oSession.getTGTId();
                        if (sTGTID != null) {
                            oTGT = this._tgtFactory.retrieve((Object)sTGTID);
                            if (oTGT == null) {
                                this._logger.warn((Object)"No TGT ID found in session");
                                throw new ASelectException("0001");
                            }
                            lTGTExpireTime = oTGT.getTgtExpTime().getTime();
                            sAuthNProfile = this.getHighestAuthNProfile(oTGT.getAuthNProfileIDs());
                            if (sAuthNProfile == null && (oAuthNProfile = oSession.getSelectedAuthNProfile()) != null) {
                                sAuthNProfile = oAuthNProfile.getID();
                            }
                            if (sAuthNProfile == null) {
                                sAuthNProfile = (String)oTGT.getAuthNProfileIDs().get(0);
                            }
                        } else {
                            oAuthNProfile = oSession.getSelectedAuthNProfile();
                            if (oAuthNProfile == null) {
                                this._logger.warn((Object)"No authentication profile found in Session");
                                throw new ASelectException("0001");
                            }
                            sAuthNProfile = oAuthNProfile.getID();
                        }
                        Integer intAuthSPLevel = this.getAuthSPLevel(sAuthNProfile);
                        String sUid = null;
                        try {
                            sUid = this.getUid(oUser, oASRequestorPool, oRequestorPool, oRequestor);
                        }
                        catch (ASelectException e) {
                            if (oTGT != null) {
                                oTGT.removeRequestorID(oRequestor.getID());
                                this._aliasStoreSPRole.removeAlias("aselect_credentials", oRequestor.getID(), sCredentials);
                                if (oTGT.getRequestorIDs().size() == 0) {
                                    oTGT.expire();
                                    oTGT.persist();
                                }
                            }
                            throw e;
                        }
                        String sAttributes = null;
                        IAttributes attributes = oUser.getAttributes();
                        if (attributes != null && attributes.size() > 0) {
                            sAttributes = this.serializeAttributes(attributes);
                        }
                        oResponse = oBinding.getResponse();
                        oResponse.setParameter("organization", oUser.getOrganization());
                        oResponse.setParameter("uid", sUid);
                        oResponse.setParameter("tgt_exp_time", String.valueOf(lTGTExpireTime));
                        oResponse.setParameter("app_level", sAppLevel);
                        oResponse.setParameter("authsp", sAuthNProfile);
                        oResponse.setParameter("asp", sAuthNProfile);
                        oResponse.setParameter("authsp_level", String.valueOf(intAuthSPLevel));
                        oResponse.setParameter("asp_level", String.valueOf(intAuthSPLevel));
                        if (sAttributes != null) {
                            oResponse.setParameter("attributes", sAttributes);
                        }
                        sResultCode = "0000";
                        break;
                    }
                    case USER_CANCELLED: {
                        sResultCode = "0040";
                        break;
                    }
                    case AUTHN_FAILED: {
                        sResultCode = "0003";
                        break;
                    }
                    case PRE_AUTHZ_FAILED: {
                        sResultCode = "0003";
                        break;
                    }
                    case AUTHN_SELECTION_FAILED: {
                        sResultCode = "0003";
                        break;
                    }
                    case USER_BLOCKED: {
                        sResultCode = "9001";
                        break;
                    }
                    case USER_UNKNOWN: {
                        sResultCode = "0002";
                        break;
                    }
                    case PASSIVE_FAILED: {
                        sResultCode = "9921";
                        break;
                    }
                    default: {
                        sResultCode = "0001";
                        break;
                    }
                }
            }
            catch (ASelectException e) {
                sResultCode = e.getMessage();
                if (sResultCode.equals("0030")) {
                    throw e;
                }
                oLogItem = new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.TOKEN_DEREFERENCE_SUCCESSFUL, (IAuthority)this, "request=verify_credentials: IDP");
            }
            oResponse.setParameter("result_code", sResultCode);
            oResponse.setParameter("a-select-server", this._OAServer.getID());
            if (oLogItem == null) {
                oLogItem = new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.TOKEN_DEREFERENCE_SUCCESSFUL, (IAuthority)this, "request=verify_credentials: IDP");
            }
            this._eventLogger.info((Object)oLogItem);
            this._logger.debug((Object)("Remove session id: " + sRID));
            oSession.expire();
            oSession.persist();
            oResponse.send();
            StringBuffer sbDebug = new StringBuffer("Send verify_credentials response with '");
            sbDebug.append("result_code");
            sbDebug.append("': ");
            sbDebug.append(sResultCode);
            this._logger.debug((Object)sbDebug.toString());
        }
        catch (ASelectException e) {
            oLogItem = oSession != null ? new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.REQUEST_INVALID, (IAuthority)this, "request=verify_credentials: " + e.getMessage()) : new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=verify_credentials: " + e.getMessage());
            this._eventLogger.info((Object)oLogItem);
            throw e;
        }
        catch (Exception e) {
            oLogItem = oSession != null ? new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.INTERNAL_ERROR, (IAuthority)this, "request=verify_credentials") : new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=verify_credentials");
            this._eventLogger.info((Object)oLogItem);
            this._logger.fatal((Object)"Internal error during 'verify_crendentials' process", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    public void slo(HttpServletRequest oServletRequest, IBinding oBinding) throws ASelectException {
        ISession oSession = null;
        RequestorEventLogItem oLogItem = null;
        try {
            IRequest oRequest = oBinding.getRequest();
            String sASelectServer = (String)oRequest.getParameter("a-select-server");
            if (sASelectServer == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("a-select-server");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            String sLocalIdp = (String)oRequest.getParameter("local_organization");
            if (sLocalIdp == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("local_organization");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            String sLocalIdpUrl = (String)oRequest.getParameter("local_as_url");
            if (sLocalIdpUrl == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("local_as_url");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            String sCredentials = (String)oRequest.getParameter("aselect_credentials");
            if (sCredentials == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("aselect_credentials");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            IResponse oResponse = oBinding.getResponse();
            if (oResponse == null) {
                this._logger.error((Object)"No response for request");
                throw new ASelectException("0001");
            }
            String sResultCode = "0001";
            try {
                if (!this._OAServer.getID().equals(sASelectServer)) {
                    StringBuffer sbError = new StringBuffer("The server ID doesn't correspond to the supplied '");
                    sbError.append("a-select-server");
                    sbError.append("' parameter: ");
                    sbError.append(sASelectServer);
                    this._logger.debug((Object)sbError.toString());
                    throw new ASelectException("0033");
                }
                IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sLocalIdp);
                if (oRequestor == null) {
                    StringBuffer sbError = new StringBuffer("Unknown '");
                    sbError.append("local_organization");
                    sbError.append("' found in request: ");
                    sbError.append(sLocalIdp);
                    this._logger.debug((Object)sbError.toString());
                    throw new ASelectException("0031");
                }
                if (!oRequestor.isEnabled()) {
                    StringBuffer sbError = new StringBuffer("Disabled '");
                    sbError.append("local_organization");
                    sbError.append("' found in request: ");
                    sbError.append(sLocalIdp);
                    this._logger.debug((Object)sbError.toString());
                    throw new ASelectException("0031");
                }
                RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(oRequestor.getID());
                if (oRequestorPool == null) {
                    this._logger.warn((Object)("Requestor not available in a pool: " + oRequestor.getID()));
                    throw new ASelectException("0001");
                }
                if (!oRequestorPool.isEnabled()) {
                    StringBuffer sbError = new StringBuffer("Requestor '");
                    sbError.append(sLocalIdp);
                    sbError.append("' is found in a disabled requestor pool: ");
                    sbError.append(oRequestorPool.getID());
                    this._logger.warn((Object)sbError.toString());
                    throw new ASelectException("0001");
                }
                ASelectRequestorPool oASRequestorPool = (ASelectRequestorPool)this._htASelectRequestorPools.get(oRequestorPool.getID());
                if (this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                    String sSignature = (String)oRequest.getParameter("signature");
                    if (sSignature == null) {
                        StringBuffer sbError = new StringBuffer("No '");
                        sbError.append("signature");
                        sbError.append("' found in request");
                        this._logger.debug((Object)sbError.toString());
                        throw new ASelectException("0030");
                    }
                    Hashtable<String, String> htSignatureData = new Hashtable<String, String>();
                    htSignatureData.put("a-select-server", sASelectServer);
                    htSignatureData.put("aselect_credentials", sCredentials);
                    htSignatureData.put("local_as_url", sLocalIdpUrl);
                    htSignatureData.put("local_organization", sLocalIdp);
                    if (!this.verifySignature(sSignature, oRequestor.getID(), htSignatureData)) {
                        this._logger.error((Object)("Invalid signature for request from requestor with id: " + oRequestor.getID()));
                        throw new ASelectException("0030");
                    }
                }
                if (!this._aliasStoreSPRole.isAlias("aselect_credentials", sLocalIdp, sCredentials)) {
                    this._logger.debug((Object)("Unknown credentials supplied in request: " + sCredentials));
                    throw new ASelectException("0007");
                }
                try {
                    new URL(sLocalIdpUrl);
                }
                catch (MalformedURLException e) {
                    StringBuffer sbError = new StringBuffer("The supplied '");
                    sbError.append("local_as_url");
                    sbError.append("' parameter isn't an URL: ");
                    sbError.append(sLocalIdpUrl);
                    this._logger.debug((Object)sbError.toString(), (Throwable)e);
                    throw new ASelectException("0032");
                }
                String sAsUrl = this._sRedirectURL;
                if (sAsUrl == null) {
                    sAsUrl = oRequest.getRequestedURL();
                }
                oSession = this._sessionFactory.createSession(sLocalIdp);
                ISessionAttributes oAttributes = oSession.getAttributes();
                oAttributes.put(ASelectProcessor.class, "requestor_url", (Object)sLocalIdpUrl);
                oSession.persist();
                StringBuffer sbAsUrl = new StringBuffer(sAsUrl);
                sbAsUrl.append("?request=logout");
                oResponse.setParameter("as_url", sbAsUrl.toString());
                oResponse.setParameter("rid", oSession.getId());
                sResultCode = "0000";
            }
            catch (ASelectException e) {
                sResultCode = e.getMessage();
                if (sResultCode.equals("0030")) {
                    throw e;
                }
                oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), sLocalIdp, (IAuthority)this, "request=slo: " + sResultCode);
            }
            oResponse.setParameter("result_code", sResultCode);
            oResponse.setParameter("a-select-server", this._OAServer.getID());
            if (oLogItem == null) {
                oLogItem = new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.LOGOUT_INITIATION_SUCCESSFUL, (IAuthority)this, "request=slo: IDP");
            }
            this._eventLogger.info((Object)oLogItem);
            oResponse.send();
        }
        catch (ASelectException e) {
            oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=slo: " + e.getMessage());
            this._eventLogger.info((Object)oLogItem);
            throw e;
        }
        catch (OAException e) {
            oLogItem = oSession != null ? new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.REQUEST_INVALID, (IAuthority)this, "request=slo: " + e.getMessage()) : new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=slo: " + e.getMessage());
            this._eventLogger.info((Object)oLogItem);
            throw new ASelectException(e.getMessage());
        }
        catch (Exception e) {
            oLogItem = oSession != null ? new RequestorEventLogItem(oSession, oServletRequest.getRemoteAddr(), RequestorEvent.INTERNAL_ERROR, (IAuthority)this, "request=slo") : new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=slo");
            this._eventLogger.info((Object)oLogItem);
            this._logger.fatal((Object)"Internal error during 'slo' process", (Throwable)e);
            throw new ASelectException("0001");
        }
    }
}

