/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.processor.handler;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.RequestorEvent;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.api.tgt.TGTListenerException;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.authentication.remote.aselect.idp.storage.ASelectIDP;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authentication.AuthenticationException;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import com.alfaariss.oa.engine.core.authentication.factory.IAuthenticationProfileFactory;
import com.alfaariss.oa.engine.core.crypto.CryptoException;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.idp.IDPStorageManager;
import com.alfaariss.oa.engine.core.idp.storage.IIDP;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.requestor.factory.IRequestorPoolFactory;
import com.alfaariss.oa.engine.core.server.Server;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.profile.aselect.ASelectException;
import com.alfaariss.oa.profile.aselect.binding.IBinding;
import com.alfaariss.oa.profile.aselect.binding.IRequest;
import com.alfaariss.oa.profile.aselect.binding.IResponse;
import com.alfaariss.oa.profile.aselect.processor.handler.ASelectRequestorPool;
import com.alfaariss.oa.util.logging.RequestorEventLogItem;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class AbstractAPIHandler
implements IAuthority {
    protected Log _logger;
    protected Log _eventLogger;
    protected Server _OAServer;
    protected ISessionFactory _sessionFactory;
    protected IRequestorPoolFactory _requestorPoolFactory;
    protected IAuthenticationProfileFactory _authnProfileFactory;
    protected ITGTFactory _tgtFactory;
    protected String _sRedirectURL;
    protected boolean _bEnabled;
    protected Hashtable<String, Integer> _htAuthSPLevels;
    protected int _iDefaultAuthSPLevel;
    protected Hashtable<String, ASelectRequestorPool> _htASelectRequestorPools;
    protected int _iDefaultAppLevel;
    protected ITGTAliasStore _aliasStoreSPRole;
    protected ITGTAliasStore _aliasStoreIDPRole;
    protected IDPStorageManager _idpStorageManager;
    private static final String PROPERTY_SIGN_REQUESTS = ".sign.requests";
    private static final String PROPERTY_APP_LEVEL = ".app_level";
    private static final String PROPERTY_UID_ATTRIBUTE = ".uid.attribute";
    private static final String PROPERTY_UID_OPAQUE_ENABLED = ".uid.opaque.enabled";
    private static final String PROPERTY_UID_OPAQUE_SALT = ".uid.opaque.salt";
    private static final String PROPERTY_AUTHSP_LEVEL = ".authsp_level";
    private String _sProfileID;
    private CryptoManager _cryptoManager;

    public AbstractAPIHandler(IConfigurationManager oConfigurationManager, Element eConfig, String sRedirectURL, Hashtable<String, Integer> htAuthSPLevels, int iDefaultAuthSPLevel, String sProfileID) throws OAException {
        block17: {
            try {
                this._logger = LogFactory.getLog(AbstractAPIHandler.class);
                this._eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
                this._htAuthSPLevels = htAuthSPLevels;
                this._iDefaultAuthSPLevel = iDefaultAuthSPLevel;
                this._sProfileID = sProfileID;
                this._bEnabled = false;
                if (eConfig != null) {
                    String sEnabled = oConfigurationManager.getParam(eConfig, "enabled");
                    if (sEnabled == null) {
                        this._logger.info((Object)"No optional 'enabled' parameter found in handler section in configuration");
                        this._bEnabled = true;
                    } else if (sEnabled.equalsIgnoreCase("true")) {
                        this._logger.info((Object)"Request handler is enabled");
                        this._bEnabled = true;
                    } else if (sEnabled.equalsIgnoreCase("false")) {
                        this._logger.info((Object)"Request handler is disabled");
                        this._bEnabled = false;
                    } else {
                        this._logger.error((Object)("Wrong 'enabled' parameter found in handler section in configuration: " + sEnabled));
                        throw new OAException(17);
                    }
                }
                if (!this._bEnabled) break block17;
                Engine engine = Engine.getInstance();
                this._OAServer = engine.getServer();
                this._sessionFactory = engine.getSessionFactory();
                this._requestorPoolFactory = engine.getRequestorPoolFactory();
                this._tgtFactory = engine.getTGTFactory();
                this._aliasStoreSPRole = this._tgtFactory.getAliasStoreSP();
                this._aliasStoreIDPRole = this._tgtFactory.getAliasStoreIDP();
                this._idpStorageManager = engine.getIDPStorageManager();
                this._authnProfileFactory = engine.getAuthenticationProfileFactory();
                this._cryptoManager = engine.getCryptoManager();
                if (this._cryptoManager == null) {
                    this._logger.error((Object)"No crypto manager available");
                    throw new OAException(2);
                }
                this._sRedirectURL = sRedirectURL;
                String sDefaultAppLevel = oConfigurationManager.getParam(eConfig, "app_level");
                if (sDefaultAppLevel == null) {
                    this._logger.error((Object)"No default 'app_level' item in handler section found in configuration");
                    throw new OAException(17);
                }
                try {
                    this._iDefaultAppLevel = Integer.valueOf(sDefaultAppLevel);
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)("The configured default 'app_level' parameter isn't a number: " + sDefaultAppLevel), (Throwable)e);
                    throw new OAException(2);
                }
                this._logger.info((Object)("Configured default 'app_level': " + sDefaultAppLevel));
                this._htASelectRequestorPools = new Hashtable();
                Element eRequestorPool = oConfigurationManager.getSection(eConfig, "requestorpool");
                while (eRequestorPool != null) {
                    ASelectRequestorPool oASRequestorPool = new ASelectRequestorPool(oConfigurationManager, eRequestorPool);
                    String sPoolId = oASRequestorPool.getID();
                    if (this._htASelectRequestorPools.containsKey(sPoolId)) {
                        this._logger.warn((Object)("The configured 'requestorpool' doesn't have a unique id: " + sPoolId));
                        throw new OAException(2);
                    }
                    if (!this._requestorPoolFactory.isPool(sPoolId)) {
                        this._logger.warn((Object)("The configured 'requestorpool' doesn't exist as a requestor pool: " + sPoolId));
                        throw new OAException(2);
                    }
                    this._htASelectRequestorPools.put(sPoolId, oASRequestorPool);
                    this._logger.info((Object)("Configured: " + oASRequestorPool));
                    eRequestorPool = oConfigurationManager.getNextSection(eRequestorPool);
                }
            }
            catch (OAException e) {
                throw e;
            }
            catch (Exception e) {
                this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
                throw new OAException(1);
            }
        }
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    public String getAuthority() {
        return "A-Select Profile";
    }

    public void doRequestorSynchronousLogout(HttpServletRequest oServletRequest, IBinding oBinding, String sRequestorID, String sAppID, String credentials) throws ASelectException {
        RequestorEventLogItem oLogItem = null;
        try {
            IResponse oResponse;
            IRequestor oRequestor;
            if (sRequestorID == null && sAppID == null) {
                this._logger.debug((Object)"No 'requestor' or 'app_id' found in request");
                throw new ASelectException("0030");
            }
            if (credentials == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("aselect_credentials");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            IRequest oRequest = oBinding.getRequest();
            if (sRequestorID == null) {
                sRequestorID = sAppID;
            }
            if ((oRequestor = this._requestorPoolFactory.getRequestor(sRequestorID)) == null) {
                this._logger.debug((Object)("Unknown 'requestor' or 'app_id' found in request: " + sRequestorID));
                throw new ASelectException("0031");
            }
            String reason = (String)oRequest.getParameter("reason");
            if (reason != null) {
                StringBuffer sbDebug = new StringBuffer("Received optional '");
                sbDebug.append("reason");
                sbDebug.append("' in request from requestor: ");
                sbDebug.append(oRequestor.getID());
                this._logger.debug((Object)sbDebug.toString());
            }
            if ((oResponse = oBinding.getResponse()) == null) {
                this._logger.error((Object)"No response for request");
                throw new ASelectException("0001");
            }
            String sResultCode = "0001";
            try {
                if (!oRequestor.isEnabled()) {
                    StringBuffer sbError = new StringBuffer("Disabled '");
                    sbError.append("local_organization");
                    sbError.append("' found in request: ");
                    sbError.append(oRequestor.getID());
                    this._logger.debug((Object)sbError.toString());
                    throw new ASelectException("0031");
                }
                RequestorPool oRequestorPool = this._requestorPoolFactory.getRequestorPool(oRequestor.getID());
                if (oRequestorPool == null) {
                    this._logger.warn((Object)("Requestor not available in a pool: " + oRequestor.getID()));
                    throw new ASelectException("0001");
                }
                if (!oRequestorPool.isEnabled()) {
                    StringBuffer sbError = new StringBuffer("Requestor '");
                    sbError.append(oRequestor.getID());
                    sbError.append("' is found in a disabled requestor pool: ");
                    sbError.append(oRequestorPool.getID());
                    this._logger.warn((Object)sbError.toString());
                    throw new ASelectException("0001");
                }
                ASelectRequestorPool oASRequestorPool = this._htASelectRequestorPools.get(oRequestorPool.getID());
                if (this.doSigning(oRequestorPool, oASRequestorPool, oRequestor)) {
                    String sSignature = (String)oRequest.getParameter("signature");
                    if (sSignature == null) {
                        StringBuffer sbError = new StringBuffer("No '");
                        sbError.append("signature");
                        sbError.append("' found in request");
                        this._logger.debug((Object)sbError.toString());
                        throw new ASelectException("0030");
                    }
                    Hashtable<String, String> htSignatureData = new Hashtable<String, String>();
                    htSignatureData.put("aselect_credentials", credentials);
                    if (sRequestorID != null) {
                        htSignatureData.put("requestor", sRequestorID);
                    }
                    if (sAppID != null) {
                        htSignatureData.put("app_id", sAppID);
                    }
                    if (reason != null) {
                        htSignatureData.put("reason", reason);
                    }
                    if (!this.verifySignature(sSignature, oRequestor.getID(), htSignatureData)) {
                        this._logger.error((Object)("Invalid signature for request from requestor with id: " + oRequestor.getID()));
                        throw new ASelectException("0030");
                    }
                }
                if (reason != null && !"timeout".equalsIgnoreCase(reason)) {
                    this._logger.debug((Object)("Invalid reason in request from SP with id: " + oRequestor.getID()));
                    throw new ASelectException("0030");
                }
                RequestorEvent logoutResult = RequestorEvent.LOGOUT_FAILED;
                if (this._aliasStoreSPRole == null) {
                    this._logger.debug((Object)"TGT Factory has no alias support");
                    sResultCode = "9911";
                    logoutResult = RequestorEvent.LOGOUT_FAILED;
                } else {
                    ITGT tgt;
                    sResultCode = "0000";
                    logoutResult = RequestorEvent.LOGOUT_SUCCESS;
                    String sTGTID = this._aliasStoreSPRole.getTGTID("aselect_credentials", oRequestor.getID(), credentials);
                    if (sTGTID != null && (tgt = this._tgtFactory.retrieve((Object)sTGTID)) != null && !tgt.isExpired()) {
                        this._aliasStoreSPRole.removeAlias("aselect_credentials", oRequestor.getID(), credentials);
                        if (reason != null && tgt.getRequestorIDs().size() > 1) {
                            tgt.removeRequestorID(oRequestor.getID());
                            tgt.persist();
                            sResultCode = "9912";
                            logoutResult = RequestorEvent.LOGOUT_PARTIALLY;
                        } else {
                            try {
                                if (reason != null) {
                                    tgt.clean();
                                } else {
                                    tgt.expire();
                                    tgt.persist();
                                }
                            }
                            catch (TGTListenerException e) {
                                logoutResult = this.getLogoutResult(e.getErrors());
                                switch (logoutResult) {
                                    case LOGOUT_PARTIALLY: {
                                        sResultCode = "9912";
                                        break;
                                    }
                                    default: {
                                        sResultCode = "9911";
                                    }
                                }
                            }
                        }
                    }
                }
                oLogItem = new RequestorEventLogItem(null, null, null, logoutResult, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "slogout SP role");
            }
            catch (ASelectException e) {
                sResultCode = e.getMessage();
                if (sResultCode.equals("0030")) {
                    throw e;
                }
                oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), oRequestor.getID(), (IAuthority)this, "slogout SP role: " + sResultCode);
            }
            oResponse.setParameter("result_code", sResultCode);
            this._eventLogger.info((Object)oLogItem);
            oResponse.send();
        }
        catch (ASelectException e) {
            throw e;
        }
        catch (OAException e) {
            oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=logout: " + e.getMessage());
            this._eventLogger.info((Object)oLogItem);
            throw new ASelectException(e.getMessage());
        }
        catch (Exception e) {
            oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=logout");
            this._eventLogger.info((Object)oLogItem);
            this._logger.fatal((Object)"Internal error during 'logout' process", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    public void doOrganizationSynchronousLogout(HttpServletRequest oServletRequest, IBinding oBinding, String sLocalOrganization, String credentials) throws ASelectException {
        RequestorEventLogItem oLogItem = null;
        try {
            if (sLocalOrganization == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("local_organization");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            if (credentials == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append("aselect_credentials");
                sbError.append("' found in request");
                this._logger.debug((Object)sbError.toString());
                throw new ASelectException("0030");
            }
            IRequest oRequest = oBinding.getRequest();
            IIDP idp = this._idpStorageManager.getIDP(sLocalOrganization);
            if (idp == null) {
                this._logger.debug((Object)("Unknown 'local_organization' found in request: " + sLocalOrganization));
                throw new ASelectException("0031");
            }
            String reason = (String)oRequest.getParameter("reason");
            if (reason != null) {
                StringBuffer sbDebug = new StringBuffer("Received optional '");
                sbDebug.append("reason");
                sbDebug.append("' in request from idp: ");
                sbDebug.append(idp.getID());
                this._logger.debug((Object)sbDebug.toString());
            }
            ASelectIDP aselectIDP = null;
            if (!(idp instanceof ASelectIDP)) {
                this._logger.debug((Object)("Supplied 'local_organization' is not of type ASelectIDP: " + idp.getID()));
                throw new ASelectException("0031");
            }
            aselectIDP = (ASelectIDP)idp;
            IResponse oResponse = oBinding.getResponse();
            if (oResponse == null) {
                this._logger.error((Object)"No response for request");
                throw new ASelectException("0001");
            }
            String sResultCode = "0001";
            try {
                if (aselectIDP.doSigning()) {
                    String sSignature = (String)oRequest.getParameter("signature");
                    if (sSignature == null) {
                        StringBuffer sbError = new StringBuffer("No '");
                        sbError.append("signature");
                        sbError.append("' found in request");
                        this._logger.debug((Object)sbError.toString());
                        throw new ASelectException("0030");
                    }
                    Hashtable<String, String> htSignatureData = new Hashtable<String, String>();
                    htSignatureData.put("aselect_credentials", credentials);
                    if (sLocalOrganization != null) {
                        htSignatureData.put("local_organization", sLocalOrganization);
                    }
                    if (reason != null) {
                        htSignatureData.put("reason", reason);
                    }
                    if (!this.verifySignature(sSignature, idp.getID(), htSignatureData)) {
                        this._logger.error((Object)("Invalid signature for request from IDP with id: " + idp.getID()));
                        throw new ASelectException("0030");
                    }
                }
                if (reason != null && !"timeout".equalsIgnoreCase(reason)) {
                    this._logger.debug((Object)("Invalid reason in request from IDP with id: " + aselectIDP.getID()));
                    throw new ASelectException("0030");
                }
                RequestorEvent logoutResult = RequestorEvent.LOGOUT_FAILED;
                if (this._aliasStoreIDPRole == null) {
                    this._logger.debug((Object)"TGT Factory has no alias support");
                    sResultCode = "9911";
                    logoutResult = RequestorEvent.LOGOUT_FAILED;
                } else {
                    ITGT tgt;
                    sResultCode = "0000";
                    logoutResult = RequestorEvent.LOGOUT_SUCCESS;
                    String sTGTID = this._aliasStoreIDPRole.getTGTID("aselect_credentials", aselectIDP.getID(), credentials);
                    if (sTGTID != null && (tgt = this._tgtFactory.retrieve((Object)sTGTID)) != null && !tgt.isExpired()) {
                        this._aliasStoreIDPRole.removeAlias("aselect_credentials", aselectIDP.getID(), credentials);
                        if (reason != null) {
                            sResultCode = "9912";
                            logoutResult = RequestorEvent.LOGOUT_PARTIALLY;
                        } else {
                            tgt.expire();
                            try {
                                tgt.persist();
                            }
                            catch (TGTListenerException e) {
                                logoutResult = this.getLogoutResult(e.getErrors());
                                switch (logoutResult) {
                                    case LOGOUT_PARTIALLY: {
                                        sResultCode = "9912";
                                        break;
                                    }
                                    default: {
                                        sResultCode = "9911";
                                    }
                                }
                            }
                        }
                    }
                }
                oLogItem = new RequestorEventLogItem(null, null, null, logoutResult, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "slogout IDP role");
            }
            catch (ASelectException e) {
                sResultCode = e.getMessage();
                if (sResultCode.equals("0030")) {
                    throw e;
                }
                oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), aselectIDP.getID(), (IAuthority)this, "slogout IDP role: " + sResultCode);
            }
            oResponse.setParameter("result_code", sResultCode);
            this._eventLogger.info((Object)oLogItem);
            oResponse.send();
        }
        catch (ASelectException e) {
            throw e;
        }
        catch (OAException e) {
            oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.REQUEST_INVALID, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=logout: " + e.getMessage());
            this._eventLogger.info((Object)oLogItem);
            throw new ASelectException(e.getMessage());
        }
        catch (Exception e) {
            oLogItem = new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, oServletRequest.getRemoteAddr(), null, (IAuthority)this, "request=logout");
            this._eventLogger.info((Object)oLogItem);
            this._logger.fatal((Object)"Internal error during 'logout' process", (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    protected String serializeAttributes(IAttributes oAttributes) throws ASelectException {
        String sReturn = null;
        try {
            StringBuffer sbCGI = new StringBuffer();
            Enumeration enumGatheredAttributes = oAttributes.getNames();
            while (enumGatheredAttributes.hasMoreElements()) {
                StringBuffer sbPart = new StringBuffer();
                String sKey = (String)enumGatheredAttributes.nextElement();
                Object oValue = oAttributes.get(sKey);
                if (oValue instanceof Vector) {
                    Vector vValue = (Vector)oValue;
                    Enumeration eEnum = vValue.elements();
                    while (eEnum.hasMoreElements()) {
                        String sValue = (String)eEnum.nextElement();
                        sbPart.append(URLEncoder.encode(sKey + "[]", "UTF-8"));
                        sbPart.append("=");
                        sbPart.append(URLEncoder.encode(sValue, "UTF-8"));
                        if (!eEnum.hasMoreElements()) continue;
                        sbPart.append("&");
                    }
                } else if (oValue instanceof String) {
                    String sValue = (String)oValue;
                    sbPart.append(URLEncoder.encode(sKey, "UTF-8"));
                    sbPart.append("=");
                    sbPart.append(URLEncoder.encode(sValue, "UTF-8"));
                } else {
                    StringBuffer sbDebug = new StringBuffer("Attribute '");
                    sbDebug.append(sKey);
                    sbDebug.append("' has an unsupported value; is not a String: ");
                    sbDebug.append(oValue);
                    this._logger.debug((Object)sbDebug.toString());
                }
                if (sbPart.length() > 0 && sbCGI.length() > 0) {
                    sbCGI.append("&");
                }
                sbCGI.append(sbPart);
            }
            if (sbCGI.length() > 0) {
                byte[] baCGI = Base64.encodeBase64((byte[])sbCGI.toString().getBytes("UTF-8"));
                sReturn = new String(baCGI, "UTF-8");
            }
        }
        catch (Exception e) {
            this._logger.fatal((Object)("Could not serialize attributes: " + oAttributes.toString()), (Throwable)e);
            throw new ASelectException("0001");
        }
        return sReturn;
    }

    protected boolean verifySignature(String sSignature, String sKeyAlias, Map<String, String> mapRequest) throws ASelectException {
        StringBuffer sbSignatureData = new StringBuffer();
        TreeSet<String> sortedSet = new TreeSet<String>(mapRequest.keySet());
        for (String sKey : sortedSet) {
            sbSignatureData.append(mapRequest.get(sKey));
        }
        return this.verifySignature(sSignature, sKeyAlias, sbSignatureData.toString());
    }

    protected boolean verifySignature(String sSignature, String sKeyAlias, String sData) throws ASelectException {
        try {
            Certificate oCertificate = this._cryptoManager.getCertificate(sKeyAlias);
            if (oCertificate == null) {
                this._logger.warn((Object)("No certificate object found with alias: " + sKeyAlias));
                throw new ASelectException("0001");
            }
            Signature oSignature = this._cryptoManager.getSignature();
            if (oSignature == null) {
                this._logger.warn((Object)"No signature object found");
                throw new ASelectException("0001");
            }
            oSignature.initVerify(oCertificate);
            oSignature.update(sData.getBytes("UTF-8"));
            byte[] baData = Base64.decodeBase64((byte[])sSignature.getBytes("UTF-8"));
            boolean bVerified = oSignature.verify(baData);
            if (!bVerified) {
                StringBuffer sbDebug = new StringBuffer("Could not verify signature '");
                sbDebug.append(sSignature);
                sbDebug.append("' for key with alias '");
                sbDebug.append(sKeyAlias);
                sbDebug.append("' with data: ");
                sbDebug.append(sData);
                this._logger.debug((Object)sbDebug.toString());
            }
            return bVerified;
        }
        catch (CryptoException e) {
            this._logger.warn((Object)"A crypto exception occurred", (Throwable)e);
            throw new ASelectException(e.getMessage());
        }
        catch (ASelectException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Could not verify signature '");
            sbError.append(sSignature);
            sbError.append("' for key with alias: ");
            sbError.append(sKeyAlias);
            this._logger.fatal((Object)sbError.toString(), (Throwable)e);
            throw new ASelectException("0001");
        }
    }

    protected String getHighestAuthNProfile(List<String> listAuthNProfileIDs) throws OAException {
        String sHighestProfile = null;
        int iMaxLevel = -1;
        for (String sAuthNProfileID : listAuthNProfileIDs) {
            if (this._htAuthSPLevels.containsKey(sAuthNProfileID)) {
                int iAuthNProfileID = this._htAuthSPLevels.get(sAuthNProfileID);
                if (iAuthNProfileID <= iMaxLevel) continue;
                iMaxLevel = iAuthNProfileID;
                sHighestProfile = sAuthNProfileID;
                continue;
            }
            AuthenticationProfile authnProfile = null;
            try {
                authnProfile = this._authnProfileFactory.getProfile(sAuthNProfileID);
            }
            catch (AuthenticationException e) {
                this._logger.error((Object)("Authentication profile not available: " + sAuthNProfileID));
                throw new OAException(1);
            }
            String sLevel = (String)authnProfile.getProperty(this._sProfileID + PROPERTY_AUTHSP_LEVEL);
            if (sLevel == null) continue;
            try {
                int iAuthNProfileID = Integer.valueOf(sLevel);
                if (iAuthNProfileID <= iMaxLevel) continue;
                iMaxLevel = iAuthNProfileID;
                sHighestProfile = sAuthNProfileID;
            }
            catch (NumberFormatException e) {
                StringBuffer sbError = new StringBuffer("Invalid value of the '");
                sbError.append(this._sProfileID);
                sbError.append(PROPERTY_AUTHSP_LEVEL);
                sbError.append("' property available: ");
                sbError.append(sLevel);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        }
        return sHighestProfile;
    }

    protected Integer getAuthSPLevel(String sAuthNProfileID) throws OAException {
        Integer intAuthSPLevel = this._iDefaultAuthSPLevel;
        if (this._htAuthSPLevels.containsKey(sAuthNProfileID)) {
            intAuthSPLevel = this._htAuthSPLevels.get(sAuthNProfileID);
        } else {
            AuthenticationProfile authnProfile = null;
            try {
                authnProfile = this._authnProfileFactory.getProfile(sAuthNProfileID);
            }
            catch (AuthenticationException e) {
                this._logger.error((Object)("Authentication profile not available: " + sAuthNProfileID));
                throw new OAException(1);
            }
            String sLevel = (String)authnProfile.getProperty(this._sProfileID + PROPERTY_AUTHSP_LEVEL);
            if (sLevel != null) {
                try {
                    intAuthSPLevel = new Integer(sLevel);
                }
                catch (NumberFormatException e) {
                    StringBuffer sbError = new StringBuffer("Invalid value of the '");
                    sbError.append(this._sProfileID);
                    sbError.append(PROPERTY_AUTHSP_LEVEL);
                    sbError.append("' property available: ");
                    sbError.append(sLevel);
                    this._logger.error((Object)sbError.toString());
                    throw new OAException(1);
                }
            }
        }
        return intAuthSPLevel;
    }

    protected String getUid(IUser oUser, ASelectRequestorPool oASRequestorPool, RequestorPool oRequestorPool, IRequestor oRequestor) throws ASelectException, OAException {
        String sUid = oUser.getID();
        String sUidAttribute = (String)oRequestor.getProperty(this._sProfileID + PROPERTY_UID_ATTRIBUTE);
        if (sUidAttribute == null) {
            if (oASRequestorPool != null) {
                sUidAttribute = oASRequestorPool.getUidAttribute();
            }
            if (sUidAttribute == null) {
                sUidAttribute = (String)oRequestorPool.getProperty(this._sProfileID + PROPERTY_UID_ATTRIBUTE);
            }
        }
        if (sUidAttribute != null) {
            IAttributes oAttributes = oUser.getAttributes();
            sUid = (String)oAttributes.get(sUidAttribute);
            if (sUid == null) {
                StringBuffer sbError = new StringBuffer("Missing required attribute (");
                sbError.append(sUidAttribute);
                sbError.append(") to resolve uid for user with ID: ");
                sbError.append(oUser.getID());
                this._logger.warn((Object)sbError.toString());
                throw new ASelectException("9901");
            }
            oAttributes.remove(sUidAttribute);
        }
        boolean bOpaqueUID = false;
        String sUIDOpaque = (String)oRequestor.getProperty(this._sProfileID + PROPERTY_UID_OPAQUE_ENABLED);
        if (sUIDOpaque != null) {
            if ("TRUE".equalsIgnoreCase(sUIDOpaque)) {
                bOpaqueUID = true;
            } else if (!"FALSE".equalsIgnoreCase(sUIDOpaque)) {
                StringBuffer sbError = new StringBuffer("Invalid value for requestor property '");
                sbError.append(this._sProfileID);
                sbError.append(PROPERTY_UID_OPAQUE_ENABLED);
                sbError.append("': ");
                sbError.append(sUIDOpaque);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        } else {
            if (oASRequestorPool != null) {
                bOpaqueUID = oASRequestorPool.isUidOpaque();
            }
            if (!bOpaqueUID && (sUIDOpaque = (String)oRequestorPool.getProperty(this._sProfileID + PROPERTY_UID_OPAQUE_ENABLED)) != null) {
                if ("TRUE".equalsIgnoreCase(sUIDOpaque)) {
                    bOpaqueUID = true;
                } else if (!"FALSE".equalsIgnoreCase(sUIDOpaque)) {
                    StringBuffer sbError = new StringBuffer("Invalid value for requestorpool property '");
                    sbError.append(this._sProfileID);
                    sbError.append(PROPERTY_UID_OPAQUE_ENABLED);
                    sbError.append("': ");
                    sbError.append(sUIDOpaque);
                    this._logger.error((Object)sbError.toString());
                    throw new OAException(1);
                }
            }
        }
        if (bOpaqueUID) {
            String sSalt = (String)oRequestor.getProperty(this._sProfileID + PROPERTY_UID_OPAQUE_SALT);
            if (sSalt == null) {
                if (oASRequestorPool != null) {
                    sSalt = oASRequestorPool.getUidOpaqueSalt();
                }
                if (sSalt == null) {
                    sSalt = (String)oRequestorPool.getProperty(this._sProfileID + PROPERTY_UID_OPAQUE_SALT);
                }
            }
            if (sSalt != null) {
                sUid = sUid + sSalt;
            }
            MessageDigest oMessageDigest = this._cryptoManager.getMessageDigest();
            try {
                oMessageDigest.update(sUid.getBytes("UTF-8"));
                sUid = AbstractAPIHandler.toHexString(oMessageDigest.digest());
            }
            catch (Exception e) {
                this._logger.warn((Object)("Unable to generate '" + oMessageDigest.getAlgorithm() + "' hash from user ID: " + sUid), (Throwable)e);
                throw new OAException(1);
            }
        }
        return sUid;
    }

    protected String getAppLevel(RequestorPool oRequestorPool, ASelectRequestorPool oASRequestorPool, IRequestor oRequestor) throws OAException {
        String sAppLevel = String.valueOf(this._iDefaultAppLevel);
        int iAppLevel = -1;
        String appLevel = (String)oRequestor.getProperty(this._sProfileID + PROPERTY_APP_LEVEL);
        if (appLevel != null) {
            try {
                iAppLevel = Integer.valueOf(appLevel);
            }
            catch (NumberFormatException e) {
                StringBuffer sbError = new StringBuffer("The configured requestor property (");
                sbError.append(this._sProfileID);
                sbError.append(PROPERTY_APP_LEVEL);
                sbError.append(") value isn't a number: ");
                sbError.append(appLevel);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new OAException(1);
            }
        }
        if (oASRequestorPool != null) {
            iAppLevel = oASRequestorPool.getAppLevel();
        }
        if (iAppLevel == -1 && (appLevel = (String)oRequestorPool.getProperty(this._sProfileID + PROPERTY_APP_LEVEL)) != null) {
            try {
                iAppLevel = Integer.valueOf(appLevel);
            }
            catch (NumberFormatException e) {
                StringBuffer sbError = new StringBuffer("The configured requestorpool property (");
                sbError.append(this._sProfileID);
                sbError.append(PROPERTY_APP_LEVEL);
                sbError.append(") value isn't a number: ");
                sbError.append(appLevel);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new OAException(1);
            }
        }
        if (iAppLevel > 0) {
            sAppLevel = String.valueOf(iAppLevel);
        }
        return sAppLevel;
    }

    protected boolean doSigning(RequestorPool oRequestorPool, ASelectRequestorPool oASRequestorPool, IRequestor oRequestor) throws OAException {
        String sEnabled = (String)oRequestor.getProperty(this._sProfileID + PROPERTY_SIGN_REQUESTS);
        if (sEnabled != null) {
            if ("TRUE".equalsIgnoreCase(sEnabled)) {
                return true;
            }
            if (!"FALSE".equalsIgnoreCase(sEnabled)) {
                StringBuffer sbError = new StringBuffer("The configured requestor property (");
                sbError.append(this._sProfileID);
                sbError.append(PROPERTY_SIGN_REQUESTS);
                sbError.append(") value isn't a boolean: ");
                sbError.append(sEnabled);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        }
        if (oASRequestorPool != null && oASRequestorPool.doSigning()) {
            return true;
        }
        sEnabled = (String)oRequestorPool.getProperty(this._sProfileID + PROPERTY_SIGN_REQUESTS);
        if (sEnabled != null) {
            if ("TRUE".equalsIgnoreCase(sEnabled)) {
                return true;
            }
            if (!"FALSE".equalsIgnoreCase(sEnabled)) {
                StringBuffer sbError = new StringBuffer("The configured requestorpool property (");
                sbError.append(this._sProfileID);
                sbError.append(PROPERTY_SIGN_REQUESTS);
                sbError.append(") value isn't a boolean: ");
                sbError.append(sEnabled);
                this._logger.error((Object)sbError.toString());
                throw new OAException(1);
            }
        }
        return false;
    }

    private RequestorEvent getLogoutResult(List<TGTEventError> listErrors) {
        RequestorEvent event = RequestorEvent.LOGOUT_FAILED;
        block3: for (TGTEventError eventError : listErrors) {
            switch (eventError.getCode()) {
                case USER_LOGOUT_PARTIALLY: {
                    event = RequestorEvent.LOGOUT_PARTIALLY;
                    continue block3;
                }
            }
            return RequestorEvent.LOGOUT_FAILED;
        }
        return event;
    }

    private static String toHexString(byte[] baBytes) {
        char[] ca = Hex.encodeHex((byte[])baBytes);
        String s = new String(ca).toUpperCase();
        return s;
    }
}

