/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.profile.aselect.processor.handler;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ASelectRequestorPool {
    private Log _logger;
    private String _sID;
    private int _iAppLevel;
    private boolean _bUidOpaque;
    private String _sUidOpaqueSalt;
    private String _sUidAttribute;
    private boolean _bSigning;

    public ASelectRequestorPool(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            String sEnabled;
            this._logger = LogFactory.getLog(ASelectRequestorPool.class);
            this._sID = oConfigurationManager.getParam(eConfig, "id");
            if (this._sID == null) {
                this._logger.warn((Object)"No 'id' parameter found in configuration");
                throw new OAException(2);
            }
            String sLevel = oConfigurationManager.getParam(eConfig, "app_level");
            if (sLevel == null) {
                this._logger.warn((Object)"No optional 'app_level' parameter found in configuration");
                this._iAppLevel = -1;
            } else {
                try {
                    this._iAppLevel = Integer.valueOf(sLevel);
                }
                catch (NumberFormatException e) {
                    this._logger.warn((Object)("The configured 'app_level' parameter isn't a number: " + sLevel), (Throwable)e);
                    throw new OAException(2);
                }
            }
            this._bUidOpaque = false;
            Element eUid = oConfigurationManager.getSection(eConfig, "uid");
            if (eUid != null) {
                String sUidOpaque;
                this._sUidAttribute = oConfigurationManager.getParam(eUid, "attribute");
                Element eOpaque = oConfigurationManager.getSection(eUid, "opaque");
                if (eOpaque != null && (sUidOpaque = oConfigurationManager.getParam(eOpaque, "enabled")) != null) {
                    if (sUidOpaque.equalsIgnoreCase("TRUE")) {
                        this._bUidOpaque = true;
                        this._sUidOpaqueSalt = oConfigurationManager.getParam(eOpaque, "salt");
                    } else if (!sUidOpaque.equalsIgnoreCase("FALSE")) {
                        this._logger.warn((Object)("The configured opaque 'enabled' parameter isn't TRUE or FALSE: " + sUidOpaque));
                        throw new OAException(2);
                    }
                }
            }
            this._bSigning = false;
            Element eSigning = oConfigurationManager.getSection(eConfig, "signing");
            if (eSigning != null && (sEnabled = oConfigurationManager.getParam(eSigning, "enabled")) != null) {
                if (sEnabled.equalsIgnoreCase("TRUE")) {
                    this._bSigning = true;
                } else if (!sEnabled.equalsIgnoreCase("FALSE")) {
                    this._logger.warn((Object)("The configured 'enabled' parameter in the 'signing' section isn't TRUE or FALSE: " + sEnabled));
                    throw new OAException(2);
                }
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
            throw new OAException(1);
        }
    }

    public String getID() {
        return this._sID;
    }

    public int getAppLevel() {
        return this._iAppLevel;
    }

    public boolean isUidOpaque() {
        return this._bUidOpaque;
    }

    public String getUidOpaqueSalt() {
        return this._sUidOpaqueSalt;
    }

    public String getUidAttribute() {
        return this._sUidAttribute;
    }

    public boolean doSigning() {
        return this._bSigning;
    }

    public String toString() {
        StringBuffer sbInfo = new StringBuffer("Requestor (");
        sbInfo.append(this._sID).append(") with ");
        sbInfo.append(" app_level=").append(this._iAppLevel);
        sbInfo.append(", signing=").append(this._bSigning);
        StringBuffer sbUid = new StringBuffer();
        if (this._bUidOpaque) {
            sbUid.append("opaque");
            if (this._sUidOpaqueSalt != null) {
                sbUid.append(" with salt '").append(this._sUidOpaqueSalt).append("'");
            }
        }
        if (this._sUidAttribute != null) {
            if (sbUid.length() > 0) {
                sbUid.append(",");
            }
            sbUid.append("attribute=").append(this._sUidAttribute);
        }
        if (sbUid.length() > 0) {
            sbInfo.append(", uid(").append(sbUid).append(")");
        }
        return sbInfo.toString();
    }
}

