/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.tgt.memory.alias;

import com.alfaariss.oa.engine.tgt.memory.alias.Alias;
import com.alfaariss.oa.engine.tgt.memory.alias.AliasKey;
import java.util.Enumeration;
import java.util.Hashtable;

public class AliasStore {
    private String _sStoreID;
    private Hashtable<AliasKey, Alias> _htIndexedOnAlias;
    private Hashtable<AliasKey, Alias> _htIndexedOnTGTID;

    public AliasStore(String sStoreID) {
        this._sStoreID = sStoreID;
        this._htIndexedOnAlias = new Hashtable();
        this._htIndexedOnTGTID = new Hashtable();
    }

    public String getID() {
        return this._sStoreID;
    }

    public Enumeration<Alias> getAll() {
        return this._htIndexedOnAlias.elements();
    }

    public void remove(String requestorID, String alias) {
        AliasKey oAliasKey = new AliasKey(requestorID, alias);
        Alias oAlias = this._htIndexedOnAlias.get(oAliasKey);
        if (oAlias != null) {
            this._htIndexedOnAlias.remove(oAliasKey);
            this._htIndexedOnTGTID.remove(new AliasKey(requestorID, oAlias.getTGTID()));
        }
    }

    public void removeForTGT(String requestorID, String tgtID) {
        AliasKey oAliasKey = new AliasKey(requestorID, tgtID);
        Alias oAlias = this._htIndexedOnTGTID.get(oAliasKey);
        if (oAlias != null) {
            this._htIndexedOnTGTID.remove(new AliasKey(requestorID, tgtID));
            this._htIndexedOnAlias.remove(new AliasKey(requestorID, oAlias.getAlias()));
        }
    }

    public void removeForTGT(String tgtID) {
        Enumeration<Alias> enumAliasses = this._htIndexedOnAlias.elements();
        while (enumAliasses.hasMoreElements()) {
            Alias alias = enumAliasses.nextElement();
            if (!alias.getTGTID().equals(tgtID)) continue;
            this._htIndexedOnTGTID.remove(new AliasKey(alias.getRequestorID(), alias.getTGTID()));
            this._htIndexedOnAlias.remove(new AliasKey(alias.getRequestorID(), alias.getAlias()));
        }
    }

    public void put(String requestorID, String tgtID, String alias) {
        Alias oAlias = new Alias(tgtID, requestorID, alias);
        this._htIndexedOnAlias.put(new AliasKey(requestorID, alias), oAlias);
        this._htIndexedOnTGTID.put(new AliasKey(requestorID, tgtID), oAlias);
    }

    public String getAlias(String requestorID, String tgtID) {
        Alias oAlias = this._htIndexedOnTGTID.get(new AliasKey(requestorID, tgtID));
        if (oAlias != null) {
            return oAlias.getAlias();
        }
        return null;
    }

    public String getTGTID(String requestorID, String alias) {
        Alias oAlias = this._htIndexedOnAlias.get(new AliasKey(requestorID, alias));
        if (oAlias != null) {
            return oAlias.getTGTID();
        }
        return null;
    }

    public boolean exist(String requestorID, String alias) {
        AliasKey oAliasKey = new AliasKey(requestorID, alias);
        return this._htIndexedOnAlias.containsKey(oAliasKey);
    }

    public void removeAlias(String entityID, String tgtID) {
        AliasKey oAliasKey = new AliasKey(entityID, tgtID);
        Alias oAlias = this._htIndexedOnTGTID.get(oAliasKey);
        if (oAlias != null) {
            this._htIndexedOnTGTID.remove(new AliasKey(oAlias.getRequestorID(), oAlias.getTGTID()));
            this._htIndexedOnAlias.remove(new AliasKey(oAlias.getRequestorID(), oAlias.getAlias()));
        }
    }
}

