/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.tgt.memory;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.api.tgt.TGTListenerEvent;
import com.alfaariss.oa.api.tgt.TGTListenerException;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.tgt.TGTException;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.engine.tgt.memory.MemoryTGT;
import com.alfaariss.oa.engine.tgt.memory.MemoryTGTAliasStore;
import com.alfaariss.oa.util.ModifiedBase64;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.storage.factory.AbstractStorageFactory;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryTGTFactory
extends AbstractStorageFactory
implements ITGTFactory<MemoryTGT> {
    private Hashtable<String, MemoryTGT> _htTGT;
    private List<ITGTListener> _lListeners;
    private Log _logger = LogFactory.getLog(MemoryTGTFactory.class);
    private Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    private MemoryTGTAliasStore _aliasStoreSP;
    private MemoryTGTAliasStore _aliasStoreIDP;

    public MemoryTGTFactory() {
        this._htTGT = new Hashtable();
        this._lListeners = new Vector<ITGTListener>();
        this._aliasStoreSP = new MemoryTGTAliasStore();
        this._aliasStoreIDP = new MemoryTGTAliasStore();
    }

    public ITGT createTGT(IUser user) throws TGTException {
        if (this._lMax > 0L && (long)this._htTGT.size() >= this._lMax) {
            this._logger.error((Object)"Could not create TGT, maximum reached");
            throw new TGTException(65);
        }
        return new MemoryTGT(this, user);
    }

    public boolean exists(Object id) {
        return this._htTGT.containsKey(id);
    }

    public MemoryTGT retrieve(Object id) throws PersistenceException {
        return this._htTGT.get(id);
    }

    public TGTListenerEvent persistPassingListenerEvent(MemoryTGT tgt) throws PersistenceException {
        TGTListenerEvent passedEvent = this.performPersist(tgt, false);
        StringBuffer sbDebug = new StringBuffer("Passed '");
        sbDebug.append(passedEvent);
        sbDebug.append("' event for TGT with id: ");
        sbDebug.append(tgt.getId());
        this._logger.debug((Object)sbDebug.toString());
        return passedEvent;
    }

    public void clean(MemoryTGT tgt) throws PersistenceException {
        List listTGTEventErrors = null;
        String id = tgt.getId();
        this._logger.debug((Object)("Clean TGT: " + id));
        try {
            this.processEvent(TGTListenerEvent.ON_EXPIRE, (ITGT)tgt);
        }
        catch (TGTListenerException e) {
            listTGTEventErrors = e.getErrors();
        }
        int iCountR = this._aliasStoreSP.remove(id);
        int iCountF = this._aliasStoreIDP.remove(id);
        if (this._logger.isDebugEnabled() && iCountR + iCountF > 0) {
            StringBuffer sbDebug = new StringBuffer("Cleaned '");
            sbDebug.append(iCountR);
            sbDebug.append("' (requestor based) aliasses and '");
            sbDebug.append(iCountF);
            sbDebug.append("' (remote enitity based) aliasses for TGT with id: ");
            sbDebug.append(id);
            this._logger.debug((Object)sbDebug.toString());
        }
        IUser tgtUser = tgt.getUser();
        this._eventLogger.info((Object)new UserEventLogItem(null, id, null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, null));
        this._htTGT.remove(id);
        if (listTGTEventErrors != null) {
            throw new TGTListenerException(listTGTEventErrors);
        }
    }

    public void persist(MemoryTGT tgt) throws PersistenceException {
        TGTListenerEvent performedEvent = this.performPersist(tgt, true);
        StringBuffer sbDebug = new StringBuffer("Performed '");
        sbDebug.append(performedEvent);
        sbDebug.append("' event for TGT with id: ");
        sbDebug.append(tgt.getId());
        this._logger.debug((Object)sbDebug.toString());
    }

    public void persist(MemoryTGT[] oaTgt) throws PersistenceException {
        Vector listTGTEventErrors = new Vector();
        int iErrorCode = -1;
        for (MemoryTGT tgt : oaTgt) {
            try {
                this.persist(tgt);
            }
            catch (TGTListenerException e) {
                listTGTEventErrors.addAll(e.getErrors());
            }
            catch (PersistenceException e) {
                if (iErrorCode != -1) continue;
                iErrorCode = e.getCode();
            }
        }
        if (!listTGTEventErrors.isEmpty()) {
            throw new TGTListenerException(listTGTEventErrors);
        }
        if (iErrorCode != -1) {
            throw new PersistenceException(iErrorCode);
        }
    }

    public void removeExpired() throws PersistenceException {
        long lNow = System.currentTimeMillis();
        Enumeration<MemoryTGT> eTGTs = this._htTGT.elements();
        while (eTGTs.hasMoreElements()) {
            MemoryTGT tgt = eTGTs.nextElement();
            if (tgt.getTgtExpTime().getTime() > lNow) continue;
            String id = tgt.getId();
            this._logger.debug((Object)("TGT Expired: " + id));
            try {
                this.processEvent(TGTListenerEvent.ON_EXPIRE, (ITGT)tgt);
            }
            catch (TGTListenerException e) {
                this._logger.debug((Object)("Could not process events for TGT with id: " + id), (Throwable)e);
            }
            int iCountR = this._aliasStoreSP.remove(id);
            int iCountF = this._aliasStoreIDP.remove(id);
            if (this._logger.isDebugEnabled() && iCountR + iCountF > 0) {
                StringBuffer sbDebug = new StringBuffer("Cleaned '");
                sbDebug.append(iCountR);
                sbDebug.append("' (requestor based) aliasses and '");
                sbDebug.append(iCountF);
                sbDebug.append("' (remote enitity based) aliasses for TGT with id: ");
                sbDebug.append(id);
                this._logger.debug((Object)sbDebug.toString());
            }
            IUser tgtUser = tgt.getUser();
            this._eventLogger.info((Object)new UserEventLogItem(null, id, null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, "clean"));
            this._htTGT.remove(id);
        }
    }

    public void start() throws OAException {
        if (this._tCleaner != null) {
            this._tCleaner.start();
        }
    }

    public long poll() throws OAException {
        if (this._htTGT != null) {
            return this._htTGT.size();
        }
        return Long.MIN_VALUE;
    }

    public void addListener(ITGTListener listener) {
        this._lListeners.add(listener);
    }

    public void removeListener(ITGTListener listener) {
        this._lListeners.remove(listener);
    }

    public List<ITGTListener> getListeners() {
        return Collections.unmodifiableList(this._lListeners);
    }

    public void putAlias(String type, String requestorID, String tgtID, String alias) throws OAException {
        this._aliasStoreSP.putAlias(type, requestorID, tgtID, alias);
    }

    public String getAlias(String type, String requestorID, String tgtID) throws OAException {
        return this._aliasStoreSP.getAlias(type, requestorID, tgtID);
    }

    public String getTGTID(String type, String requestorID, String alias) throws OAException {
        return this._aliasStoreSP.getTGTID(type, requestorID, alias);
    }

    public boolean isAlias(String type, String requestorID, String alias) throws OAException {
        return this._aliasStoreSP.isAlias(type, requestorID, alias);
    }

    public boolean hasAliasSupport() {
        return this._aliasStoreSP != null;
    }

    public String getAuthority() {
        return "TGTFactory";
    }

    public ITGTAliasStore getAliasStoreIDP() {
        return this._aliasStoreIDP;
    }

    public ITGTAliasStore getAliasStoreSP() {
        return this._aliasStoreSP;
    }

    private synchronized TGTListenerEvent performPersist(MemoryTGT tgt, boolean bProcessEvent) throws PersistenceException {
        TGTListenerEvent listenerEvent = null;
        List listTGTEventErrors = null;
        String id = tgt.getId();
        if (id == null) {
            byte[] baId = new byte[128];
            do {
                this._random.nextBytes(baId);
                try {
                    id = ModifiedBase64.encode((byte[])baId);
                }
                catch (UnsupportedEncodingException e) {
                    this._logger.error((Object)("Could not create tgt id for byte[]: " + baId), (Throwable)e);
                    throw new PersistenceException(1);
                }
            } while (this._htTGT.containsKey(id));
            tgt.setId(id);
            tgt.setTgtExpTime(System.currentTimeMillis() + this._lExpiration);
            this._htTGT.put(id, tgt);
            listenerEvent = TGTListenerEvent.ON_CREATE;
            if (bProcessEvent) {
                try {
                    this.processEvent(listenerEvent, (ITGT)tgt);
                }
                catch (TGTListenerException e) {
                    listTGTEventErrors = e.getErrors();
                }
            }
        } else if (tgt.isExpired()) {
            this._logger.debug((Object)("TGT Expired: " + id));
            listenerEvent = TGTListenerEvent.ON_REMOVE;
            if (bProcessEvent) {
                try {
                    this.processEvent(listenerEvent, (ITGT)tgt);
                }
                catch (TGTListenerException e) {
                    listTGTEventErrors = e.getErrors();
                }
            }
            int iCountR = this._aliasStoreSP.remove(id);
            int iCountF = this._aliasStoreIDP.remove(id);
            if (this._logger.isDebugEnabled() && iCountR + iCountF > 0) {
                StringBuffer sbDebug = new StringBuffer("Cleaned '");
                sbDebug.append(iCountR);
                sbDebug.append("' (requestor based) aliasses and '");
                sbDebug.append(iCountF);
                sbDebug.append("' (remote enitity based) aliasses for TGT with id: ");
                sbDebug.append(id);
                this._logger.debug((Object)sbDebug.toString());
            }
            IUser tgtUser = tgt.getUser();
            this._eventLogger.info((Object)new UserEventLogItem(null, id, null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, null));
            this._htTGT.remove(id);
        } else {
            tgt.setTgtExpTime(System.currentTimeMillis() + this._lExpiration);
            listenerEvent = TGTListenerEvent.ON_UPDATE;
            if (bProcessEvent) {
                try {
                    this.processEvent(listenerEvent, (ITGT)tgt);
                }
                catch (TGTListenerException e) {
                    listTGTEventErrors = e.getErrors();
                }
            }
        }
        if (listTGTEventErrors != null) {
            throw new TGTListenerException(listTGTEventErrors);
        }
        return listenerEvent;
    }

    private void processEvent(TGTListenerEvent event, ITGT tgt) throws TGTListenerException {
        Vector listErrors = new Vector();
        for (int i = 0; i < this._lListeners.size(); ++i) {
            ITGTListener listener = this._lListeners.get(i);
            try {
                listener.processTGTEvent(event, tgt);
                continue;
            }
            catch (TGTListenerException e) {
                StringBuffer sbDebug = new StringBuffer("Could not process '");
                sbDebug.append(event);
                sbDebug.append("' event for TGT with id '");
                sbDebug.append(tgt.getId());
                sbDebug.append("': ");
                sbDebug.append((Object)e);
                this._logger.debug((Object)sbDebug.toString(), (Throwable)e);
                listErrors.addAll(e.getErrors());
            }
        }
        if (!listErrors.isEmpty()) {
            throw new TGTListenerException(listErrors);
        }
    }
}

