/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.tgt.memory;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.tgt.memory.alias.AliasStore;
import java.util.Enumeration;
import java.util.Hashtable;

public class MemoryTGTAliasStore
implements ITGTAliasStore {
    private Hashtable<String, AliasStore> _htAliasStores = new Hashtable();

    public void putAlias(String type, String requestorID, String tgtID, String alias) throws OAException {
        AliasStore store = this._htAliasStores.get(type);
        if (store == null) {
            store = new AliasStore(type);
        }
        store.put(requestorID, tgtID, alias);
        this._htAliasStores.put(type, store);
    }

    public String getAlias(String type, String requestorID, String tgtID) throws OAException {
        AliasStore store = this._htAliasStores.get(type);
        if (store != null) {
            return store.getAlias(requestorID, tgtID);
        }
        return null;
    }

    public String getTGTID(String type, String requestorID, String alias) throws OAException {
        AliasStore store = this._htAliasStores.get(type);
        if (store != null) {
            return store.getTGTID(requestorID, alias);
        }
        return null;
    }

    public boolean isAlias(String type, String requestorID, String alias) throws OAException {
        AliasStore store = this._htAliasStores.get(type);
        if (store != null) {
            return store.exist(requestorID, alias);
        }
        return false;
    }

    public void removeAlias(String type, String entityID, String alias) throws OAException {
        AliasStore store = this._htAliasStores.get(type);
        if (store != null) {
            store.remove(entityID, alias);
        }
    }

    public void removeAll(String requestorID, String tgtID) throws OAException {
        Enumeration<AliasStore> enumStores = this._htAliasStores.elements();
        while (enumStores.hasMoreElements()) {
            enumStores.nextElement().removeAlias(requestorID, tgtID);
        }
    }

    int remove(String tgtID) {
        int iReturn = 0;
        Enumeration<AliasStore> enumStores = this._htAliasStores.elements();
        while (enumStores.hasMoreElements()) {
            enumStores.nextElement().removeForTGT(tgtID);
            ++iReturn;
        }
        return iReturn;
    }
}

