/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.engine.tgt.jgroups;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.api.tgt.TGTListenerEvent;
import com.alfaariss.oa.api.tgt.TGTListenerException;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.tgt.TGTException;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.util.ModifiedBase64;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.storage.factory.AbstractStorageFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asimba.engine.cluster.ClusterConfiguration;
import org.asimba.engine.core.cluster.ICluster;
import org.asimba.engine.tgt.jgroups.JGroupsTGT;
import org.asimba.engine.tgt.jgroups.JGroupsTGTAliasStore;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.ReplicatedHashMap;
import org.w3c.dom.Element;

public class JGroupsTGTFactory
extends AbstractStorageFactory
implements ITGTFactory<JGroupsTGT> {
    public static final String EL_CONFIG_CLUSTERID = "cluster_id";
    public static final String EL_CONFIG_ALIAS_CLUSTERID = "alias_cluster_id";
    public static final String EL_CONFIG_BLOCKING_MODE = "blocking_mode";
    public static final String EL_CONFIG_BLOCKING_TIMEOUT = "blocking_timeout";
    public static final String EL_CONFIG_STATE_TIMEOUT = "state_timeout";
    public static final String EL_CONFIG_ALIASMAP_RETRIES = "aliasmap_retries";
    public static final String EL_CONFIG_ALIASMAP_TIMEOUT = "aliasmap_timeout";
    public static final String EL_CONFIG_ALIASMAP_LOGGING = "aliasmap_logging";
    public static final Boolean BLOCKING_MODE_DEFAULT = true;
    public static final Long BLOCKING_TIMEOUT_DEFAULT = 5000L;
    public static final Long STATE_TIMEOUT_DEFAULT = 100000L;
    public static final Integer ALIASMAP_RETRIES_DEFAULT = 0;
    public static final Long ALIASMAP_TIMEOUT_DEFAULT = 10L;
    public static final Boolean ALIASMAP_LOGGING_DEFAULT = false;
    private static final Log _oLogger = LogFactory.getLog(JGroupsTGTFactory.class);
    private static final Log _oEventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    private ReplicatedHashMap<String, JGroupsTGT> _mTGTs;
    private ReplicatedHashMap<String, String> _mAliasMap;
    private ICluster _oCluster = null;
    private ICluster _oAliasCluster = null;
    private JChannel _jChannel = null;
    private JChannel _jAliasChannel = null;
    private JGroupsTGTAliasStore _oSPAliasStore;
    private JGroupsTGTAliasStore _oIDPAliasStore;
    private List<ITGTListener> _lListeners;
    private int _iAliasMapRetries;
    private long _lAliasMapTimeout;

    public void start() throws OAException {
        this._lListeners = new Vector<ITGTListener>();
        ClusterConfiguration oClusterConfiguration = new ClusterConfiguration(this._configurationManager);
        if (this._oCluster == null) {
            this._oCluster = oClusterConfiguration.getClusterFromConfigById(this._eConfig, EL_CONFIG_CLUSTERID);
        }
        this._jChannel = (JChannel)this._oCluster.getChannel();
        this._mTGTs = new ReplicatedHashMap((Channel)this._jChannel);
        this._iAliasMapRetries = new ConfigParser<Integer>().parse(EL_CONFIG_ALIASMAP_RETRIES, this._eConfig, ALIASMAP_RETRIES_DEFAULT);
        this._lAliasMapTimeout = new ConfigParser<Long>().parse(EL_CONFIG_ALIASMAP_TIMEOUT, this._eConfig, ALIASMAP_TIMEOUT_DEFAULT);
        Long lStateTimeout = new ConfigParser<Long>().parse(EL_CONFIG_STATE_TIMEOUT, this._eConfig, STATE_TIMEOUT_DEFAULT);
        Boolean bBlockingMode = new ConfigParser<Boolean>().parse(EL_CONFIG_BLOCKING_MODE, this._eConfig, BLOCKING_MODE_DEFAULT);
        Long lBlockingTimeout = new ConfigParser<Long>().parse(EL_CONFIG_BLOCKING_TIMEOUT, this._eConfig, BLOCKING_TIMEOUT_DEFAULT);
        Boolean bAliasMapLogging = new ConfigParser<Boolean>().parse(EL_CONFIG_ALIASMAP_LOGGING, this._eConfig, ALIASMAP_LOGGING_DEFAULT);
        try {
            this._mTGTs.start(lStateTimeout.longValue());
        }
        catch (Exception e) {
            _oLogger.error((Object)("Could not start Replicated HashMap: " + e.getMessage()), (Throwable)e);
            throw new OAException(1);
        }
        if (this._oAliasCluster == null) {
            this._oAliasCluster = oClusterConfiguration.getClusterFromConfigById(this._eConfig, EL_CONFIG_ALIAS_CLUSTERID);
        }
        this._jAliasChannel = (JChannel)this._oAliasCluster.getChannel();
        this._mAliasMap = new ReplicatedHashMap((Channel)this._jAliasChannel);
        try {
            this._mAliasMap.start(lStateTimeout.longValue());
        }
        catch (Exception e) {
            _oLogger.error((Object)("Could not start Replicated HashMap: " + e.getMessage()), (Throwable)e);
            throw new OAException(1);
        }
        this._mTGTs.setBlockingUpdates(bBlockingMode.booleanValue());
        this._mAliasMap.setBlockingUpdates(bBlockingMode.booleanValue());
        this._mTGTs.setTimeout(lBlockingTimeout.longValue());
        this._mAliasMap.setTimeout(lBlockingTimeout.longValue());
        this._oSPAliasStore = new JGroupsTGTAliasStore("sp", this._mAliasMap, this);
        this._oIDPAliasStore = new JGroupsTGTAliasStore("idp", this._mAliasMap, this);
        this._oSPAliasStore.setFailureLogging(bAliasMapLogging, JGroupsTGTFactory.class.getName());
        this._oIDPAliasStore.setFailureLogging(bAliasMapLogging, JGroupsTGTFactory.class.getName());
        if (this._tCleaner != null) {
            this._tCleaner.start();
        }
    }

    public void stop() {
        this._mTGTs.stop();
        this._mAliasMap.stop();
        this._oIDPAliasStore.stop();
        this._oSPAliasStore.stop();
        this._oCluster.close();
        this._oAliasCluster.close();
    }

    public void startForTesting(IConfigurationManager oConfigurationManager, Element eConfig, ICluster oCluster, ICluster oAliasCluster, SecureRandom secureRandom, long expiration) throws OAException {
        this._configurationManager = oConfigurationManager;
        this._eConfig = eConfig;
        this._oCluster = oCluster;
        this._oAliasCluster = oAliasCluster;
        this._random = secureRandom;
        this._lExpiration = expiration;
        this.start();
    }

    public boolean isBlockingUpdates() {
        return this._mTGTs.isBlockingUpdates() && this._mAliasMap.isBlockingUpdates();
    }

    public void setBlockingUpdates(boolean b) {
        this._mTGTs.setBlockingUpdates(b);
        this._mAliasMap.setBlockingUpdates(b);
    }

    public long getTimeout() {
        return this._mTGTs.getTimeout();
    }

    public void setTimout(long timeout) {
        this._mTGTs.setTimeout(timeout);
        this._mAliasMap.setTimeout(timeout);
    }

    public void removeExpired() throws PersistenceException {
        long lNow = System.currentTimeMillis();
        for (Map.Entry entry : this._mTGTs.entrySet()) {
            JGroupsTGT tgt = (JGroupsTGT)entry.getValue();
            if (tgt.getTgtExpTime().getTime() > lNow) continue;
            String id = tgt.getId();
            _oLogger.debug((Object)("TGT Expired: " + id));
            try {
                this.processEvent(TGTListenerEvent.ON_EXPIRE, (ITGT)tgt);
            }
            catch (TGTListenerException e) {
                _oLogger.debug((Object)("Could not process events for TGT with id: " + id), (Throwable)e);
            }
            int iCountR = this._oSPAliasStore.remove(id);
            int iCountF = this._oIDPAliasStore.remove(id);
            if (_oLogger.isDebugEnabled() && iCountR + iCountF > 0) {
                StringBuilder sbDebug = new StringBuilder("Cleaned '");
                sbDebug.append(iCountR);
                sbDebug.append("' (requestor based) aliases and '");
                sbDebug.append(iCountF);
                sbDebug.append("' (remote entity based) aliases for TGT with id: ");
                sbDebug.append(id);
                _oLogger.debug((Object)sbDebug.toString());
            }
            IUser tgtUser = tgt.getUser();
            _oEventLogger.info((Object)new UserEventLogItem(null, id, null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, "clean"));
            this._mTGTs.remove(entry.getKey());
        }
    }

    public boolean exists(Object id) throws PersistenceException {
        return this._mTGTs.containsKey((Object)((String)id));
    }

    public void persist(JGroupsTGT oEntity) throws PersistenceException {
        TGTListenerEvent performedEvent = this.performPersist(oEntity, true);
        StringBuilder sbDebug = new StringBuilder("Performed '");
        sbDebug.append(performedEvent);
        sbDebug.append("' event for TGT with id: ");
        sbDebug.append(oEntity.getId());
        _oLogger.debug((Object)sbDebug.toString());
    }

    public void persist(JGroupsTGT[] entities) throws PersistenceException {
        Vector listTGTEventErrors = new Vector();
        int iErrorCode = -1;
        for (JGroupsTGT tgt : entities) {
            try {
                this.persist(tgt);
            }
            catch (TGTListenerException e) {
                listTGTEventErrors.addAll(e.getErrors());
            }
            catch (PersistenceException e) {
                if (iErrorCode != -1) continue;
                iErrorCode = e.getCode();
            }
        }
        if (!listTGTEventErrors.isEmpty()) {
            throw new TGTListenerException(listTGTEventErrors);
        }
        if (iErrorCode != -1) {
            throw new PersistenceException(iErrorCode);
        }
    }

    public TGTListenerEvent persistPassingListenerEvent(JGroupsTGT tgt) throws PersistenceException {
        TGTListenerEvent passedEvent = this.performPersist(tgt, false);
        _oLogger.debug((Object)("Passed '" + passedEvent + "' event for TGT with id: " + tgt.getId()));
        return passedEvent;
    }

    private synchronized TGTListenerEvent performPersist(JGroupsTGT oTGT, boolean bProcessEvent) throws PersistenceException {
        TGTListenerEvent listenerEvent = null;
        List listTGTEventErrors = null;
        String sTGTID = oTGT.getId();
        if (sTGTID == null) {
            byte[] baId = new byte[128];
            int iAllowedIdGenAttempts = 1000;
            do {
                this._random.nextBytes(baId);
                try {
                    sTGTID = ModifiedBase64.encode((byte[])baId);
                }
                catch (UnsupportedEncodingException e) {
                    _oLogger.error((Object)("Could not create tgt id for byte[]: " + Arrays.toString(baId)), (Throwable)e);
                    throw new PersistenceException(1);
                }
            } while (this._mTGTs.containsKey((Object)sTGTID) && --iAllowedIdGenAttempts > 0);
            if (this._mTGTs.containsKey((Object)sTGTID)) {
                _oLogger.error((Object)"Could not persist TGT because could not generate ID (which is weird!)");
                throw new PersistenceException(1);
            }
            oTGT.setId(sTGTID);
            oTGT.setTgtExpTime(System.currentTimeMillis() + this._lExpiration);
            this._mTGTs.put((Object)sTGTID, (Object)oTGT);
            listenerEvent = TGTListenerEvent.ON_CREATE;
            if (bProcessEvent) {
                try {
                    this.processEvent(listenerEvent, (ITGT)oTGT);
                }
                catch (TGTListenerException e) {
                    listTGTEventErrors = e.getErrors();
                }
            }
        } else if (oTGT.isExpired()) {
            int iCountF;
            int iCountR;
            _oLogger.debug((Object)("TGT Expired: " + sTGTID));
            listenerEvent = TGTListenerEvent.ON_REMOVE;
            if (bProcessEvent) {
                try {
                    this.processEvent(listenerEvent, (ITGT)oTGT);
                }
                catch (TGTListenerException e) {
                    listTGTEventErrors = e.getErrors();
                }
            }
            if ((iCountR = this._oSPAliasStore.remove(sTGTID)) + (iCountF = this._oIDPAliasStore.remove(sTGTID)) > 0) {
                _oLogger.debug((Object)("Cleaned '" + iCountR + "' (requestor based) aliasses and '" + iCountF + "' (remote enitity based) aliasses for TGT with id: " + sTGTID));
            }
            IUser tgtUser = oTGT.getUser();
            _oEventLogger.info((Object)new UserEventLogItem(null, sTGTID, null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, null));
            this._mTGTs.remove((Object)sTGTID);
        } else {
            oTGT.setTgtExpTime(System.currentTimeMillis() + this._lExpiration);
            this._mTGTs.replace((Object)sTGTID, (Object)oTGT);
            listenerEvent = TGTListenerEvent.ON_UPDATE;
            if (bProcessEvent) {
                try {
                    this.processEvent(listenerEvent, (ITGT)oTGT);
                }
                catch (TGTListenerException e) {
                    listTGTEventErrors = e.getErrors();
                }
            }
        }
        if (listTGTEventErrors != null) {
            throw new TGTListenerException(listTGTEventErrors);
        }
        return listenerEvent;
    }

    public void clean(JGroupsTGT oJGroupsTGT) throws PersistenceException {
        List listTGTEventErrors = null;
        String sTGTID = oJGroupsTGT.getId();
        _oLogger.debug((Object)("Clean TGT: " + sTGTID));
        try {
            this.processEvent(TGTListenerEvent.ON_REMOVE, (ITGT)oJGroupsTGT);
        }
        catch (TGTListenerException e) {
            listTGTEventErrors = e.getErrors();
        }
        int iCountR = this._oSPAliasStore.remove(sTGTID);
        int iCountF = this._oIDPAliasStore.remove(sTGTID);
        if (iCountR + iCountF > 0) {
            _oLogger.debug((Object)("Cleaned '" + iCountR + "' (requestor based) aliasses and '" + iCountF + "' (remote enitity based) aliasses for TGT with id: " + sTGTID));
        }
        IUser tgtUser = oJGroupsTGT.getUser();
        _oEventLogger.info((Object)new UserEventLogItem(null, sTGTID, null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, null));
        this._mTGTs.remove((Object)sTGTID);
        if (listTGTEventErrors != null) {
            throw new TGTListenerException(listTGTEventErrors);
        }
    }

    public long poll() throws OAException {
        if (this._mTGTs == null) {
            return 0L;
        }
        return this._mTGTs.size();
    }

    public String getAuthority() {
        return "TGTFactory";
    }

    public ITGT createTGT(IUser user) throws TGTException {
        if (this._lMax > 0L && (long)this._mTGTs.size() >= this._lMax) {
            _oLogger.error((Object)"Could not create TGT, maximum reached");
            throw new TGTException(65);
        }
        return new JGroupsTGT(this, user);
    }

    public JGroupsTGT retrieve(Object id) throws PersistenceException {
        String sId = id.toString();
        JGroupsTGT oJGroupTGT = (JGroupsTGT)this._mTGTs.get((Object)sId);
        if (oJGroupTGT != null) {
            oJGroupTGT.resuscitate(this);
        }
        return oJGroupTGT;
    }

    public void addListener(ITGTListener listener) {
        this._lListeners.add(listener);
    }

    public void removeListener(ITGTListener listener) {
        this._lListeners.remove(listener);
    }

    public List<ITGTListener> getListeners() {
        return Collections.unmodifiableList(this._lListeners);
    }

    public void putAlias(String sType, String sRequestorID, String sTGTID, String sAlias) throws OAException {
        _oLogger.error((Object)"method not supported: deprecated");
        throw new OAException(1);
    }

    public String getAlias(String sType, String sRequestorID, String sTGTID) throws OAException {
        _oLogger.error((Object)"method not supported: deprecated");
        throw new OAException(1);
    }

    public String getTGTID(String sType, String sRequestorID, String sAlias) throws OAException {
        _oLogger.error((Object)"method not supported: deprecated");
        throw new OAException(1);
    }

    public boolean isAlias(String sType, String sRequestorID, String sAlias) throws OAException {
        _oLogger.error((Object)"method not supported: deprecated");
        throw new OAException(1);
    }

    public boolean hasAliasSupport() {
        _oLogger.error((Object)"method not supported: deprecated");
        return this._oSPAliasStore != null;
    }

    public ITGTAliasStore getAliasStoreSP() {
        return this._oSPAliasStore;
    }

    public ITGTAliasStore getAliasStoreIDP() {
        return this._oIDPAliasStore;
    }

    public int size() {
        return this._mTGTs.size();
    }

    public Set<Map.Entry<String, JGroupsTGT>> entrySet() {
        return this._mTGTs.entrySet();
    }

    public int getAliasMapRetries() {
        return this._iAliasMapRetries;
    }

    public long getAliasMapTimeout() {
        return this._lAliasMapTimeout;
    }

    public void setAliasMapFailureLogging(boolean doLog, String label) {
        this._oIDPAliasStore.setFailureLogging(doLog, label);
        this._oSPAliasStore.setFailureLogging(doLog, label);
    }

    public boolean isAliasMapFailureLogging() {
        return this._oIDPAliasStore.isFailureLogging() && this._oSPAliasStore.isFailureLogging();
    }

    private void processEvent(TGTListenerEvent event, ITGT tgt) throws TGTListenerException {
        Vector listErrors = new Vector();
        for (ITGTListener listener : this._lListeners) {
            try {
                listener.processTGTEvent(event, tgt);
            }
            catch (TGTListenerException e) {
                StringBuilder sbDebug = new StringBuilder("Could not process '");
                sbDebug.append(event);
                sbDebug.append("' event for TGT with id '");
                sbDebug.append(tgt.getId());
                sbDebug.append("': ");
                sbDebug.append((Object)e);
                _oLogger.debug((Object)sbDebug.toString(), (Throwable)e);
                listErrors.addAll(e.getErrors());
            }
        }
        if (!listErrors.isEmpty()) {
            throw new TGTListenerException(listErrors);
        }
    }

    private class ConfigParser<T> {
        private ConfigParser() {
        }

        public T parse(String name, Element configElement, T defaultValue) throws OAException {
            Object value = defaultValue;
            Class<?> type = defaultValue.getClass();
            HashSet<Class> supportedTypes = new HashSet<Class>(Arrays.asList(Long.class, Integer.class, Boolean.class));
            if (!supportedTypes.contains(type)) {
                _oLogger.error((Object)("Internal error: type '" + type + "' is not supported"));
                throw new OAException(1);
            }
            String sParameterValue = null;
            try {
                sParameterValue = JGroupsTGTFactory.this._configurationManager.getParam(configElement, name);
            }
            catch (ConfigurationException ex) {
                Logger.getLogger(JGroupsTGTFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Constructor<?> constructor = type.getConstructor(String.class);
                if (sParameterValue != null) {
                    if (defaultValue.getClass() == Boolean.class) {
                        if (!sParameterValue.equalsIgnoreCase("true") && !sParameterValue.equalsIgnoreCase("false")) {
                            throw new IllegalArgumentException("Bad boolean value: '" + sParameterValue + "'");
                        }
                        value = BooleanUtils.toBoolean((String)sParameterValue);
                    } else {
                        value = constructor.newInstance(sParameterValue);
                    }
                }
            }
            catch (NumberFormatException e) {
                _oLogger.error((Object)("Invalid numeric value '" + sParameterValue + "' in config for <" + name + ">, using default: " + defaultValue));
            }
            catch (IllegalArgumentException iae) {
                _oLogger.error((Object)("Invalid boolean value '" + sParameterValue + "' in config for <" + name + ">, using default: " + defaultValue));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                _oLogger.error((Object)("Unexpceted exception '" + e.getClass().getName() + "' while parsing value '" + sParameterValue + "' in config for '" + name + "', using default value"));
            }
            return value;
        }
    }
}

