/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.engine.tgt.jgroups;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asimba.engine.tgt.jgroups.JGroupsTGT;
import org.asimba.engine.tgt.jgroups.JGroupsTGTFactory;
import org.asimba.utility.storage.jgroups.HashMapStore;
import org.asimba.utility.storage.jgroups.RetrieveRepeater;
import org.jgroups.blocks.ReplicatedHashMap;

public class JGroupsTGTAliasStore
implements ITGTAliasStore {
    private static final Log _oLogger = LogFactory.getLog(JGroupsTGTAliasStore.class);
    private final RetrieveRepeater<JGroupsTGT> _oRepeater;
    private static final String INDEX_SEPARATOR = " ";
    private static final int IDX_PREFIX = 0;
    private static final int IDX_TYPE = 1;
    private static final int IDX_ENTITYID = 2;
    private static final int IDX_ALIAS = 3;
    private final String _sPrefix;
    private final ReplicatedHashMap<String, String> _oAliasMap;
    private final JGroupsTGTFactory _oTGTFactory;

    public JGroupsTGTAliasStore(String sPrefix, ReplicatedHashMap<String, String> oAliasMap, JGroupsTGTFactory oTGTFactory) {
        this._sPrefix = sPrefix;
        this._oAliasMap = oAliasMap;
        this._oTGTFactory = oTGTFactory;
        this._oRepeater = new RetrieveRepeater(oTGTFactory.getAliasMapRetries(), oTGTFactory.getAliasMapTimeout());
    }

    private String getPrefixTypeEntitySubKey(String sType, String sEntityID) {
        Object[] aKey = new String[]{this._sPrefix, sType, sEntityID};
        return StringUtils.join((Object[])aKey, (String)INDEX_SEPARATOR);
    }

    private String getMapKey(String sType, String sEntityID, String sAlias) {
        Object[] aKey = new String[]{this.getPrefixTypeEntitySubKey(sType, sEntityID), sAlias};
        return StringUtils.join((Object[])aKey, (String)INDEX_SEPARATOR);
    }

    public void putAlias(String sType, String sEntityID, final String sTGTID, String sAlias) throws OAException {
        if (StringUtils.isEmpty((CharSequence)sType) || StringUtils.isEmpty((CharSequence)sAlias) || StringUtils.isEmpty((CharSequence)sEntityID)) {
            throw new IllegalArgumentException("Type, alias and entityId must be set.");
        }
        String sKey = this.getMapKey(sType, sEntityID, sAlias);
        this._oAliasMap.put((Object)sKey, (Object)sTGTID);
        JGroupsTGT oJGroupsTGT = (JGroupsTGT)this._oRepeater.get((HashMapStore)new HashMapStore<JGroupsTGT>(){

            public JGroupsTGT get() throws OAException {
                return JGroupsTGTAliasStore.this._oTGTFactory.retrieve(sTGTID);
            }
        });
        oJGroupsTGT.registerAlias(sKey);
        this._oTGTFactory.persist(oJGroupsTGT);
    }

    public String getAlias(String sType, String sEntityID, String sTGTID) throws OAException {
        JGroupsTGT oJGroupsTGT = this._oTGTFactory.retrieve(sTGTID);
        if (oJGroupsTGT == null) {
            _oLogger.error((Object)("Integrity check failed: TGT must exist for ID " + sTGTID));
            throw new OAException(1);
        }
        List<String> lAliasList = oJGroupsTGT.getAliases();
        String sKeyPrefix = this.getPrefixTypeEntitySubKey(sType, sEntityID);
        for (String sKey : lAliasList) {
            if (!sKey.startsWith(sKeyPrefix)) continue;
            String[] aKeyElements = sKey.split(INDEX_SEPARATOR);
            return aKeyElements[3];
        }
        return null;
    }

    public String getTGTID(String sType, String sEntityID, String sAlias) throws OAException {
        String sKey = this.getMapKey(sType, sEntityID, sAlias);
        return (String)this._oAliasMap.get((Object)sKey);
    }

    public boolean isAlias(String sType, String sEntityID, String sAlias) throws OAException {
        String sKey = this.getMapKey(sType, sEntityID, sAlias);
        return this._oAliasMap.containsKey((Object)sKey);
    }

    public void removeAlias(String sType, String sEntityID, String sAlias) throws OAException {
        String sKey = this.getMapKey(sType, sEntityID, sAlias);
        String sTGTID = (String)this._oAliasMap.get((Object)sKey);
        this._oAliasMap.remove((Object)sKey);
        JGroupsTGT oTGT = this._oTGTFactory.retrieve(sTGTID);
        List<String> lAliasList = oTGT.getAliases();
        Iterator<String> iterAlias = lAliasList.iterator();
        while (iterAlias.hasNext()) {
            if (!sKey.equals(iterAlias.next())) continue;
            iterAlias.remove();
            break;
        }
    }

    public void removeAll(String sEntityID, String sTGTID) throws OAException {
        JGroupsTGT oTGT = this._oTGTFactory.retrieve(sTGTID);
        List<String> lAliasList = oTGT.getAliases();
        Iterator<String> iterAlias = lAliasList.iterator();
        while (iterAlias.hasNext()) {
            String sKey = iterAlias.next();
            String[] aKeyElements = sKey.split(INDEX_SEPARATOR);
            boolean bEntityIdMatches = aKeyElements[2].equals(sEntityID);
            if (!bEntityIdMatches) continue;
            _oLogger.debug((Object)("Removing alias with key '" + sKey + "'"));
            iterAlias.remove();
            this._oAliasMap.remove((Object)sKey);
        }
    }

    public void setBlockingUpdates(boolean b) {
        this._oAliasMap.setBlockingUpdates(b);
    }

    public void stop() {
        this._oAliasMap.stop();
    }

    public int size() {
        return this._oAliasMap.size();
    }

    public int remove(String sTGTID) {
        JGroupsTGT oTGT;
        try {
            oTGT = this._oTGTFactory.retrieve(sTGTID);
        }
        catch (PersistenceException e) {
            _oLogger.error((Object)("Could not establish TGT for id " + sTGTID + ": " + e.getMessage()));
            return 0;
        }
        List<String> lAliasList = oTGT.getAliases();
        int iDeletedAliasesCount = 0;
        Iterator<String> iterAlias = lAliasList.iterator();
        while (iterAlias.hasNext()) {
            String sKey = iterAlias.next();
            String[] aKeyElements = sKey.split(INDEX_SEPARATOR);
            boolean bPrefixMatches = aKeyElements[0].equals(this._sPrefix);
            if (!bPrefixMatches) continue;
            _oLogger.debug((Object)("Removing alias with key '" + sKey + "'"));
            iterAlias.remove();
            this._oAliasMap.remove((Object)sKey);
            ++iDeletedAliasesCount;
        }
        return iDeletedAliasesCount;
    }

    public long[] getRepetitions() {
        return this._oRepeater.getRepetitions();
    }

    public void setFailureLogging(boolean doLog, String label) {
        this._oRepeater.setFailureLogging(doLog, label);
    }

    public boolean isFailureLogging() {
        return this._oRepeater.isFailureLogging();
    }
}

