/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.tgt.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.datastorage.IDataStorageFactory;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.api.tgt.TGTListenerEvent;
import com.alfaariss.oa.api.tgt.TGTListenerException;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.attribute.TGTAttributes;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import com.alfaariss.oa.engine.core.tgt.TGTException;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.engine.tgt.jdbc.JDBCTGT;
import com.alfaariss.oa.engine.tgt.jdbc.JDBCTGTAliasStore;
import com.alfaariss.oa.util.ModifiedBase64;
import com.alfaariss.oa.util.Serialize;
import com.alfaariss.oa.util.database.DatabaseException;
import com.alfaariss.oa.util.database.jdbc.DataSourceFactory;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.storage.factory.AbstractStorageFactory;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JDBCTGTFactory
extends AbstractStorageFactory
implements ITGTFactory<JDBCTGT> {
    private static final String TABLE_NAME = "tgt";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_EXPIRATION = "expiration";
    private static final String COLUMN_USER = "tgtuser";
    private static final String COLUMN_AUTHN_PROFILE = "authn_profile";
    private static final String COLUMN_AUTHN_PROFILES = "authn_profile_ids";
    private static final String COLUMN_REQUESTOR_IDS = "requestor_ids";
    private static final String COLUMN_ATTRIBUTES = "attributes";
    private String _sTableName;
    private String _sColumnID;
    private String _sColumnEXPIRATION;
    private String _sColumnUSER;
    private String _sColumnAUTHN_PROFILE;
    private String _sColumnAUTHN_PROFILES;
    private String _sColumnREQUESTOR_IDS;
    private String _sColumnATTRIBUTES;
    private String _sSearchQuery = null;
    private String _sCountQuery = null;
    private String _sInsertQuery = null;
    private String _sUpdateQuery = null;
    private String _sRemoveQuery = null;
    private String _sRemoveExpiredQuery = null;
    private String _sSelectExpiredQuery = null;
    private List<ITGTListener> _lListeners;
    private DataSource _oDataSource;
    private Log _logger = LogFactory.getLog(JDBCTGTFactory.class);
    private Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    private JDBCTGTAliasStore _aliasStoreSP;
    private JDBCTGTAliasStore _aliasStoreIDP;

    public JDBCTGTFactory() {
        this._lListeners = new Vector<ITGTListener>();
    }

    public void start() throws OAException {
        Element eResource = this._configurationManager.getSection(this._eConfig, "resource");
        if (eResource != null) {
            this._oDataSource = DataSourceFactory.createDataSource((IConfigurationManager)this._configurationManager, (Element)eResource);
            this._logger.info((Object)"Using datasource specified in 'resource' section in configuration");
        } else {
            IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
            if (databaseFactory != null && databaseFactory.isEnabled()) {
                this._oDataSource = databaseFactory.createSystemDatasource();
                if (this._oDataSource == null) {
                    this._logger.error((Object)"Could not create a valid datasource");
                    throw new DatabaseException(2);
                }
                this._logger.info((Object)"Using datasource specified in engine");
            } else {
                this._logger.error((Object)"Could not create a valid datasource");
                throw new DatabaseException(2);
            }
        }
        this.createQueries(this._eConfig);
        this.verifyTableConfig(this._eConfig);
        Element eAliasStoreSP = this._configurationManager.getSection(this._eConfig, "alias_store", "id=sp");
        if (eAliasStoreSP == null) {
            this._logger.info((Object)"No optional 'alias_store' section with id='sp' found in configuration, disabling alias storage support for Requestors");
            this._aliasStoreSP = null;
        } else {
            this._aliasStoreSP = new JDBCTGTAliasStore(this._configurationManager, eAliasStoreSP, this._oDataSource, this._sTableName, this._sColumnID);
        }
        Element eAliasStoreIDP = this._configurationManager.getSection(this._eConfig, "alias_store", "id=idp");
        if (eAliasStoreIDP == null) {
            this._logger.info((Object)"No optional 'alias_store' section with id='idp' found in configuration, disabling alias storage support for IdP's");
            this._aliasStoreIDP = null;
        } else {
            this._aliasStoreIDP = new JDBCTGTAliasStore(this._configurationManager, eAliasStoreIDP, this._oDataSource, this._sTableName, this._sColumnID);
        }
        if (this._tCleaner != null) {
            this._tCleaner.start();
        }
    }

    public ITGT createTGT(IUser user) throws TGTException {
        if (this._lMax > 0L && (long)this.getTGTCount() >= this._lMax) {
            this._logger.error((Object)"Could not create TGT, maximum reached");
            throw new TGTException(65);
        }
        return new JDBCTGT(this, user);
    }

    public boolean exists(Object id) throws PersistenceException {
        if (id == null || !(id instanceof String)) {
            throw new IllegalArgumentException("Suplied id is empty or invalid");
        }
        boolean bRet = false;
        Connection oConnection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            oConnection = this._oDataSource.getConnection();
            ps = oConnection.prepareStatement(this._sSearchQuery);
            ps.setString(1, (String)id);
            rs = ps.executeQuery();
            if (rs.next()) {
                bRet = true;
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute search query: " + this._sSearchQuery), (Throwable)e);
            throw new PersistenceException(35);
        }
        catch (Exception e) {
            this._logger.error((Object)("Internal error during exists check for tgt with id: " + id), (Throwable)e);
            throw new PersistenceException(35);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return bRet;
    }

    public JDBCTGT retrieve(Object id) throws PersistenceException {
        if (id == null || !(id instanceof String)) {
            throw new IllegalArgumentException("Suplied id is empty or invalid");
        }
        JDBCTGT tgt = null;
        Connection oConnection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            oConnection = this._oDataSource.getConnection();
            ps = oConnection.prepareStatement(this._sSearchQuery);
            ps.setString(1, (String)id);
            rs = ps.executeQuery();
            if (rs.next()) {
                byte[] baUser = rs.getBytes(this._sColumnUSER);
                tgt = new JDBCTGT(this, (IUser)Serialize.decode((byte[])baUser));
                tgt.setId((String)id);
                tgt.setTgtExpTime(rs.getTimestamp(this._sColumnEXPIRATION).getTime());
                tgt.setAuthenticationProfile((IAuthenticationProfile)((AuthenticationProfile)Serialize.decode((byte[])rs.getBytes(this._sColumnAUTHN_PROFILE))));
                tgt.setAuthNProfileIDs((List)Serialize.decode((byte[])rs.getBytes(this._sColumnAUTHN_PROFILES)));
                tgt.setRequestorIDs((List)Serialize.decode((byte[])rs.getBytes(this._sColumnREQUESTOR_IDS)));
                TGTAttributes oAttributes = (TGTAttributes)Serialize.decode((byte[])rs.getBytes(this._sColumnATTRIBUTES));
                if (oAttributes != null) {
                    tgt.setAttributes(oAttributes);
                }
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute search query", (Throwable)e);
            throw new PersistenceException(35);
        }
        catch (ClassCastException e) {
            this._logger.error((Object)"Could not decode, invalid class type", (Throwable)e);
            throw new PersistenceException(35);
        }
        catch (Exception e) {
            this._logger.error((Object)("Internal error during retrieval of tgt with id: " + id), (Throwable)e);
            throw new PersistenceException(35);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return tgt;
    }

    public TGTListenerEvent persistPassingListenerEvent(JDBCTGT tgt) throws PersistenceException {
        TGTListenerEvent passedEvent = this.performPersist(tgt, false);
        StringBuffer sbDebug = new StringBuffer("Passed '");
        sbDebug.append(passedEvent);
        sbDebug.append("' event for TGT with id: ");
        sbDebug.append(tgt.getId());
        this._logger.debug((Object)sbDebug.toString());
        return passedEvent;
    }

    public void clean(JDBCTGT tgt) throws PersistenceException {
        if (tgt == null) {
            throw new IllegalArgumentException("Suplied tgt is empty or invalid");
        }
        Connection oConnection = null;
        Statement ps = null;
        List listTGTEventErrors = null;
        String id = tgt.getId();
        try {
            oConnection = this._oDataSource.getConnection();
            this._logger.debug((Object)("Clean TGT: " + id));
            IUser tgtUser = tgt.getUser();
            this._eventLogger.info((Object)new UserEventLogItem(null, tgt.getId(), null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, "clean"));
            try {
                this.processEvent(TGTListenerEvent.ON_EXPIRE, (ITGT)tgt);
            }
            catch (TGTListenerException e) {
                listTGTEventErrors = e.getErrors();
            }
            try {
                ps = oConnection.prepareStatement(this._sRemoveQuery);
                ps.setString(1, id);
                int i = ps.executeUpdate();
                this._logger.debug((Object)(i + " TGT cleaned: " + id));
            }
            catch (SQLException e) {
                this._logger.error((Object)("Could not execute delete query: " + this._sRemoveQuery), (Throwable)e);
                throw new PersistenceException(37);
            }
            int iCountR = 0;
            if (this._aliasStoreSP != null) {
                iCountR = this._aliasStoreSP.remove(oConnection, id);
            }
            int iCountF = 0;
            if (this._aliasStoreIDP != null) {
                iCountF = this._aliasStoreIDP.remove(oConnection, id);
            }
            if (this._logger.isDebugEnabled() && iCountR + iCountF > 0) {
                StringBuffer sbDebug = new StringBuffer("Cleaned '");
                sbDebug.append(iCountR);
                sbDebug.append("' (requestor based) aliasses and '");
                sbDebug.append(iCountF);
                sbDebug.append("' (remote enitity based) aliasses");
                this._logger.debug((Object)sbDebug.toString());
            }
            if (listTGTEventErrors != null) {
                throw new TGTListenerException(listTGTEventErrors);
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)("Internal error during cleaning of tgt with id: " + id), (Throwable)e);
            throw new PersistenceException(37);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public void persist(JDBCTGT tgt) throws PersistenceException {
        TGTListenerEvent performedEvent = this.performPersist(tgt, true);
        StringBuffer sbDebug = new StringBuffer("Performed '");
        sbDebug.append(performedEvent);
        sbDebug.append("' event for TGT with id: ");
        sbDebug.append(tgt.getId());
        this._logger.debug((Object)sbDebug.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void persist(JDBCTGT[] tgts) throws PersistenceException {
        if (tgts == null) {
            throw new IllegalArgumentException("Suplied tgt array is empty or invalid");
        }
        Vector listTGTEventErrors = new Vector();
        Connection connection = null;
        Statement psInsert = null;
        Statement psDelete = null;
        Statement psDeleteAliasR = null;
        PreparedStatement psDeleteAliasF = null;
        Statement psUpdate = null;
        try {
            int iTotalAliasDeleted;
            int i$;
            void var14_45;
            connection = this._oDataSource.getConnection();
            connection.setAutoCommit(false);
            if (this._aliasStoreSP != null) {
                psDeleteAliasR = connection.prepareStatement(this._aliasStoreSP.getQueryAliasRemove());
            }
            if (this._aliasStoreIDP != null) {
                psDeleteAliasF = connection.prepareStatement(this._aliasStoreIDP.getQueryAliasRemove());
            }
            psInsert = connection.prepareStatement(this._sInsertQuery);
            psDelete = connection.prepareStatement(this._sRemoveQuery);
            psUpdate = connection.prepareStatement(this._sUpdateQuery);
            Vector<JDBCTGT> vCreate = new Vector<JDBCTGT>();
            Vector<JDBCTGT> vUpdate = new Vector<JDBCTGT>();
            Vector<JDBCTGT> vRemove = new Vector<JDBCTGT>();
            JDBCTGT[] arr$ = tgts;
            int n = arr$.length;
            boolean bl = false;
            while (var14_45 < n) {
                JDBCTGT tgt = arr$[var14_45];
                String id = tgt.getId();
                if (id == null) {
                    byte[] baId = new byte[128];
                    do {
                        this._random.nextBytes(baId);
                        try {
                            id = ModifiedBase64.encode((byte[])baId);
                        }
                        catch (UnsupportedEncodingException e) {
                            this._logger.error((Object)("Could not create tgt id for byte[]: " + baId), (Throwable)e);
                            throw new PersistenceException(1);
                        }
                    } while (this.exists(id));
                    tgt.setId(id);
                    long expiration = System.currentTimeMillis() + this._lExpiration;
                    tgt.setTgtExpTime(expiration);
                    psInsert.setString(1, id);
                    psInsert.setTimestamp(2, new Timestamp(expiration));
                    psInsert.setBytes(3, Serialize.encode((Object)tgt.getUser()));
                    psInsert.setBytes(4, Serialize.encode((Object)tgt.getAuthenticationProfile()));
                    psInsert.setBytes(5, Serialize.encode(tgt.getModifiableAuthNProfileIDs()));
                    psInsert.setBytes(6, Serialize.encode(tgt.getModifiableRequestorIDs()));
                    psInsert.setBytes(7, Serialize.encode((Object)tgt.getAttributes()));
                    psInsert.addBatch();
                    vCreate.add(tgt);
                } else if (tgt.isExpired()) {
                    this._logger.debug((Object)("TGT Expired: " + id));
                    if (psDeleteAliasR != null) {
                        psDeleteAliasR.setString(1, id);
                        psDeleteAliasR.addBatch();
                    }
                    if (psDeleteAliasF != null) {
                        psDeleteAliasF.setString(1, id);
                        psDeleteAliasF.addBatch();
                    }
                    vRemove.add(tgt);
                } else {
                    long expiration = System.currentTimeMillis() + this._lExpiration;
                    tgt.setTgtExpTime(expiration);
                    psUpdate.setTimestamp(1, new Timestamp(expiration));
                    psUpdate.setBytes(2, Serialize.encode((Object)tgt.getUser()));
                    psUpdate.setBytes(3, Serialize.encode((Object)tgt.getAuthenticationProfile()));
                    psUpdate.setBytes(4, Serialize.encode(tgt.getModifiableAuthNProfileIDs()));
                    psUpdate.setBytes(5, Serialize.encode(tgt.getModifiableRequestorIDs()));
                    psUpdate.setBytes(6, Serialize.encode((Object)tgt.getAttributes()));
                    psUpdate.setString(7, id);
                    psUpdate.addBatch();
                    vUpdate.add(tgt);
                }
                ++var14_45;
            }
            try {
                int iTotalAdded = 0;
                for (int i : psInsert.executeBatch()) {
                    iTotalAdded += i;
                }
                this._logger.debug((Object)(iTotalAdded + " new TGT(s) added by batch"));
                for (ITGT iTGT : vCreate) {
                    try {
                        this.processEvent(TGTListenerEvent.ON_CREATE, iTGT);
                    }
                    catch (TGTListenerException e) {
                        listTGTEventErrors.addAll(e.getErrors());
                    }
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not execute insert batch", (Throwable)e);
                throw new PersistenceException(34);
            }
            try {
                for (ITGT iTGT : vRemove) {
                    IUser iUser = iTGT.getUser();
                    this._eventLogger.info((Object)new UserEventLogItem(null, iTGT.getId(), null, UserEvent.TGT_EXPIRED, iUser.getID(), iUser.getOrganization(), null, null, (IAuthority)this, null));
                    try {
                        this.processEvent(TGTListenerEvent.ON_REMOVE, iTGT);
                    }
                    catch (TGTListenerException e) {
                        listTGTEventErrors.addAll(e.getErrors());
                    }
                }
                int iTotalDeleted = 0;
                int[] nArray = psDelete.executeBatch();
                int n2 = nArray.length;
                for (i$ = 0; i$ < n2; ++i$) {
                    int i = nArray[i$];
                    iTotalDeleted += i;
                }
                this._logger.debug((Object)(iTotalDeleted + " TGT(s) deleted by batch"));
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not execute delete batch", (Throwable)e);
                throw new PersistenceException(37);
            }
            if (psDeleteAliasR != null) {
                try {
                    iTotalAliasDeleted = 0;
                    int[] nArray = psDeleteAliasR.executeBatch();
                    int n3 = nArray.length;
                    for (i$ = 0; i$ < n3; ++i$) {
                        int i = nArray[i$];
                        iTotalAliasDeleted += i;
                    }
                    this._logger.debug((Object)(iTotalAliasDeleted + " (requestor based) alias(es) deleted by batch"));
                }
                catch (SQLException e) {
                    this._logger.error((Object)"Could not execute delete (requestor based) alias batch", (Throwable)e);
                    throw new PersistenceException(37);
                }
            }
            if (psDeleteAliasF != null) {
                try {
                    iTotalAliasDeleted = 0;
                    int[] nArray = psDeleteAliasF.executeBatch();
                    int n4 = nArray.length;
                    for (i$ = 0; i$ < n4; ++i$) {
                        int i = nArray[i$];
                        iTotalAliasDeleted += i;
                    }
                    this._logger.debug((Object)(iTotalAliasDeleted + " (remote enitity based) alias(es) deleted by batch"));
                }
                catch (SQLException e) {
                    this._logger.error((Object)"Could not execute delete (remote enitity based) alias batch", (Throwable)e);
                    throw new PersistenceException(37);
                }
            }
            try {
                int iTotalUpdated = 0;
                for (int i : psUpdate.executeBatch()) {
                    iTotalUpdated += i;
                }
                this._logger.debug((Object)(iTotalUpdated + " TGT(s) updated by batch"));
                for (ITGT iTGT : vUpdate) {
                    try {
                        this.processEvent(TGTListenerEvent.ON_UPDATE, iTGT);
                    }
                    catch (TGTListenerException e) {
                        listTGTEventErrors.addAll(e.getErrors());
                    }
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not execute update batch", (Throwable)e);
                throw new PersistenceException(36);
            }
            connection.commit();
            if (listTGTEventErrors != null) {
                throw new TGTListenerException(listTGTEventErrors);
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute Batch", (Throwable)e);
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                this._logger.warn((Object)"Could not rollback batch", (Throwable)e);
            }
            throw new PersistenceException(1);
        }
        catch (PersistenceException e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                this._logger.warn((Object)"Could not rollback batch", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Could not connect to JDBC resource", (Throwable)e);
            throw new PersistenceException(33);
        }
        finally {
            try {
                if (psInsert != null) {
                    psInsert.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close insert statement", (Throwable)e);
            }
            try {
                if (psDelete != null) {
                    psDelete.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close delete statement", (Throwable)e);
            }
            try {
                if (psDeleteAliasR != null) {
                    psDeleteAliasR.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close delete (requestor based) alias statement", (Throwable)e);
            }
            try {
                if (psDeleteAliasF != null) {
                    psDeleteAliasF.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close delete (remote entity based) alias statement", (Throwable)e);
            }
            try {
                if (psUpdate != null) {
                    psUpdate.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close update statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public void removeExpired() throws PersistenceException {
        Connection oConnection = null;
        PreparedStatement psSelect = null;
        Statement psDelete = null;
        ResultSet rsSelect = null;
        try {
            oConnection = this._oDataSource.getConnection();
            psSelect = oConnection.prepareStatement(this._sSelectExpiredQuery);
            psSelect.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            rsSelect = psSelect.executeQuery();
            while (rsSelect.next()) {
                String sId = rsSelect.getString(this._sColumnID);
                if (sId == null) continue;
                try {
                    JDBCTGT tgt = this.retrieve(sId);
                    if (tgt != null) {
                        String sTGTUserID = null;
                        String sTGTUserOrganization = null;
                        IUser tgtUser = tgt.getUser();
                        if (tgtUser != null) {
                            sTGTUserID = tgtUser.getID();
                            sTGTUserOrganization = tgtUser.getOrganization();
                        } else {
                            this._logger.debug((Object)("No user available for TGT with ID: " + sId));
                        }
                        this._eventLogger.info((Object)new UserEventLogItem(null, sId, null, UserEvent.TGT_EXPIRED, sTGTUserID, sTGTUserOrganization, null, null, (IAuthority)this, "clean"));
                        this.processEvent(TGTListenerEvent.ON_EXPIRE, (ITGT)tgt);
                        continue;
                    }
                    this._logger.debug((Object)("No TGT available with ID: " + sId));
                }
                catch (PersistenceException e) {
                    this._logger.debug((Object)("Invalid TGT will be removed: " + sId), (Throwable)e);
                }
            }
            psDelete = oConnection.prepareStatement(this._sRemoveExpiredQuery);
            psDelete.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            int i = psDelete.executeUpdate();
            if (i > 0) {
                this._logger.debug((Object)(i + " TGT(s) expired"));
            }
            int iCountR = 0;
            if (this._aliasStoreSP != null) {
                iCountR = this._aliasStoreSP.clean(oConnection);
            }
            int iCountF = 0;
            if (this._aliasStoreIDP != null) {
                iCountF = this._aliasStoreIDP.clean(oConnection);
            }
            if (this._logger.isDebugEnabled() && iCountR + iCountF > 0) {
                StringBuffer sbDebug = new StringBuffer("Cleaned '");
                sbDebug.append(iCountR);
                sbDebug.append("' (requestor based) aliasses and '");
                sbDebug.append(iCountF);
                sbDebug.append("' (remote enitity based) aliasses");
                this._logger.debug((Object)sbDebug.toString());
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute delete expired", (Throwable)e);
            throw new PersistenceException(37);
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during removal of expired tgt", (Throwable)e);
            throw new PersistenceException(37);
        }
        finally {
            try {
                if (rsSelect != null) {
                    rsSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close select statement", (Throwable)e);
            }
            try {
                if (psDelete != null) {
                    psDelete.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close delete statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public long poll() throws OAException {
        return this.getTGTCount();
    }

    public void addListener(ITGTListener listener) {
        this._lListeners.add(listener);
    }

    public void removeListener(ITGTListener listener) {
        this._lListeners.remove(listener);
    }

    public List<ITGTListener> getListeners() {
        return Collections.unmodifiableList(this._lListeners);
    }

    public void putAlias(String type, String requestorID, String tgtID, String alias) throws OAException {
        if (this._aliasStoreSP == null) {
            this._logger.debug((Object)"SP role alias store not available");
            throw new OAException(1);
        }
        this._aliasStoreSP.putAlias(type, requestorID, tgtID, alias);
    }

    public String getAlias(String type, String requestorID, String tgtID) throws OAException {
        if (this._aliasStoreSP == null) {
            this._logger.debug((Object)"SP role alias store not available");
            throw new OAException(1);
        }
        return this._aliasStoreSP.getAlias(type, requestorID, tgtID);
    }

    public String getTGTID(String type, String requestorID, String alias) throws OAException {
        if (this._aliasStoreSP == null) {
            this._logger.debug((Object)"SP role alias store not available");
            throw new OAException(1);
        }
        return this._aliasStoreSP.getTGTID(type, requestorID, alias);
    }

    public boolean isAlias(String type, String requestorID, String alias) throws OAException {
        if (this._aliasStoreSP == null) {
            this._logger.debug((Object)"SP role alias store not available");
            throw new OAException(1);
        }
        return this._aliasStoreSP.isAlias(type, requestorID, alias);
    }

    public boolean hasAliasSupport() {
        return this._aliasStoreSP != null;
    }

    public String getAuthority() {
        return "TGTFactory";
    }

    public ITGTAliasStore getAliasStoreIDP() {
        return this._aliasStoreIDP;
    }

    public ITGTAliasStore getAliasStoreSP() {
        return this._aliasStoreSP;
    }

    private void createQueries(Element eConfig) throws TGTException, ConfigurationException {
        Element eEntity = this._configurationManager.getSection(eConfig, "entity");
        if (eEntity == null) {
            this._logger.info((Object)"No optional 'entity' section found in configuration, using default table and column names");
        } else {
            this._sTableName = this._configurationManager.getParam(eEntity, "table");
            this._sColumnID = this.getIdColumnName(eEntity);
            this._sColumnEXPIRATION = this.getColumnName(eEntity, "tgtExpTime");
            this._sColumnUSER = this.getColumnName(eEntity, "user");
            this._sColumnAUTHN_PROFILE = this.getColumnName(eEntity, "authenticationProfile");
            this._sColumnAUTHN_PROFILES = this.getColumnName(eEntity, "authenticationProfileIDs");
            this._sColumnREQUESTOR_IDS = this.getColumnName(eEntity, "requestorIDs");
            this._sColumnATTRIBUTES = this.getColumnName(eEntity, COLUMN_ATTRIBUTES);
        }
        if (this._sTableName == null) {
            this._sTableName = TABLE_NAME;
        }
        if (this._sColumnID == null) {
            this._sColumnID = COLUMN_ID;
        }
        if (this._sColumnEXPIRATION == null) {
            this._sColumnEXPIRATION = COLUMN_EXPIRATION;
        }
        if (this._sColumnUSER == null) {
            this._sColumnUSER = COLUMN_USER;
        }
        if (this._sColumnAUTHN_PROFILE == null) {
            this._sColumnAUTHN_PROFILE = COLUMN_AUTHN_PROFILE;
        }
        if (this._sColumnAUTHN_PROFILES == null) {
            this._sColumnAUTHN_PROFILES = COLUMN_AUTHN_PROFILES;
        }
        if (this._sColumnREQUESTOR_IDS == null) {
            this._sColumnREQUESTOR_IDS = COLUMN_REQUESTOR_IDS;
        }
        if (this._sColumnATTRIBUTES == null) {
            this._sColumnATTRIBUTES = COLUMN_ATTRIBUTES;
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append(this._sColumnEXPIRATION).append(", ");
        sb.append(this._sColumnUSER).append(", ");
        sb.append(this._sColumnAUTHN_PROFILE).append(", ");
        sb.append(this._sColumnAUTHN_PROFILES).append(", ");
        sb.append(this._sColumnREQUESTOR_IDS).append(", ");
        sb.append(this._sColumnATTRIBUTES);
        sb.append(" FROM ").append(this._sTableName);
        sb.append(" WHERE ").append(this._sColumnID).append("=?");
        this._sSearchQuery = sb.toString();
        this._logger.debug((Object)("Using SearchQuery: " + this._sSearchQuery));
        sb = new StringBuffer("SELECT COUNT(");
        sb.append(this._sColumnID);
        sb.append(") FROM ");
        sb.append(this._sTableName);
        this._sCountQuery = sb.toString();
        this._logger.debug((Object)("Using CountQuery: " + this._sCountQuery));
        sb = new StringBuffer("INSERT INTO ");
        sb.append(this._sTableName).append("(");
        sb.append(this._sColumnID).append(", ");
        sb.append(this._sColumnEXPIRATION).append(", ");
        sb.append(this._sColumnUSER).append(", ");
        sb.append(this._sColumnAUTHN_PROFILE).append(", ");
        sb.append(this._sColumnAUTHN_PROFILES).append(", ");
        sb.append(this._sColumnREQUESTOR_IDS).append(",");
        sb.append(this._sColumnATTRIBUTES);
        sb.append(") VALUES(? , ?, ?, ?, ?, ?, ?)");
        this._sInsertQuery = sb.toString();
        this._logger.debug((Object)("Using InsertQuery: " + this._sInsertQuery));
        sb = new StringBuffer("UPDATE ");
        sb.append(this._sTableName).append(" SET ");
        sb.append(this._sColumnEXPIRATION).append("=?, ");
        sb.append(this._sColumnUSER).append("=?, ");
        sb.append(this._sColumnAUTHN_PROFILE).append("=?, ");
        sb.append(this._sColumnAUTHN_PROFILES).append("=?, ");
        sb.append(this._sColumnREQUESTOR_IDS).append("=?, ");
        sb.append(this._sColumnATTRIBUTES).append("=? WHERE  ");
        sb.append(this._sColumnID).append("=?");
        this._sUpdateQuery = sb.toString();
        this._logger.debug((Object)("Using UpdateQuery: " + this._sUpdateQuery));
        sb = new StringBuffer("DELETE FROM ");
        sb.append(this._sTableName).append(" WHERE ");
        sb.append(this._sColumnID).append("=?");
        this._sRemoveQuery = sb.toString();
        this._logger.debug((Object)("Using RemoveQuery: " + this._sRemoveQuery));
        sb = new StringBuffer("DELETE FROM ");
        sb.append(this._sTableName).append(" WHERE ");
        sb.append(this._sColumnEXPIRATION).append("<=?");
        this._sRemoveExpiredQuery = sb.toString();
        this._logger.debug((Object)("Using RemoveExpiredQuery: " + this._sRemoveExpiredQuery));
        sb = new StringBuffer("SELECT ");
        sb.append(this._sColumnID);
        sb.append(" FROM ");
        sb.append(this._sTableName).append(" WHERE ");
        sb.append(this._sColumnEXPIRATION).append("<=?");
        this._sSelectExpiredQuery = sb.toString();
        this._logger.debug((Object)("Using SelectExpiredQuery: " + this._sSelectExpiredQuery));
    }

    private void verifyTableConfig(Element eConfig) throws OAException {
        Connection oConnection = null;
        Statement pVerify = null;
        try {
            String sVerificationQuery;
            block29: {
                try {
                    oConnection = this._oDataSource.getConnection();
                }
                catch (SQLException e) {
                    this._logger.error((Object)"Could not connect to resource", (Throwable)e);
                    throw new DatabaseException(2);
                }
                sVerificationQuery = null;
                try {
                    Element eValidation = this._configurationManager.getSection(eConfig, "validation");
                    if (eValidation == null || (sVerificationQuery = this._configurationManager.getParam(eValidation, "query")) != null && sVerificationQuery.length() != 0) break block29;
                    this._logger.warn((Object)"Empty validation query found, table structure is not validated");
                    return;
                }
                catch (ConfigurationException e) {
                    this._logger.error((Object)"Invalid validation query found", (Throwable)e);
                    throw new DatabaseException(17);
                }
            }
            if (sVerificationQuery == null) {
                StringBuffer sbVerificationQuery = new StringBuffer("SELECT ");
                sbVerificationQuery.append(this._sColumnID).append(",");
                sbVerificationQuery.append(this._sColumnEXPIRATION).append(",");
                sbVerificationQuery.append(this._sColumnUSER).append(",");
                sbVerificationQuery.append(this._sColumnAUTHN_PROFILE).append(",");
                sbVerificationQuery.append(this._sColumnAUTHN_PROFILES).append(",");
                sbVerificationQuery.append(this._sColumnREQUESTOR_IDS).append(",");
                sbVerificationQuery.append(this._sColumnATTRIBUTES);
                sbVerificationQuery.append(" FROM ");
                sbVerificationQuery.append(this._sTableName);
                sbVerificationQuery.append(" LIMIT 1");
                sVerificationQuery = sbVerificationQuery.toString();
                this._logger.info((Object)("No validation query found, using default: " + sVerificationQuery));
            }
            this._logger.debug((Object)("Running validation query " + sVerificationQuery));
            pVerify = oConnection.prepareStatement(sVerificationQuery);
            try {
                pVerify.executeQuery();
            }
            catch (Exception e) {
                StringBuffer sbError = new StringBuffer("Invalid table configured '");
                sbError.append(this._sTableName);
                sbError.append("' verified with query: ");
                sbError.append(sVerificationQuery);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new DatabaseException(2);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during verification of configured table", (Throwable)e);
            throw new OAException(2);
        }
        finally {
            try {
                if (pVerify != null) {
                    pVerify.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    private String getIdColumnName(Element eConfig) throws TGTException, ConfigurationException {
        String sIdColumn = null;
        if (eConfig != null) {
            Element eIdColumn = this._configurationManager.getSection(eConfig, COLUMN_ID);
            if (eIdColumn == null) {
                this._logger.error((Object)"Could not find 'id' section");
                throw new TGTException(17);
            }
            sIdColumn = this._configurationManager.getParam(eIdColumn, "column");
            if (sIdColumn == null) {
                this._logger.error((Object)"Could not find column name for id");
                throw new TGTException(17);
            }
        }
        return sIdColumn;
    }

    private String getColumnName(Element eConfig, String sName) throws TGTException, ConfigurationException {
        String sColumn = null;
        if (eConfig != null || sName != null) {
            Element eColumn = this._configurationManager.getSection(eConfig, "property", "name=" + sName);
            if (eColumn == null) {
                this._logger.warn((Object)("No optional 'property' section found for property with name: " + sName));
            } else {
                sColumn = this._configurationManager.getParam(eColumn, "column");
                if (sColumn == null) {
                    this._logger.error((Object)("Could not find column name for property " + sName));
                    throw new TGTException(17);
                }
            }
        }
        return sColumn;
    }

    private int getTGTCount() throws TGTException {
        Connection oConnection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int iRet = 0;
        try {
            oConnection = this._oDataSource.getConnection();
            ps = oConnection.prepareStatement(this._sCountQuery);
            rs = ps.executeQuery();
            if (rs.next()) {
                iRet = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute count query", (Throwable)e);
            throw new TGTException(35);
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during TGT counting", (Throwable)e);
            throw new TGTException(35);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return iRet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TGTListenerEvent performPersist(JDBCTGT tgt, boolean bProcessEvent) throws PersistenceException {
        Statement ps;
        Connection oConnection;
        List listTGTEventErrors;
        TGTListenerEvent listenerEvent;
        block41: {
            byte[] baId;
            String id;
            block40: {
                if (tgt == null) {
                    throw new IllegalArgumentException("Suplied tgt is empty or invalid");
                }
                listenerEvent = null;
                listTGTEventErrors = null;
                oConnection = null;
                ps = null;
                id = tgt.getId();
                try {
                    oConnection = this._oDataSource.getConnection();
                    if (id == null) {
                        baId = new byte[128];
                        break block40;
                    }
                    if (tgt.isExpired()) {
                        this._logger.debug((Object)("TGT Expired: " + id));
                        IUser tgtUser = tgt.getUser();
                        this._eventLogger.info((Object)new UserEventLogItem(null, tgt.getId(), null, UserEvent.TGT_EXPIRED, tgtUser.getID(), tgtUser.getOrganization(), null, null, (IAuthority)this, null));
                        listenerEvent = TGTListenerEvent.ON_REMOVE;
                        if (bProcessEvent) {
                            try {
                                this.processEvent(listenerEvent, (ITGT)tgt);
                            }
                            catch (TGTListenerException e) {
                                listTGTEventErrors = e.getErrors();
                            }
                        }
                        try {
                            ps = oConnection.prepareStatement(this._sRemoveQuery);
                            ps.setString(1, id);
                            int i = ps.executeUpdate();
                            this._logger.debug((Object)(i + " TGT removed: " + id));
                        }
                        catch (SQLException e) {
                            this._logger.error((Object)("Could not execute delete query: " + this._sRemoveQuery), (Throwable)e);
                            throw new PersistenceException(37);
                        }
                        int iCountR = 0;
                        if (this._aliasStoreSP != null) {
                            iCountR = this._aliasStoreSP.remove(oConnection, id);
                        }
                        int iCountF = 0;
                        if (this._aliasStoreIDP != null) {
                            iCountF = this._aliasStoreIDP.remove(oConnection, id);
                        }
                        if (this._logger.isDebugEnabled() && iCountR + iCountF > 0) {
                            StringBuffer sbDebug = new StringBuffer("Removed '");
                            sbDebug.append(iCountR);
                            sbDebug.append("' (requestor based) aliasses and '");
                            sbDebug.append(iCountF);
                            sbDebug.append("' (remote enitity based) aliasses");
                            this._logger.debug((Object)sbDebug.toString());
                        }
                        break block41;
                    }
                    try {
                        long expiration = System.currentTimeMillis() + this._lExpiration;
                        tgt.setTgtExpTime(expiration);
                        ps = oConnection.prepareStatement(this._sUpdateQuery);
                        ps.setTimestamp(1, new Timestamp(expiration));
                        ps.setBytes(2, Serialize.encode((Object)tgt.getUser()));
                        ps.setBytes(3, Serialize.encode((Object)tgt.getAuthenticationProfile()));
                        ps.setBytes(4, Serialize.encode(tgt.getModifiableAuthNProfileIDs()));
                        ps.setBytes(5, Serialize.encode(tgt.getModifiableRequestorIDs()));
                        ps.setBytes(6, Serialize.encode((Object)tgt.getAttributes()));
                        ps.setString(7, id);
                        int i = ps.executeUpdate();
                        this._logger.debug((Object)(i + " TGT updated:" + id));
                        listenerEvent = TGTListenerEvent.ON_UPDATE;
                        if (bProcessEvent) {
                            try {
                                this.processEvent(listenerEvent, (ITGT)tgt);
                            }
                            catch (TGTListenerException e) {
                                listTGTEventErrors = e.getErrors();
                            }
                        }
                        break block41;
                    }
                    catch (SQLException e) {
                        this._logger.error((Object)("Could not execute update query: " + this._sUpdateQuery), (Throwable)e);
                        throw new PersistenceException(36);
                    }
                }
                catch (PersistenceException e) {
                    throw e;
                }
                catch (Exception e) {
                    this._logger.error((Object)("Internal error during persist of tgt with id: " + id), (Throwable)e);
                    throw new PersistenceException(36);
                }
            }
            do {
                this._random.nextBytes(baId);
                try {
                    id = ModifiedBase64.encode((byte[])baId);
                }
                catch (UnsupportedEncodingException e) {
                    this._logger.error((Object)("Could not create tgt id for byte[]: " + baId), (Throwable)e);
                    throw new PersistenceException(1);
                }
            } while (this.exists(id));
            tgt.setId(id);
            long expiration = System.currentTimeMillis() + this._lExpiration;
            tgt.setTgtExpTime(expiration);
            try {
                ps = oConnection.prepareStatement(this._sInsertQuery);
                ps.setString(1, id);
                ps.setTimestamp(2, new Timestamp(expiration));
                ps.setBytes(3, Serialize.encode((Object)tgt.getUser()));
                ps.setBytes(4, Serialize.encode((Object)tgt.getAuthenticationProfile()));
                ps.setBytes(5, Serialize.encode(tgt.getModifiableAuthNProfileIDs()));
                ps.setBytes(6, Serialize.encode(tgt.getModifiableRequestorIDs()));
                ps.setBytes(7, Serialize.encode((Object)tgt.getAttributes()));
                int i = ps.executeUpdate();
                this._logger.debug((Object)(i + " New TGT(s) added:" + id));
                listenerEvent = TGTListenerEvent.ON_CREATE;
                if (bProcessEvent) {
                    try {
                        this.processEvent(listenerEvent, (ITGT)tgt);
                    }
                    catch (TGTListenerException e) {
                        listTGTEventErrors = e.getErrors();
                    }
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)("Could not execute insert query: " + this._sInsertQuery), (Throwable)e);
                throw new PersistenceException(34);
            }
        }
        if (listTGTEventErrors == null) return listenerEvent;
        throw new TGTListenerException(listTGTEventErrors);
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    private void processEvent(TGTListenerEvent event, ITGT tgt) throws TGTListenerException {
        Vector<TGTEventError> listErrors = new Vector<TGTEventError>();
        for (int i = 0; i < this._lListeners.size(); ++i) {
            StringBuffer sbDebug;
            ITGTListener listener = this._lListeners.get(i);
            try {
                if (tgt != null) {
                    listener.processTGTEvent(event, tgt);
                    continue;
                }
                this._logger.debug((Object)("No TGT available; event not processed: " + event));
                continue;
            }
            catch (TGTListenerException e) {
                sbDebug = new StringBuffer("Could not process '");
                sbDebug.append(event);
                sbDebug.append("' event for TGT with id '");
                sbDebug.append(tgt == null ? "NULL" : tgt.getId());
                sbDebug.append("': ");
                sbDebug.append((Object)e);
                this._logger.debug((Object)sbDebug.toString(), (Throwable)e);
                listErrors.addAll(e.getErrors());
                continue;
            }
            catch (Exception e) {
                sbDebug = new StringBuffer("Internal error while processing '");
                sbDebug.append(event);
                sbDebug.append("' event for TGT with id: ");
                sbDebug.append(tgt == null ? "NULL" : tgt.getId());
                this._logger.debug((Object)sbDebug.toString(), (Throwable)e);
                listErrors.add(new TGTEventError(UserEvent.INTERNAL_ERROR));
            }
        }
        if (!listErrors.isEmpty()) {
            throw new TGTListenerException(listErrors);
        }
    }
}

