/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.tgt.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.engine.core.tgt.TGTException;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.util.database.DatabaseException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JDBCTGTAliasStore
implements ITGTAliasStore {
    private static final String ALIAS_STORE_TABLE_NAME_PREFIX = "alias_store_";
    private static final String ALIAS_STORE_COLUMN_TGT_ID = "tgt_id";
    private static final String ALIAS_STORE_COLUMN_ENTITY_ID_POSTFIX = "_id";
    private String _sTGTTableName;
    private String _sTGTColumnID;
    private String _sAliasTableName;
    private String _sAliasColumnTGTID;
    private String _sAliasColumnEntityID;
    private String _sAliasQueryRemoveExpired;
    private String _sAliasQueryRowExists;
    private String _sAliasQueryDelete;
    private String _sAliasQueryDeleteAll;
    private DataSource _oDataSource;
    private Log _logger = LogFactory.getLog(JDBCTGTAliasStore.class);
    private String _sID;

    public JDBCTGTAliasStore(IConfigurationManager configurationManager, Element config, DataSource dataSource, String sTGTTableName, String sTGTColumnID) throws OAException {
        this._oDataSource = dataSource;
        this._sTGTTableName = sTGTTableName;
        this._sTGTColumnID = sTGTColumnID;
        this._sID = configurationManager.getParam(config, "id");
        if (this._sID == null) {
            this._logger.error((Object)"No 'id' parameter in alias store section in configuration");
            throw new OAException(17);
        }
        boolean bIsAliasSupportEnabled = false;
        String sEnabled = configurationManager.getParam(config, "enabled");
        if (sEnabled != null) {
            if (sEnabled.equalsIgnoreCase("TRUE")) {
                bIsAliasSupportEnabled = true;
            } else if (!sEnabled.equalsIgnoreCase("FALSE")) {
                this._logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                throw new OAException(17);
            }
        }
        if (bIsAliasSupportEnabled) {
            this.createAliasQueries(configurationManager, config);
            this.verifyAliasTableConfig(configurationManager, config);
        }
        StringBuffer sbInfo = new StringBuffer("Alias store '");
        sbInfo.append(this._sID);
        sbInfo.append("' : ");
        sbInfo.append(bIsAliasSupportEnabled ? "enabled" : "disabled");
        this._logger.info((Object)sbInfo.toString());
        this._logger.info((Object)("Started " + this.getClass().getName() + "-" + this.getClass().getPackage().getImplementationVersion()));
    }

    public void putAlias(String type, String requestorID, String tgtID, String alias) throws OAException {
        Connection connection = null;
        PreparedStatement psSelect = null;
        ResultSet rsSelect = null;
        try {
            connection = this._oDataSource.getConnection();
            psSelect = connection.prepareStatement(this._sAliasQueryRowExists);
            psSelect.setString(1, tgtID);
            psSelect.setString(2, requestorID);
            rsSelect = psSelect.executeQuery();
            if (rsSelect.next()) {
                this.update(connection, tgtID, requestorID, type, alias);
            } else {
                this.insert(connection, tgtID, requestorID, type, alias);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute query: " + this._sAliasQueryRowExists), (Throwable)e);
            throw new OAException(34);
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Internal error during insert of alias '");
            sbError.append(alias);
            sbError.append("' in column '");
            sbError.append(type);
            sbError.append("' for requestor id '");
            sbError.append(requestorID);
            sbError.append("' and TGT id: ");
            sbError.append(tgtID);
            this._logger.error((Object)sbError.toString(), (Throwable)e);
            throw new OAException(34);
        }
        finally {
            try {
                if (rsSelect != null) {
                    rsSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public String getAlias(String type, String requestorID, String tgtID) throws OAException {
        String sAlias = null;
        Connection connection = null;
        Statement psSelect = null;
        ResultSet rsSelect = null;
        StringBuffer sbQuerySearchTransient = null;
        try {
            sbQuerySearchTransient = new StringBuffer("SELECT ");
            sbQuerySearchTransient.append(type);
            sbQuerySearchTransient.append(" FROM ").append(this._sAliasTableName);
            sbQuerySearchTransient.append(" WHERE ").append(this._sAliasColumnTGTID).append("=?");
            sbQuerySearchTransient.append(" AND ").append(this._sAliasColumnEntityID).append("=?");
            connection = this._oDataSource.getConnection();
            psSelect = connection.prepareStatement(sbQuerySearchTransient.toString());
            psSelect.setString(1, tgtID);
            psSelect.setString(2, requestorID);
            rsSelect = psSelect.executeQuery();
            if (rsSelect.next()) {
                sAlias = rsSelect.getString(type);
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute select query: " + sbQuerySearchTransient.toString()), (Throwable)e);
            throw new OAException(35);
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Internal error during retrieval of value from column '");
            sbError.append(type);
            sbError.append("' for requestor with id: ");
            sbError.append(requestorID);
            this._logger.error((Object)sbError.toString(), (Throwable)e);
            throw new OAException(35);
        }
        finally {
            try {
                if (rsSelect != null) {
                    rsSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return sAlias;
    }

    public String getTGTID(String type, String requestorID, String alias) throws OAException {
        String sTGTID = null;
        Connection connection = null;
        Statement psSelect = null;
        ResultSet rsSelect = null;
        StringBuffer sbQuerySearch = null;
        try {
            sbQuerySearch = new StringBuffer("SELECT ");
            sbQuerySearch.append(this._sAliasColumnTGTID);
            sbQuerySearch.append(" FROM ").append(this._sAliasTableName);
            sbQuerySearch.append(" WHERE ").append(this._sAliasColumnEntityID).append("=?");
            sbQuerySearch.append(" AND ").append(type).append("=?");
            connection = this._oDataSource.getConnection();
            psSelect = connection.prepareStatement(sbQuerySearch.toString());
            psSelect.setString(1, requestorID);
            psSelect.setString(2, alias);
            rsSelect = psSelect.executeQuery();
            if (rsSelect.next()) {
                sTGTID = rsSelect.getString(this._sAliasColumnTGTID);
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute select query: " + sbQuerySearch.toString()), (Throwable)e);
            throw new OAException(35);
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Internal error during retrieval of value from column '");
            sbError.append(type);
            sbError.append("' for requestor with id: ");
            sbError.append(requestorID);
            this._logger.error((Object)sbError.toString(), (Throwable)e);
            throw new OAException(35);
        }
        finally {
            try {
                if (rsSelect != null) {
                    rsSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return sTGTID;
    }

    public boolean isAlias(String type, String requestorID, String alias) throws OAException {
        boolean bRet = false;
        Connection connection = null;
        Statement psSelect = null;
        ResultSet rsSelect = null;
        StringBuffer sbQuerySearch = null;
        try {
            sbQuerySearch = new StringBuffer("SELECT ");
            sbQuerySearch.append(type);
            sbQuerySearch.append(" FROM ").append(this._sAliasTableName);
            sbQuerySearch.append(" WHERE ").append(this._sAliasColumnEntityID).append("=?");
            sbQuerySearch.append(" AND ").append(type).append("=?");
            connection = this._oDataSource.getConnection();
            psSelect = connection.prepareStatement(sbQuerySearch.toString());
            psSelect.setString(1, requestorID);
            psSelect.setString(2, alias);
            rsSelect = psSelect.executeQuery();
            if (rsSelect.next()) {
                bRet = true;
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute select query: " + sbQuerySearch.toString()), (Throwable)e);
            throw new OAException(35);
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Internal error during exist check for value '");
            sbError.append(alias);
            sbError.append("' on column '");
            sbError.append(type);
            sbError.append("' for  requestor id: ");
            sbError.append(requestorID);
            this._logger.error((Object)sbError.toString(), (Throwable)e);
            throw new OAException(35);
        }
        finally {
            try {
                if (rsSelect != null) {
                    rsSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String type, String entityID, String alias) throws OAException {
        Connection connection = null;
        Statement ps = null;
        StringBuffer sbQueryRemove = null;
        try {
            sbQueryRemove = new StringBuffer("UPDATE ");
            sbQueryRemove.append(this._sAliasTableName);
            sbQueryRemove.append(" SET ");
            sbQueryRemove.append(type);
            sbQueryRemove.append("=? WHERE ");
            sbQueryRemove.append(this._sAliasColumnEntityID);
            sbQueryRemove.append("=? AND ");
            sbQueryRemove.append(type);
            sbQueryRemove.append("=?");
            connection = this._oDataSource.getConnection();
            ps = connection.prepareStatement(sbQueryRemove.toString());
            ps.setNull(1, 12);
            ps.setString(2, entityID);
            ps.setString(3, alias);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute alias remove query: " + sbQueryRemove.toString()), (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String entityID, String tgtID) throws OAException {
        Connection connection = null;
        Statement ps = null;
        try {
            connection = this._oDataSource.getConnection();
            ps = connection.prepareStatement(this._sAliasQueryDeleteAll);
            ps.setString(1, entityID);
            ps.setString(2, tgtID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute remove all aliasses query: " + this._sAliasQueryDeleteAll), (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int remove(Connection connection, String tgtID) {
        PreparedStatement ps = null;
        int iAlias = 0;
        try {
            ps = connection.prepareStatement(this._sAliasQueryDelete);
            ps.setString(1, tgtID);
            iAlias = ps.executeUpdate();
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute alias delete query: " + this._sAliasQueryDelete), (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
        }
        return iAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clean(Connection connection) {
        PreparedStatement ps = null;
        int iAlias = 0;
        try {
            ps = connection.prepareStatement(this._sAliasQueryRemoveExpired);
            iAlias = ps.executeUpdate();
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute alias delete query: " + this._sAliasQueryRemoveExpired), (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
        }
        return iAlias;
    }

    String getQueryAliasRemove() {
        return this._sAliasQueryDelete;
    }

    private void createAliasQueries(IConfigurationManager configurationManager, Element eConfig) throws TGTException, ConfigurationException {
        Element eEntity = configurationManager.getSection(eConfig, "entity");
        if (eEntity == null) {
            this._logger.info((Object)"No optional 'entity' section found in configuration, using default table and column names");
        } else {
            this._sAliasTableName = configurationManager.getParam(eEntity, "table");
            Element eColumnTGTID = configurationManager.getSection(eConfig, "property", "name=tgtId");
            if (eColumnTGTID == null) {
                this._logger.warn((Object)"No optional 'property' section found for property with name: tgtId");
            } else {
                this._sAliasColumnTGTID = configurationManager.getParam(eColumnTGTID, "column");
                if (this._sAliasColumnTGTID == null) {
                    this._logger.error((Object)"Could not find column name for property tgtId");
                    throw new TGTException(17);
                }
            }
            Element eColumnRequestorID = configurationManager.getSection(eConfig, "property", "name=requestorId");
            if (eColumnRequestorID == null) {
                this._logger.warn((Object)"No optional 'property' section found for property with name: requestorId");
            } else {
                this._sAliasColumnEntityID = configurationManager.getParam(eColumnRequestorID, "column");
                if (this._sAliasColumnEntityID == null) {
                    this._logger.error((Object)"Could not find column name for property requestorId");
                    throw new TGTException(17);
                }
            }
        }
        if (this._sAliasTableName == null) {
            this._sAliasTableName = ALIAS_STORE_TABLE_NAME_PREFIX + this._sID;
        }
        if (this._sAliasColumnTGTID == null) {
            this._sAliasColumnTGTID = ALIAS_STORE_COLUMN_TGT_ID;
        }
        if (this._sAliasColumnEntityID == null) {
            this._sAliasColumnEntityID = this._sID + ALIAS_STORE_COLUMN_ENTITY_ID_POSTFIX;
        }
        this._sAliasQueryRemoveExpired = null;
        Element eRemoveExpired = configurationManager.getSection(eConfig, "remove_expired");
        if (eRemoveExpired != null) {
            this._sAliasQueryRemoveExpired = configurationManager.getParam(eRemoveExpired, "query");
            if (this._sAliasQueryRemoveExpired == null || this._sAliasQueryRemoveExpired.length() == 0) {
                this._logger.warn((Object)("Empty remove_expired query found for alias store '" + this._sAliasTableName + "'"));
            } else {
                this._logger.info((Object)"Setting configured remove_expired query");
            }
        }
        if (this._sAliasQueryRemoveExpired == null) {
            this._logger.debug((Object)"Building remove_expired query manually (MySQL NOT-IN syntax)");
            StringBuffer sbQueryRemoveExpired = new StringBuffer("DELETE FROM ");
            sbQueryRemoveExpired.append(this._sAliasTableName);
            sbQueryRemoveExpired.append(" WHERE ");
            sbQueryRemoveExpired.append(this._sAliasColumnTGTID);
            sbQueryRemoveExpired.append(" NOT IN (SELECT ");
            sbQueryRemoveExpired.append(this._sTGTTableName).append(".").append(this._sTGTColumnID);
            sbQueryRemoveExpired.append(" FROM ");
            sbQueryRemoveExpired.append(this._sTGTTableName);
            sbQueryRemoveExpired.append(")");
            this._sAliasQueryRemoveExpired = sbQueryRemoveExpired.toString();
        }
        this._logger.debug((Object)("Using alias remove expired query: " + this._sAliasQueryRemoveExpired));
        StringBuffer sbQuerySelect = new StringBuffer("SELECT ");
        sbQuerySelect.append(this._sAliasColumnTGTID);
        sbQuerySelect.append(" FROM ");
        sbQuerySelect.append(this._sAliasTableName);
        sbQuerySelect.append(" WHERE ");
        sbQuerySelect.append(this._sAliasColumnTGTID);
        sbQuerySelect.append("=? AND ");
        sbQuerySelect.append(this._sAliasColumnEntityID);
        sbQuerySelect.append("=?");
        this._sAliasQueryRowExists = sbQuerySelect.toString();
        this._logger.debug((Object)("Using alias row exists query: " + this._sAliasQueryRowExists));
        StringBuffer sbQueryDelete = new StringBuffer("DELETE FROM ");
        sbQueryDelete.append(this._sAliasTableName);
        sbQueryDelete.append(" WHERE ");
        sbQueryDelete.append(this._sAliasColumnTGTID);
        sbQueryDelete.append("=?");
        this._sAliasQueryDelete = sbQueryDelete.toString();
        this._logger.debug((Object)("Using alias delete query: " + this._sAliasQueryDelete));
        StringBuffer sbQueryRemove = new StringBuffer("DELETE FROM ");
        sbQueryRemove.append(this._sAliasTableName);
        sbQueryRemove.append(" WHERE ");
        sbQueryRemove.append(this._sAliasColumnEntityID);
        sbQueryRemove.append("=? AND ");
        sbQueryRemove.append(this._sAliasColumnTGTID);
        sbQueryRemove.append("=?");
        this._sAliasQueryDeleteAll = sbQueryRemove.toString();
        this._logger.debug((Object)("Using all aliasses remove query: " + this._sAliasQueryDeleteAll));
    }

    private void verifyAliasTableConfig(IConfigurationManager configurationManager, Element eAlias) throws OAException {
        Connection oConnection = null;
        Statement pVerify = null;
        try {
            String sVerificationQuery;
            block29: {
                try {
                    oConnection = this._oDataSource.getConnection();
                }
                catch (SQLException e) {
                    this._logger.error((Object)"Could not connect to resource", (Throwable)e);
                    throw new DatabaseException(2);
                }
                sVerificationQuery = null;
                try {
                    Element eValidation = configurationManager.getSection(eAlias, "validation");
                    if (eValidation == null || (sVerificationQuery = configurationManager.getParam(eValidation, "query")) != null && sVerificationQuery.length() != 0) break block29;
                    this._logger.warn((Object)"Empty validation query found for table, alias store table structure is not validated");
                    return;
                }
                catch (ConfigurationException e) {
                    this._logger.error((Object)"Invalid validation query found for alias store table", (Throwable)e);
                    throw new DatabaseException(17);
                }
            }
            if (sVerificationQuery == null) {
                StringBuffer sbVerificationQuery = new StringBuffer("SELECT ");
                sbVerificationQuery.append(this._sAliasColumnTGTID).append(",");
                sbVerificationQuery.append(this._sAliasColumnEntityID);
                sbVerificationQuery.append(" FROM ");
                sbVerificationQuery.append(this._sAliasTableName);
                sbVerificationQuery.append(" LIMIT 1");
                sVerificationQuery = sbVerificationQuery.toString();
                this._logger.info((Object)("No validation query found for alias store table, using default: " + sVerificationQuery));
            }
            pVerify = oConnection.prepareStatement(sVerificationQuery);
            try {
                pVerify.executeQuery();
            }
            catch (Exception e) {
                StringBuffer sbError = new StringBuffer("Invalid alias store table configured '");
                sbError.append(this._sAliasTableName);
                sbError.append("' verified with query: ");
                sbError.append(sVerificationQuery);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new DatabaseException(2);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during verification of configured alias store table", (Throwable)e);
            throw new OAException(2);
        }
        finally {
            try {
                if (pVerify != null) {
                    pVerify.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    private void update(Connection connection, String sTGTID, String sEntityID, String sColumn, String sAlias) throws OAException {
        Statement psUpdate = null;
        StringBuffer sbQueryUpdate = null;
        try {
            sbQueryUpdate = new StringBuffer("UPDATE ");
            sbQueryUpdate.append(this._sAliasTableName);
            sbQueryUpdate.append(" SET ");
            sbQueryUpdate.append(sColumn);
            sbQueryUpdate.append("=? WHERE ");
            sbQueryUpdate.append(this._sAliasColumnTGTID);
            sbQueryUpdate.append("=? AND ");
            sbQueryUpdate.append(this._sAliasColumnEntityID);
            sbQueryUpdate.append("=?");
            psUpdate = connection.prepareStatement(sbQueryUpdate.toString());
            psUpdate.setString(1, sAlias);
            psUpdate.setString(2, sTGTID);
            psUpdate.setString(3, sEntityID);
            int iUpdated = psUpdate.executeUpdate();
            if (iUpdated != 1) {
                this._logger.error((Object)("Nothing updated while executing query: " + sbQueryUpdate.toString()));
                throw new OAException(36);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute query: " + sbQueryUpdate.toString()), (Throwable)e);
            throw new OAException(34);
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Internal error during update of row with alias '");
            sbError.append(sAlias);
            sbError.append("' in column '");
            sbError.append(sColumn);
            sbError.append("' for requestor id '");
            sbError.append(sEntityID);
            sbError.append("' and TGT id: ");
            sbError.append(sTGTID);
            this._logger.error((Object)sbError.toString(), (Throwable)e);
            throw new OAException(34);
        }
        finally {
            try {
                if (psUpdate != null) {
                    psUpdate.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
        }
    }

    private void insert(Connection connection, String sTGTID, String sRequestorID, String sColumn, String sAlias) throws OAException {
        Statement psInsert = null;
        StringBuffer sbQueryInsert = null;
        try {
            sbQueryInsert = new StringBuffer("INSERT INTO ");
            sbQueryInsert.append(this._sAliasTableName);
            sbQueryInsert.append(" (");
            sbQueryInsert.append(this._sAliasColumnTGTID);
            sbQueryInsert.append(",");
            sbQueryInsert.append(this._sAliasColumnEntityID);
            sbQueryInsert.append(",");
            sbQueryInsert.append(sColumn);
            sbQueryInsert.append(") VALUES (?,?,?)");
            psInsert = connection.prepareStatement(sbQueryInsert.toString());
            psInsert.setString(1, sTGTID);
            psInsert.setString(2, sRequestorID);
            psInsert.setString(3, sAlias);
            int iInserted = psInsert.executeUpdate();
            if (iInserted != 1) {
                this._logger.error((Object)("Nothing inserted while executing query: " + sbQueryInsert.toString()));
                throw new OAException(36);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute query: " + sbQueryInsert.toString()), (Throwable)e);
            throw new OAException(34);
        }
        catch (Exception e) {
            StringBuffer sbError = new StringBuffer("Internal error during insert of alias '");
            sbError.append(sAlias);
            sbError.append("' in column '");
            sbError.append(sColumn);
            sbError.append("' for requestor id '");
            sbError.append(sRequestorID);
            sbError.append("' and TGT id: ");
            sbError.append(sTGTID);
            this._logger.error((Object)sbError.toString(), (Throwable)e);
            throw new OAException(34);
        }
        finally {
            try {
                if (psInsert != null) {
                    psInsert.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
        }
    }
}

