/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.storage.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.datastorage.IDataStorageFactory;
import com.alfaariss.oa.util.database.jdbc.DataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JDBCFactory
implements IComponent,
IDataStorageFactory {
    private Log _logger = LogFactory.getLog(JDBCFactory.class);
    private IConfigurationManager _configurationManager;
    private boolean _bEnabled = false;
    private DataSource _dsModel = null;
    private DataSource _dsSystem = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element config) throws OAException {
        JDBCFactory jDBCFactory = this;
        synchronized (jDBCFactory) {
            this.stop();
            this.start(this._configurationManager, config);
        }
    }

    public void start(IConfigurationManager configurationManager, Element config) throws OAException {
        block27: {
            Connection conModel = null;
            Connection conSystem = null;
            try {
                this._configurationManager = configurationManager;
                this._bEnabled = true;
                String sEnabled = this._configurationManager.getParam(config, "enabled");
                if (sEnabled != null) {
                    if (sEnabled.equalsIgnoreCase("FALSE")) {
                        this._bEnabled = false;
                    } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                        this._logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                        throw new OAException(17);
                    }
                }
                if (!this._bEnabled) break block27;
                Element eModel = this._configurationManager.getSection(config, "model");
                if (eModel == null) {
                    this._logger.info((Object)"No optional 'model' section found in configuration, disabling global model store");
                } else {
                    this._dsModel = DataSourceFactory.createDataSource((IConfigurationManager)this._configurationManager, (Element)eModel);
                    try {
                        conModel = this._dsModel.getConnection();
                    }
                    catch (SQLException e) {
                        this._logger.error((Object)"Could not connect to model resource", (Throwable)e);
                        throw new OAException(2);
                    }
                }
                Element eSystem = this._configurationManager.getSection(config, "system");
                if (eSystem == null) {
                    this._logger.info((Object)"No optional 'system' section found in configuration, disabling global system store");
                    break block27;
                }
                this._dsSystem = DataSourceFactory.createDataSource((IConfigurationManager)this._configurationManager, (Element)eSystem);
                try {
                    conSystem = this._dsSystem.getConnection();
                }
                catch (SQLException e) {
                    this._logger.error((Object)"Could not connect to system resource", (Throwable)e);
                    throw new OAException(2);
                }
            }
            catch (OAException e) {
                throw e;
            }
            catch (Exception e) {
                this._logger.fatal((Object)"Internal error during initialization", (Throwable)e);
                throw new OAException(1);
            }
            finally {
                try {
                    if (conModel != null) {
                        conModel.close();
                    }
                }
                catch (Exception e) {
                    this._logger.error((Object)"Could not close model connection", (Throwable)e);
                }
                try {
                    if (conSystem != null) {
                        conSystem.close();
                    }
                }
                catch (Exception e) {
                    this._logger.error((Object)"Could not close system connection", (Throwable)e);
                }
            }
        }
    }

    public void stop() {
        this._bEnabled = false;
        this._dsSystem = null;
        this._dsModel = null;
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    public DataSource createModelDatasource() throws OAException {
        return this._dsModel;
    }

    public DataSource createSystemDatasource() throws OAException {
        return this._dsSystem;
    }
}

