/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.session.memory;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.engine.core.session.SessionException;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.engine.session.memory.MemorySession;
import com.alfaariss.oa.util.ModifiedBase64;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.storage.factory.AbstractStorageFactory;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemorySessionFactory
extends AbstractStorageFactory
implements ISessionFactory<MemorySession> {
    private Hashtable<String, MemorySession> _htSession;
    private Log _logger = LogFactory.getLog(MemorySessionFactory.class);
    private Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");

    public MemorySessionFactory() {
        this._htSession = new Hashtable();
    }

    public ISession createSession(String sRequestorId) throws SessionException {
        if (sRequestorId == null) {
            throw new IllegalArgumentException("Suplied requestor id is empty");
        }
        if (this._lMax > 0L && (long)this._htSession.size() >= this._lMax) {
            this._logger.error((Object)"Could not create session, maximum reached");
            throw new SessionException(81);
        }
        return new MemorySession(this, sRequestorId);
    }

    public boolean exists(Object id) {
        return this._htSession.containsKey(id);
    }

    public MemorySession retrieve(Object id) throws PersistenceException {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Current sessions: " + this._htSession));
        }
        return this._htSession.get(id);
    }

    public synchronized void persist(MemorySession session) throws PersistenceException {
        String id = session.getId();
        if (id == null) {
            byte[] baId = new byte[16];
            do {
                this._random.nextBytes(baId);
                try {
                    id = ModifiedBase64.encode((byte[])baId);
                }
                catch (UnsupportedEncodingException e) {
                    this._logger.error((Object)("Could not create id for byte[]: " + baId), (Throwable)e);
                    throw new PersistenceException(1);
                }
            } while (this._htSession.containsKey(id));
            session.setId(id);
            session.setExpTime(System.currentTimeMillis() + this._lExpiration);
            this._htSession.put(id, session);
            this._logger.info((Object)("New session(s) added: " + id + " for requestor '" + session.getRequestorId() + "'"));
        } else if (session.isExpired()) {
            this._logger.info((Object)("Session Expired: " + id));
            this._eventLogger.info((Object)new UserEventLogItem((ISession)session, null, UserEvent.SESSION_EXPIRED, (IAuthority)this, null));
            this._htSession.remove(id);
        } else {
            session.setExpTime(System.currentTimeMillis() + this._lExpiration);
            this._logger.info((Object)("Existing session(s) updated: " + id + " for requestor '" + session.getRequestorId() + "'"));
        }
    }

    public void persist(MemorySession[] oaSession) throws PersistenceException {
        for (MemorySession session : oaSession) {
            this.persist(session);
        }
    }

    public void removeExpired() throws PersistenceException {
        long lNow = System.currentTimeMillis();
        Enumeration<MemorySession> e = this._htSession.elements();
        while (e.hasMoreElements()) {
            MemorySession session = e.nextElement();
            if (session.getExpTime() > lNow) continue;
            String id = session.getId();
            this._logger.info((Object)("Session Expired: " + id));
            this._eventLogger.info((Object)new UserEventLogItem((ISession)session, null, UserEvent.SESSION_EXPIRED, (IAuthority)this, "clean"));
            this._htSession.remove(id);
        }
    }

    public void start() throws OAException {
        if (this._tCleaner != null) {
            this._tCleaner.start();
        }
    }

    public long poll() throws OAException {
        if (this._htSession != null) {
            return this._htSession.size();
        }
        return Long.MIN_VALUE;
    }

    public String getAuthority() {
        return "SessionFactory";
    }
}

