/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.engine.session.jgroups;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.session.SessionException;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.util.ModifiedBase64;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.storage.factory.AbstractStorageFactory;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asimba.engine.cluster.ClusterConfiguration;
import org.asimba.engine.core.cluster.ICluster;
import org.asimba.engine.session.jgroups.JGroupsSession;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.ReplicatedHashMap;
import org.w3c.dom.Element;

public class JGroupsSessionFactory
extends AbstractStorageFactory
implements ISessionFactory<JGroupsSession> {
    public static final String EL_CONFIG_CLUSTERID = "cluster_id";
    public static final String EL_CONFIG_BLOCKING_MODE = "blocking_mode";
    public static final String EL_CONFIG_BLOCKING_TIMEOUT = "blocking_timeout";
    public static final String EL_CONFIG_STATE_TIMEOUT = "state_timeout";
    public static final long STATE_TIMEOUT_DEFAULT = 100000L;
    private static final Log _oLogger = LogFactory.getLog(JGroupsSessionFactory.class);
    private static final Log _oEventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    private ReplicatedHashMap<String, JGroupsSession> _mSessions;
    private ICluster _oCluster;

    public void start() throws OAException {
        if (this._oCluster == null) {
            ClusterConfiguration oClusterConfiguration = new ClusterConfiguration(this._configurationManager);
            this._oCluster = oClusterConfiguration.getClusterFromConfigById(this._eConfig, EL_CONFIG_CLUSTERID);
        }
        JChannel jChannel = (JChannel)this._oCluster.getChannel();
        this._mSessions = new ReplicatedHashMap((Channel)jChannel);
        String sBlockingMode = this._configurationManager.getParam(this._eConfig, EL_CONFIG_BLOCKING_MODE);
        if (sBlockingMode != null) {
            if (sBlockingMode.equalsIgnoreCase("true") || sBlockingMode.equalsIgnoreCase("false")) {
                Boolean bBlockingMode = Boolean.valueOf(sBlockingMode);
                this._mSessions.setBlockingUpdates(bBlockingMode.booleanValue());
            } else {
                _oLogger.error((Object)"Invalid value in config for <blocking_mode>, using default.");
            }
        } else {
            this._mSessions.setBlockingUpdates(true);
        }
        String sBlockingTimeout = this._configurationManager.getParam(this._eConfig, EL_CONFIG_BLOCKING_TIMEOUT);
        if (sBlockingTimeout != null) {
            try {
                Long lBlockingTimeout = new Long(sBlockingTimeout);
                this._mSessions.setTimeout(lBlockingTimeout.longValue());
            }
            catch (NumberFormatException e) {
                _oLogger.error((Object)"Invalid value in config for <blocking_timeout>, using default.");
            }
        }
        Long lStateTimeout = 100000L;
        String sStateTimeout = this._configurationManager.getParam(this._eConfig, EL_CONFIG_STATE_TIMEOUT);
        if (sStateTimeout != null) {
            try {
                lStateTimeout = new Long(sStateTimeout);
            }
            catch (NumberFormatException e) {
                _oLogger.error((Object)"Invalid value in config for <state_timeout>, using default.");
            }
        }
        try {
            this._mSessions.start(lStateTimeout.longValue());
        }
        catch (Exception e) {
            _oLogger.error((Object)("Could not start Replicated HashMap: " + e.getMessage()), (Throwable)e);
            throw new OAException(1);
        }
        if (this._tCleaner != null) {
            this._tCleaner.start();
        }
    }

    public void startForTesting(IConfigurationManager configurationManager, Element clusterElement, ICluster clusterConfig, SecureRandom secureRandom, long expiration) throws OAException {
        this._configurationManager = configurationManager;
        this._eConfig = clusterElement;
        this._oCluster = clusterConfig;
        this._random = secureRandom;
        this._lMax = 100000L;
        this._lExpiration = expiration;
        this.start();
    }

    public void stop() {
        super.stop();
        if (this._mSessions != null) {
            _oLogger.debug((Object)"Stopping Replicated HashMap");
            this._mSessions.stop();
        }
        if (this._oCluster != null) {
            _oLogger.debug((Object)("Closing cluster " + this._oCluster.getID()));
            this._oCluster.close();
        }
    }

    public void removeExpired() throws PersistenceException {
        long lNow = System.currentTimeMillis();
        for (Map.Entry entry : this._mSessions.entrySet()) {
            JGroupsSession session = (JGroupsSession)entry.getValue();
            if (session.getSessionExpTime().getTime() > lNow) continue;
            String id = session.getId();
            _oLogger.debug((Object)("Session Expired: " + id));
            IUser sessionUser = session.getUser();
            _oLogger.info((Object)new UserEventLogItem((ISession)session, null, UserEvent.SESSION_EXPIRED, (IAuthority)this, "clean"));
            this._mSessions.remove(entry.getKey());
        }
    }

    public boolean exists(Object id) throws PersistenceException {
        return this._mSessions.containsKey((Object)((String)id));
    }

    public void persist(JGroupsSession oSession) throws PersistenceException {
        String sSessionId = oSession.getId();
        if (sSessionId == null) {
            byte[] baId = new byte[16];
            int iAllowedIdGenAttempts = 1000;
            do {
                this._random.nextBytes(baId);
                try {
                    sSessionId = ModifiedBase64.encode((byte[])baId);
                }
                catch (UnsupportedEncodingException e) {
                    _oLogger.error((Object)("Could not create session id for byte[]: " + Arrays.toString(baId)), (Throwable)e);
                    throw new PersistenceException(1);
                }
            } while (this._mSessions.containsKey((Object)sSessionId) && --iAllowedIdGenAttempts > 0);
            if (this._mSessions.containsKey((Object)sSessionId)) {
                _oLogger.error((Object)"Could not persist Session because could not generate ID (which is weird!)");
                throw new PersistenceException(1);
            }
            oSession.setId(sSessionId);
            oSession.setExpTime(System.currentTimeMillis() + this._lExpiration);
            this._mSessions.put((Object)sSessionId, (Object)oSession);
            _oLogger.info((Object)("New session added: " + sSessionId + " for requestor '" + oSession.getRequestorId() + "'"));
        } else if (oSession.isExpired()) {
            _oLogger.info((Object)("Session expired: " + sSessionId));
            _oEventLogger.info((Object)new UserEventLogItem((ISession)oSession, null, UserEvent.SESSION_EXPIRED, (IAuthority)this, null));
            this._mSessions.remove((Object)sSessionId);
        } else {
            long lExpiration = System.currentTimeMillis() + this._lExpiration;
            oSession.setExpTime(lExpiration);
            this._mSessions.put((Object)sSessionId, (Object)oSession);
            _oLogger.info((Object)("Existing session(s) updated: " + sSessionId + " for requestor '" + oSession.getRequestorId() + "'"));
        }
    }

    public void persist(JGroupsSession[] aoSession) throws PersistenceException {
        for (JGroupsSession oSession : aoSession) {
            this.persist(oSession);
        }
    }

    public long poll() throws OAException {
        if (this._mSessions == null) {
            return 0L;
        }
        return this._mSessions.size();
    }

    public String getAuthority() {
        return "SessionFactory";
    }

    public ISession createSession(String sRequestorId) throws SessionException {
        if (sRequestorId == null) {
            throw new IllegalArgumentException("Supplied requestor id is empty");
        }
        if (this._lMax > 0L && (long)this._mSessions.size() >= this._lMax) {
            _oLogger.error((Object)"Could not create session, maximum reached");
            throw new SessionException(81);
        }
        return new JGroupsSession(this, sRequestorId);
    }

    public JGroupsSession retrieve(Object oSessionId) throws PersistenceException {
        JGroupsSession oSession = (JGroupsSession)this._mSessions.get((Object)((String)oSessionId));
        if (oSession != null) {
            oSession.resuscitate(this);
        }
        return oSession;
    }

    public Integer size() {
        return this._mSessions.size();
    }

    public long getTimeout() {
        return this._mSessions.getTimeout();
    }

    public boolean isBlockingUpdates() {
        return this._mSessions.isBlockingUpdates();
    }
}

