/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.session.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.datastorage.IDataStorageFactory;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.attribute.SessionAttributes;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import com.alfaariss.oa.engine.core.session.SessionException;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.engine.session.jdbc.JDBCSession;
import com.alfaariss.oa.util.ModifiedBase64;
import com.alfaariss.oa.util.Serialize;
import com.alfaariss.oa.util.database.DatabaseException;
import com.alfaariss.oa.util.database.jdbc.DataSourceFactory;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.storage.factory.AbstractStorageFactory;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JDBCSessionFactory
extends AbstractStorageFactory
implements ISessionFactory<JDBCSession> {
    private static final String TABLE_NAME = "session";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_TGT_ID = "tgt_id";
    private static final String COLUMN_STATE = "state";
    private static final String COLUMN_REQUESTOR = "requestor_id";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_EXPIRATION = "expiration";
    private static final String COLUMN_FORCED_AUTHENTICATE = "forced_authenticate";
    private static final String COLUMN_OWNER = "sessionuser";
    private static final String COLUMN_ATTRIBUTES = "attributes";
    private static final String COLUMN_FORCED_USERID = "forced_userid";
    private static final String COLUMN_LOCALE = "locale";
    private static final String COLUMN_SELECTED_AUTHN_PROFILE = "selected_authn_profile";
    private static final String COLUMN_AUTHN_PROFILES = "authn_profiles";
    private static final String COLUMN_PASSIVE = "passive";
    private String _sTableName;
    private String _sColumnID;
    private String _sColumnTGT_ID;
    private String _sColumnSTATE;
    private String _sColumnREQUESTOR;
    private String _sColumnURL;
    private String _sColumnEXPIRATION;
    private String _sColumnFORCED_AUTHENTICATE;
    private String _sColumnOWNER;
    private String _sColumnATTRIBUTES;
    private String _sColumnFORCED_USERID;
    private String _sColumnLOCALE;
    private String _sColumnSELECTED_AUTHN_PROFILE;
    private String _sColumnAUTHN_PROFILES;
    private String _sColumnPASSIVE;
    private String _sSearchQuery = null;
    private String _sCountQuery = null;
    private String _sInsertQuery = null;
    private String _sUpdateQuery = null;
    private String _sRemoveQuery = null;
    private String _sRemoveExpiredQuery = null;
    private DataSource _oDataSource;
    private Log _logger = LogFactory.getLog(JDBCSessionFactory.class);
    private Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");

    public void start() throws OAException {
        Element eResource = this._configurationManager.getSection(this._eConfig, "resource");
        if (eResource != null) {
            this._oDataSource = DataSourceFactory.createDataSource((IConfigurationManager)this._configurationManager, (Element)eResource);
            this._logger.info((Object)"Using datasource specified in 'resource' section in configuration");
        } else {
            IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
            if (databaseFactory != null && databaseFactory.isEnabled()) {
                this._oDataSource = databaseFactory.createSystemDatasource();
                if (this._oDataSource == null) {
                    this._logger.error((Object)"Could not create a valid datasource");
                    throw new DatabaseException(2);
                }
                this._logger.info((Object)"Using datasource specified in engine");
            } else {
                this._logger.error((Object)"Could not create a valid datasource");
                throw new DatabaseException(2);
            }
        }
        this.createQueries(this._eConfig);
        this.verifyTableConfig(this._eConfig);
        if (this._tCleaner != null) {
            this._tCleaner.start();
        }
    }

    public ISession createSession(String sRequestorId) throws SessionException {
        if (sRequestorId == null) {
            throw new IllegalArgumentException("Suplied requestor id is empty");
        }
        if (this._lMax > 0L && (long)this.getSessionCount() >= this._lMax) {
            this._logger.error((Object)"Could not create session, maximum reached");
            throw new SessionException(81);
        }
        return new JDBCSession(this, sRequestorId);
    }

    public boolean exists(Object id) throws PersistenceException {
        if (id == null || !(id instanceof String)) {
            throw new IllegalArgumentException("Suplied id is empty or invalid");
        }
        boolean bRet = false;
        Connection oConnection = null;
        PreparedStatement psSelect = null;
        ResultSet rsSelect = null;
        try {
            oConnection = this._oDataSource.getConnection();
            psSelect = oConnection.prepareStatement(this._sSearchQuery);
            psSelect.setString(1, (String)id);
            rsSelect = psSelect.executeQuery();
            if (rsSelect.next()) {
                bRet = true;
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute search query", (Throwable)e);
            throw new PersistenceException(35);
        }
        catch (Exception e) {
            this._logger.error((Object)("Internal error during exists check for session with id: " + id), (Throwable)e);
            throw new PersistenceException(35);
        }
        finally {
            try {
                if (rsSelect != null) {
                    rsSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return bRet;
    }

    public JDBCSession retrieve(Object id) throws PersistenceException {
        if (id == null || !(id instanceof String)) {
            throw new IllegalArgumentException("Suplied id is empty or invalid");
        }
        Connection oConnection = null;
        JDBCSession session = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            oConnection = this._oDataSource.getConnection();
            ps = oConnection.prepareStatement(this._sSearchQuery);
            ps.setString(1, (String)id);
            rs = ps.executeQuery();
            if (rs.next()) {
                AuthenticationProfile oProfile;
                List listProfiles;
                Locale oLocale;
                String sForcedUid;
                IUser oUser;
                session = new JDBCSession(this, rs.getString(this._sColumnREQUESTOR));
                session.setId((String)id);
                String sTGTID = rs.getString(this._sColumnTGT_ID);
                if (sTGTID != null) {
                    session.setTGTId(sTGTID);
                }
                session.setState(SessionState.values()[rs.getInt(this._sColumnSTATE)]);
                String sUrl = rs.getString(this._sColumnURL);
                if (sUrl != null) {
                    session.setProfileURL(sUrl);
                }
                if ((oUser = (IUser)Serialize.decode((byte[])rs.getBytes(this._sColumnOWNER))) != null) {
                    session.setUser(oUser);
                }
                session.setExpTime(rs.getTimestamp(this._sColumnEXPIRATION).getTime());
                session.setForcedAuthentication(rs.getBoolean(this._sColumnFORCED_AUTHENTICATE));
                session.setPassive(rs.getBoolean(this._sColumnPASSIVE));
                SessionAttributes oAttributes = (SessionAttributes)Serialize.decode((byte[])rs.getBytes(this._sColumnATTRIBUTES));
                if (oAttributes != null) {
                    session.setAttributes(oAttributes);
                }
                if ((sForcedUid = rs.getString(this._sColumnFORCED_USERID)) != null) {
                    session.setForcedUserID(sForcedUid);
                }
                if ((oLocale = (Locale)Serialize.decode((byte[])rs.getBytes(this._sColumnLOCALE))) != null) {
                    session.setLocale(oLocale);
                }
                if ((listProfiles = (List)Serialize.decode((byte[])rs.getBytes(this._sColumnAUTHN_PROFILES))) != null) {
                    session.setAuthNProfiles(listProfiles);
                }
                if ((oProfile = (AuthenticationProfile)Serialize.decode((byte[])rs.getBytes(this._sColumnSELECTED_AUTHN_PROFILE))) != null) {
                    session.setSelectedAuthNProfile((IAuthenticationProfile)oProfile);
                }
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)("Could not execute search query: " + this._sSearchQuery), (Throwable)e);
            throw new PersistenceException(35);
        }
        catch (ClassCastException e) {
            this._logger.error((Object)"Could not decode, invalid class type", (Throwable)e);
            throw new PersistenceException(35);
        }
        catch (Exception e) {
            this._logger.error((Object)("Internal error during retrieve of session id: " + id), (Throwable)e);
            throw new PersistenceException(35);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return session;
    }

    public void persist(JDBCSession session) throws PersistenceException {
        block38: {
            if (session == null) {
                throw new IllegalArgumentException("Suplied session is empty or invalid");
            }
            Connection oConnection = null;
            Statement psInsert = null;
            Statement psDelete = null;
            Statement psUpdate = null;
            String id = session.getId();
            try {
                oConnection = this._oDataSource.getConnection();
                if (id == null) {
                    try {
                        byte[] baId = new byte[16];
                        do {
                            this._random.nextBytes(baId);
                            try {
                                id = ModifiedBase64.encode((byte[])baId);
                            }
                            catch (UnsupportedEncodingException e) {
                                this._logger.error((Object)("Could not create id for byte[]: " + baId), (Throwable)e);
                                throw new PersistenceException(1);
                            }
                        } while (this.exists(id));
                        long expiration = System.currentTimeMillis() + this._lExpiration;
                        session.setTgtExpTime(expiration);
                        session.setId(id);
                        psInsert = oConnection.prepareStatement(this._sInsertQuery);
                        psInsert.setString(1, id);
                        psInsert.setString(2, session.getTGTId());
                        psInsert.setInt(3, session.getState().ordinal());
                        psInsert.setString(4, session.getRequestorId());
                        psInsert.setString(5, session.getProfileURL());
                        psInsert.setBytes(6, Serialize.encode((Object)session.getUser()));
                        psInsert.setTimestamp(7, new Timestamp(expiration));
                        psInsert.setBoolean(8, session.isForcedAuthentication());
                        psInsert.setBoolean(9, session.isPassive());
                        psInsert.setBytes(10, Serialize.encode((Object)session.getAttributes()));
                        psInsert.setString(11, session.getForcedUserID());
                        psInsert.setBytes(12, Serialize.encode((Object)session.getLocale()));
                        psInsert.setBytes(13, Serialize.encode((Object)session.getSelectedAuthNProfile()));
                        psInsert.setBytes(14, Serialize.encode((Object)session.getAuthNProfiles()));
                        int i = psInsert.executeUpdate();
                        this._logger.info((Object)(i + " new session(s) added: " + id + " for requestor '" + session.getRequestorId() + "'"));
                        break block38;
                    }
                    catch (SQLException e) {
                        this._logger.error((Object)("Could not execute insert query: " + this._sInsertQuery), (Throwable)e);
                        throw new PersistenceException(34);
                    }
                }
                if (session.isExpired()) {
                    try {
                        this._logger.info((Object)("Session Expired: " + id));
                        this._eventLogger.info((Object)new UserEventLogItem((ISession)session, null, UserEvent.SESSION_EXPIRED, (IAuthority)this, null));
                        psDelete = oConnection.prepareStatement(this._sRemoveQuery);
                        psDelete.setString(1, id);
                        int i = psDelete.executeUpdate();
                        this._logger.debug((Object)(i + " session(s) removed: " + id));
                        break block38;
                    }
                    catch (SQLException e) {
                        this._logger.error((Object)("Could not execute delete query: " + this._sRemoveQuery), (Throwable)e);
                        throw new PersistenceException(37);
                    }
                }
                try {
                    long expiration = System.currentTimeMillis() + this._lExpiration;
                    session.setExpTime(expiration);
                    psUpdate = oConnection.prepareStatement(this._sUpdateQuery);
                    psUpdate.setString(1, session.getTGTId());
                    psUpdate.setInt(2, session.getState().ordinal());
                    psUpdate.setString(3, session.getRequestorId());
                    psUpdate.setString(4, session.getProfileURL());
                    psUpdate.setBytes(5, Serialize.encode((Object)session.getUser()));
                    psUpdate.setTimestamp(6, new Timestamp(expiration));
                    psUpdate.setBoolean(7, session.isForcedAuthentication());
                    psUpdate.setBoolean(8, session.isPassive());
                    psUpdate.setBytes(9, Serialize.encode((Object)session.getAttributes()));
                    psUpdate.setString(10, session.getForcedUserID());
                    psUpdate.setBytes(11, Serialize.encode((Object)session.getLocale()));
                    psUpdate.setBytes(12, Serialize.encode((Object)session.getSelectedAuthNProfile()));
                    psUpdate.setBytes(13, Serialize.encode((Object)session.getAuthNProfiles()));
                    psUpdate.setString(14, id);
                    int i = psUpdate.executeUpdate();
                    this._logger.info((Object)(i + " session(s) updated: " + id + " for requestor '" + session.getRequestorId() + "'"));
                }
                catch (SQLException e) {
                    this._logger.error((Object)("Could not execute update query: " + this._sUpdateQuery), (Throwable)e);
                    throw new PersistenceException(36);
                }
            }
            catch (PersistenceException e) {
                throw e;
            }
            catch (Exception e) {
                this._logger.error((Object)("Internal error during persist of session with id: " + id), (Throwable)e);
                throw new PersistenceException(36);
            }
            finally {
                try {
                    if (psInsert != null) {
                        psInsert.close();
                    }
                }
                catch (SQLException e) {
                    this._logger.debug((Object)"Could not close insert statement", (Throwable)e);
                }
                try {
                    if (psDelete != null) {
                        psDelete.close();
                    }
                }
                catch (SQLException e) {
                    this._logger.debug((Object)"Could not close delete statement", (Throwable)e);
                }
                try {
                    if (psUpdate != null) {
                        psUpdate.close();
                    }
                }
                catch (SQLException e) {
                    this._logger.debug((Object)"Could not close update statement", (Throwable)e);
                }
                try {
                    if (oConnection != null) {
                        oConnection.close();
                    }
                }
                catch (SQLException e) {
                    this._logger.debug((Object)"Could not close connection", (Throwable)e);
                }
            }
        }
    }

    public void persist(JDBCSession[] sessions) throws PersistenceException {
        if (sessions == null) {
            throw new IllegalArgumentException("Suplied session array is empty or invalid");
        }
        Connection connection = null;
        Statement psInsert = null;
        Statement psDelete = null;
        Statement psUpdate = null;
        try {
            int[] iResult;
            connection = this._oDataSource.getConnection();
            connection.setAutoCommit(false);
            psInsert = connection.prepareStatement(this._sInsertQuery);
            psDelete = connection.prepareStatement(this._sRemoveQuery);
            psUpdate = connection.prepareStatement(this._sUpdateQuery);
            for (JDBCSession session : sessions) {
                String id = session.getId();
                if (id == null) {
                    byte[] baId = new byte[16];
                    do {
                        this._random.nextBytes(baId);
                        try {
                            id = ModifiedBase64.encode((byte[])baId);
                        }
                        catch (UnsupportedEncodingException e) {
                            this._logger.error((Object)("Could not create id for byte[]: " + baId), (Throwable)e);
                            throw new PersistenceException(1);
                        }
                    } while (this.exists(id));
                    session.setId(id);
                    long expiration = System.currentTimeMillis() + this._lExpiration;
                    session.setTgtExpTime(expiration);
                    psInsert.setString(1, id);
                    psInsert.setString(2, session.getTGTId());
                    psInsert.setInt(3, session.getState().ordinal());
                    psInsert.setString(4, session.getRequestorId());
                    psInsert.setString(5, session.getProfileURL());
                    psInsert.setBytes(6, Serialize.encode((Object)session.getUser()));
                    psInsert.setTimestamp(7, new Timestamp(expiration));
                    psInsert.setBoolean(8, session.isForcedAuthentication());
                    psInsert.setBoolean(9, session.isPassive());
                    psInsert.setBytes(10, Serialize.encode((Object)session.getAttributes()));
                    psInsert.setString(11, session.getForcedUserID());
                    psInsert.setBytes(12, Serialize.encode((Object)session.getLocale()));
                    psInsert.setBytes(13, Serialize.encode((Object)session.getSelectedAuthNProfile()));
                    psInsert.setBytes(14, Serialize.encode((Object)session.getAuthNProfiles()));
                    psInsert.addBatch();
                    continue;
                }
                if (session.isExpired()) {
                    this._logger.info((Object)("Session Expired: " + id));
                    this._eventLogger.info((Object)new UserEventLogItem((ISession)session, null, UserEvent.SESSION_EXPIRED, (IAuthority)this, null));
                    psDelete.setString(1, id);
                    psDelete.addBatch();
                    continue;
                }
                long expiration = System.currentTimeMillis() + this._lExpiration;
                session.setTgtExpTime(expiration);
                psUpdate.setString(1, session.getTGTId());
                psUpdate.setInt(2, session.getState().ordinal());
                psUpdate.setString(3, session.getRequestorId());
                psUpdate.setString(4, session.getProfileURL());
                psUpdate.setBytes(5, Serialize.encode((Object)session.getUser()));
                psUpdate.setTimestamp(6, new Timestamp(expiration));
                psUpdate.setBoolean(7, session.isForcedAuthentication());
                psInsert.setBoolean(8, session.isPassive());
                psUpdate.setBytes(9, Serialize.encode((Object)session.getAttributes()));
                psUpdate.setString(10, session.getForcedUserID());
                psUpdate.setBytes(11, Serialize.encode((Object)session.getLocale()));
                psUpdate.setBytes(12, Serialize.encode((Object)session.getSelectedAuthNProfile()));
                psUpdate.setBytes(13, Serialize.encode((Object)session.getAuthNProfiles()));
                psUpdate.setString(14, id);
                psUpdate.addBatch();
            }
            try {
                iResult = psInsert.executeBatch();
                if (this._logger.isDebugEnabled()) {
                    int iTotalAdded = 0;
                    for (int i : iResult) {
                        iTotalAdded += i;
                    }
                    this._logger.info((Object)(iTotalAdded + " new session(s) added by batch"));
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not execute insert batch", (Throwable)e);
                throw new PersistenceException(34);
            }
            try {
                iResult = psDelete.executeBatch();
                if (this._logger.isDebugEnabled()) {
                    int iTotalDeleted = 0;
                    for (int i : iResult) {
                        iTotalDeleted += i;
                    }
                    this._logger.info((Object)(iTotalDeleted + " session(s) deleted by batch"));
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not execute delete batch", (Throwable)e);
                throw new PersistenceException(37);
            }
            try {
                iResult = psUpdate.executeBatch();
                if (this._logger.isDebugEnabled()) {
                    int iTotalUpdated = 0;
                    for (int i : iResult) {
                        iTotalUpdated += i;
                    }
                    this._logger.info((Object)(iTotalUpdated + " session(s) updated by batch"));
                }
            }
            catch (SQLException e) {
                this._logger.error((Object)"Could not execute update batch", (Throwable)e);
                throw new PersistenceException(36);
            }
            connection.commit();
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute batch", (Throwable)e);
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                this._logger.warn((Object)"Could not rollback batch", (Throwable)e);
            }
            throw new PersistenceException(1);
        }
        catch (PersistenceException e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                this._logger.warn((Object)"Could not rollback batch", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during session persist", (Throwable)e);
            throw new PersistenceException(33);
        }
        finally {
            try {
                if (psInsert != null) {
                    psInsert.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close insert statement", (Throwable)e);
            }
            try {
                if (psDelete != null) {
                    psDelete.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close delete statement", (Throwable)e);
            }
            try {
                if (psUpdate != null) {
                    psUpdate.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close update statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public void removeExpired() throws PersistenceException {
        Connection oConnection = null;
        Statement ps = null;
        try {
            oConnection = this._oDataSource.getConnection();
            ps = oConnection.prepareStatement(this._sRemoveExpiredQuery);
            ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            int i = ps.executeUpdate();
            if (i > 0) {
                this._logger.info((Object)(i + " session(s) expired"));
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute delete expired", (Throwable)e);
            throw new PersistenceException(37);
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error while delete expired sessions", (Throwable)e);
            throw new PersistenceException(37);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public long poll() throws OAException {
        return this.getSessionCount();
    }

    public String getAuthority() {
        return "SessionFactory";
    }

    private void createQueries(Element eConfig) throws SessionException, ConfigurationException {
        Element eEntity = this._configurationManager.getSection(eConfig, "entity");
        if (eEntity == null) {
            this._logger.info((Object)"No optional 'entity' section found in configuration, using default table and column names");
        } else {
            this._sTableName = this._configurationManager.getParam(eEntity, "table");
            this._sColumnID = this.getIdColumnName(eEntity);
            this._sColumnTGT_ID = this.getColumnName(eEntity, "tgtId");
            this._sColumnSTATE = this.getColumnName(eEntity, COLUMN_STATE);
            this._sColumnREQUESTOR = this.getColumnName(eEntity, "requestorId");
            this._sColumnURL = this.getColumnName(eEntity, "profileURL");
            this._sColumnEXPIRATION = this.getColumnName(eEntity, "expTime");
            this._sColumnFORCED_AUTHENTICATE = this.getColumnName(eEntity, "forcedAuthentication");
            this._sColumnOWNER = this.getColumnName(eEntity, "user");
            this._sColumnATTRIBUTES = this.getColumnName(eEntity, COLUMN_ATTRIBUTES);
            this._sColumnFORCED_USERID = this.getColumnName(eEntity, "forcedUserId");
            this._sColumnLOCALE = this.getColumnName(eEntity, COLUMN_LOCALE);
            this._sColumnSELECTED_AUTHN_PROFILE = this.getColumnName(eEntity, "selectedAuthNProfile");
            this._sColumnAUTHN_PROFILES = this.getColumnName(eEntity, "authenticationProfiles");
            this._sColumnPASSIVE = this.getColumnName(eEntity, COLUMN_PASSIVE);
        }
        if (this._sTableName == null) {
            this._sTableName = TABLE_NAME;
        }
        if (this._sColumnID == null) {
            this._sColumnID = COLUMN_ID;
        }
        if (this._sColumnTGT_ID == null) {
            this._sColumnTGT_ID = COLUMN_TGT_ID;
        }
        if (this._sColumnSTATE == null) {
            this._sColumnSTATE = COLUMN_STATE;
        }
        if (this._sColumnREQUESTOR == null) {
            this._sColumnREQUESTOR = COLUMN_REQUESTOR;
        }
        if (this._sColumnURL == null) {
            this._sColumnURL = COLUMN_URL;
        }
        if (this._sColumnEXPIRATION == null) {
            this._sColumnEXPIRATION = COLUMN_EXPIRATION;
        }
        if (this._sColumnFORCED_AUTHENTICATE == null) {
            this._sColumnFORCED_AUTHENTICATE = COLUMN_FORCED_AUTHENTICATE;
        }
        if (this._sColumnPASSIVE == null) {
            this._sColumnPASSIVE = COLUMN_PASSIVE;
        }
        if (this._sColumnOWNER == null) {
            this._sColumnOWNER = COLUMN_OWNER;
        }
        if (this._sColumnATTRIBUTES == null) {
            this._sColumnATTRIBUTES = COLUMN_ATTRIBUTES;
        }
        if (this._sColumnFORCED_USERID == null) {
            this._sColumnFORCED_USERID = COLUMN_FORCED_USERID;
        }
        if (this._sColumnLOCALE == null) {
            this._sColumnLOCALE = COLUMN_LOCALE;
        }
        if (this._sColumnSELECTED_AUTHN_PROFILE == null) {
            this._sColumnSELECTED_AUTHN_PROFILE = COLUMN_SELECTED_AUTHN_PROFILE;
        }
        if (this._sColumnAUTHN_PROFILES == null) {
            this._sColumnAUTHN_PROFILES = COLUMN_AUTHN_PROFILES;
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append(this._sColumnTGT_ID).append(", ");
        sb.append(this._sColumnSTATE).append(", ");
        sb.append(this._sColumnREQUESTOR).append(", ");
        sb.append(this._sColumnURL).append(", ");
        sb.append(this._sColumnOWNER).append(", ");
        sb.append(this._sColumnEXPIRATION).append(", ");
        sb.append(this._sColumnFORCED_AUTHENTICATE).append(", ");
        sb.append(this._sColumnPASSIVE).append(", ");
        sb.append(this._sColumnATTRIBUTES).append(", ");
        sb.append(this._sColumnFORCED_USERID).append(", ");
        sb.append(this._sColumnLOCALE).append(", ");
        sb.append(this._sColumnSELECTED_AUTHN_PROFILE).append(", ");
        sb.append(this._sColumnAUTHN_PROFILES);
        sb.append(" FROM ").append(this._sTableName);
        sb.append(" WHERE ").append(this._sColumnID).append("=?");
        this._sSearchQuery = sb.toString();
        this._logger.debug((Object)("Using SearchQuery: " + this._sSearchQuery));
        sb = new StringBuffer("SELECT COUNT(");
        sb.append(this._sColumnID).append(") FROM ").append(this._sTableName);
        this._sCountQuery = sb.toString();
        this._logger.debug((Object)("Using CountQuery: " + this._sCountQuery));
        sb = new StringBuffer("INSERT INTO ");
        sb.append(this._sTableName).append("(");
        sb.append(this._sColumnID).append(",");
        sb.append(this._sColumnTGT_ID).append(",");
        sb.append(this._sColumnSTATE).append(",");
        sb.append(this._sColumnREQUESTOR).append(",");
        sb.append(this._sColumnURL).append(",");
        sb.append(this._sColumnOWNER).append(",");
        sb.append(this._sColumnEXPIRATION).append(",");
        sb.append(this._sColumnFORCED_AUTHENTICATE).append(",");
        sb.append(this._sColumnPASSIVE).append(",");
        sb.append(this._sColumnATTRIBUTES).append(",");
        sb.append(this._sColumnFORCED_USERID).append(",");
        sb.append(this._sColumnLOCALE).append(",");
        sb.append(this._sColumnSELECTED_AUTHN_PROFILE).append(",");
        sb.append(this._sColumnAUTHN_PROFILES);
        sb.append(") VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        this._sInsertQuery = sb.toString();
        this._logger.debug((Object)("Using InsertQuery: " + this._sInsertQuery));
        sb = new StringBuffer("UPDATE ");
        sb.append(this._sTableName).append(" SET ");
        sb.append(this._sColumnTGT_ID).append("=?, ");
        sb.append(this._sColumnSTATE).append("=?, ");
        sb.append(this._sColumnREQUESTOR).append("=?, ");
        sb.append(this._sColumnURL).append("=?, ");
        sb.append(this._sColumnOWNER).append("=?, ");
        sb.append(this._sColumnEXPIRATION).append("=?, ");
        sb.append(this._sColumnFORCED_AUTHENTICATE).append("=?, ");
        sb.append(this._sColumnPASSIVE).append("=?, ");
        sb.append(this._sColumnATTRIBUTES).append("=?, ");
        sb.append(this._sColumnFORCED_USERID).append("=?, ");
        sb.append(this._sColumnLOCALE).append("=?, ");
        sb.append(this._sColumnSELECTED_AUTHN_PROFILE).append("=?, ");
        sb.append(this._sColumnAUTHN_PROFILES).append("=? WHERE  ");
        sb.append(this._sColumnID).append("=?");
        this._sUpdateQuery = sb.toString();
        this._logger.debug((Object)("Using UpdateQuery: " + this._sUpdateQuery));
        sb = new StringBuffer("DELETE FROM ");
        sb.append(this._sTableName).append(" WHERE ");
        sb.append(this._sColumnID).append("=?");
        this._sRemoveQuery = sb.toString();
        this._logger.debug((Object)("Using RemoveQuery: " + this._sRemoveQuery));
        sb = new StringBuffer("DELETE FROM ");
        sb.append(this._sTableName).append(" WHERE ");
        sb.append(this._sColumnEXPIRATION).append("<=?");
        this._sRemoveExpiredQuery = sb.toString();
        this._logger.debug((Object)("Using RemoveExpiredQuery: " + this._sRemoveExpiredQuery));
    }

    private void verifyTableConfig(Element eConfig) throws OAException {
        Connection oConnection = null;
        Statement pVerify = null;
        try {
            String sVerificationQuery;
            block29: {
                try {
                    oConnection = this._oDataSource.getConnection();
                }
                catch (SQLException e) {
                    this._logger.error((Object)"Could not connect to resource", (Throwable)e);
                    throw new DatabaseException(2);
                }
                sVerificationQuery = null;
                try {
                    Element eValidation = this._configurationManager.getSection(eConfig, "validation");
                    if (eValidation == null || (sVerificationQuery = this._configurationManager.getParam(eValidation, "query")) != null && sVerificationQuery.length() != 0) break block29;
                    this._logger.warn((Object)"Empty validation query found, table structure is not validated");
                    return;
                }
                catch (ConfigurationException e) {
                    this._logger.error((Object)"Invalid validation query found", (Throwable)e);
                    throw new DatabaseException(17);
                }
            }
            if (sVerificationQuery == null) {
                StringBuffer sbVerificationQuery = new StringBuffer("SELECT ");
                sbVerificationQuery.append(this._sColumnID).append(",");
                sbVerificationQuery.append(this._sColumnTGT_ID).append(",");
                sbVerificationQuery.append(this._sColumnSTATE).append(",");
                sbVerificationQuery.append(this._sColumnREQUESTOR).append(",");
                sbVerificationQuery.append(this._sColumnURL).append(",");
                sbVerificationQuery.append(this._sColumnEXPIRATION).append(",");
                sbVerificationQuery.append(this._sColumnFORCED_AUTHENTICATE).append(",");
                sbVerificationQuery.append(this._sColumnPASSIVE).append(",");
                sbVerificationQuery.append(this._sColumnOWNER).append(",");
                sbVerificationQuery.append(this._sColumnATTRIBUTES).append(",");
                sbVerificationQuery.append(this._sColumnFORCED_USERID).append(",");
                sbVerificationQuery.append(this._sColumnLOCALE).append(",");
                sbVerificationQuery.append(this._sColumnSELECTED_AUTHN_PROFILE).append(",");
                sbVerificationQuery.append(this._sColumnAUTHN_PROFILES);
                sbVerificationQuery.append(" FROM ");
                sbVerificationQuery.append(this._sTableName);
                sbVerificationQuery.append(" LIMIT 1");
                sVerificationQuery = sbVerificationQuery.toString();
                this._logger.info((Object)("No validation query found, using default: " + sVerificationQuery));
            }
            pVerify = oConnection.prepareStatement(sVerificationQuery);
            try {
                pVerify.executeQuery();
            }
            catch (Exception e) {
                StringBuffer sbError = new StringBuffer("Invalid table configured '");
                sbError.append(this._sTableName);
                sbError.append("' verified with query: ");
                sbError.append(sVerificationQuery);
                this._logger.error((Object)sbError.toString(), (Throwable)e);
                throw new DatabaseException(2);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during verification of configured table", (Throwable)e);
            throw new OAException(2);
        }
        finally {
            try {
                if (pVerify != null) {
                    pVerify.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    private String getIdColumnName(Element eConfig) throws SessionException, ConfigurationException {
        String sIdColumn = null;
        if (eConfig != null) {
            Element eIdColumn = this._configurationManager.getSection(eConfig, COLUMN_ID);
            if (eIdColumn == null) {
                this._logger.error((Object)"No optional 'id' section found");
            } else {
                sIdColumn = this._configurationManager.getParam(eIdColumn, "column");
                if (sIdColumn == null) {
                    this._logger.error((Object)"Could not find column name for id");
                    throw new SessionException(17);
                }
            }
        }
        return sIdColumn;
    }

    private String getColumnName(Element eConfig, String sName) throws SessionException, ConfigurationException {
        String sColumn = null;
        if (eConfig != null || sName != null) {
            Element eColumn = this._configurationManager.getSection(eConfig, "property", "name=" + sName);
            if (eColumn == null) {
                this._logger.warn((Object)("No optional 'property' section found for property with name: " + sName));
            } else {
                sColumn = this._configurationManager.getParam(eColumn, "column");
                if (sColumn == null) {
                    this._logger.error((Object)("Could not find column name for property " + sName));
                    throw new SessionException(17);
                }
            }
        }
        return sColumn;
    }

    private int getSessionCount() throws SessionException {
        Connection oConnection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int iRet = 0;
        try {
            oConnection = this._oDataSource.getConnection();
            ps = oConnection.prepareStatement(this._sCountQuery);
            rs = ps.executeQuery();
            if (rs.next()) {
                iRet = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            this._logger.error((Object)"Could not execute count query", (Throwable)e);
            throw new SessionException(35);
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during session count retrieval", (Throwable)e);
            throw new SessionException(35);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (SQLException e) {
                this._logger.debug((Object)"Could not close connection", (Throwable)e);
            }
        }
        return iRet;
    }
}

