/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.requestor.configuration;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.engine.core.requestor.Requestor;
import com.alfaariss.oa.engine.core.requestor.RequestorException;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Element;

public class ConfigurationPool
extends RequestorPool {
    private static final Log _logger = LogFactory.getLog(ConfigurationPool.class);

    public ConfigurationPool(IConfigurationManager oConfigurationManager, Element eConfig) throws RequestorException {
        try {
            this._sID = oConfigurationManager.getParam(eConfig, "id");
            if (this._sID == null) {
                _logger.error((Object)"No 'id' item in 'pool' section found in configuration");
                throw new RequestorException(17);
            }
            this._sFriendlyName = oConfigurationManager.getParam(eConfig, "friendlyname");
            if (this._sFriendlyName == null) {
                _logger.error((Object)"No 'friendlyname' item in 'pool' section found in configuration");
                throw new RequestorException(17);
            }
            this._bEnabled = true;
            String sEnabled = oConfigurationManager.getParam(eConfig, "enabled");
            if (sEnabled != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new RequestorException(17);
                }
            }
            this.readPoolConfiguration(oConfigurationManager, eConfig);
        }
        catch (RequestorException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during pool object creation", (Throwable)e);
            throw new RequestorException(1);
        }
    }

    private void readPoolConfiguration(IConfigurationManager oConfigurationManager, Element eConfig) throws RequestorException {
        try {
            Element eProperties;
            Element eAuthentication;
            Element eAttributeRelease;
            Element eAuthorization = oConfigurationManager.getSection(eConfig, "authorization");
            if (eAuthorization != null) {
                Element ePost;
                Element ePre = oConfigurationManager.getSection(eAuthorization, "pre");
                if (ePre != null) {
                    this._sPreAuthorizationProfileID = oConfigurationManager.getParam(ePre, "profile");
                }
                if ((ePost = oConfigurationManager.getSection(eAuthorization, "post")) != null) {
                    this._sPostAuthorizationProfileID = oConfigurationManager.getParam(ePost, "profile");
                }
            }
            if ((eAttributeRelease = oConfigurationManager.getSection(eConfig, "attributerelease")) != null) {
                this._sAttributeReleasePolicyID = oConfigurationManager.getParam(eAttributeRelease, "policy");
            }
            if ((eAuthentication = oConfigurationManager.getSection(eConfig, "authentication")) != null) {
                this._bForcedAuthenticate = false;
                String sForced = oConfigurationManager.getParam(eAuthentication, "forced");
                if (sForced != null) {
                    if (sForced.equalsIgnoreCase("TRUE")) {
                        this._bForcedAuthenticate = true;
                    } else if (!sForced.equalsIgnoreCase("FALSE")) {
                        StringBuffer sbError = new StringBuffer("Wrong configuration in requestor pool with id '");
                        sbError.append(this._sID);
                        sbError.append("': Unknown value in 'forced' configuration item: ");
                        sbError.append(sForced);
                        _logger.error((Object)sbError.toString());
                        throw new RequestorException(17);
                    }
                }
                Element eAuthProfile = oConfigurationManager.getSection(eAuthentication, "profile");
                while (eAuthProfile != null) {
                    this.addAuthenticationProfileID(oConfigurationManager.getParam(eAuthProfile, "id"));
                    eAuthProfile = oConfigurationManager.getNextSection(eAuthProfile);
                }
            }
            if ((eProperties = oConfigurationManager.getSection(eConfig, "properties")) == null) {
                _logger.info((Object)("No 'properties' section found, no extended properties found for requestorpool: " + this._sID));
                this._properties = new Properties();
            } else {
                this._properties = this.readExtendedProperties(oConfigurationManager, eProperties);
            }
            Element eRequestors = oConfigurationManager.getSection(eConfig, "requestors");
            if (eRequestors == null) {
                _logger.error((Object)"No 'requestors' section found");
                throw new RequestorException(17);
            }
            Element eRequestor = oConfigurationManager.getSection(eRequestors, "requestor");
            while (eRequestor != null) {
                Requestor oRequestor = this.createRequestor(oConfigurationManager, eRequestor);
                if (oRequestor != null) {
                    this.addRequestor((IRequestor)oRequestor);
                }
                eRequestor = oConfigurationManager.getNextSection(eRequestor);
            }
        }
        catch (RequestorException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during pool object update", (Throwable)e);
            throw new RequestorException(1);
        }
    }

    private Requestor createRequestor(IConfigurationManager oConfigurationManager, Element eConfig) throws RequestorException {
        Requestor oRequestor = null;
        try {
            String sID = oConfigurationManager.getParam(eConfig, "id");
            if (sID == null) {
                _logger.error((Object)"No 'id' item in 'requestor' section found in configuration");
                throw new RequestorException(17);
            }
            String sEnabled = oConfigurationManager.getParam(eConfig, "enabled");
            boolean bEnabled = true;
            if (sEnabled != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    bEnabled = false;
                } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new RequestorException(17);
                }
            }
            if (!bEnabled) {
                StringBuffer sbInfo = new StringBuffer("Requestor with id '");
                sbInfo.append(sID);
                sbInfo.append("' is disabled");
                _logger.info((Object)sbInfo.toString());
                return null;
            }
            String sFriendlyName = oConfigurationManager.getParam(eConfig, "friendlyname");
            if (sFriendlyName == null) {
                _logger.error((Object)"No 'friendlyname' item in 'requestor' section found in configuration");
                throw new RequestorException(17);
            }
            Element eProperties = oConfigurationManager.getSection(eConfig, "properties");
            Properties properties = null;
            if (eProperties == null) {
                _logger.info((Object)("No 'properties' section found, no extended properties found for requestor: " + sID));
                properties = new Properties();
            } else {
                properties = this.readExtendedProperties(oConfigurationManager, eProperties);
            }
            String sDateLastModified = oConfigurationManager.getParam(eConfig, "lastmodified");
            Date dLastModified = null;
            if (sDateLastModified != null) {
                try {
                    DateTime dt = ISODateTimeFormat.dateTimeNoMillis().parseDateTime(sDateLastModified);
                    dLastModified = dt.toDate();
                }
                catch (IllegalArgumentException iae) {
                    _logger.info((Object)("Invalid 'lastmodified' timestamp provided: " + sDateLastModified + "; ignoring."));
                    dLastModified = null;
                }
            }
            oRequestor = new Requestor(sID, sFriendlyName, bEnabled, properties, dLastModified);
            _logger.info((Object)("Found: " + oRequestor));
        }
        catch (RequestorException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during pool object update", (Throwable)e);
            throw new RequestorException(1, (Throwable)e);
        }
        return oRequestor;
    }

    private Properties readExtendedProperties(IConfigurationManager config, Element eProperties) throws OAException {
        Properties prop = new Properties();
        Element eProperty = config.getSection(eProperties, "property");
        while (eProperty != null) {
            String sName = config.getParam(eProperty, "name");
            if (sName == null) {
                _logger.error((Object)"No 'name' item found in 'property' section in configuration");
                throw new OAException(17);
            }
            if (prop.containsKey(sName)) {
                _logger.error((Object)("Duplicate 'name' item found in 'property' section in configuration, property is not added: " + sName));
                throw new OAException(17);
            }
            String sValue = config.getParam(eProperty, "value");
            if (sValue == null) {
                _logger.error((Object)"No 'value' item found in 'property' section in configuration");
                throw new OAException(17);
            }
            prop.put(sName, sValue);
            eProperty = config.getNextSection(eProperty);
        }
        return prop;
    }
}

