/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.requestor.configuration;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.engine.core.requestor.RequestorException;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.requestor.factory.IRequestorPoolFactory;
import com.alfaariss.oa.engine.requestor.configuration.ConfigurationPool;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ConfigurationFactory
implements IRequestorPoolFactory,
IComponent {
    private static Log _logger;
    private IConfigurationManager _configurationManager;
    private Element _eConfig;
    private HashMap<String, RequestorPool> _mapPools;
    private HashMap<String, IRequestor> _mapRequestors;

    public ConfigurationFactory() {
        _logger = LogFactory.getLog(ConfigurationFactory.class);
        this._mapPools = new HashMap();
        this._mapRequestors = new HashMap();
        this._eConfig = null;
    }

    public RequestorPool getRequestorPool(String sRequestor) throws RequestorException {
        for (RequestorPool oRequestorPool : this._mapPools.values()) {
            if (!oRequestorPool.existRequestor(sRequestor)) continue;
            return oRequestorPool;
        }
        return null;
    }

    public IRequestor getRequestor(String sRequestor) throws RequestorException {
        return this._mapRequestors.get(sRequestor);
    }

    public boolean isPool(String sPoolID) {
        if (this._mapPools != null) {
            return this._mapPools.containsKey(sPoolID);
        }
        return false;
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            this._configurationManager = oConfigurationManager;
            this._eConfig = eConfig;
            Element ePool = this._configurationManager.getSection(eConfig, "pool");
            while (ePool != null) {
                ConfigurationPool oRequestorPool = new ConfigurationPool(this._configurationManager, ePool);
                for (IRequestor oRequestor : oRequestorPool.getRequestors()) {
                    if (this._mapRequestors.containsKey(oRequestor.getID())) {
                        StringBuffer sbError = new StringBuffer("Duplicate entry for requestor with id '");
                        sbError.append(oRequestor.getID());
                        sbError.append("' in pool: ");
                        sbError.append(oRequestorPool.getID());
                        _logger.error((Object)sbError.toString());
                        throw new RequestorException(2);
                    }
                    this._mapRequestors.put(oRequestor.getID(), oRequestor);
                }
                if (this._mapPools.containsKey(oRequestorPool.getID())) {
                    _logger.error((Object)("Duplicate entry for requestorpool with id: " + oRequestorPool.getID()));
                    throw new RequestorException(2);
                }
                this._mapPools.put(oRequestorPool.getID(), oRequestorPool);
                ePool = this._configurationManager.getNextSection(ePool);
            }
        }
        catch (RequestorException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new RequestorException(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        ConfigurationFactory configurationFactory = this;
        synchronized (configurationFactory) {
            this.stop();
            this.start(this._configurationManager, eConfig);
        }
    }

    public void stop() {
        if (this._mapPools != null) {
            this._mapPools.clear();
        }
        if (this._mapRequestors != null) {
            this._mapRequestors.clear();
        }
        this._eConfig = null;
    }

    public Collection<RequestorPool> getAllEnabledRequestorPools() throws RequestorException {
        Vector<RequestorPool> collPools = new Vector<RequestorPool>();
        if (this._mapPools != null) {
            for (RequestorPool pool : this._mapPools.values()) {
                if (!pool.isEnabled()) continue;
                collPools.add(pool);
            }
        }
        return Collections.unmodifiableCollection(collPools);
    }

    public Collection<RequestorPool> getAllRequestorPools() throws RequestorException {
        if (this._mapPools == null) {
            return Collections.unmodifiableCollection(new Vector());
        }
        return Collections.unmodifiableCollection(this._mapPools.values());
    }

    public Collection<IRequestor> getAllEnabledRequestors() throws RequestorException {
        Vector<IRequestor> collRequestors = new Vector<IRequestor>();
        if (this._mapRequestors != null) {
            for (IRequestor requestor : this._mapRequestors.values()) {
                if (!requestor.isEnabled()) continue;
                collRequestors.add(requestor);
            }
        }
        return Collections.unmodifiableCollection(collRequestors);
    }

    public Collection<IRequestor> getAllRequestors() throws RequestorException {
        if (this._mapRequestors == null) {
            return Collections.unmodifiableCollection(new Vector());
        }
        return Collections.unmodifiableCollection(this._mapRequestors.values());
    }

    public boolean isRequestor(String requestorID) throws RequestorException {
        if (this._mapRequestors != null) {
            return this._mapRequestors.containsKey(requestorID);
        }
        return false;
    }

    public IRequestor getRequestor(Object id, String type) throws RequestorException {
        try {
            Element ePool = this._configurationManager.getSection(this._eConfig, "pool");
            while (ePool != null) {
                Element eRequestors = this._configurationManager.getSection(ePool, "requestors");
                if (eRequestors != null) {
                    Element eRequestor = this._configurationManager.getSection(eRequestors, "requestor");
                    while (eRequestor != null) {
                        String sID;
                        String sType = this._configurationManager.getParam(eRequestor, type);
                        if (sType != null && sType.equals(String.valueOf(id)) && (sID = this._configurationManager.getParam(eRequestor, "id")) != null) {
                            return this._mapRequestors.get(sID);
                        }
                        eRequestor = this._configurationManager.getNextSection(eRequestor);
                    }
                }
                ePool = this._configurationManager.getNextSection(ePool);
            }
            return null;
        }
        catch (ConfigurationException e) {
            throw new RequestorException(17);
        }
    }

    public boolean isRequestorIDSupported(String type) throws RequestorException {
        try {
            Element ePool = this._configurationManager.getSection(this._eConfig, "pool");
            while (ePool != null) {
                Element eRequestors = this._configurationManager.getSection(ePool, "requestors");
                if (eRequestors != null) {
                    Element eRequestor = this._configurationManager.getSection(eRequestors, "requestor");
                    while (eRequestor != null) {
                        String sType = this._configurationManager.getParam(eRequestor, type);
                        if (sType != null) {
                            return true;
                        }
                        eRequestor = this._configurationManager.getNextSection(eRequestor);
                    }
                }
                ePool = this._configurationManager.getNextSection(ePool);
            }
        }
        catch (ConfigurationException e) {
            throw new RequestorException(17);
        }
        return false;
    }
}

