/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.idp.storage.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.datastorage.IDataStorageFactory;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.idp.storage.IIDP;
import com.alfaariss.oa.engine.core.idp.storage.IIDPStorage;
import com.alfaariss.oa.util.database.DatabaseException;
import com.alfaariss.oa.util.database.jdbc.DataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public abstract class AbstractJDBCStorage<IDP extends IIDP>
implements IIDPStorage {
    private static Log _logger;
    protected DataSource _dataSource;

    public AbstractJDBCStorage() {
        _logger = LogFactory.getLog(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(IConfigurationManager configManager, Element config) throws OAException {
        Connection oConnection = null;
        try {
            block21: {
                Element eResource = configManager.getSection(config, "resource");
                if (eResource == null) {
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._dataSource = databaseFactory.createModelDatasource();
                        if (this._dataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                        break block21;
                    } else {
                        _logger.error((Object)"Could not create a valid datasource");
                        throw new DatabaseException(2);
                    }
                }
                try {
                    this._dataSource = DataSourceFactory.createDataSource((IConfigurationManager)configManager, (Element)eResource);
                    _logger.info((Object)"Using datasource specified in 'resource' section in configuration");
                }
                catch (DatabaseException e) {
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._dataSource = databaseFactory.createModelDatasource();
                        if (this._dataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                    }
                    _logger.error((Object)"Could not create a valid datasource", (Throwable)e);
                    throw new DatabaseException(2);
                }
            }
            try {
                oConnection = this._dataSource.getConnection();
                return;
            }
            catch (SQLException e) {
                _logger.error((Object)"Could not connect to resource", (Throwable)e);
                throw new DatabaseException(2);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during start", (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public void stop() {
        this._dataSource = null;
    }
}

