/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.authorization.configuration;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.engine.authorization.configuration.ConfigurationProfile;
import com.alfaariss.oa.engine.core.authorization.AuthorizationException;
import com.alfaariss.oa.engine.core.authorization.AuthorizationProfile;
import com.alfaariss.oa.engine.core.authorization.factory.IAuthorizationFactory;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ConfigurationFactory
implements IAuthorizationFactory,
IComponent {
    private static Log _logger;
    private IConfigurationManager _configurationManager;
    private boolean _bEnabled;
    private HashMap<String, AuthorizationProfile> _mapProfiles;

    public ConfigurationFactory() {
        _logger = LogFactory.getLog(ConfigurationFactory.class);
        this._mapProfiles = new HashMap();
        this._bEnabled = true;
    }

    public AuthorizationProfile getProfile(String id) throws AuthorizationException {
        return this._mapProfiles.get(id);
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            this._configurationManager = oConfigurationManager;
            String sEnabled = this._configurationManager.getParam(eConfig, "enabled");
            if (sEnabled != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else if (sEnabled.equalsIgnoreCase("TRUE")) {
                    this._bEnabled = true;
                } else {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new AuthorizationException(17);
                }
            }
            Element eProfile = this._configurationManager.getSection(eConfig, "profile");
            while (eProfile != null) {
                ConfigurationProfile oProfile = new ConfigurationProfile(this._configurationManager, eProfile);
                this._mapProfiles.put(oProfile.getID(), oProfile);
                eProfile = this._configurationManager.getNextSection(eProfile);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new AuthorizationException(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        ConfigurationFactory configurationFactory = this;
        synchronized (configurationFactory) {
            this.stop();
            this.start(this._configurationManager, eConfig);
        }
    }

    public void stop() {
        if (this._mapProfiles != null) {
            this._mapProfiles.clear();
        }
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }
}

