/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.authorization.configuration;

import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.engine.authorization.configuration.ConfigurationMethod;
import com.alfaariss.oa.engine.core.authentication.AuthenticationException;
import com.alfaariss.oa.engine.core.authorization.AuthorizationException;
import com.alfaariss.oa.engine.core.authorization.AuthorizationProfile;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ConfigurationProfile
extends AuthorizationProfile {
    private static Log _logger;

    public ConfigurationProfile(IConfigurationManager oConfigurationManager, Element eConfig) throws AuthorizationException {
        try {
            _logger = LogFactory.getLog(ConfigurationProfile.class);
            this._sID = oConfigurationManager.getParam(eConfig, "id");
            if (this._sID == null) {
                _logger.error((Object)"No 'id' item in 'profile' section found in configuration");
                throw new AuthorizationException(17);
            }
            this._sFriendlyName = oConfigurationManager.getParam(eConfig, "friendlyname");
            if (this._sFriendlyName == null) {
                _logger.error((Object)"No 'friendlyname' item in 'profile' section found in configuration");
                throw new AuthorizationException(17);
            }
            String sEnabled = oConfigurationManager.getParam(eConfig, "enabled");
            if (sEnabled != null) {
                if (sEnabled.equalsIgnoreCase("TRUE")) {
                    this._bEnabled = true;
                } else if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new AuthorizationException(17);
                }
            }
            this._listAuthorizationMethod = new Vector();
            Element eMethod = oConfigurationManager.getSection(eConfig, "method");
            if (eMethod == null) {
                _logger.error((Object)("No methods found in authz profile: " + this._sID));
                throw new AuthenticationException(17);
            }
            while (eMethod != null) {
                this._listAuthorizationMethod.add(new ConfigurationMethod(oConfigurationManager, eMethod));
                eMethod = oConfigurationManager.getNextSection(eMethod);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new AuthorizationException(1);
        }
    }
}

