/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.authentication.jdbc;

import com.alfaariss.oa.api.authentication.IAuthenticationMethod;
import com.alfaariss.oa.engine.authentication.jdbc.JDBCMethod;
import com.alfaariss.oa.engine.core.authentication.AuthenticationException;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCProfile
extends AuthenticationProfile {
    public static final String COLUMN_PROFILE_ID = "id";
    public static final String COLUMN_PROFILE_FRIENDLYNAME = "friendlyname";
    public static final String COLUMN_PROFILE_ENABLED = "enabled";
    public static final String COLUMN_PROPERTY_PROFILE_ID = "profile_id";
    public static final String COLUMN_PROPERTY_NAME = "name";
    public static final String COLUMN_PROPERTY_VALUE = "value";
    public static final String COLUMN_ORDER_ID = "order_id";
    private static final long serialVersionUID = 9142656710779277563L;
    private static Log _logger;

    public JDBCProfile(DataSource oDataSource, ResultSet oResultSet, String sMethodTable, String sProfilePropertiesTable) throws AuthenticationException {
        try {
            _logger = LogFactory.getLog(JDBCProfile.class);
            this._sID = oResultSet.getString(COLUMN_PROFILE_ID);
            this._sFriendlyName = oResultSet.getString(COLUMN_PROFILE_FRIENDLYNAME);
            this._bEnabled = oResultSet.getBoolean(COLUMN_PROFILE_ENABLED);
            this._listAuthenticationMethods = this.readMethods(oDataSource, sMethodTable);
            this.addProperties(oDataSource, sProfilePropertiesTable);
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new AuthenticationException(1);
        }
    }

    public String toString() {
        StringBuffer sbInfo = new StringBuffer("Profile ");
        sbInfo.append(this._sID);
        sbInfo.append(" contains ");
        for (IAuthenticationMethod oMethod : this._listAuthenticationMethods) {
            sbInfo.append("[").append(oMethod).append("]");
        }
        return sbInfo.toString();
    }

    private Vector<IAuthenticationMethod> readMethods(DataSource oDataSource, String sMethodTable) throws AuthenticationException {
        Vector<IAuthenticationMethod> vMethods = new Vector<IAuthenticationMethod>();
        Connection oConnection = null;
        Statement oPreparedStatement = null;
        ResultSet oResultSet = null;
        try {
            oConnection = oDataSource.getConnection();
            StringBuffer sbSelect = new StringBuffer("SELECT * FROM ");
            sbSelect.append(sMethodTable);
            sbSelect.append(" WHERE ");
            sbSelect.append(COLUMN_PROPERTY_PROFILE_ID);
            sbSelect.append("=? ORDER BY ");
            sbSelect.append(COLUMN_ORDER_ID);
            sbSelect.append(" ASC");
            oPreparedStatement = oConnection.prepareStatement(sbSelect.toString());
            oPreparedStatement.setString(1, this._sID);
            oResultSet = oPreparedStatement.executeQuery();
            while (oResultSet.next()) {
                JDBCMethod oMethod = new JDBCMethod(oResultSet);
                vMethods.add((IAuthenticationMethod)oMethod);
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new AuthenticationException(1);
        }
        finally {
            try {
                if (oResultSet != null) {
                    oResultSet.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (oPreparedStatement != null) {
                    oPreparedStatement.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return vMethods;
    }

    private void addProperties(DataSource oDataSource, String sProfilePropertiesTable) throws AuthenticationException {
        Connection oConnection = null;
        Statement oPreparedStatement = null;
        ResultSet rsProperties = null;
        try {
            oConnection = oDataSource.getConnection();
            StringBuffer sbSelectProperties = new StringBuffer("SELECT ");
            sbSelectProperties.append(sProfilePropertiesTable).append(".*");
            sbSelectProperties.append(" FROM ");
            sbSelectProperties.append(sProfilePropertiesTable);
            sbSelectProperties.append(" WHERE ");
            sbSelectProperties.append(sProfilePropertiesTable);
            sbSelectProperties.append(".");
            sbSelectProperties.append(COLUMN_PROPERTY_PROFILE_ID);
            sbSelectProperties.append("=?");
            oPreparedStatement = oConnection.prepareStatement(sbSelectProperties.toString());
            oPreparedStatement.setString(1, this._sID);
            rsProperties = oPreparedStatement.executeQuery();
            this._properties = new Properties();
            while (rsProperties.next()) {
                String sName = rsProperties.getString(COLUMN_PROPERTY_NAME);
                String value = rsProperties.getString(COLUMN_PROPERTY_VALUE);
                this._properties.put(sName, value);
            }
            _logger.debug((Object)("Retrieved properties: " + this._properties));
        }
        catch (SQLException e) {
            _logger.error((Object)"Can not read from database", (Throwable)e);
            throw new AuthenticationException(35);
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during create of an authentication profile", (Throwable)e);
            throw new AuthenticationException(1);
        }
        finally {
            try {
                if (rsProperties != null) {
                    rsProperties.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (oPreparedStatement != null) {
                    oPreparedStatement.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }
}

