/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.authentication.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.datastorage.IDataStorageFactory;
import com.alfaariss.oa.engine.authentication.jdbc.JDBCProfile;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authentication.AuthenticationException;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import com.alfaariss.oa.engine.core.authentication.factory.IAuthenticationProfileFactory;
import com.alfaariss.oa.util.database.DatabaseException;
import com.alfaariss.oa.util.database.jdbc.DataSourceFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JDBCFactory
implements IAuthenticationProfileFactory,
IComponent {
    private static final String TABLE_NAME_PROFILES = "authn_profile";
    private static final String TABLE_NAME_METHODS = "authn_method";
    private static final String TABLE_NAME_PROFILE_PROPS = "authn_profile_properties";
    private static Log _logger;
    private IConfigurationManager _configurationManager;
    private DataSource _oDataSource;
    private String _sProfilesTable;
    private String _sMethodsTable;
    private String _sProfilesPropertiesTable;

    public JDBCFactory() {
        _logger = LogFactory.getLog(JDBCFactory.class);
        this._sProfilesTable = null;
        this._sMethodsTable = null;
        this._sProfilesPropertiesTable = null;
    }

    public AuthenticationProfile getProfile(String sProfile) throws AuthenticationException {
        JDBCProfile oProfile = null;
        Connection oConnection = null;
        Statement oPreparedStatement = null;
        ResultSet oResultSet = null;
        try {
            oConnection = this._oDataSource.getConnection();
            StringBuffer sbSelect = new StringBuffer("SELECT * FROM ");
            sbSelect.append(this._sProfilesTable);
            sbSelect.append(" WHERE ");
            sbSelect.append("id");
            sbSelect.append("=?");
            oPreparedStatement = oConnection.prepareStatement(sbSelect.toString());
            oPreparedStatement.setString(1, sProfile);
            oResultSet = oPreparedStatement.executeQuery();
            if (oResultSet.next()) {
                oProfile = new JDBCProfile(this._oDataSource, oResultSet, this._sMethodsTable, this._sProfilesPropertiesTable);
            }
            _logger.debug((Object)("Retrieved profile: " + oProfile));
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during retrieval of profile: " + sProfile), (Throwable)e);
            throw new AuthenticationException(1);
        }
        finally {
            try {
                if (oResultSet != null) {
                    oResultSet.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (oPreparedStatement != null) {
                    oPreparedStatement.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return oProfile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        Connection oConnection = null;
        try {
            Element eMethods;
            Element eResource;
            block33: {
                this._configurationManager = oConfigurationManager;
                eResource = this._configurationManager.getSection(eConfig, "resource");
                if (eResource == null) {
                    _logger.warn((Object)"No 'resource' section found in configuration, using default table names");
                    this._sProfilesTable = TABLE_NAME_PROFILES;
                    this._sMethodsTable = TABLE_NAME_METHODS;
                    this._sProfilesPropertiesTable = TABLE_NAME_PROFILE_PROPS;
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._oDataSource = databaseFactory.createModelDatasource();
                        if (this._oDataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                        break block33;
                    } else {
                        _logger.error((Object)"Could not create a valid datasource");
                        throw new DatabaseException(2);
                    }
                }
                try {
                    this._oDataSource = DataSourceFactory.createDataSource((IConfigurationManager)this._configurationManager, (Element)eResource);
                    _logger.info((Object)"Using datasource specified in 'resource' section in configuration");
                }
                catch (DatabaseException e) {
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._oDataSource = databaseFactory.createModelDatasource();
                        if (this._oDataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                    }
                    _logger.error((Object)"Could not create a valid datasource", (Throwable)e);
                    throw new DatabaseException(2);
                }
            }
            try {
                oConnection = this._oDataSource.getConnection();
            }
            catch (SQLException e) {
                _logger.error((Object)"Could not connect to resource", (Throwable)e);
                throw new DatabaseException(2, (Throwable)e);
            }
            if (eResource != null) {
                Element eProfiles = this._configurationManager.getSection(eResource, "profiles");
                if (eProfiles == null) {
                    this._sProfilesTable = TABLE_NAME_PROFILES;
                    _logger.warn((Object)("No 'profiles' section found in configuration, using default table: " + this._sProfilesTable));
                } else {
                    this._sProfilesTable = this._configurationManager.getParam(eProfiles, "table");
                    if (this._sProfilesTable == null) {
                        this._sProfilesTable = TABLE_NAME_PROFILES;
                        _logger.warn((Object)("No 'table' item in 'profiles' section found in configuration, using default: " + this._sProfilesTable));
                    }
                }
            }
            Element eValidation = this._configurationManager.getSection(eConfig, "validation");
            StringBuffer sbVerify = new StringBuffer("SELECT ");
            sbVerify.append("id").append(",");
            sbVerify.append("enabled").append(",");
            sbVerify.append("friendlyname");
            sbVerify.append(" FROM ");
            sbVerify.append(this._sProfilesTable);
            sbVerify.append(" LIMIT 1");
            this.validateTable(oConnection, eValidation, "profiles", sbVerify.toString());
            if (eResource != null) {
                eMethods = this._configurationManager.getSection(eResource, "methods");
                if (eMethods == null) {
                    this._sMethodsTable = TABLE_NAME_METHODS;
                    _logger.warn((Object)("No 'methods' section found in configuration, using default table: " + this._sMethodsTable));
                } else {
                    this._sMethodsTable = this._configurationManager.getParam(eMethods, "table");
                    if (this._sMethodsTable == null) {
                        this._sMethodsTable = TABLE_NAME_METHODS;
                        _logger.warn((Object)("No 'table' item in 'methods' section found in configuration, using default: " + this._sMethodsTable));
                    }
                }
            }
            sbVerify = new StringBuffer("SELECT ");
            sbVerify.append("id").append(",");
            sbVerify.append("profile_id");
            sbVerify.append(" FROM ");
            sbVerify.append(this._sMethodsTable);
            sbVerify.append(" LIMIT 1");
            this.validateTable(oConnection, eValidation, "methods", sbVerify.toString());
            if (eResource != null) {
                eMethods = this._configurationManager.getSection(eResource, "profile_properties");
                if (eMethods == null) {
                    this._sProfilesPropertiesTable = TABLE_NAME_PROFILE_PROPS;
                    _logger.warn((Object)("No 'profile_properties' section found in configuration, using default table: " + this._sMethodsTable));
                } else {
                    this._sProfilesPropertiesTable = this._configurationManager.getParam(eMethods, "table");
                    if (this._sProfilesPropertiesTable == null) {
                        this._sProfilesPropertiesTable = TABLE_NAME_PROFILE_PROPS;
                        _logger.warn((Object)("No 'table' item in 'profile_properties' section found in configuration, using default: " + this._sMethodsTable));
                    }
                }
            }
            sbVerify = new StringBuffer("SELECT ");
            sbVerify.append("profile_id").append(",");
            sbVerify.append("name").append(",");
            sbVerify.append("value");
            sbVerify.append(" FROM ");
            sbVerify.append(this._sProfilesPropertiesTable);
            sbVerify.append(" LIMIT 1");
            this.validateTable(oConnection, eValidation, "profile_properties", sbVerify.toString());
            return;
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        JDBCFactory jDBCFactory = this;
        synchronized (jDBCFactory) {
            this.stop();
            this.start(this._configurationManager, eConfig);
        }
    }

    public void stop() {
    }

    private void validateTable(Connection oConnection, Element eValidation, String table, String sDefault) throws DatabaseException, SQLException {
        String sVerificationQuery = null;
        Statement pVerification = null;
        try {
            Element e;
            if (eValidation != null && (e = this._configurationManager.getSection(eValidation, table)) != null) {
                sVerificationQuery = this._configurationManager.getParam(e, "query");
                if (sVerificationQuery == null || sVerificationQuery.length() == 0) {
                    _logger.warn((Object)("Empty validation query found, table structure is not validated for table:  " + table));
                    return;
                }
                _logger.info((Object)("Validation query found: " + sVerificationQuery));
            }
            if (sVerificationQuery == null) {
                sVerificationQuery = sDefault;
                _logger.info((Object)("No validation query found, using default: " + sDefault));
            }
            pVerification = oConnection.prepareStatement(sVerificationQuery);
            try {
                pVerification.executeQuery();
            }
            catch (Exception e2) {
                StringBuffer sbError = new StringBuffer("Invalid table configured '");
                sbError.append(table);
                sbError.append("' verified with query: ");
                sbError.append(sVerificationQuery);
                _logger.error((Object)sbError.toString(), (Throwable)e2);
                throw new DatabaseException(2);
            }
            _logger.info((Object)("Table structure validated for table: " + table));
        }
        catch (ConfigurationException e) {
            _logger.error((Object)("Invalid validation query found for table: " + table), (Throwable)e);
            throw new DatabaseException(17);
        }
        finally {
            try {
                if (pVerification != null) {
                    pVerification.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close verification statement", (Throwable)e);
            }
        }
    }
}

