/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.attribute.release.jdbc;

import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.engine.core.attribute.AttributeException;
import com.alfaariss.oa.engine.core.attribute.UserAttributes;
import com.alfaariss.oa.engine.core.attribute.release.IAttributeReleasePolicy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCPolicy
implements IAttributeReleasePolicy {
    public static final String COLUMN_POLICY_ID = "id";
    public static final String COLUMN_POLICY_FRIENDLYNAME = "friendlyname";
    public static final String COLUMN_POLICY_ENABLED = "enabled";
    public static final String COLUMN_ATTRIBUTE_POLICY_ID = "policy_id";
    public static final String COLUMN_ATTRIBUTE_ATTRIBUTE = "expression";
    private static Log _logger;
    private String _sID;
    private String _sFriendlyName;
    private boolean _bEnabled;
    private Vector<String> _vAttributeNames;

    public JDBCPolicy(DataSource dataSource, ResultSet resultSet, String attributeTable) throws AttributeException {
        try {
            _logger = LogFactory.getLog(JDBCPolicy.class);
            this._sID = resultSet.getString(COLUMN_POLICY_ID);
            this._sFriendlyName = resultSet.getString(COLUMN_POLICY_FRIENDLYNAME);
            this._bEnabled = resultSet.getBoolean(COLUMN_POLICY_ENABLED);
            this._vAttributeNames = this.readAttributes(dataSource, attributeTable);
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new AttributeException(1);
        }
    }

    public IAttributes apply(IAttributes attributes) throws AttributeException {
        UserAttributes oReturnAttributes = new UserAttributes();
        try {
            if (this._bEnabled) {
                Enumeration enumNames = attributes.getNames();
                while (enumNames.hasMoreElements()) {
                    String sName = (String)enumNames.nextElement();
                    if (!this.matches(sName)) continue;
                    oReturnAttributes.put(sName, attributes.getFormat(sName), attributes.get(sName));
                }
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during apply of release policy: " + this._sID), (Throwable)e);
            throw new AttributeException(1);
        }
        return oReturnAttributes;
    }

    public String getFriendlyName() {
        return this._sFriendlyName;
    }

    public String getID() {
        return this._sID;
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    public String toString() {
        return this._sID;
    }

    private Vector<String> readAttributes(DataSource dataSource, String attributeTable) throws AttributeException {
        Vector<String> vAttributeNames = new Vector<String>();
        Connection oConnection = null;
        Statement oPreparedStatement = null;
        ResultSet oResultSet = null;
        try {
            oConnection = dataSource.getConnection();
            StringBuffer sbSelect = new StringBuffer("SELECT ");
            sbSelect.append(COLUMN_ATTRIBUTE_ATTRIBUTE);
            sbSelect.append(" FROM ");
            sbSelect.append(attributeTable);
            sbSelect.append(" WHERE ");
            sbSelect.append(COLUMN_ATTRIBUTE_POLICY_ID);
            sbSelect.append("=?");
            oPreparedStatement = oConnection.prepareStatement(sbSelect.toString());
            oPreparedStatement.setString(1, this._sID);
            oResultSet = oPreparedStatement.executeQuery();
            while (oResultSet.next()) {
                vAttributeNames.add(oResultSet.getString(COLUMN_ATTRIBUTE_ATTRIBUTE));
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new AttributeException(1);
        }
        finally {
            try {
                if (oResultSet != null) {
                    oResultSet.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (oPreparedStatement != null) {
                    oPreparedStatement.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return vAttributeNames;
    }

    private boolean matches(String sName) {
        if (this._vAttributeNames.contains(sName)) {
            return true;
        }
        for (String sReleaseName : this._vAttributeNames) {
            String sStart;
            int iWildcard = sReleaseName.indexOf("*");
            if (iWildcard == 0) {
                String sIntermediate;
                String sEnd = sReleaseName.substring(1, sReleaseName.length());
                if (sEnd.length() == 0) {
                    return true;
                }
                if (sName.endsWith(sEnd)) {
                    return true;
                }
                if (!sEnd.endsWith("*") || !sName.contains(sIntermediate = sEnd.substring(0, sEnd.length() - 1))) continue;
                return true;
            }
            if (iWildcard != sReleaseName.length() - 1 || !sName.startsWith(sStart = sReleaseName.substring(0, iWildcard))) continue;
            return true;
        }
        return false;
    }
}

