/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.engine.attribute.release.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.datastorage.IDataStorageFactory;
import com.alfaariss.oa.engine.attribute.release.jdbc.JDBCPolicy;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.attribute.AttributeException;
import com.alfaariss.oa.engine.core.attribute.release.IAttributeReleasePolicy;
import com.alfaariss.oa.engine.core.attribute.release.factory.IAttributeReleasePolicyFactory;
import com.alfaariss.oa.util.database.DatabaseException;
import com.alfaariss.oa.util.database.jdbc.DataSourceFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JDBCFactory
implements IAttributeReleasePolicyFactory,
IComponent {
    private static final String TABLE_NAME_POLICY = "attributerelease_policy";
    private static final String TABLE_NAME_ATTRIBUTE = "attributerelease_expression";
    private static Log _logger;
    private IConfigurationManager _configurationManager;
    private DataSource _oDataSource;
    private String _sPolicyTable;
    private String _sAttributeTable;
    private boolean _bEnabled;

    public JDBCFactory() {
        _logger = LogFactory.getLog(JDBCFactory.class);
        this._sPolicyTable = null;
        this._sAttributeTable = null;
        this._bEnabled = false;
    }

    public IAttributeReleasePolicy getPolicy(String policy) throws AttributeException {
        JDBCPolicy oPolicy = null;
        Connection oConnection = null;
        Statement oPreparedStatement = null;
        ResultSet oResultSet = null;
        try {
            oConnection = this._oDataSource.getConnection();
            StringBuffer sbSelect = new StringBuffer("SELECT * FROM ");
            sbSelect.append(this._sPolicyTable);
            sbSelect.append(" WHERE ");
            sbSelect.append("id");
            sbSelect.append("=?");
            oPreparedStatement = oConnection.prepareStatement(sbSelect.toString());
            oPreparedStatement.setString(1, policy);
            oResultSet = oPreparedStatement.executeQuery();
            if (oResultSet.next()) {
                oPolicy = new JDBCPolicy(this._oDataSource, oResultSet, this._sAttributeTable);
            }
            _logger.debug((Object)("Retrieved profile: " + oPolicy));
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during retrieval of policy: " + policy), (Throwable)e);
            throw new AttributeException(1, (Throwable)e);
        }
        finally {
            try {
                if (oResultSet != null) {
                    oResultSet.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close resultset", (Throwable)e);
            }
            try {
                if (oPreparedStatement != null) {
                    oPreparedStatement.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close statement", (Throwable)e);
            }
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return oPolicy;
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element config) throws OAException {
        JDBCFactory jDBCFactory = this;
        synchronized (jDBCFactory) {
            this.stop();
            this.start(this._configurationManager, config);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(IConfigurationManager configurationManager, Element config) throws OAException {
        Connection oConnection = null;
        try {
            Element eResource;
            block29: {
                this._bEnabled = false;
                this._configurationManager = configurationManager;
                eResource = this._configurationManager.getSection(config, "resource");
                if (eResource == null) {
                    _logger.warn((Object)"No 'resource' section found in configuration, using default table names");
                    this._sPolicyTable = TABLE_NAME_POLICY;
                    this._sAttributeTable = TABLE_NAME_ATTRIBUTE;
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._oDataSource = databaseFactory.createModelDatasource();
                        if (this._oDataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                        break block29;
                    } else {
                        _logger.error((Object)"Could not create a valid datasource");
                        throw new DatabaseException(2);
                    }
                }
                try {
                    this._oDataSource = DataSourceFactory.createDataSource((IConfigurationManager)this._configurationManager, (Element)eResource);
                    _logger.info((Object)"Using datasource specified in 'resource' section in configuration");
                }
                catch (DatabaseException e) {
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._oDataSource = databaseFactory.createModelDatasource();
                        if (this._oDataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                    }
                    _logger.error((Object)"Could not create a valid datasource", (Throwable)e);
                    throw new DatabaseException(2);
                }
            }
            try {
                oConnection = this._oDataSource.getConnection();
            }
            catch (SQLException e) {
                _logger.error((Object)"Could not connect to resource", (Throwable)e);
                throw new DatabaseException(2, (Throwable)e);
            }
            if (eResource != null) {
                Element ePolicy = this._configurationManager.getSection(eResource, "policy");
                if (ePolicy == null) {
                    this._sPolicyTable = TABLE_NAME_POLICY;
                    _logger.warn((Object)("No 'policy' section found in configuration, using default table: " + this._sPolicyTable));
                } else {
                    this._sPolicyTable = this._configurationManager.getParam(ePolicy, "table");
                    if (this._sPolicyTable == null) {
                        this._sPolicyTable = TABLE_NAME_POLICY;
                        _logger.warn((Object)("No 'table' item in 'policy' section found in configuration, using default: " + this._sPolicyTable));
                    }
                }
            }
            Element eValidation = this._configurationManager.getSection(config, "validation");
            StringBuffer sbPolicyVerify = new StringBuffer("SELECT ");
            sbPolicyVerify.append("id").append(",");
            sbPolicyVerify.append("friendlyname").append(",");
            sbPolicyVerify.append("enabled");
            sbPolicyVerify.append(" FROM ");
            sbPolicyVerify.append(this._sPolicyTable);
            sbPolicyVerify.append(" LIMIT 1");
            this.validateTable(oConnection, eValidation, "policy", sbPolicyVerify.toString());
            if (eResource != null) {
                Element eAttribute = this._configurationManager.getSection(eResource, "attribute");
                if (eAttribute == null) {
                    this._sAttributeTable = TABLE_NAME_ATTRIBUTE;
                    _logger.warn((Object)("No 'attribute' section found in configuration, using default table: " + this._sAttributeTable));
                } else {
                    this._sAttributeTable = this._configurationManager.getParam(eAttribute, "table");
                    if (this._sAttributeTable == null) {
                        this._sAttributeTable = TABLE_NAME_ATTRIBUTE;
                        _logger.warn((Object)("No 'table' item in 'attribute' section found in configuration, using default: " + this._sAttributeTable));
                    }
                }
            }
            StringBuffer sbAttributeVerify = new StringBuffer("SELECT ");
            sbAttributeVerify.append("policy_id").append(",");
            sbAttributeVerify.append("expression");
            sbAttributeVerify.append(" FROM ");
            sbAttributeVerify.append(this._sAttributeTable);
            sbAttributeVerify.append(" LIMIT 1");
            this.validateTable(oConnection, eValidation, "attribute", sbAttributeVerify.toString());
            this._bEnabled = true;
            return;
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during initialization", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
        finally {
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    private void validateTable(Connection oConnection, Element eValidation, String table, String sDefault) throws DatabaseException, SQLException {
        String sVerificationQuery = null;
        Statement pVerification = null;
        try {
            Element e;
            if (eValidation != null && (e = this._configurationManager.getSection(eValidation, table)) != null) {
                sVerificationQuery = this._configurationManager.getParam(e, "query");
                if (sVerificationQuery == null || sVerificationQuery.length() == 0) {
                    _logger.warn((Object)("Empty validation query found, table structure is not validated for table:  " + table));
                    return;
                }
                _logger.info((Object)("Validation query found: " + sVerificationQuery));
            }
            if (sVerificationQuery == null) {
                sVerificationQuery = sDefault;
                _logger.info((Object)("No validation query found, using default: " + sDefault));
            }
            pVerification = oConnection.prepareStatement(sVerificationQuery);
            try {
                pVerification.executeQuery();
            }
            catch (Exception e2) {
                StringBuffer sbError = new StringBuffer("Invalid table configured '");
                sbError.append(table);
                sbError.append("' verified with query: ");
                sbError.append(sVerificationQuery);
                _logger.error((Object)sbError.toString(), (Throwable)e2);
                throw new DatabaseException(2);
            }
            _logger.info((Object)("Table structure validated for table: " + table));
        }
        catch (ConfigurationException e) {
            _logger.error((Object)("Invalid validation query found for table: " + table), (Throwable)e);
            throw new DatabaseException(17);
        }
        finally {
            try {
                if (pVerification != null) {
                    pVerification.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close verification statement", (Throwable)e);
            }
        }
    }
}

