/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.custom.postauthz.authncontextattribute;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.attribute.ITGTAttributes;
import com.alfaariss.oa.api.authentication.IAuthenticationContext;
import com.alfaariss.oa.api.authentication.IAuthenticationContexts;
import com.alfaariss.oa.api.authorization.IAuthorizationAction;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authentication.AuthenticationContexts;
import com.alfaariss.oa.sso.authorization.web.IWebAuthorizationMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asimba.custom.postauthz.authncontextattribute.ACAttribute;
import org.w3c.dom.Element;

public class AuthnContextToUserAttributes
implements IWebAuthorizationMethod {
    private Log _oLogger = LogFactory.getLog(AuthnContextToUserAttributes.class);
    public static final String EL_ENABLED = "enabled";
    public static final String EL_ID = "id";
    public static final String EL_FRIENDLYNAME = "friendlyname";
    public static final String EL_ATTRIBUTES = "attributes";
    public static final String EL_ATTRIBUTE = "attribute";
    private String _sID;
    private String _sFriendlyname;
    private boolean _enabled;
    private List<ACAttribute> _lConfiguredAttributes;

    public String getID() {
        return this._sID;
    }

    public String getFriendlyName() {
        return this._sFriendlyname;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public String getAuthority() {
        return null;
    }

    public UserEvent authorize(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession) throws OAException {
        if (!this._enabled) {
            this._oLogger.debug((Object)("AuthnContextToUserAttributes '" + this._sID + "' was disabled; skipping."));
            return UserEvent.AUTHZ_METHOD_SUCCESSFUL;
        }
        if (this._lConfiguredAttributes == null) {
            this._oLogger.debug((Object)"No AuthnContext attributes processed.");
            return UserEvent.AUTHZ_METHOD_SUCCESSFUL;
        }
        IAuthenticationContexts oAuthenticationContexts = (IAuthenticationContexts)oSession.getAttributes().get(AuthenticationContexts.class, "authcontexts");
        if (oAuthenticationContexts == null) {
            this._oLogger.debug((Object)"Trying to get AuthenticationContexts from TGT ...");
            String sTGTID = oSession.getTGTId();
            if (sTGTID != null) {
                Engine oEngine = Engine.getInstance();
                ITGT oTGT = oEngine.getTGTFactory().retrieve((Object)sTGTID);
                if (oTGT != null) {
                    ITGTAttributes oTGTAttributes = oTGT.getAttributes();
                    oAuthenticationContexts = (IAuthenticationContexts)oTGTAttributes.get(AuthenticationContexts.class, "authcontexts");
                }
            } else {
                this._oLogger.warn((Object)"Could not find TGT for Session, so no AuthenticationContext was resolved!");
            }
        }
        if (oAuthenticationContexts == null) {
            this._oLogger.warn((Object)"No AuthenticationContext was resolved - will fail on required attributes!");
        }
        IUser oUser = oSession.getUser();
        IAttributes oUserAttributes = oUser.getAttributes();
        for (ACAttribute o : this._lConfiguredAttributes) {
            String val = this.getAttributeValue(o, oAuthenticationContexts);
            if (val != null) {
                oUserAttributes.put(o.getDest(), (Object)val);
                continue;
            }
            this._oLogger.debug((Object)("No value established for " + o.getAuthnMethodID() + ":" + o.getSrc()));
            if (!o.isRequired()) continue;
            this._oLogger.info((Object)("Failing Authorization because attribute '" + o.getSrc() + "' is required."));
            return UserEvent.AUTHZ_METHOD_FAILED;
        }
        return UserEvent.AUTHZ_METHOD_SUCCESSFUL;
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig, Map<String, IAuthorizationAction> mapActions) throws OAException {
        this._oLogger.trace((Object)"start() called.");
        this._enabled = true;
        String sEnabled = oConfigurationManager.getParam(eConfig, EL_ENABLED);
        if (sEnabled != null) {
            this._enabled = Boolean.valueOf(sEnabled);
        }
        this._sID = oConfigurationManager.getParam(eConfig, EL_ID);
        if (this._sID == null || "".equals(this._sID)) {
            this._oLogger.error((Object)"No 'id' found for authorization method");
            throw new OAException(17);
        }
        this._sFriendlyname = oConfigurationManager.getParam(eConfig, EL_FRIENDLYNAME);
        if (this._sFriendlyname == null) {
            this._oLogger.error((Object)"No 'friendlyname' found for authorization method");
            throw new OAException(17);
        }
        this._lConfiguredAttributes = null;
        if (this._enabled) {
            Element eAttributes = oConfigurationManager.getSection(eConfig, EL_ATTRIBUTES);
            if (eAttributes == null) {
                this._oLogger.info((Object)"No attributes configured for AuthnContextToUserAttributes: no processing.");
                return;
            }
            this.readAttributes(oConfigurationManager, eAttributes);
        }
        this._oLogger.info((Object)("Initialized AuthnContextToUserAttributes (enabled: " + this._enabled + ")"));
    }

    public void stop() {
        this._oLogger.trace((Object)"stop() called.");
        this._lConfiguredAttributes.clear();
    }

    private void readAttributes(IConfigurationManager oConfigurationManager, Element eAttributesConfig) throws OAException {
        this._lConfiguredAttributes = new ArrayList<ACAttribute>();
        Element eAttribute = oConfigurationManager.getSection(eAttributesConfig, EL_ATTRIBUTE);
        while (eAttribute != null) {
            ACAttribute oConfiguredAttribute = ACAttribute.fromConfig(oConfigurationManager, eAttribute);
            if (oConfiguredAttribute == null) {
                throw new OAException(17);
            }
            this._lConfiguredAttributes.add(oConfiguredAttribute);
            eAttribute = oConfigurationManager.getNextSection(eAttribute);
        }
    }

    private String getAttributeValue(ACAttribute oConfiguredAttribute, IAuthenticationContexts oAuthenticationContexts) {
        if (oAuthenticationContexts == null) {
            if (oConfiguredAttribute.isRequired()) {
                return null;
            }
            return oConfiguredAttribute.getDefault();
        }
        IAuthenticationContext oAuthenticationContext = oAuthenticationContexts.getAuthenticationContext(oConfiguredAttribute.getAuthnMethodID());
        if (oAuthenticationContext == null) {
            if (oConfiguredAttribute.isRequired()) {
                return null;
            }
            return oConfiguredAttribute.getDefault();
        }
        String value = oAuthenticationContext.get(oConfiguredAttribute.getSrc());
        if (value == null) {
            value = oConfiguredAttribute.getDefault();
        }
        return value;
    }
}

