/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.custom.postauthz.authncontextattribute;

import com.alfaariss.oa.api.configuration.ConfigurationException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ACAttribute {
    private static Log _oLogger = LogFactory.getLog(ACAttribute.class);
    public static final String ATTR_AUTHNMETHOD = "authnmethod";
    public static final String ATTR_SRC = "src";
    public static final String ATTR_DEST = "dest";
    public static final String ATTR_REQUIRED = "required";
    public static final String ATTR_DEFAULT = "default";
    private String _sAuthnMethodID;
    private String _sSrc;
    private String _sDest;
    private boolean _required;
    private String _sDefault;

    public String getAuthnMethodID() {
        return this._sAuthnMethodID;
    }

    public String getSrc() {
        return this._sSrc;
    }

    public String getDest() {
        return this._sDest;
    }

    public boolean isRequired() {
        return this._required;
    }

    public String getDefault() {
        return this._sDefault;
    }

    public static ACAttribute fromConfig(IConfigurationManager oConfigurationManager, Element eAttributeConfig) {
        ACAttribute oACAttribute = new ACAttribute();
        try {
            String sAuthnMethod = oConfigurationManager.getParam(eAttributeConfig, ATTR_AUTHNMETHOD);
            if (sAuthnMethod == null) {
                _oLogger.error((Object)"Attribute did not configure attribute 'authnmethod'");
                return null;
            }
            oACAttribute._sAuthnMethodID = sAuthnMethod;
            String sSrc = oConfigurationManager.getParam(eAttributeConfig, ATTR_SRC);
            if (sSrc == null) {
                _oLogger.error((Object)"Attribute did not configure attribute 'src'");
                return null;
            }
            oACAttribute._sSrc = sSrc;
            String sDest = oConfigurationManager.getParam(eAttributeConfig, ATTR_DEST);
            oACAttribute._sDest = sDest == null ? sSrc : sDest;
            String sRequired = oConfigurationManager.getParam(eAttributeConfig, ATTR_REQUIRED);
            oACAttribute._required = sRequired == null ? true : Boolean.valueOf(sRequired);
            String sDefault = oConfigurationManager.getParam(eAttributeConfig, ATTR_DEFAULT);
            if (sDefault == null) {
                if (!oACAttribute._required) {
                    _oLogger.info((Object)("Attribute '" + sSrc + "' not required and no default value configured."));
                }
                oACAttribute._sDefault = null;
            } else {
                oACAttribute._sDefault = sDefault;
            }
        }
        catch (ConfigurationException e) {
            _oLogger.error((Object)("Could not configure attribute: " + e.getMessage()));
            return null;
        }
        _oLogger.info((Object)("Added attribute " + oACAttribute.toString()));
        return oACAttribute;
    }

    public String toString() {
        return "{authnmethod:'" + this._sAuthnMethodID + "'; src:'" + this._sSrc + "'; dest:'" + this._sDest + "'; required: " + this._required + "; default:" + (this._sDefault == null ? this._sDefault : "'" + this._sDefault + "'") + "}";
    }
}

