/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authorization.method.web.ip;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.authorization.IAuthorizationAction;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.authorization.method.web.AbstractWebAuthorizationMethod;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class IPAuthorizationMethod
extends AbstractWebAuthorizationMethod {
    private static final String AUTHORITY_NAME = "IPAuthZMethod_";
    private Log _logger = LogFactory.getLog(IPAuthorizationMethod.class);
    private Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    private List<IPAuthRange> _lRanges = null;
    private boolean _bMatch = true;

    @Override
    public void start(IConfigurationManager oConfigurationManager, Element eConfig, Map<String, IAuthorizationAction> mapActions) throws OAException {
        super.start(oConfigurationManager, eConfig, mapActions);
        this._logger.debug((Object)("Authorization method '" + this.getID() + "' starting..."));
        this._lRanges = new LinkedList<IPAuthRange>();
        Element eRanges = this._configManager.getSection(eConfig, "ranges");
        if (eRanges == null) {
            this._logger.error((Object)("No 'ranges' section found in configuration for method: " + this.getID()));
            throw new OAException(17);
        }
        String sValue = this._configManager.getParam(eRanges, "match");
        if (!"true".equalsIgnoreCase(sValue) && !"false".equalsIgnoreCase(sValue)) {
            this._logger.error((Object)("Misconfigured property 'match' for IP authorization method " + this.getID()));
            throw new OAException(17);
        }
        this._bMatch = new Boolean(sValue);
        StringBuffer sbInfo = new StringBuffer("Default value for IP authorization set to ");
        sbInfo.append(this._bMatch);
        sbInfo.append(" in authorization method: ");
        sbInfo.append(this.getID());
        this._logger.info((Object)sbInfo.toString());
        Element eOneRange = this._configManager.getSection(eRanges, "range");
        while (eOneRange != null) {
            String sStart = this._configManager.getParam(eOneRange, "start");
            if (sStart == null) {
                this._logger.error((Object)("Misconfigured property 'start' for IP authorization method " + this.getID()));
                throw new OAException(17);
            }
            String sEnd = this._configManager.getParam(eOneRange, "end");
            if (sEnd == null) {
                this._logger.error((Object)("Misconfigured property 'end' for IP authorization method " + this.getID()));
                throw new OAException(17);
            }
            try {
                IPAuthRange oRange = new IPAuthRange(sStart, sEnd);
                this._lRanges.add(oRange);
            }
            catch (OAException aee) {
                this._logger.error((Object)("Misconfigured IP value for IP authorization method " + this.getID()));
                throw aee;
            }
            eOneRange = this._configManager.getNextSection(eOneRange);
        }
        if (this._lRanges.isEmpty()) {
            this._logger.error((Object)("Not even one 'range' section found in 'ranges' section in configuration for method: " + this.getID()));
            throw new OAException(17);
        }
        this._logger.info((Object)("IP Authorization method loaded properly: " + this.getID()));
    }

    public UserEvent authorize(HttpServletRequest request, HttpServletResponse response, ISession session) throws OAException {
        IPAuthRange oRange;
        UserEvent event = UserEvent.AUTHZ_METHOD_SUCCESSFUL;
        if (request == null) {
            throw new IllegalArgumentException("Supplied request == null");
        }
        if (response == null) {
            throw new IllegalArgumentException("Supplied response == null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Supplied session == null");
        }
        String sUserIP = request.getRemoteAddr();
        boolean bInrange = false;
        Iterator<IPAuthRange> i$ = this._lRanges.iterator();
        while (i$.hasNext() && !(bInrange = (oRange = i$.next()).matchRange(sUserIP))) {
        }
        if (!(bInrange ^ this._bMatch)) {
            event = this._oAction.perform(session);
        }
        this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), event, (IAuthority)this, null));
        return event;
    }

    public String getAuthority() {
        return AUTHORITY_NAME + this._sId;
    }

    @Override
    public void stop() {
        if (this._lRanges != null) {
            this._lRanges.clear();
        }
        super.stop();
    }

    private class IPAuthRange {
        private long _aiStart = 0L;
        private long _aiEnd = 0L;

        public IPAuthRange(String start, String end) throws OAException {
            this._aiStart = this.setIp(start);
            this._aiEnd = this.setIp(end);
        }

        public boolean matchRange(String ip) throws OAException {
            return this.isInRange(ip);
        }

        private boolean isInRange(String ip) throws OAException {
            assert (ip != null);
            long iCheckedIp = this.setIp(ip);
            return this._aiStart <= iCheckedIp && iCheckedIp <= this._aiEnd;
        }

        private long setIp(String ip) throws OAException {
            assert (ip != null);
            String[] asStartParts = ip.split("\\.");
            long iRetVal = 0L;
            if (asStartParts.length == 4) {
                for (int i = 0; i < 4; ++i) {
                    try {
                        int iVal = Integer.parseInt(asStartParts[i]);
                        long power = (long)Math.pow(2.0, 8 * (3 - i));
                        iRetVal += (long)iVal * power;
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new OAException(17, (Throwable)nfe);
                    }
                }
            } else {
                throw new OAException(17);
            }
            return iRetVal;
        }
    }
}

