/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authorization.method.web;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.authorization.IAuthorizationAction;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.engine.core.attribute.AttributeException;
import com.alfaariss.oa.sso.authorization.web.IWebAuthorizationMethod;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public abstract class AbstractWebAuthorizationMethod
implements IWebAuthorizationMethod {
    protected IConfigurationManager _configManager = null;
    protected IAuthorizationAction _oAction;
    protected String _sId;
    private boolean _bIsEnabled = false;
    private Log _logger = LogFactory.getLog(AbstractWebAuthorizationMethod.class);
    private String _sFriendlyName;

    public String getID() {
        return this._sId;
    }

    public boolean isEnabled() {
        return this._bIsEnabled;
    }

    public String getFriendlyName() {
        return this._sFriendlyName;
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig, Map<String, IAuthorizationAction> mapActions) throws OAException {
        if (eConfig == null) {
            throw new IllegalArgumentException("Supplied configuration section empty");
        }
        if (oConfigurationManager == null) {
            throw new IllegalArgumentException("Supplied configurationmanager empty");
        }
        this._configManager = oConfigurationManager;
        this._sId = this._configManager.getParam(eConfig, "id");
        if (this._sId == null || "".equals(this._sId)) {
            this._logger.error((Object)"No id found for authorization method");
            throw new AttributeException(17);
        }
        this._sFriendlyName = this._configManager.getParam(eConfig, "friendlyname");
        if (this._sFriendlyName == null) {
            this._logger.error((Object)"No 'friendlyname' parameter found in configuration");
            throw new OAException(17);
        }
        this._bIsEnabled = true;
        String sEnabled = this._configManager.getParam(eConfig, "enabled");
        if (sEnabled != null) {
            if (sEnabled.equalsIgnoreCase("FALSE")) {
                this._bIsEnabled = false;
            } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                StringBuffer sbError = new StringBuffer("Unknown value in 'enabled' configuration item: ");
                sbError.append(sEnabled);
                sbError.append(", for authZ method ");
                sbError.append(this._sId);
                this._logger.error((Object)sbError.toString());
                throw new AttributeException(17);
            }
        }
        StringBuffer sbInfo = new StringBuffer("Authorization method (");
        sbInfo.append(this._sId);
        sbInfo.append("): ");
        if (this._bIsEnabled) {
            sbInfo.append("enabled");
        } else {
            sbInfo.append("disabled");
        }
        String sActionID = this._configManager.getParam(eConfig, "action");
        if (sActionID == null) {
            this._logger.error((Object)("Value 'action' not found for authZ method " + this._sId));
            throw new AttributeException(17);
        }
        this._oAction = mapActions.get(sActionID);
        if (this._oAction == null) {
            this._logger.error((Object)("Unknown 'action' item found in configuration: " + sActionID));
            throw new AttributeException(17);
        }
    }

    public void stop() {
        this._bIsEnabled = false;
    }
}

