/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.auth.smsotp;

import com.alfaariss.oa.DetailedUserException;
import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.idmapper.IIDMapper;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.crypto.CryptoException;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.user.factory.IUserFactory;
import com.alfaariss.oa.sso.authentication.web.IWebAuthenticationMethod;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.asimba.auth.smsotp.OTP;
import org.asimba.auth.smsotp.Warnings;
import org.asimba.auth.smsotp.distributor.IOTPDistributor;
import org.asimba.auth.smsotp.distributor.OTPDistributorException;
import org.asimba.auth.smsotp.generator.IOTPGenerator;
import org.w3c.dom.Element;

public class OTPAuthenticationMethod
implements IWebAuthenticationMethod {
    private static Logger _oLogger = Logger.getLogger(OTPAuthenticationMethod.class);
    private static Logger _oEventLogger = Logger.getLogger((String)"com.alfaariss.oa.EventLogger");
    private IConfigurationManager _oConfigManager;
    private IUserFactory _oUserFactory;
    private Engine _oEngine;
    protected IOTPGenerator _oOTPGenerator;
    protected IOTPDistributor _oOTPDistributor;
    protected IIDMapper _oIDMapper = null;
    protected static final String AUTHORITY_NAME = "OTPAuthenticationMethod";
    private static final String HASCAPTCHA = "hasCaptcha";
    private static final String CAPTCHA = "captcha";
    private static final String PASSWORD = "password";
    private static final String RESEND_OTP = "resend_otp";
    private static final String OTP_RESEND_RETRIES = "OTPResendRetries";
    private static final String OTP_NAME = "OTP";
    private static final String CAPTCHA_HASH = "##captcha_hash##";
    private String _sIdTemplate;
    private String _sPwdTemplate;
    private String _sMethodID;
    private String _sFriendlyName;
    private int _iAllowedTries;
    private int _iAllowedOTPResends = 5;
    protected boolean _bDisableDistribute;
    private boolean _bEnabled = false;
    private boolean _bCaptchaEnabled;
    private CryptoManager _CryptoManager;

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        block44: {
            try {
                Element eIDMapper;
                _oLogger.info((Object)("Starting " + OTPAuthenticationMethod.class.getName()));
                if (eConfig == null || oConfigurationManager == null) {
                    _oLogger.error((Object)"No configuration supplied");
                    throw new OAException(17);
                }
                this._oConfigManager = oConfigurationManager;
                this._oEngine = Engine.getInstance();
                this._CryptoManager = this._oEngine.getCryptoManager();
                if (this._CryptoManager == null) {
                    _oLogger.error((Object)"No crypto manager available");
                    throw new OAException(2);
                }
                this._oUserFactory = this._oEngine.getUserFactory();
                if (this._oUserFactory == null || !this._oUserFactory.isEnabled()) {
                    _oLogger.error((Object)"User Factory is disabled");
                    throw new OAException(2);
                }
                this._sMethodID = this._oConfigManager.getParam(eConfig, "id");
                if (this._sMethodID == null || this._sMethodID.equals("")) {
                    _oLogger.error((Object)"No 'id' found in 'method' section in configuration");
                    throw new OAException(17);
                }
                this._sFriendlyName = this._oConfigManager.getParam(eConfig, "friendlyname");
                if (this._sFriendlyName == null || this._sFriendlyName.equals("")) {
                    _oLogger.error((Object)"No 'friendlyname' parameter found in configuration");
                    throw new OAException(17);
                }
                String sEnabled = this._oConfigManager.getParam(eConfig, "enabled");
                if (sEnabled != null) {
                    if (sEnabled.equalsIgnoreCase("TRUE")) {
                        this._bEnabled = true;
                    } else if (!sEnabled.equalsIgnoreCase("FALSE")) {
                        _oLogger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                        throw new OAException(17);
                    }
                } else {
                    this._bEnabled = true;
                }
                if (!this._bEnabled) break block44;
                this._bCaptchaEnabled = false;
                String sCaptchaEnabled = this._oConfigManager.getParam(eConfig, CAPTCHA);
                if (sCaptchaEnabled != null) {
                    if (sCaptchaEnabled.equalsIgnoreCase("TRUE")) {
                        this._bCaptchaEnabled = true;
                    } else if (!sCaptchaEnabled.equalsIgnoreCase("FALSE")) {
                        _oLogger.error((Object)("Unknown value in 'captcha' configuration item: " + sCaptchaEnabled));
                        throw new OAException(17);
                    }
                }
                _oLogger.info((Object)(this._bCaptchaEnabled ? "Captcha is enabled" : "Captcha is not enabled"));
                Element eIdTemplate = this._oConfigManager.getSection(eConfig, "idtemplate");
                if (eIdTemplate == null) {
                    _oLogger.error((Object)("No 'idtemplate' section found in 'method' section with id: " + this._sMethodID));
                    throw new OAException(17);
                }
                this._sIdTemplate = this._oConfigManager.getParam(eIdTemplate, "path");
                if (this._sIdTemplate == null || this._sIdTemplate.equals("")) {
                    _oLogger.error((Object)("No 'path' attribute found in 'idtemplate' section within 'method' with id: " + this._sMethodID));
                    throw new OAException(17);
                }
                Element ePwdTemplate = this._oConfigManager.getSection(eConfig, "pwdtemplate");
                if (ePwdTemplate == null) {
                    _oLogger.error((Object)("No 'pwdtemplate' section found in 'method' section with id: " + this._sMethodID));
                    throw new OAException(17);
                }
                this._sPwdTemplate = this._oConfigManager.getParam(ePwdTemplate, "path");
                if (this._sPwdTemplate == null || this._sPwdTemplate.equals("")) {
                    _oLogger.error((Object)("No 'path' attribute found in 'pwdtemplate' section within 'method' with id: " + this._sMethodID));
                    throw new OAException(17);
                }
                String sRetries = this._oConfigManager.getParam(eConfig, "retries");
                if (sRetries == null || sRetries.equals("")) {
                    _oLogger.error((Object)("No 'retries' found in 'method' section with id: " + this._sMethodID));
                    throw new OAException(17);
                }
                try {
                    this._iAllowedTries = Integer.parseInt(sRetries);
                    if (this._iAllowedTries < 0) {
                        _oLogger.error((Object)("Invalid 'retries' item found in 'method' section with id: " + this._sMethodID));
                        throw new OAException(17);
                    }
                }
                catch (NumberFormatException e) {
                    _oLogger.error((Object)("Invalid 'retries' item found in 'method' section with id: " + this._sMethodID), (Throwable)e);
                    throw new OAException(17);
                }
                Element eOTPHandler = this._oConfigManager.getSection(eConfig, "otp_handler");
                if (eOTPHandler == null) {
                    _oLogger.error((Object)("No 'otp_handler' section found in 'method' section with id: " + this._sMethodID));
                    throw new OAException(17);
                }
                String sOTPHandlerClass = this._oConfigManager.getParam(eOTPHandler, "class");
                if (sOTPHandlerClass == null || sOTPHandlerClass.equals("")) {
                    _oLogger.error((Object)"No class found for otp_handler");
                    throw new OAException(17);
                }
                Class<?> cOTPHandler = null;
                try {
                    cOTPHandler = Class.forName(sOTPHandlerClass);
                }
                catch (Exception e) {
                    _oLogger.error((Object)("Could not find OTP Handler Class: " + sOTPHandlerClass), (Throwable)e);
                    throw new OAException(17);
                }
                try {
                    this._oOTPGenerator = (IOTPGenerator)cOTPHandler.newInstance();
                }
                catch (Exception e) {
                    _oLogger.error((Object)("Could not instantiate IOTPGenerator: " + sOTPHandlerClass), (Throwable)e);
                    throw new OAException(17);
                }
                this._oOTPGenerator.start(this._oConfigManager, eOTPHandler);
                if (_oLogger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer(this._sMethodID);
                    sb.append(" handler '");
                    sb.append(sOTPHandlerClass).append("' started");
                    _oLogger.debug((Object)sb.toString());
                }
                this._bDisableDistribute = false;
                String sDisableDistribute = this._oConfigManager.getParam(eConfig, "disabledistribute");
                if (sDisableDistribute != null) {
                    if (sDisableDistribute.equalsIgnoreCase("TRUE")) {
                        this._bDisableDistribute = true;
                    } else if (!sDisableDistribute.equalsIgnoreCase("FALSE")) {
                        _oLogger.error((Object)("Unknown value 'disabledistribute' configured: " + sDisableDistribute));
                        throw new OAException(17);
                    }
                }
                _oLogger.info((Object)("OneTimePassword distribution is " + (this._bDisableDistribute ? "disabled" : "enabled")));
                Element eOTPDistributor = this._oConfigManager.getSection(eConfig, "otp_distributor");
                if (eOTPDistributor == null) {
                    _oLogger.error((Object)("No 'otp_distributor' section found in 'method' section with id: " + this._sMethodID));
                    throw new OAException(17);
                }
                String sOTPDistributorClass = this._oConfigManager.getParam(eOTPDistributor, "class");
                if (sOTPDistributorClass == null || sOTPDistributorClass.equals("")) {
                    _oLogger.error((Object)"No class found for otp_distributor");
                    throw new OAException(17);
                }
                Class<?> cOTPDistributor = null;
                try {
                    cOTPDistributor = Class.forName(sOTPDistributorClass);
                }
                catch (Exception e) {
                    _oLogger.error((Object)("Could not find otp distributor class: " + sOTPDistributorClass), (Throwable)e);
                    throw new OAException(17);
                }
                try {
                    this._oOTPDistributor = (IOTPDistributor)cOTPDistributor.newInstance();
                }
                catch (Exception e) {
                    _oLogger.error((Object)("Could not instantiate otp distributor: " + sOTPDistributorClass), (Throwable)e);
                    throw new OAException(17);
                }
                this._oOTPDistributor.start(this._oConfigManager, eOTPDistributor);
                if (_oLogger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer(this._sMethodID);
                    sb.append(" handler '");
                    sb.append(sOTPDistributorClass).append("' started");
                    _oLogger.debug((Object)sb.toString());
                }
                if ((eIDMapper = this._oConfigManager.getSection(eConfig, "idmapper")) != null) {
                    this._oIDMapper = this.createMapper(eIDMapper);
                }
            }
            catch (OAException e) {
                _oLogger.error((Object)"Error during start of OneTimePassword authentication method");
                throw e;
            }
            catch (Exception e) {
                _oLogger.fatal((Object)"Internal error during start of OneTimePassword authentication method", (Throwable)e);
                throw new OAException(1);
            }
        }
        _oLogger.info((Object)("Started " + OTPAuthenticationMethod.class.getName() + ": " + this._sMethodID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        OTPAuthenticationMethod oTPAuthenticationMethod = this;
        synchronized (oTPAuthenticationMethod) {
            this.stop();
            this.start(this._oConfigManager, eConfig);
        }
    }

    public String getID() {
        return this._sMethodID;
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    public String getFriendlyName() {
        return this._sFriendlyName;
    }

    public String getAuthority() {
        return AUTHORITY_NAME + this._sMethodID;
    }

    public UserEvent authenticate(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession) throws OAException {
        ISessionAttributes oAttributes = null;
        IUser oUser = null;
        OTP oOTP = null;
        int iTries = this._iAllowedTries;
        UserEvent userEvent = null;
        String sUserId = null;
        boolean bRetries = true;
        Vector<Enum> warnings = new Vector<Enum>();
        try {
            String sUserPassword;
            oAttributes = oSession.getAttributes();
            Integer oiRetries = (Integer)oAttributes.get(OTPAuthenticationMethod.class, this._sMethodID + "retries");
            if (oiRetries != null) {
                iTries = oiRetries;
            }
            if ((oUser = oSession.getUser()) == null) {
                sUserId = oSession.getForcedUserID();
                if (sUserId == null && ((sUserId = oRequest.getParameter("user_id")) == null || sUserId.equals(""))) {
                    bRetries = false;
                    if (oiRetries != null) {
                        warnings.add(Warnings.NO_USERNAME_SUPPLIED);
                    }
                    this.forwardUser(oRequest, oResponse, oSession, iTries, bRetries, warnings);
                    return UserEvent.AUTHN_METHOD_IN_PROGRESS;
                }
                oUser = this._oUserFactory.getUser(sUserId);
                if (oUser == null) {
                    throw new UserException(UserEvent.AUTHN_METHOD_NOT_SUPPORTED);
                }
                oSession.setUser(oUser);
            }
            if (!oUser.isEnabled()) {
                throw new UserException(UserEvent.USER_DISABLED);
            }
            if (!oUser.isAuthenticationRegistered(this._sMethodID)) {
                _oLogger.warn((Object)"Authentication Method is not registered for this user; aborting login attempt.");
                throw new UserException(UserEvent.AUTHN_METHOD_NOT_REGISTERED);
            }
            oOTP = (OTP)oAttributes.get(OTPAuthenticationMethod.class, this._sMethodID + OTP_NAME);
            if (oOTP == null) {
                oOTP = this._oOTPGenerator.generate(oUser);
                oAttributes.put(OTPAuthenticationMethod.class, this._sMethodID + OTP_NAME, (Object)oOTP);
                oSession.persist();
            }
            if (this.mustDistributeOTP(oRequest, oOTP, oUser, warnings)) {
                if (this._bDisableDistribute) {
                    _oLogger.debug((Object)("Distribute disabled for sending OTP: " + oOTP.getValue()));
                    oOTP.registerSent(System.currentTimeMillis());
                } else {
                    this._oOTPDistributor.distribute(oOTP, oUser);
                }
                bRetries = false;
                this.forwardPassword(oRequest, oResponse, oSession, iTries, bRetries, warnings);
                return UserEvent.AUTHN_METHOD_IN_PROGRESS;
            }
            String sCaptcha = null;
            if (this._bCaptchaEnabled && ((sCaptcha = oRequest.getParameter(CAPTCHA)) == null || sCaptcha.trim().length() <= 0)) {
                bRetries = false;
                warnings.add(Warnings.NO_CAPTCHA_SUPPLIED);
            }
            if ((sUserPassword = oRequest.getParameter(PASSWORD)) == null || sUserPassword.trim().equalsIgnoreCase("")) {
                bRetries = false;
                warnings.add(Warnings.NO_PASSWORD_SUPPLIED);
            }
            if (!warnings.isEmpty()) {
                throw new DetailedUserException(UserEvent.AUTHN_METHOD_IN_PROGRESS, warnings);
            }
            if (this._bCaptchaEnabled) {
                Class<?> cCaptchaEngine = null;
                try {
                    cCaptchaEngine = Class.forName("com.alfaariss.oa.helper.captcha.engine.CaptchaEngine");
                }
                catch (ClassNotFoundException e) {
                    _oLogger.error((Object)"Captcha enabled, but 'com.alfaariss.oa.helper.captcha.engine.CaptchaEngine' is not available", (Throwable)e);
                    throw new OAException(1);
                }
                byte[] baCaptchaHash = (byte[])oAttributes.get(cCaptchaEngine, CAPTCHA_HASH);
                if (!this.verifyCaptcha(sCaptcha, baCaptchaHash)) {
                    throw new DetailedUserException(UserEvent.AUTHN_METHOD_IN_PROGRESS, (Enum)Warnings.INVALID_CAPTCHA_SUPPLIED);
                }
                oAttributes.remove(cCaptchaEngine, CAPTCHA_HASH);
            }
            String sAuthUserId = null;
            if (this._oIDMapper != null) {
                sAuthUserId = this._oIDMapper.map(oUser.getID());
                if (sAuthUserId == null) {
                    throw new UserException(UserEvent.AUTHN_METHOD_FAILED);
                }
            } else {
                sAuthUserId = oUser.getID();
            }
            if (!this._oOTPGenerator.authenticate(oUser, oOTP, sAuthUserId, sUserPassword)) {
                throw new DetailedUserException(UserEvent.AUTHN_METHOD_IN_PROGRESS, (Enum)Warnings.INVALID_CREDENTIALS_SUPPLIED);
            }
            oSession.setUser(oUser);
            _oEventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_SUCCESSFUL, (IAuthority)this, null));
            userEvent = UserEvent.AUTHN_METHOD_SUCCESSFUL;
        }
        catch (OTPDistributorException ode) {
            _oEventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_FAILED, (IAuthority)this, "OTPDistributorException code " + ode.getCode()));
            userEvent = UserEvent.AUTHN_METHOD_FAILED;
        }
        catch (UserException e) {
            userEvent = e.getEvent();
            _oEventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), e.getEvent(), (IAuthority)this, null));
        }
        catch (DetailedUserException e) {
            if (iTries <= 0) {
                _oEventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_FAILED, (IAuthority)this, e.getDetails().toString()));
                userEvent = UserEvent.AUTHN_METHOD_FAILED;
            }
            this.forwardPassword(oRequest, oResponse, oSession, iTries, bRetries, e.getDetails());
            userEvent = e.getEvent();
        }
        return userEvent;
    }

    private boolean mustDistributeOTP(HttpServletRequest oRequest, OTP oOTP, IUser oUser, Vector<Enum> vWarnings) {
        if (oOTP.getTimesSent() == 0) {
            return true;
        }
        String sRequestResend = (String)oRequest.getAttribute(RESEND_OTP);
        if (sRequestResend != null && sRequestResend != "") {
            int iResendCount = oOTP.getTimesSent();
            if (iResendCount >= this._iAllowedOTPResends) {
                vWarnings.add(Warnings.OTP_NO_MORE_RESEND_ALLOWED);
                return false;
            }
            return true;
        }
        return false;
    }

    public void stop() {
        this._bEnabled = false;
        if (this._oOTPGenerator != null) {
            this._oOTPGenerator.stop();
            this._oOTPGenerator = null;
        }
        this._sIdTemplate = null;
        this._sPwdTemplate = null;
        this._sMethodID = null;
        this._sFriendlyName = null;
        this._oUserFactory = null;
        this._bCaptchaEnabled = false;
        this._CryptoManager = null;
        this._oEngine = null;
        this._iAllowedTries = 0;
    }

    private void forwardUser(HttpServletRequest request, HttpServletResponse response, ISession session, int iTries, boolean bRetries, List<Enum> warnings) throws OAException {
        try {
            RequestDispatcher dispatcher;
            request.setAttribute("asid", (Object)session.getId());
            request.setAttribute("sessionLocale", (Object)session.getLocale());
            request.setAttribute(HASCAPTCHA, (Object)this._bCaptchaEnabled);
            ISessionAttributes oAttributes = session.getAttributes();
            oAttributes.put(OTPAuthenticationMethod.class, this._sMethodID + "retries", (Object)iTries);
            session.persist();
            _oEventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.AUTHN_METHOD_IN_PROGRESS, (IAuthority)this, warnings.toString()));
            request.setAttribute("details", warnings);
            request.setAttribute("methodFriendlyName", (Object)this._sFriendlyName);
            request.setAttribute("serverInfo", (Object)this._oEngine.getServer());
            IUser oUser = session.getUser();
            if (oUser != null) {
                request.setAttribute("user_id", (Object)oUser.getID());
            }
            if ((dispatcher = request.getRequestDispatcher(this._sIdTemplate)) != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (IOException e) {
            _oLogger.warn((Object)"IO exception occured while forwarding", (Throwable)e);
            throw new OAException(1);
        }
        catch (ServletException e) {
            _oLogger.warn((Object)"Servlet exception occured while forwarding", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void forwardPassword(HttpServletRequest request, HttpServletResponse response, ISession session, int iTries, boolean bRetries, List<Enum> warnings) throws OAException {
        try {
            if (iTries == 1 && this._iAllowedTries != 1) {
                warnings.add(Warnings.ONE_RETRY_LEFT);
            }
            request.setAttribute("asid", (Object)session.getId());
            request.setAttribute("sessionLocale", (Object)session.getLocale());
            request.setAttribute(HASCAPTCHA, (Object)this._bCaptchaEnabled);
            if (bRetries) {
                --iTries;
            }
            ISessionAttributes oAttributes = session.getAttributes();
            oAttributes.put(OTPAuthenticationMethod.class, this._sMethodID + "retries", (Object)iTries);
            session.persist();
            _oEventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.AUTHN_METHOD_IN_PROGRESS, (IAuthority)this, warnings.toString()));
            request.setAttribute("details", warnings);
            request.setAttribute("methodFriendlyName", (Object)this._sFriendlyName);
            request.setAttribute("serverInfo", (Object)this._oEngine.getServer());
            IUser oUser = session.getUser();
            if (oUser == null) {
                _oLogger.error((Object)"User disappeared from session when asking for password!");
                throw new OAException(1);
            }
            request.setAttribute("user_id", (Object)oUser.getID());
            RequestDispatcher dispatcher = request.getRequestDispatcher(this._sPwdTemplate);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (IOException e) {
            _oLogger.warn((Object)"IO exception occured while forwarding", (Throwable)e);
            throw new OAException(1);
        }
        catch (ServletException e) {
            _oLogger.warn((Object)"Servlet exception occured while forwarding", (Throwable)e);
            throw new OAException(1);
        }
    }

    private boolean verifyCaptcha(String sSuppliedCaptcha, byte[] baSessionCaptcha) throws OAException {
        boolean bValidCaptcha = false;
        try {
            MessageDigest oMessageDigest = null;
            oMessageDigest = this._CryptoManager.getMessageDigest();
            oMessageDigest.update(sSuppliedCaptcha.getBytes("UTF-8"));
            byte[] baCaptcha = oMessageDigest.digest();
            bValidCaptcha = Arrays.equals(baSessionCaptcha, baCaptcha);
        }
        catch (CryptoException e) {
            _oLogger.warn((Object)"Unable to generate digest from captcha text", (Throwable)e);
            throw new OAException(1);
        }
        catch (Exception e) {
            _oLogger.warn((Object)"Unexpected error occured while generating digest", (Throwable)e);
            throw new OAException(1);
        }
        return bValidCaptcha;
    }

    private IIDMapper createMapper(Element eConfig) throws OAException {
        IIDMapper oMapper = null;
        try {
            String sClass = this._oConfigManager.getParam(eConfig, "class");
            if (sClass == null) {
                _oLogger.error((Object)"No 'class' parameter found in 'idmapper' section in configuration");
                throw new OAException(17);
            }
            Class<?> cMapper = null;
            try {
                cMapper = Class.forName(sClass);
            }
            catch (Exception e) {
                _oLogger.error((Object)("No 'class' found with name: " + sClass), (Throwable)e);
                throw new OAException(17);
            }
            try {
                oMapper = (IIDMapper)cMapper.newInstance();
            }
            catch (Exception e) {
                _oLogger.error((Object)("Could not create an 'IIDMapper' instance of the configured 'class': " + sClass), (Throwable)e);
                throw new OAException(17);
            }
            oMapper.start(this._oConfigManager, eConfig);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _oLogger.fatal((Object)"Internal error during creation of id mapper", (Throwable)e);
            throw new OAException(1);
        }
        return oMapper;
    }
}

