/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.auth.smsotp.distributor.cm;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.asimba.auth.smsotp.OTP;
import org.asimba.auth.smsotp.distributor.IOTPDistributor;
import org.asimba.auth.smsotp.distributor.OTPDistributorException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CMOTPDistributor
implements IOTPDistributor {
    protected IConfigurationManager _oConfigManager;
    private Logger _oLogger = Logger.getLogger(CMOTPDistributor.class);
    protected boolean _bStarted = false;
    protected String _sUrl;
    protected URL _oURL;
    private Integer _oiCustomerID;
    private String _sLogin;
    private String _sPassword;
    protected String _sFrom;
    protected String _sPhonenrAttribute;
    protected String _sMessageTemplate;

    @Override
    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        if (eConfig == null || oConfigurationManager == null) {
            this._oLogger.error((Object)"No configuration supplied");
            throw new OAException(17);
        }
        this._oConfigManager = oConfigurationManager;
        this._sUrl = this._oConfigManager.getParam(eConfig, "url");
        if (this._sUrl == null) {
            this._oLogger.error((Object)"No 'url' element found for 'CMOTPDistributor");
            throw new OAException(17);
        }
        try {
            this._oURL = new URL(this._sUrl);
        }
        catch (MalformedURLException mue) {
            this._oLogger.fatal((Object)"Invalid URL configured for CMOTPDistributor'");
            throw new OAException(2);
        }
        try {
            this._oiCustomerID = Integer.decode(this._oConfigManager.getParam(eConfig, "customerid"));
            if (this._oiCustomerID == null) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this._oLogger.fatal((Object)("Invalid 'customerid' configured for CMOTPDistributor': " + this._oiCustomerID));
            throw new OAException(2);
        }
        this._sLogin = this._oConfigManager.getParam(eConfig, "login");
        if (this._sLogin == null || this._sLogin.equals("")) {
            this._oLogger.error((Object)"No 'login' element found for 'CMOTPDistributor'");
            throw new OAException(17);
        }
        this._sPassword = this._oConfigManager.getParam(eConfig, "password");
        if (this._sPassword == null || this._sPassword.equals("")) {
            this._oLogger.error((Object)"No 'password' element found in 'CMOTPDistributor'");
            throw new OAException(17);
        }
        this._sFrom = this._oConfigManager.getParam(eConfig, "from");
        if (this._sFrom == null || this._sFrom.equals("")) {
            this._oLogger.debug((Object)"No 'from' element found for 'CMOTPDistributor', using defaults");
            this._sFrom = Engine.getInstance().getServer().getOrganization().getID();
        }
        this._sPhonenrAttribute = this._oConfigManager.getParam(eConfig, "phonenrattribute");
        if (this._sPhonenrAttribute == null || this._sPhonenrAttribute.equals("")) {
            this._oLogger.error((Object)"No 'phonenrattribute' element found for 'CMOTPDistributor'");
            throw new OAException(17);
        }
        this._sMessageTemplate = this._oConfigManager.getParam(eConfig, "messagetemplate");
        if (this._sMessageTemplate == null || this._sMessageTemplate.equals("")) {
            this._oLogger.debug((Object)"No 'messagetemplate' configured, using default");
            this._sMessageTemplate = "Password is :1";
        }
        this._bStarted = true;
        this._oLogger.info((Object)"Started CMOTPDistributor");
    }

    @Override
    public void stop() {
        this._bStarted = false;
    }

    @Override
    public int distribute(OTP oOtp, IUser oUser) throws OAException {
        if (!this._bStarted) {
            throw new OAException(3);
        }
        IAttributes oUserAttributes = oUser.getAttributes();
        if (!oUserAttributes.contains(this._sPhonenrAttribute)) {
            this._oLogger.error((Object)("Unknown phonenr for user " + oUser.getID() + "; missing attribute '" + this._sPhonenrAttribute + "'"));
            throw new OTPDistributorException(0);
        }
        String sRecipient = (String)oUserAttributes.get(this._sPhonenrAttribute);
        String sMsg = this.getMessageForPwd(oOtp.getValue());
        String sPostbody = this.createPostBody(sMsg, sRecipient);
        String sResult = this.postPostBody(this._oURL, sPostbody);
        if (sResult != null && sResult.length() > 0) {
            this._oLogger.error((Object)("Error sending message; gateway said: '" + sResult + "'"));
            throw new OTPDistributorException(1);
        }
        oOtp.registerSent(System.currentTimeMillis());
        return 0;
    }

    protected String getMessageForPwd(String sPassword) {
        return this._sMessageTemplate.replaceAll(":1", sPassword);
    }

    protected String createPostBody(String sMessage, String sRecipient) throws OAException {
        try {
            ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
            DocumentBuilderFactory oDBFactory = DocumentBuilderFactory.newInstance();
            oDBFactory.setNamespaceAware(true);
            DocumentBuilder oDocBuilder = oDBFactory.newDocumentBuilder();
            DOMImplementation oDOMImpl = oDocBuilder.getDOMImplementation();
            Document oDocument = oDOMImpl.createDocument(null, "MESSAGES", null);
            Element oElRoot = oDocument.getDocumentElement();
            Element oElCustomer = oDocument.createElement("CUSTOMER");
            oElCustomer.setAttribute("ID", "" + this._oiCustomerID.toString());
            oElRoot.appendChild(oElCustomer);
            Element oElUser = oDocument.createElement("USER");
            oElUser.setAttribute("LOGIN", this._sLogin);
            oElUser.setAttribute("PASSWORD", this._sPassword);
            oElRoot.appendChild(oElUser);
            Element oElMessage = oDocument.createElement("MSG");
            oElRoot.appendChild(oElMessage);
            Element oElFrom = oDocument.createElement("FROM");
            Text oTxtFrom = oDocument.createTextNode("FROM");
            oTxtFrom.setNodeValue(this._sFrom);
            oElFrom.appendChild(oTxtFrom);
            oElMessage.appendChild(oElFrom);
            Element oElBody = oDocument.createElement("BODY");
            Text oTxtBody = oDocument.createTextNode("BODY");
            oTxtBody.setNodeValue(sMessage);
            oElBody.appendChild(oTxtBody);
            oElBody.setAttribute("TYPE", "TEXT");
            oElMessage.appendChild(oElBody);
            Element oElTo = oDocument.createElement("TO");
            Text oTxtTo = oDocument.createTextNode("TO");
            oTxtTo.setNodeValue(sRecipient);
            oElTo.appendChild(oTxtTo);
            oElMessage.appendChild(oElTo);
            TransformerFactory oTransformerFactory = TransformerFactory.newInstance();
            Transformer oTransformer = oTransformerFactory.newTransformer();
            oTransformer.setOutputProperty("indent", "yes");
            DOMSource oDomSource = new DOMSource(oDocument);
            StreamResult oResult = new StreamResult(oBAOS);
            oTransformer.transform(oDomSource, oResult);
            return oBAOS.toString();
        }
        catch (ParserConfigurationException e) {
            this._oLogger.error((Object)("ParserConfigurationException occurred when building arguments for CMOTPDistributor: " + e.getMessage()));
            throw new OAException(1);
        }
        catch (TransformerConfigurationException e) {
            this._oLogger.error((Object)("TransformerConfigurationException occurred when building arguments for CMOTPDistributor: " + e.getMessage()));
            throw new OAException(1);
        }
        catch (TransformerException e) {
            this._oLogger.error((Object)("TransformerException occurred when building arguments for CMOTPDistributor: " + e.getMessage()));
            throw new OAException(1);
        }
    }

    private String postPostBody(URL oUrl, String sBodydata) throws OAException {
        try {
            String s;
            URLConnection oConn = oUrl.openConnection();
            oConn.setDoOutput(true);
            OutputStreamWriter oOut = new OutputStreamWriter(oConn.getOutputStream());
            oOut.write(sBodydata);
            oOut.flush();
            BufferedReader oIn = new BufferedReader(new InputStreamReader(oConn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((s = oIn.readLine()) != null) {
                sb.append(s);
            }
            oOut.close();
            oIn.close();
            return sb.toString();
        }
        catch (IOException e) {
            this._oLogger.error((Object)("IOException occurred when sending data with CMOTPDistributor: " + e.getMessage()));
            throw new OAException(1);
        }
    }
}

