/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.auth.smsotp.generator;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.user.IUser;
import java.security.SecureRandom;
import org.apache.log4j.Logger;
import org.asimba.auth.smsotp.OTP;
import org.asimba.auth.smsotp.generator.IOTPGenerator;
import org.w3c.dom.Element;

public class BasicOTPGenerator
implements IOTPGenerator {
    private IConfigurationManager _oConfigManager;
    private static final Logger _oLogger = Logger.getLogger(BasicOTPGenerator.class);
    private boolean _bStarted = false;
    private int _iPasswordLength;
    private long _lAllowedAge;
    private static SecureRandom _oRandomGenerator;

    @Override
    public boolean authenticate(IUser oUser, OTP oOtp, String sUsername, String sPassword) throws OAException, UserException {
        if (!this._bStarted) {
            throw new OAException(3);
        }
        if (oOtp.getTimesSent() == 0) {
            _oLogger.warn((Object)"User tried to authenticate with unsent OneTimePassword.");
            return false;
        }
        if (oOtp.getTimeSent() < System.currentTimeMillis() - this._lAllowedAge) {
            _oLogger.warn((Object)"User tried to authenticate with expired OneTimePassword.");
            return false;
        }
        return sPassword.equals(oOtp.getValue());
    }

    @Override
    public OTP generate(IUser oUser) throws OAException, UserException {
        if (!this._bStarted) {
            throw new OAException(3);
        }
        StringBuffer sbNewPassword = new StringBuffer();
        for (int i = 0; i < this._iPasswordLength; ++i) {
            sbNewPassword.append(_oRandomGenerator.nextInt(10));
        }
        OTP oResultOtp = new OTP();
        oResultOtp.setTimeGenerated(System.currentTimeMillis());
        oResultOtp.setTimesSent(0);
        oResultOtp.setTimeSent(new Long(0L));
        oResultOtp.setValue(sbNewPassword.toString());
        return oResultOtp;
    }

    @Override
    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        long lSalt;
        if (eConfig == null || oConfigurationManager == null) {
            _oLogger.error((Object)"No configuration supplied");
            throw new OAException(17);
        }
        this._oConfigManager = oConfigurationManager;
        String sSalt = this._oConfigManager.getParam(eConfig, "salt");
        if (sSalt == null || sSalt.equals("")) {
            _oLogger.warn((Object)"No 'salt' found in BasicOtpGenerator configuration; using default value.");
            sSalt = Long.toString(System.currentTimeMillis());
        }
        try {
            lSalt = Integer.parseInt(sSalt);
        }
        catch (NumberFormatException e) {
            _oLogger.error((Object)"Invalid 'salt' item BasicOtpGenerator configuration.", (Throwable)e);
            throw new OAException(17);
        }
        _oRandomGenerator = new SecureRandom();
        _oRandomGenerator.setSeed(lSalt);
        String sPasswordLength = this._oConfigManager.getParam(eConfig, "length");
        if (sPasswordLength == null || sPasswordLength.equals("")) {
            _oLogger.debug((Object)"No 'length' found in BasicOtpGenerator configuration; using default value.");
            sSalt = "6";
        }
        try {
            this._iPasswordLength = Integer.parseInt(sPasswordLength);
        }
        catch (NumberFormatException e) {
            _oLogger.error((Object)"Invalid 'length' item BasicOtpGenerator configuration.", (Throwable)e);
            throw new OAException(17);
        }
        String sAllowedAge = this._oConfigManager.getParam(eConfig, "allowed_age");
        if (sAllowedAge == null || sAllowedAge.equals("")) {
            _oLogger.debug((Object)"No 'allowed_age' found in BasicOtpGenerator configuration; using default value.");
            sAllowedAge = "600";
        }
        try {
            this._lAllowedAge = 1000 * Integer.parseInt(sAllowedAge);
        }
        catch (NumberFormatException e) {
            _oLogger.error((Object)"Invalid 'allowed_age' item BasicOtpGenerator configuration.", (Throwable)e);
            throw new OAException(17);
        }
        this._bStarted = true;
        _oLogger.info((Object)"Started genersstor BasicOtpGenerator");
    }

    @Override
    public void stop() {
        this._bStarted = false;
    }
}

