/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.auth.smsotp.distributor.mollie;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.asimba.auth.smsotp.OTP;
import org.asimba.auth.smsotp.distributor.IOTPDistributor;
import org.asimba.auth.smsotp.distributor.OTPDistributorException;
import org.w3c.dom.Element;

public class MollieOTPDistributor
implements IOTPDistributor {
    protected IConfigurationManager _oConfigurationManager;
    private static Logger _oLogger = Logger.getLogger(MollieOTPDistributor.class);
    protected String _sUrl;
    protected URL _oURL;
    private String _sUsername;
    private String _sPassword;
    protected String _sSenderName;
    protected String _sPhonenrAttribute;
    protected String _sMessageTemplate;
    private boolean _bStarted = false;

    @Override
    public int distribute(OTP oOtp, IUser oUser) throws OAException, OTPDistributorException {
        if (!this._bStarted) {
            throw new OAException(3);
        }
        int returncode = 15;
        IAttributes oUserAttributes = oUser.getAttributes();
        if (!oUserAttributes.contains(this._sPhonenrAttribute)) {
            _oLogger.error((Object)("Unknown phonenr for user " + oUser.getID() + "; missing attribute '" + this._sPhonenrAttribute + "'"));
            throw new OTPDistributorException(returncode);
        }
        String sRecipient = (String)oUserAttributes.get(this._sPhonenrAttribute);
        String sMsg = this.getMessageForPwd(oOtp.getValue());
        StringBuffer sbData = new StringBuffer();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(StringUtils.join((Object[])new String[]{"gebruikersnaam", URLEncoder.encode(this._sUsername, "UTF-8")}, (String)"="));
            params.add(StringUtils.join((Object[])new String[]{"wachtwoord", URLEncoder.encode(this._sPassword, "UTF-8")}, (String)"="));
            params.add(StringUtils.join((Object[])new String[]{"afzender", URLEncoder.encode(this._sSenderName, "UTF-8")}, (String)"="));
            params.add(StringUtils.join((Object[])new String[]{"bericht", URLEncoder.encode(sMsg, "UTF-8")}, (String)"="));
            params.add(StringUtils.join((Object[])new String[]{"ontvangers", URLEncoder.encode(sRecipient, "UTF-8")}, (String)"="));
            String sCGIString = StringUtils.join(params, (String)"&");
            ++returncode;
            URLConnection oURLConnection = this._oURL.openConnection();
            ++returncode;
            oURLConnection.setDoOutput(true);
            OutputStreamWriter oWriter = new OutputStreamWriter(oURLConnection.getOutputStream());
            oWriter.write(sCGIString);
            oWriter.flush();
            ++returncode;
            BufferedReader oReader = new BufferedReader(new InputStreamReader(oURLConnection.getInputStream()));
            String sLine = oReader.readLine();
            if (sLine != null) {
                returncode = Integer.parseInt(sLine);
            }
            if (returncode != 0) {
                _oLogger.error((Object)("Mollie could not send sms, returncode from Mollie: " + returncode + "."));
                throw new OTPDistributorException(returncode);
            }
            ++returncode;
            oWriter.close();
            oReader.close();
        }
        catch (NumberFormatException e) {
            _oLogger.error((Object)("Sending SMS, using '" + this._oURL.toString() + ", data=" + sbData.toString() + "' failed due to number format exception!" + e.getMessage()));
            throw new OTPDistributorException(returncode);
        }
        catch (Exception e) {
            _oLogger.error((Object)("Sending SMS, using '" + this._oURL.toString() + ", data=" + sbData.toString() + "' failed (return code=" + returncode + ")! " + e.getMessage()));
            throw new OTPDistributorException(returncode);
        }
        _oLogger.info((Object)("Sending to user " + oUser.getID() + " password with value " + oOtp.getValue()));
        oOtp.registerSent(System.currentTimeMillis());
        return returncode;
    }

    protected String getMessageForPwd(String sPassword) {
        return this._sMessageTemplate.replaceAll(":1", sPassword);
    }

    @Override
    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        if (eConfig == null || oConfigurationManager == null) {
            _oLogger.error((Object)"No configuration supplied");
            throw new OAException(17);
        }
        this._oConfigurationManager = oConfigurationManager;
        this._sUrl = this._oConfigurationManager.getParam(eConfig, "url");
        if (this._sUrl == null) {
            _oLogger.error((Object)"No 'url' element found in 'MollieOtpDistributor");
            throw new OAException(17);
        }
        try {
            this._oURL = new URL(this._sUrl);
        }
        catch (MalformedURLException mue) {
            _oLogger.fatal((Object)"Invalid URL configured for MollieOtpDistributor'");
            throw new OAException(2);
        }
        this._sUsername = this._oConfigurationManager.getParam(eConfig, "username");
        if (this._sUsername == null || this._sUsername.equals("")) {
            _oLogger.error((Object)"No 'username' element found in 'MollieOtpDistributor'");
            throw new OAException(17);
        }
        this._sPassword = this._oConfigurationManager.getParam(eConfig, "password");
        if (this._sPassword == null || this._sPassword.equals("")) {
            _oLogger.error((Object)"No 'password' element found in 'MollieOtpDistributor'");
            throw new OAException(17);
        }
        this._sSenderName = this._oConfigurationManager.getParam(eConfig, "originator");
        if (this._sSenderName == null || this._sSenderName.equals("")) {
            _oLogger.debug((Object)"No 'originator' element found in 'MollieOtpDistributor', using defaults");
            this._sSenderName = Engine.getInstance().getServer().getOrganization().getID();
        }
        this._sPhonenrAttribute = this._oConfigurationManager.getParam(eConfig, "phonenrattribute");
        if (this._sPhonenrAttribute == null || this._sPhonenrAttribute.equals("")) {
            _oLogger.error((Object)"No 'phonenrattribute' element found in 'MollieOtpDistributor'");
            throw new OAException(17);
        }
        this._sMessageTemplate = this._oConfigurationManager.getParam(eConfig, "messagetemplate");
        if (this._sMessageTemplate == null || this._sMessageTemplate.equals("")) {
            _oLogger.debug((Object)"No 'messagetemplate' configured, using default");
            this._sMessageTemplate = "Password is :1";
        }
        this._bStarted = true;
    }

    @Override
    public void stop() {
        this._bStarted = false;
    }
}

