/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.remote.aselect;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.api.sso.logout.IASLogout;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.authentication.remote.AbstractRemoteMethod;
import com.alfaariss.oa.authentication.remote.aselect.ASelectRemoteUser;
import com.alfaariss.oa.authentication.remote.aselect.Warnings;
import com.alfaariss.oa.authentication.remote.aselect.idp.storage.ASelectIDP;
import com.alfaariss.oa.authentication.remote.aselect.logout.LogoutManager;
import com.alfaariss.oa.authentication.remote.aselect.selector.ISelector;
import com.alfaariss.oa.engine.core.attribute.AttributeException;
import com.alfaariss.oa.engine.core.attribute.UserAttributes;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import com.alfaariss.oa.engine.core.authentication.factory.IAuthenticationProfileFactory;
import com.alfaariss.oa.engine.core.idp.IDPStorageManager;
import com.alfaariss.oa.engine.core.idp.storage.IIDPStorage;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.user.provisioning.ProvisioningUser;
import com.alfaariss.oa.engine.user.provisioning.storage.external.IExternalStorage;
import com.alfaariss.oa.engine.user.provisioning.translator.standard.StandardProfile;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.session.ProxyAttributes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;
import org.asimba.authentication.remote.provisioning.aselect.CredentialResponseUserStorage;
import org.asimba.utility.attributes.AttributeHelper;
import org.w3c.dom.Element;

public class RemoteASelectMethod
extends AbstractRemoteMethod
implements IASLogout {
    public static final String TGT_LOGOUT_ORGANIZATION = "aslogout_organization";
    private static final String AUTHORITY_NAME = "RemoteASelectMethod_";
    private static final String SESSION_SELECTED_ORGANIZATION = "organization";
    private static final String SESSION_AVAILABLE_ORGANIZATIONS = "available_organizations";
    private static final String SESSION_PROXY_REQUIRED_LEVEL = "required_level";
    private static final String SESSION_LOGOUT_ORGANIZATION = "aslogout_organization";
    private static final String SESSION_PROXY_ARP_TARGET = "arp_target";
    private static final String SINGLE_LOGOUT = "slo";
    private static final String AUTHENTICATE = "authenticate";
    private static final String VERIFY_CREDENTIALS = "verify_credentials";
    private static final String ERROR_ASELECT_SUCCESS = "0000";
    private static final String ERROR_ASELECT_SERVER_UNKNOWN_TGT = "0007";
    private static final String ERROR_ASELECT_CANCEL = "0040";
    public static final String PARAM_REQUEST = "request";
    public static final String PARAM_RID = "rid";
    public static final String PARAM_FORCED = "forced_logon";
    public static final String PARAM_LOCAL_AS_URL = "local_as_url";
    public static final String PARAM_LOCAL_ORG = "local_organization";
    public static final String PARAM_ASELECTSERVER = "a-select-server";
    public static final String PARAM_UID = "uid";
    public static final String PARAM_COUNTRY = "country";
    public static final String PARAM_LANGUAGE = "language";
    public static final String PARAM_RESULTCODE = "result_code";
    public static final String PARAM_AS_URL = "as_url";
    public static final String PARAM_ASELECTCREDENTIALS = "aselect_credentials";
    public static final String PARAM_ORGANIZATION = "organization";
    public static final String PARAM_AUTHSP_LEVEL = "authsp_level";
    public static final String PARAM_AUTHSP = "authsp";
    public static final String PARAM_APP_LEVEL = "app_level";
    public static final String PARAM_TGT_EXP_TIME = "tgt_exp_time";
    public static final String PARAM_ATTRIBUTES = "attributes";
    public static final String PARAM_SIGNATURE = "signature";
    public static final String PARAM_REMOTE_ORGANIZATION = "remote_organization";
    public static final String PARAM_REQUIRED_LEVEL = "required_level";
    public static final String PARAM_ARP_TARGET = "arp_target";
    private IAuthenticationProfileFactory _authNProfileFactory;
    private String _sMyOrganization;
    private ISelector _oSelector;
    private boolean _bFallback;
    private Hashtable<String, String> _htAttributeMapper;
    private IIDPStorage _idpStorage;
    private LogoutManager _logoutManager;
    private ITGTAliasStore _aliasStoreIDPRole;
    private String _sForceAuthNProfile;
    protected StandardProfile _oRemoteASelectUserProvisioningProfile;

    public RemoteASelectMethod() {
        this._logger = LogFactory.getLog(RemoteASelectMethod.class);
        this._htAttributeMapper = new Hashtable();
        this._bFallback = false;
        this._logoutManager = null;
        this._sForceAuthNProfile = null;
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            Element elProvisioning;
            Element eReplay;
            super.start(oConfigurationManager, eConfig);
            this._authNProfileFactory = this._engine.getAuthenticationProfileFactory();
            Element eSelector = this._configurationManager.getSection(eConfig, "selector");
            if (eSelector == null) {
                this._logger.info((Object)"No optional 'selector' section found in configuration");
            } else {
                String sSelectorClass = this._configurationManager.getParam(eSelector, "class");
                if (sSelectorClass == null) {
                    this._logger.error((Object)"No 'class' item in 'selector' section found");
                    throw new OAException(17);
                }
                try {
                    this._oSelector = (ISelector)Class.forName(sSelectorClass).newInstance();
                }
                catch (InstantiationException e) {
                    this._logger.error((Object)("Can't create an instance of the configured class: " + sSelectorClass), (Throwable)e);
                    throw new OAException(17, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this._logger.error((Object)("Configured class can't be accessed: " + sSelectorClass), (Throwable)e);
                    throw new OAException(17, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    this._logger.error((Object)("Configured class doesn't exist: " + sSelectorClass), (Throwable)e);
                    throw new OAException(17, (Throwable)e);
                }
                catch (ClassCastException e) {
                    this._logger.error((Object)("Configured class isn't of type 'ISelector': " + sSelectorClass), (Throwable)e);
                    throw new OAException(17, (Throwable)e);
                }
                this._oSelector.start(this._configurationManager, eSelector);
            }
            Element eOrganizations = this._configurationManager.getSection(eConfig, "idps");
            if (eOrganizations == null) {
                this._logger.error((Object)"No 'idps' section found in configuration");
                throw new OAException(17);
            }
            this._bFallback = false;
            String sFallback = this._configurationManager.getParam(eOrganizations, "fallback");
            if (sFallback != null) {
                if (sFallback.equalsIgnoreCase("TRUE")) {
                    this._bFallback = true;
                } else if (!sFallback.equalsIgnoreCase("FALSE")) {
                    this._logger.error((Object)("Invalid 'fallback' item found in 'idps' section in configuration: " + sFallback));
                    throw new OAException(17);
                }
            }
            this._idpStorage = this.createStorage(eOrganizations);
            this._idpStorage.start(oConfigurationManager, eOrganizations);
            IDPStorageManager idpStorageManager = this._engine.getIDPStorageManager();
            if (idpStorageManager.existStorage(this._idpStorage.getID())) {
                this._logger.error((Object)("Storage not unique: " + this._idpStorage.getID()));
                throw new OAException(2);
            }
            idpStorageManager.addStorage(this._idpStorage);
            this._sMyOrganization = this._engine.getServer().getOrganization().getID();
            Element eMapper = oConfigurationManager.getSection(eConfig, "attributemapper");
            if (eMapper == null) {
                this._logger.info((Object)"No optional 'attributemapper' section found in configuration");
            } else {
                Element eMap = oConfigurationManager.getSection(eMapper, "map");
                while (eMap != null) {
                    String sExt = oConfigurationManager.getParam(eMap, "ext");
                    if (sExt == null) {
                        this._logger.error((Object)"No 'ext' item found in 'map' section");
                        throw new AttributeException(17);
                    }
                    String sInt = oConfigurationManager.getParam(eMap, "int");
                    if (sInt == null) {
                        this._logger.error((Object)"No 'int' item found in 'map' section");
                        throw new AttributeException(17);
                    }
                    if (this._htAttributeMapper.containsKey(sExt)) {
                        this._logger.error((Object)("Ext name not unique in map with 'ext' value: " + sExt));
                        throw new AttributeException(2);
                    }
                    if (this._htAttributeMapper.contains(sInt)) {
                        this._logger.error((Object)("Int name not unique in map with 'int' value: " + sInt));
                        throw new AttributeException(2);
                    }
                    this._htAttributeMapper.put(sExt, sInt);
                    eMap = oConfigurationManager.getNextSection(eMap);
                }
            }
            this._aliasStoreIDPRole = null;
            this._logoutManager = new LogoutManager(oConfigurationManager, eConfig, this._idpStorage, this._sMethodId);
            if (this._logoutManager.isEnabled()) {
                this._aliasStoreIDPRole = this._engine.getTGTFactory().getAliasStoreIDP();
                if (this._aliasStoreIDPRole == null) {
                    this._logger.error((Object)"No IDP Role TGT Alias Store available");
                    throw new OAException(2);
                }
                this._engine.getTGTFactory().addListener((ITGTListener)this._logoutManager);
            }
            if ((eReplay = this._configurationManager.getSection(eConfig, "replay")) != null) {
                this.readReplay(eReplay);
            }
            if ((elProvisioning = oConfigurationManager.getSection(eConfig, "provisioning")) == null) {
                this._oRemoteASelectUserProvisioningProfile = null;
                this._logger.info((Object)"Default Remote ASelect User provisioning");
            } else {
                this._oRemoteASelectUserProvisioningProfile = new StandardProfile();
                this._oRemoteASelectUserProvisioningProfile.start(oConfigurationManager, elProvisioning, null);
                this._logger.info((Object)"Remote ASelect User provisioning configured.");
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during start", (Throwable)e);
            throw new OAException(1);
        }
    }

    public void stop() {
        super.stop();
        this._oSelector = null;
        if (this._htAttributeMapper != null) {
            this._htAttributeMapper.clear();
        }
        if (this._idpStorage != null) {
            this._engine.getIDPStorageManager().removeStorage(this._idpStorage.getID());
            this._idpStorage.stop();
        }
        if (this._logoutManager != null) {
            try {
                this._engine.getTGTFactory().removeListener((ITGTListener)this._logoutManager);
            }
            catch (OAException e) {
                this._logger.warn((Object)"Could not remove TGT listener (Logout manager)", (Throwable)e);
            }
        }
    }

    public String getAuthority() {
        return AUTHORITY_NAME + this._sMethodId;
    }

    public UserEvent authenticate(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession) throws OAException {
        ISessionAttributes oAttributes = oSession.getAttributes();
        Vector<ASelectIDP> listAvailableOrganizations = (Vector<ASelectIDP>)oAttributes.get(RemoteASelectMethod.class, this._sMethodId + SESSION_AVAILABLE_ORGANIZATIONS);
        if (listAvailableOrganizations == null) {
            listAvailableOrganizations = new Vector<ASelectIDP>();
            listAvailableOrganizations.addAll(this._idpStorage.getAll());
        }
        if (oRequest.getParameter(PARAM_ASELECTCREDENTIALS) == null && oAttributes.contains(RemoteASelectMethod.class, this._sMethodId + "organization")) {
            oAttributes.remove(RemoteASelectMethod.class, this._sMethodId + "organization");
            this._logger.debug((Object)"User returned from organization by using browser back button");
            if (this.performReplay(oSession, oAttributes)) {
                return UserEvent.AUTHN_METHOD_IN_PROGRESS;
            }
        }
        return this.authenticate(oRequest, oResponse, oSession, oAttributes, listAvailableOrganizations, new Vector<Warnings>());
    }

    public boolean canLogout(ITGT tgt) throws OAException {
        if (tgt == null) {
            this._logger.error((Object)"No TGT supplied");
            throw new OAException(1);
        }
        IUser user = tgt.getUser();
        if (user == null) {
            this._logger.error((Object)"No user available in TGT");
            throw new OAException(1);
        }
        ASelectIDP org = (ASelectIDP)this._idpStorage.getIDP(user.getOrganization());
        if (org != null && org.hasASynchronousLogout()) {
            String sASelectCredentials = this._aliasStoreIDPRole.getAlias(PARAM_ASELECTCREDENTIALS, org.getID(), tgt.getId());
            return sASelectCredentials != null;
        }
        return false;
    }

    public UserEvent logout(HttpServletRequest request, HttpServletResponse response, ITGT tgt, ISession session) throws OAException {
        try {
            if (tgt == null) {
                this._logger.error((Object)"No TGT supplied");
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "no tgt"));
                return UserEvent.INTERNAL_ERROR;
            }
            IUser user = tgt.getUser();
            if (user == null) {
                this._logger.error((Object)"No user available in TGT");
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "invalid tgt"));
                return UserEvent.INTERNAL_ERROR;
            }
            ISessionAttributes sessionAttributes = session.getAttributes();
            ASelectIDP oASelectIDP = null;
            if (sessionAttributes.contains(RemoteASelectMethod.class, this._sMethodId + "aslogout_organization")) {
                oASelectIDP = (ASelectIDP)((Object)sessionAttributes.get(RemoteASelectMethod.class, this._sMethodId + "aslogout_organization"));
                if (!oASelectIDP.getID().equals(user.getOrganization())) {
                    StringBuffer sbDebug = new StringBuffer("Session invalid; User was logging out at '");
                    sbDebug.append(oASelectIDP.getID());
                    sbDebug.append("' instead of: ");
                    sbDebug.append(user.getOrganization());
                    this._logger.debug((Object)sbDebug.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, "invalid organization"));
                    return UserEvent.USER_LOGOUT_FAILED;
                }
                return this.logoutFinished(oASelectIDP, tgt, session, request);
            }
            oASelectIDP = (ASelectIDP)this._idpStorage.getIDP(user.getOrganization());
            if (oASelectIDP == null) {
                this._logger.warn((Object)("Organization unknown: " + user.getOrganization()));
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, "unknown organization: " + user.getOrganization()));
                return UserEvent.USER_LOGOUT_FAILED;
            }
            sessionAttributes.put(RemoteASelectMethod.class, this._sMethodId + "aslogout_organization", (Object)oASelectIDP);
            String sASelectCredentials = this._aliasStoreIDPRole.getAlias(PARAM_ASELECTCREDENTIALS, oASelectIDP.getID(), tgt.getId());
            return this.performLogout(request, response, session, oASelectIDP, sASelectCredentials, tgt);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error when performing asynchronous logout", (Throwable)e);
            throw new OAException(1);
        }
    }

    private UserEvent performLogout(HttpServletRequest request, HttpServletResponse response, ISession session, ASelectIDP oASelectIDP, String sASelectCredentials, ITGT tgt) throws OAException {
        Hashtable<String, String> htRequest = new Hashtable<String, String>();
        try {
            StringBuffer sbMyURL = new StringBuffer();
            sbMyURL.append(request.getRequestURL().toString());
            sbMyURL.append("?").append("asid");
            sbMyURL.append("=").append(URLEncoder.encode(session.getId(), "UTF-8"));
            htRequest.put(PARAM_LOCAL_AS_URL, sbMyURL.toString());
            htRequest.put(PARAM_LOCAL_ORG, this._sMyOrganization);
            htRequest.put(PARAM_ASELECTSERVER, oASelectIDP.getServerID());
            htRequest.put(PARAM_ASELECTCREDENTIALS, sASelectCredentials);
            if (oASelectIDP.doSigning()) {
                String sSignature = this.createSignature(htRequest);
                htRequest.put(PARAM_SIGNATURE, sSignature);
            }
            htRequest.put(PARAM_REQUEST, SINGLE_LOGOUT);
            Hashtable htResponse = null;
            try {
                htResponse = this.sendRequest(oASelectIDP.getURL(), htRequest);
            }
            catch (IOException e) {
                this._logger.debug((Object)("Could not send single logout request to: " + oASelectIDP.getURL()), (Throwable)e);
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, "No logout response from: " + oASelectIDP.getID()));
                return UserEvent.USER_LOGOUT_FAILED;
            }
            String sResultCode = (String)htResponse.get(PARAM_RESULTCODE);
            if (sResultCode == null) {
                StringBuffer sbError = new StringBuffer("Required parameter (");
                sbError.append(PARAM_RESULTCODE);
                sbError.append(") not found in request=logout response (");
                sbError.append(htResponse);
                sbError.append(") from A-Select Organization: ");
                sbError.append(oASelectIDP.getServerID());
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, "Invalid logout response"));
                return UserEvent.USER_LOGOUT_FAILED;
            }
            if (!ERROR_ASELECT_SUCCESS.equals(sResultCode)) {
                if (sResultCode.equals(ERROR_ASELECT_SERVER_UNKNOWN_TGT)) {
                    this._logger.debug((Object)("Credentials are unkown at the remote server, server returned result code: " + sResultCode));
                    return this.logoutFinished(oASelectIDP, tgt, session, request);
                }
                StringBuffer sbError = new StringBuffer("Response parameter (");
                sbError.append(PARAM_RESULTCODE);
                sbError.append(") from A-Select Organization '");
                sbError.append(oASelectIDP.getServerID());
                sbError.append("' contains error code: ");
                sbError.append(sResultCode);
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, sResultCode));
                return UserEvent.USER_LOGOUT_FAILED;
            }
            String sRemoteRid = (String)htResponse.get(PARAM_RID);
            if (sRemoteRid == null) {
                StringBuffer sbError = new StringBuffer("Required parameter (");
                sbError.append(PARAM_RID);
                sbError.append(") not found in request=logout response (");
                sbError.append(htResponse);
                sbError.append(") from A-Select Organization: ");
                sbError.append(oASelectIDP.getServerID());
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, "Invalid logout response"));
                return UserEvent.USER_LOGOUT_FAILED;
            }
            String sRemoteUrl = (String)htResponse.get(PARAM_AS_URL);
            if (sRemoteUrl == null) {
                StringBuffer sbError = new StringBuffer("Required parameter (");
                sbError.append(PARAM_AS_URL);
                sbError.append(") not found in request=logout response (");
                sbError.append(htResponse);
                sbError.append(") from A-Select Organization: ");
                sbError.append(oASelectIDP.getServerID());
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, "Invalid logout response"));
                return UserEvent.USER_LOGOUT_FAILED;
            }
            StringBuffer sbRedirect = new StringBuffer(sRemoteUrl);
            sbRedirect.append("&").append(PARAM_RID);
            sbRedirect.append("=").append(sRemoteRid);
            sbRedirect.append("&").append(PARAM_ASELECTSERVER);
            sbRedirect.append("=").append(oASelectIDP.getServerID());
            this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGOUT_IN_PROGRESS, (IAuthority)this, "Redirect user with request=logout"));
            session.persist();
            this._logger.debug((Object)("Redirecting user to: " + sbRedirect.toString()));
            try {
                response.sendRedirect(sbRedirect.toString());
            }
            catch (IOException e) {
                this._logger.debug((Object)("Could not send logout request to: " + sbRedirect.toString()), (Throwable)e);
                return UserEvent.USER_LOGOUT_FAILED;
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during logout initiation", (Throwable)e);
            throw new OAException(1);
        }
        return UserEvent.USER_LOGOUT_IN_PROGRESS;
    }

    private UserEvent logoutFinished(ASelectIDP oASelectIDP, ITGT tgt, ISession session, HttpServletRequest request) throws OAException {
        this._eventLogger.info((Object)new UserEventLogItem(session, request.getRemoteAddr(), UserEvent.USER_LOGGED_OUT, (IAuthority)this, oASelectIDP.getID()));
        tgt.getAttributes().put(RemoteASelectMethod.class, this._sMethodId + "aslogout_organization", (Object)oASelectIDP);
        tgt.persist();
        this._logger.debug((Object)("Logout finished at: " + oASelectIDP.getID()));
        return UserEvent.USER_LOGGED_OUT;
    }

    private IIDPStorage createStorage(Element config) throws OAException {
        IIDPStorage storage = null;
        try {
            String sClass = this._configurationManager.getParam(config, "class");
            if (sClass == null) {
                this._logger.error((Object)"No 'class' item found in 'idps' section in configuration");
                throw new OAException(17);
            }
            Class<?> oClass = null;
            try {
                oClass = Class.forName(sClass);
            }
            catch (Exception e) {
                this._logger.error((Object)("No 'class' found with name: " + sClass), (Throwable)e);
                throw new OAException(17);
            }
            try {
                storage = (IIDPStorage)oClass.newInstance();
            }
            catch (Exception e) {
                this._logger.error((Object)("Could not create an 'IIDPStorage' instance of the configured 'class' found with name: " + sClass), (Throwable)e);
                throw new OAException(17);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during creation of storage object", (Throwable)e);
            throw new OAException(1);
        }
        return storage;
    }

    private UserEvent authenticate(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, ISessionAttributes oAttributes, List<ASelectIDP> listOrganizations, List<Warnings> oWarnings) throws OAException {
        UserEvent oUserEvent = null;
        try {
            if (listOrganizations.isEmpty()) {
                throw new UserException(UserEvent.AUTHN_METHOD_FAILED);
            }
            Collection cForcedOrganizations = null;
            ASelectIDP oASelectOrganization = null;
            if (oAttributes.contains(RemoteASelectMethod.class, this._sMethodId + "organization")) {
                oASelectOrganization = (ASelectIDP)((Object)oAttributes.get(RemoteASelectMethod.class, this._sMethodId + "organization"));
            } else {
                IUser oUser = oSession.getUser();
                if (oUser != null && !oUser.isAuthenticationRegistered(this.getID())) {
                    throw new UserException(UserEvent.AUTHN_METHOD_NOT_REGISTERED);
                }
                Vector<ASelectIDP> listSelectableOrganizations = new Vector<ASelectIDP>();
                cForcedOrganizations = (Collection)oAttributes.get(ProxyAttributes.class, "forced_organizations");
                if (cForcedOrganizations != null) {
                    for (Object oForceOrganization : cForcedOrganizations) {
                        String sForceOrganization = (String)oForceOrganization;
                        for (ASelectIDP oOrganization : listOrganizations) {
                            if (!oOrganization.getID().equals(sForceOrganization)) continue;
                            listSelectableOrganizations.add(oOrganization);
                        }
                    }
                }
                if (listSelectableOrganizations.isEmpty()) {
                    listSelectableOrganizations.addAll(listOrganizations);
                }
                if (this._oSelector == null) {
                    oASelectOrganization = (ASelectIDP)((Object)listSelectableOrganizations.get(0));
                    this._logger.debug((Object)("No selector configured, using: " + oASelectOrganization.getID()));
                } else {
                    try {
                        oASelectOrganization = this._oSelector.resolve(oRequest, oResponse, oSession, listSelectableOrganizations, this._sFriendlyName, oWarnings);
                    }
                    catch (OAException e) {
                        this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, oWarnings.toString()));
                        throw e;
                    }
                }
                if (oASelectOrganization == null) {
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_IN_PROGRESS, (IAuthority)this, null));
                    return UserEvent.AUTHN_METHOD_IN_PROGRESS;
                }
                oAttributes.put(RemoteASelectMethod.class, this._sMethodId + "organization", (Object)oASelectOrganization);
            }
            if (oRequest.getParameter(PARAM_ASELECTCREDENTIALS) != null) {
                oUserEvent = this.requestVerifyCredentials(oRequest, oSession, oASelectOrganization);
            } else {
                try {
                    oUserEvent = this.requestAuthenticate(oRequest, oResponse, oSession, oASelectOrganization, cForcedOrganizations);
                }
                catch (IOException e) {
                    this._logger.warn((Object)("Could not communicate with: " + oASelectOrganization.getURL()), (Throwable)e);
                    if (!this._bFallback) {
                        throw new UserException(UserEvent.AUTHN_METHOD_FAILED);
                    }
                    oAttributes.remove(RemoteASelectMethod.class, this._sMethodId + "organization");
                    listOrganizations.remove((Object)oASelectOrganization);
                    oAttributes.put(RemoteASelectMethod.class, this._sMethodId + SESSION_AVAILABLE_ORGANIZATIONS, listOrganizations);
                    oWarnings.add(Warnings.WARNING_ORGANIZATION_UNAVAILABLE);
                }
            }
            if (oUserEvent == null) {
                oUserEvent = this.authenticate(oRequest, oResponse, oSession, oAttributes, listOrganizations, oWarnings);
            }
        }
        catch (UserException e) {
            oUserEvent = e.getEvent();
            this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), oUserEvent, (IAuthority)this, null));
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during authenticate", (Throwable)e);
            if (oSession != null) {
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oRequest.getRemoteAddr(), null, (IAuthority)this, null));
            }
            throw new OAException(1);
        }
        return oUserEvent;
    }

    private UserEvent requestAuthenticate(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, ASelectIDP oASelectOrganization, Collection cForcedOrganizations) throws OAException, IOException {
        UserEvent oUserEvent = UserEvent.AUTHN_METHOD_FAILED;
        Hashtable<String, String> htRequest = new Hashtable<String, String>();
        try {
            String sArpTarget;
            String sUID = null;
            IUser oUser = oSession.getUser();
            sUID = oUser != null ? oUser.getID() : oSession.getForcedUserID();
            if (sUID != null) {
                if (this._idMapper != null && (sUID = this._idMapper.map(sUID)) == null) {
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_NOT_SUPPORTED, (IAuthority)this, "No user mapping"));
                    return UserEvent.AUTHN_METHOD_NOT_SUPPORTED;
                }
                htRequest.put(PARAM_UID, sUID);
            }
            htRequest.put(PARAM_FORCED, String.valueOf(oSession.isForcedAuthentication()));
            StringBuffer sbMyURL = new StringBuffer();
            sbMyURL.append(oRequest.getRequestURL().toString());
            sbMyURL.append("?").append("asid");
            sbMyURL.append("=").append(URLEncoder.encode(oSession.getId(), "UTF-8"));
            htRequest.put(PARAM_LOCAL_AS_URL, sbMyURL.toString());
            htRequest.put(PARAM_LOCAL_ORG, this._sMyOrganization);
            htRequest.put(PARAM_ASELECTSERVER, oASelectOrganization.getServerID());
            ISessionAttributes oAttributes = oSession.getAttributes();
            String sRequiredLevel = null;
            sRequiredLevel = oAttributes.contains(ProxyAttributes.class, "required_level") ? (String)oAttributes.get(ProxyAttributes.class, "required_level") : String.valueOf(oASelectOrganization.getLevel());
            htRequest.put("required_level", sRequiredLevel);
            String sCountry = null;
            String sLanguage = null;
            Locale oLocale = oSession.getLocale();
            if (oLocale != null) {
                sCountry = oLocale.getCountry();
                sLanguage = oLocale.getLanguage();
            }
            if (sCountry == null && oASelectOrganization.getCountry() != null) {
                sCountry = oASelectOrganization.getCountry();
            }
            if (sCountry != null) {
                htRequest.put(PARAM_COUNTRY, sCountry);
            }
            if (sLanguage == null && oASelectOrganization.getLanguage() != null) {
                sLanguage = oASelectOrganization.getLanguage();
            }
            if (sLanguage != null) {
                htRequest.put(PARAM_LANGUAGE, sLanguage);
            }
            if (cForcedOrganizations != null) {
                for (String sRemoteOrg : cForcedOrganizations) {
                    if (sRemoteOrg.equals(oASelectOrganization.getID())) continue;
                    htRequest.put(PARAM_REMOTE_ORGANIZATION, sRemoteOrg);
                    break;
                }
            }
            if (oASelectOrganization.isArpTargetEnabled() && (sArpTarget = this.resolveArpTarget(oAttributes, oSession.getRequestorId())) != null) {
                htRequest.put("arp_target", sArpTarget);
            }
            if (oASelectOrganization.doSigning()) {
                String sSignature = this.createSignature(htRequest);
                htRequest.put(PARAM_SIGNATURE, sSignature);
            }
            htRequest.put(PARAM_REQUEST, AUTHENTICATE);
            Hashtable htResponse = null;
            try {
                htResponse = this.sendRequest(oASelectOrganization.getURL(), htRequest);
            }
            catch (IOException e) {
                this._logger.debug((Object)("Could not send authenticate request to: " + oASelectOrganization.getURL()), (Throwable)e);
                throw e;
            }
            String sResultCode = (String)htResponse.get(PARAM_RESULTCODE);
            if (sResultCode == null) {
                StringBuffer sbError = new StringBuffer("Required parameter (");
                sbError.append(PARAM_RESULTCODE);
                sbError.append(") not found in request=authenticate response (");
                sbError.append(htResponse);
                sbError.append(") from A-Select Organization: ");
                sbError.append(oASelectOrganization.getServerID());
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid authenticate response"));
                throw new OAException(1);
            }
            if (!ERROR_ASELECT_SUCCESS.equals(sResultCode)) {
                StringBuffer sbError = new StringBuffer("Response parameter (");
                sbError.append(PARAM_RESULTCODE);
                sbError.append(") from A-Select Organization '");
                sbError.append(oASelectOrganization.getServerID());
                sbError.append("' contains error code: ");
                sbError.append(sResultCode);
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_FAILED, (IAuthority)this, sResultCode));
                return UserEvent.AUTHN_METHOD_FAILED;
            }
            String sRemoteRid = (String)htResponse.get(PARAM_RID);
            if (sRemoteRid == null) {
                StringBuffer sbError = new StringBuffer("Required parameter (");
                sbError.append(PARAM_RID);
                sbError.append(") not found in request=authenticate response (");
                sbError.append(htResponse);
                sbError.append(") from A-Select Organization: ");
                sbError.append(oASelectOrganization.getServerID());
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid authenticate response"));
                throw new OAException(1);
            }
            String sRemoteLoginUrl = (String)htResponse.get(PARAM_AS_URL);
            if (sRemoteLoginUrl == null) {
                StringBuffer sbError = new StringBuffer("Required parameter (");
                sbError.append(PARAM_AS_URL);
                sbError.append(") not found in request=authenticate response (");
                sbError.append(htResponse);
                sbError.append(") from A-Select Organization: ");
                sbError.append(oASelectOrganization.getServerID());
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid authenticate response"));
                throw new OAException(1);
            }
            StringBuffer sbRedirect = new StringBuffer(sRemoteLoginUrl);
            sbRedirect.append("&").append(PARAM_RID);
            sbRedirect.append("=").append(sRemoteRid);
            sbRedirect.append("&").append(PARAM_ASELECTSERVER);
            sbRedirect.append("=").append(oASelectOrganization.getServerID());
            this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_IN_PROGRESS, (IAuthority)this, "Redirect user with request=login1"));
            oSession.persist();
            oUserEvent = UserEvent.AUTHN_METHOD_IN_PROGRESS;
            try {
                oResponse.sendRedirect(sbRedirect.toString());
            }
            catch (IOException e) {
                this._logger.debug((Object)("Could not send redirect: " + sbRedirect.toString()), (Throwable)e);
                throw e;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            if (oSession != null) {
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oRequest.getRemoteAddr(), null, (IAuthority)this, null));
            }
            this._logger.fatal((Object)("Internal error during 'request=authenticate' API call to: " + oASelectOrganization.getServerID()), (Throwable)e);
            throw new OAException(1);
        }
        return oUserEvent;
    }

    private UserEvent requestVerifyCredentials(HttpServletRequest oRequest, ISession oSession, ASelectIDP oASelectOrganization) throws OAException {
        UserEvent oUserEvent = UserEvent.AUTHN_METHOD_FAILED;
        Hashtable<String, String> htRequest = new Hashtable<String, String>();
        try {
            this._logger.debug((Object)("Processing request: " + oRequest.getParameterMap().keySet()));
            String sASelectServerId = oRequest.getParameter(PARAM_ASELECTSERVER);
            if (sASelectServerId == null) {
                StringBuffer sbError = new StringBuffer("No '");
                sbError.append(PARAM_ASELECTSERVER);
                sbError.append("' parameter found in request");
                this._logger.debug((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.REQUEST_INVALID, (IAuthority)this, "Missing a-select-server"));
                return UserEvent.REQUEST_INVALID;
            }
            if (!sASelectServerId.equals(oASelectOrganization.getServerID())) {
                StringBuffer sbError = new StringBuffer("Invalid '");
                sbError.append(PARAM_ASELECTSERVER);
                sbError.append("' parameter found in request: ");
                sbError.append(sASelectServerId);
                this._logger.debug((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.REQUEST_INVALID, (IAuthority)this, "Invalid a-select-server"));
                return UserEvent.REQUEST_INVALID;
            }
            String sRemoteRid = oRequest.getParameter(PARAM_RID);
            if (sRemoteRid == null) {
                StringBuffer sbError = new StringBuffer("Request parameter (");
                sbError.append(PARAM_RID);
                sbError.append(") not found in request from A-Select Organization: ");
                sbError.append(sASelectServerId);
                this._logger.debug((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.REQUEST_INVALID, (IAuthority)this, "Missing rid"));
                return UserEvent.REQUEST_INVALID;
            }
            String sASelectCredentials = oRequest.getParameter(PARAM_ASELECTCREDENTIALS);
            if (sASelectCredentials == null) {
                StringBuffer sbError = new StringBuffer("Request parameter (");
                sbError.append(PARAM_ASELECTCREDENTIALS);
                sbError.append(") not found in request from A-Select Organization: ");
                sbError.append(sASelectServerId);
                this._logger.debug((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.REQUEST_INVALID, (IAuthority)this, "Missing aselect_credentials"));
                return UserEvent.REQUEST_INVALID;
            }
            htRequest.put(PARAM_RID, sRemoteRid);
            htRequest.put(PARAM_ASELECTCREDENTIALS, sASelectCredentials);
            htRequest.put(PARAM_ASELECTSERVER, oASelectOrganization.getServerID());
            htRequest.put(PARAM_LOCAL_ORG, this._sMyOrganization);
            if (oASelectOrganization.doSigning()) {
                String sSignature = this.createSignature(htRequest);
                htRequest.put(PARAM_SIGNATURE, sSignature);
            }
            htRequest.put(PARAM_REQUEST, VERIFY_CREDENTIALS);
            Hashtable htResponse = null;
            try {
                htResponse = this.sendRequest(oASelectOrganization.getURL(), htRequest);
            }
            catch (IOException e) {
                this._logger.error((Object)("Could not verify credentials to: " + oASelectOrganization.getURL()), (Throwable)e);
                throw new OAException(33);
            }
            this._logger.debug((Object)("Processing response: " + htResponse));
            String sResultCode = (String)htResponse.get(PARAM_RESULTCODE);
            if (sResultCode == null) {
                StringBuffer sbError = new StringBuffer("Required parameter (");
                sbError.append(PARAM_RESULTCODE);
                sbError.append(") not found in request=verify_credentials response (");
                sbError.append(htResponse);
                sbError.append(") from A-Select Organization: ");
                sbError.append(oASelectOrganization.getServerID());
                this._logger.warn((Object)sbError.toString());
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid verify_credentials response"));
                throw new OAException(1);
            }
            if (!ERROR_ASELECT_SUCCESS.equals(sResultCode)) {
                if (ERROR_ASELECT_CANCEL.equals(sResultCode)) {
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_CANCELLED, (IAuthority)this, null));
                    oUserEvent = UserEvent.USER_CANCELLED;
                    this._logger.debug((Object)"User returned from organization where the cancel button was used");
                    oSession.getAttributes().remove(RemoteASelectMethod.class, this._sMethodId + "organization");
                    if (this.performReplay(oSession, oSession.getAttributes())) {
                        return UserEvent.AUTHN_METHOD_IN_PROGRESS;
                    }
                } else {
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_FAILED, (IAuthority)this, sResultCode));
                    oUserEvent = UserEvent.AUTHN_METHOD_FAILED;
                }
            } else {
                String sRemoteAuthSP;
                String sRemoteUID = (String)htResponse.get(PARAM_UID);
                if (sRemoteUID == null) {
                    StringBuffer sbError = new StringBuffer("Request parameter (");
                    sbError.append(PARAM_UID);
                    sbError.append(") not found in response from A-Select Organization: ");
                    sbError.append(sASelectServerId);
                    this._logger.warn((Object)sbError.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid verify_credentials response"));
                    throw new OAException(1);
                }
                sRemoteUID = URLDecoder.decode(sRemoteUID, "UTF-8");
                sRemoteUID = URLDecoder.decode(sRemoteUID, "UTF-8");
                String sRemoteOrganization = (String)htResponse.get("organization");
                if (sRemoteOrganization == null) {
                    StringBuffer sbError = new StringBuffer("Request parameter (");
                    sbError.append("organization");
                    sbError.append(") not found in response from A-Select Organization: ");
                    sbError.append(oASelectOrganization.getID());
                    this._logger.warn((Object)sbError.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid verify_credentials response"));
                    throw new OAException(1);
                }
                if (!sRemoteOrganization.equals(oASelectOrganization.getID())) {
                    StringBuffer sbError = new StringBuffer("Unknown `");
                    sbError.append("organization");
                    sbError.append("` in response; Expected `");
                    sbError.append(oASelectOrganization.getID());
                    sbError.append("` received: ");
                    sbError.append(sRemoteOrganization);
                    this._logger.warn((Object)sbError.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Unknown organization in response"));
                    throw new OAException(1);
                }
                if (this._idMapper != null && (sRemoteUID = this._idMapper.remap(sRemoteUID)) == null) {
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_UNKNOWN, (IAuthority)this, null));
                    return UserEvent.USER_UNKNOWN;
                }
                Object oUser = oSession.getUser();
                if (oUser == null) {
                    if (this._oRemoteASelectUserProvisioningProfile == null) {
                        oUser = new ASelectRemoteUser(sRemoteOrganization, sRemoteUID, this.getID(), sASelectCredentials);
                    } else {
                        CredentialResponseUserStorage oCRUS = new CredentialResponseUserStorage(htResponse);
                        ProvisioningUser oProvisioningUser = this._oRemoteASelectUserProvisioningProfile.getUser((IExternalStorage)oCRUS, sRemoteOrganization, sRemoteUID);
                        oUser = new ASelectRemoteUser(oProvisioningUser, this.getID(), sASelectCredentials);
                    }
                    oSession.setUser(oUser);
                }
                if ((sRemoteAuthSP = (String)htResponse.get(PARAM_AUTHSP)) == null) {
                    StringBuffer sbError = new StringBuffer("Request parameter (");
                    sbError.append(PARAM_AUTHSP);
                    sbError.append(") not found in response from A-Select Organization: ");
                    sbError.append(sASelectServerId);
                    this._logger.warn((Object)sbError.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid verify_credentials response"));
                    throw new OAException(1);
                }
                String sRemoteAuthSPLevel = (String)htResponse.get(PARAM_AUTHSP_LEVEL);
                if (sRemoteAuthSPLevel == null) {
                    StringBuffer sbError = new StringBuffer("Request parameter (");
                    sbError.append(PARAM_AUTHSP_LEVEL);
                    sbError.append(") not found in response from A-Select Organization: ");
                    sbError.append(sASelectServerId);
                    this._logger.warn((Object)sbError.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid verify_credentials response"));
                    throw new OAException(1);
                }
                String sRemoteAppLevel = (String)htResponse.get(PARAM_APP_LEVEL);
                if (sRemoteAppLevel == null) {
                    StringBuffer sbError = new StringBuffer("Request parameter (");
                    sbError.append(PARAM_APP_LEVEL);
                    sbError.append(") not found in response from A-Select Organization: ");
                    sbError.append(sASelectServerId);
                    this._logger.warn((Object)sbError.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid verify_credentials response"));
                    throw new OAException(1);
                }
                String sRemoteTGTExpTime = (String)htResponse.get(PARAM_TGT_EXP_TIME);
                if (sRemoteTGTExpTime == null) {
                    StringBuffer sbError = new StringBuffer("Request parameter (");
                    sbError.append(PARAM_TGT_EXP_TIME);
                    sbError.append(") not found in response from A-Select Organization: ");
                    sbError.append(sASelectServerId);
                    this._logger.warn((Object)sbError.toString());
                    this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "Invalid verify_credentials response"));
                    throw new OAException(1);
                }
                UserAttributes oAttributes = new UserAttributes();
                String sRemoteAttributes = (String)htResponse.get(PARAM_ATTRIBUTES);
                if (sRemoteAttributes != null) {
                    this._logger.debug((Object)("Remote A-Select Organization returned serialized attributes: " + sRemoteAttributes));
                    IAttributes oRemoteAttributes = AttributeHelper.deserializeAttributes((String)sRemoteAttributes, (String)"UTF-8", (IAttributes)oAttributes);
                    oAttributes = this.mapAttributes(oRemoteAttributes, oUser.getAttributes());
                } else {
                    oAttributes = oUser.getAttributes();
                }
                oUser.setAttributes((IAttributes)oAttributes);
                oUserEvent = UserEvent.AUTHN_METHOD_SUCCESSFUL;
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_SUCCESSFUL, (IAuthority)this, null));
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during 'request=verify_credentials'", (Throwable)e);
            throw new OAException(1);
        }
        return oUserEvent;
    }

    private IAttributes mapAttributes(IAttributes source, IAttributes target) {
        Enumeration enumNames = source.getNames();
        while (enumNames.hasMoreElements()) {
            String sName = (String)enumNames.nextElement();
            Object oValue = source.get(sName);
            String sMappedName = this._htAttributeMapper.get(sName);
            if (sMappedName != null) {
                sName = sMappedName;
            }
            target.put(sName, oValue);
        }
        return target;
    }

    private String resolveArpTarget(ISessionAttributes oAttributes, String requestor) {
        String sArpTarget = null;
        try {
            sArpTarget = (String)oAttributes.get(ProxyAttributes.class, "arp_target");
            if (sArpTarget == null) {
                StringBuffer sbArpTarget = new StringBuffer();
                sbArpTarget.append(URLEncoder.encode(requestor, "UTF-8"));
                sbArpTarget.append("@");
                sbArpTarget.append(URLEncoder.encode(this._sMyOrganization, "UTF-8"));
                sArpTarget = sbArpTarget.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            this._logger.warn((Object)"No support for UTF-8", (Throwable)e);
        }
        return sArpTarget;
    }

    private boolean performReplay(ISession oSession, ISessionAttributes oAttributes) throws OAException {
        boolean bPerformed = false;
        if (this._sForceAuthNProfile != null) {
            AuthenticationProfile forceAuthNProfile = this._authNProfileFactory.getProfile(this._sForceAuthNProfile);
            if (forceAuthNProfile == null) {
                this._logger.error((Object)("AuthenticationProfile is not available: " + this._sForceAuthNProfile));
                throw new OAException(1);
            }
            if (!forceAuthNProfile.isEnabled()) {
                this._logger.error((Object)("AuthenticationProfile is disabled: " + this._sForceAuthNProfile));
                throw new OAException(1);
            }
            Vector<AuthenticationProfile> listProfiles = new Vector<AuthenticationProfile>();
            listProfiles.add(forceAuthNProfile);
            oSession.setState(SessionState.AUTHN_NOT_SUPPORTED);
            oSession.setAuthNProfiles(listProfiles);
            oSession.setSelectedAuthNProfile((IAuthenticationProfile)forceAuthNProfile);
            if (oAttributes.contains(ProxyAttributes.class, "forced_organizations")) {
                oAttributes.remove(ProxyAttributes.class, "forced_organizations");
            }
            oSession.persist();
            bPerformed = true;
        }
        return bPerformed;
    }

    private void readReplay(Element eConfig) throws OAException {
        Element eForceProfile = this._configurationManager.getSection(eConfig, "forceprofile");
        if (eForceProfile != null) {
            this._sForceAuthNProfile = this._configurationManager.getParam(eForceProfile, "id");
            if (this._sForceAuthNProfile == null) {
                this._logger.error((Object)"No 'id' parameter in 'forceprofile' configured");
                throw new OAException(2);
            }
            AuthenticationProfile forceAuthNProfile = this._authNProfileFactory.getProfile(this._sForceAuthNProfile);
            if (forceAuthNProfile == null) {
                this._logger.error((Object)("AuthenticationProfile is not available: " + this._sForceAuthNProfile));
                throw new OAException(2);
            }
            if (!forceAuthNProfile.isEnabled()) {
                this._logger.warn((Object)("AuthenticationProfile is disabled: " + this._sForceAuthNProfile));
            }
        }
    }
}

