/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.remote.aselect.idp.storage.config;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.authentication.remote.aselect.idp.storage.ASelectIDP;
import com.alfaariss.oa.engine.core.idp.storage.IIDP;
import com.alfaariss.oa.engine.idp.storage.configuration.AbstractConfigurationStorage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class IDPConfigStorage
extends AbstractConfigurationStorage {
    private static Log _logger = LogFactory.getLog(IDPConfigStorage.class);
    private static final String DEFAULT_ID = "aselect";
    private String _sID;

    public void start(IConfigurationManager configManager, Element config) throws OAException {
        this._sID = configManager.getParam(config, "id");
        if (this._sID == null) {
            _logger.info((Object)"No optional 'id' item for storage configured, using default");
            this._sID = DEFAULT_ID;
        }
        super.start(configManager, config);
        _logger.info((Object)("Started storage with id: " + this._sID));
    }

    public String getID() {
        return this._sID;
    }

    public IIDP getIDP(Object id, String type) {
        if (type.equals("id") && id instanceof String) {
            return this.getIDP((String)id);
        }
        return null;
    }

    protected IIDP createIDP(IConfigurationManager configManager, Element config) throws OAException {
        ASelectIDP oASelectIDP = null;
        try {
            String sLanguage;
            int iLevel;
            String sServerID = configManager.getParam(config, "server_id");
            if (sServerID == null) {
                _logger.error((Object)"No 'server_id' parameter found in configuration");
                throw new OAException(17);
            }
            String sOrganizationID = configManager.getParam(config, "id");
            if (sOrganizationID == null) {
                _logger.error((Object)"No 'id' parameter found in configuration");
                throw new OAException(17);
            }
            String sFriendlyname = configManager.getParam(config, "friendlyname");
            if (sFriendlyname == null) {
                _logger.error((Object)"No 'friendlyname' parameter found in configuration");
                throw new OAException(17);
            }
            String sURL = configManager.getParam(config, "url");
            if (sURL == null) {
                _logger.error((Object)"No 'url' parameter found in configuration");
                throw new OAException(17);
            }
            URL urlTarget = null;
            try {
                urlTarget = new URL(sURL);
            }
            catch (MalformedURLException e) {
                _logger.error((Object)("Invalid 'url' parameter found in configuration: " + sURL));
                throw new OAException(17);
            }
            try {
                URLConnection urlConnection = urlTarget.openConnection();
                urlConnection.setConnectTimeout(3000);
                urlConnection.setReadTimeout(3000);
                urlConnection.connect();
            }
            catch (IOException e) {
                _logger.warn((Object)("Could not connect to 'url' parameter found in configuration: " + sURL));
            }
            String sLevel = configManager.getParam(config, "level");
            if (sLevel == null) {
                _logger.error((Object)"No 'level' parameter found in configuration");
                throw new OAException(17);
            }
            try {
                iLevel = Integer.parseInt(sLevel);
            }
            catch (NumberFormatException e) {
                _logger.error((Object)("Invalid 'level' parameter found in configuration, not a number: " + sLevel));
                throw new OAException(2);
            }
            String sCountry = configManager.getParam(config, "country");
            if (sCountry == null) {
                _logger.info((Object)"No optional 'country' parameter found in configuration");
            }
            if ((sLanguage = configManager.getParam(config, "language")) == null) {
                _logger.info((Object)"No optional 'language' parameter found in configuration");
            }
            boolean bDoSigning = false;
            String sSigning = configManager.getParam(config, "signing");
            if (sSigning != null) {
                if (sSigning.equalsIgnoreCase("TRUE")) {
                    bDoSigning = true;
                } else if (!sSigning.equalsIgnoreCase("FALSE")) {
                    _logger.error((Object)("Invalid 'signing' parameter found in configuration, must be 'true' or 'false': " + sSigning));
                    throw new OAException(2);
                }
            }
            boolean bASynchronousLogout = false;
            String sASynchronousLogout = configManager.getParam(config, "asynchronouslogout");
            if (sASynchronousLogout != null) {
                if (sASynchronousLogout.equalsIgnoreCase("TRUE")) {
                    bASynchronousLogout = true;
                } else if (!sASynchronousLogout.equalsIgnoreCase("FALSE")) {
                    _logger.error((Object)("Invalid 'asynchronouslogout' parameter found in configuration, must be 'true' or 'false': " + sASynchronousLogout));
                    throw new OAException(2);
                }
            }
            boolean bSynchronousLogout = false;
            String sSynchronousLogout = configManager.getParam(config, "synchronouslogout");
            if (sSynchronousLogout != null) {
                if (sSynchronousLogout.equalsIgnoreCase("TRUE")) {
                    bSynchronousLogout = true;
                } else if (!sSynchronousLogout.equalsIgnoreCase("FALSE")) {
                    _logger.error((Object)("Invalid 'synchronouslogout' parameter found in configuration, must be 'true' or 'false': " + sSynchronousLogout));
                    throw new OAException(2);
                }
            }
            boolean bSendArpTarget = false;
            String sSendArpTarget = configManager.getParam(config, "send_arp_target");
            if (sSendArpTarget != null) {
                if (sSendArpTarget.equalsIgnoreCase("TRUE")) {
                    bSendArpTarget = true;
                } else if (!sSendArpTarget.equalsIgnoreCase("FALSE")) {
                    _logger.error((Object)("Invalid 'send_arp_target' parameter found in configuration, must be 'true' or 'false': " + sSigning));
                    throw new OAException(2);
                }
            }
            oASelectIDP = new ASelectIDP(sOrganizationID, sFriendlyname, sServerID, sURL, iLevel, bDoSigning, sCountry, sLanguage, bASynchronousLogout, bSynchronousLogout, bSendArpTarget);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during create", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
        return oASelectIDP;
    }
}

