/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.remote.aselect.logout;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.api.tgt.TGTListenerEvent;
import com.alfaariss.oa.api.tgt.TGTListenerException;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.authentication.remote.aselect.ASelectRemoteUser;
import com.alfaariss.oa.authentication.remote.aselect.RemoteASelectMethod;
import com.alfaariss.oa.authentication.remote.aselect.idp.storage.ASelectIDP;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.crypto.CryptoManager;
import com.alfaariss.oa.engine.core.idp.storage.IIDPStorage;
import com.alfaariss.oa.engine.core.server.Server;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class LogoutManager
implements ITGTListener,
IAuthority {
    public static final String ALIAS_TYPE_CREDENTIALS = "aselect_credentials";
    private static final String AUTHORITY_NAME = "ASelectAuthNLogoutManager_";
    private static final String CHARSET = "UTF-8";
    private static final String REQUEST_LOGOUT = "logout";
    private static final String PARAM_REQUEST = "request";
    private static final String PARAM_ASELECT_CREDENTIALS = "aselect_credentials";
    private static final String PARAM_REQUESTORID = "requestor";
    private static final String PARAM_SIGNATURE = "signature";
    private static final String PARAM_RESULTCODE = "result_code";
    private static final String ERROR_ASELECT_LOGOUT_SUCCESS = "0000";
    private static final String ERROR_ASELECT_LOGOUT_PARTIALLY = "9912";
    private static final String PARAM_REASON = "reason";
    private static final String VALUE_REASON_TIMEOUT = "timeout";
    private static Log _logger;
    private static Log _eventLogger;
    private CryptoManager _cryptoManager;
    private Server _server;
    private ITGTAliasStore _aliasStoreIDPRole;
    private HttpClient _httpClient;
    private IIDPStorage _idpStorage;
    private String _sMethodID;
    private boolean _bEnabled;

    public LogoutManager(IConfigurationManager configurationManager, Element config, IIDPStorage idpStorage, String sMethodId) throws OAException {
        try {
            String sEnabled;
            Element eLogout;
            _logger = LogFactory.getLog(LogoutManager.class);
            _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
            this._idpStorage = idpStorage;
            this._sMethodID = sMethodId;
            this._bEnabled = true;
            if (config != null && (eLogout = configurationManager.getSection(config, REQUEST_LOGOUT)) != null && (sEnabled = configurationManager.getParam(eLogout, "enabled")) != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new OAException(17);
                }
            }
            if (!this._bEnabled) {
                _logger.info((Object)"Synchronous logout manager: disabled");
            } else {
                Engine engine = Engine.getInstance();
                this._cryptoManager = engine.getCryptoManager();
                this._server = engine.getServer();
                this._aliasStoreIDPRole = engine.getTGTFactory().getAliasStoreIDP();
                if (this._aliasStoreIDPRole == null) {
                    _logger.info((Object)"No IDP TGT Alias store available, disabling synchronous logout manager");
                    this._bEnabled = false;
                    return;
                }
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                this._httpClient = new HttpClient((HttpConnectionManager)connectionManager);
                if (config != null) {
                    Element eHTTP = configurationManager.getSection(config, "http");
                    if (eHTTP != null) {
                        this.readHTTPConfig(configurationManager, eHTTP);
                    } else {
                        _logger.info((Object)"No optional 'http' section configured, using default http connection settings");
                    }
                }
            }
            _logger.info((Object)"Synchronous Logout Manager: started");
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Could not create synchronous logout manager", (Throwable)e);
            throw new OAException(1);
        }
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    public String getAuthority() {
        return AUTHORITY_NAME + this._sMethodID;
    }

    public void processTGTEvent(TGTListenerEvent event, ITGT tgt) throws TGTListenerException {
        if (!this._bEnabled) {
            _logger.warn((Object)"Logout manager is disabled");
            return;
        }
        switch (event) {
            case ON_CREATE: {
                this.processCreate(tgt);
                break;
            }
            case ON_EXPIRE: 
            case ON_REMOVE: {
                this.processRemove(tgt, event);
                break;
            }
        }
    }

    private void processCreate(ITGT tgt) throws TGTListenerException {
        try {
            String sUserOrganization;
            IUser user = tgt.getUser();
            if (user instanceof ASelectRemoteUser && this._idpStorage.exists(sUserOrganization = user.getOrganization())) {
                this._aliasStoreIDPRole.putAlias("aselect_credentials", sUserOrganization, tgt.getId(), ((ASelectRemoteUser)user).getCredentials());
            }
        }
        catch (TGTListenerException e) {
            throw e;
        }
        catch (OAException e) {
            throw new TGTListenerException(new TGTEventError(UserEvent.INTERNAL_ERROR));
        }
    }

    private void processRemove(ITGT tgt, TGTListenerEvent event) throws TGTListenerException {
        ASelectIDP aselectIDP = null;
        try {
            String sCredentials;
            ASelectIDP org;
            String sUserOrganization;
            IUser user = tgt.getUser();
            if (user instanceof ASelectRemoteUser && (aselectIDP = (ASelectIDP)this._idpStorage.getIDP(sUserOrganization = user.getOrganization())) != null && aselectIDP.hasSynchronousLogout() && ((org = (ASelectIDP)((Object)tgt.getAttributes().get(RemoteASelectMethod.class, this._sMethodID + "aslogout_organization"))) == null || !aselectIDP.equals((Object)org)) && (sCredentials = this._aliasStoreIDPRole.getAlias("aselect_credentials", aselectIDP.getID(), tgt.getId())) != null) {
                String sLogout = this.generateSLogout(aselectIDP.getURL(), sCredentials, aselectIDP.doSigning(), event);
                UserEvent userEvent = this.sendSLogout(sLogout);
                this._aliasStoreIDPRole.removeAlias("aselect_credentials", aselectIDP.getID(), sCredentials);
                UserEventLogItem logItem = new UserEventLogItem(null, tgt.getId(), null, userEvent, user.getID(), user.getOrganization(), null, null, (IAuthority)this, null);
                _eventLogger.info((Object)logItem);
                if (userEvent != UserEvent.USER_LOGGED_OUT) {
                    throw new TGTListenerException(new TGTEventError(userEvent, aselectIDP.getFriendlyName()));
                }
            }
        }
        catch (TGTListenerException e) {
            throw e;
        }
        catch (OAException e) {
            TGTEventError eventError = null;
            eventError = aselectIDP != null ? new TGTEventError(UserEvent.USER_LOGOUT_FAILED, aselectIDP.getFriendlyName()) : new TGTEventError(UserEvent.USER_LOGOUT_FAILED);
            throw new TGTListenerException(eventError);
        }
    }

    private String generateSLogout(String sLogoutURL, String sCredentials, boolean sign, TGTListenerEvent event) throws OAException {
        String logoutCall = null;
        try {
            HashMap<String, String> mapRequest = new HashMap<String, String>();
            mapRequest.put(PARAM_REQUESTORID, this._server.getOrganization().getID());
            mapRequest.put("aselect_credentials", sCredentials);
            if (event == TGTListenerEvent.ON_EXPIRE) {
                mapRequest.put(PARAM_REASON, VALUE_REASON_TIMEOUT);
            }
            if (sign) {
                String signature = this.createSignature(mapRequest);
                mapRequest.put(PARAM_SIGNATURE, signature);
            }
            mapRequest.put(PARAM_REQUEST, REQUEST_LOGOUT);
            StringBuffer sbMessage = new StringBuffer(sLogoutURL);
            if (!sLogoutURL.contains("?")) {
                sbMessage.append("?");
            }
            for (String key : mapRequest.keySet()) {
                if (!sbMessage.toString().endsWith("&") && !sbMessage.toString().endsWith("?")) {
                    sbMessage.append("&");
                }
                sbMessage.append(key);
                sbMessage.append("=");
                sbMessage.append(URLEncoder.encode((String)mapRequest.get(key), CHARSET));
            }
            logoutCall = sbMessage.toString();
        }
        catch (Exception e) {
            _logger.error((Object)"Could not generate logout call", (Throwable)e);
            throw new OAException(1);
        }
        return logoutCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserEvent sendSLogout(String logoutCall) {
        UserEvent userEvent;
        GetMethod method = null;
        try {
            method = new GetMethod(logoutCall);
            _logger.debug((Object)("Sending message: " + logoutCall));
            int statusCode = this._httpClient.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                StringBuffer sbWarn = new StringBuffer("Received invalid http status '");
                sbWarn.append(method.getStatusLine());
                sbWarn.append("' while sending: ");
                sbWarn.append(logoutCall);
                _logger.warn((Object)sbWarn.toString());
                throw new OAException(33);
            }
            byte[] responseBody = method.getResponseBody();
            if (responseBody != null) {
                String sResponseMessage = new String(responseBody).trim();
                _logger.debug((Object)("Received response: " + sResponseMessage));
                Hashtable<String, String> htResponse = this.convertCGI(sResponseMessage);
                String sResultCode = htResponse.get(PARAM_RESULTCODE);
                if (sResultCode == null) {
                    _logger.debug((Object)"No result code in response, logout failed");
                    UserEvent userEvent2 = UserEvent.USER_LOGOUT_FAILED;
                    return userEvent2;
                }
                if (!sResultCode.equals(ERROR_ASELECT_LOGOUT_SUCCESS)) {
                    if (sResultCode.equals(ERROR_ASELECT_LOGOUT_PARTIALLY)) {
                        _logger.debug((Object)"Logout parially in response from server");
                        UserEvent userEvent3 = UserEvent.USER_LOGOUT_PARTIALLY;
                        return userEvent3;
                    }
                    _logger.debug((Object)("Logout failed, result code: " + sResultCode));
                    UserEvent userEvent4 = UserEvent.USER_LOGOUT_FAILED;
                    return userEvent4;
                }
            }
        }
        catch (OAException e) {
            userEvent = UserEvent.USER_LOGOUT_FAILED;
            return userEvent;
        }
        catch (Exception e) {
            _logger.warn((Object)"Could not send synchronous logout", (Throwable)e);
            userEvent = UserEvent.INTERNAL_ERROR;
            return userEvent;
        }
        finally {
            try {
                if (method != null) {
                    method.releaseConnection();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close the connection reader", (Throwable)e);
            }
        }
        return UserEvent.USER_LOGGED_OUT;
    }

    private void readHTTPConfig(IConfigurationManager configurationManager, Element config) throws OAException {
        String sConnectionTimeout = configurationManager.getParam(config, "connection_timeout");
        if (sConnectionTimeout == null) {
            _logger.info((Object)"No 'connection_timeout' parameter found in configuration, using default");
        } else {
            try {
                int iConnectionTimeout = Integer.parseInt(sConnectionTimeout);
                this._httpClient.getParams().setParameter("http.connection.timeout", (Object)new Integer(iConnectionTimeout));
            }
            catch (NumberFormatException e) {
                _logger.error((Object)("Invalid 'connection_timeout' parameter found in configuration, not a number: " + sConnectionTimeout), (Throwable)e);
                throw new OAException(2);
            }
        }
        String sSocketTimeout = configurationManager.getParam(config, "socket_timeout");
        if (sSocketTimeout == null) {
            _logger.info((Object)"No 'socket_timeout' parameter found in configuration, using an infinite timeout");
        } else {
            try {
                int iSocketTimeout = Integer.parseInt(sSocketTimeout);
                this._httpClient.getParams().setParameter("http.socket.timeout", (Object)new Integer(iSocketTimeout));
            }
            catch (NumberFormatException e) {
                _logger.error((Object)("Invalid 'socket_timeout' parameter found in configuration, not a number: " + sSocketTimeout), (Throwable)e);
                throw new OAException(2);
            }
        }
    }

    private String createSignature(Map<String, String> mapRequest) throws OAException {
        String sSignature = null;
        try {
            if (this._cryptoManager == null) {
                _logger.warn((Object)"No crypto manager available");
                throw new OAException(1);
            }
            Signature signature = this._cryptoManager.getSignature();
            if (signature == null) {
                _logger.warn((Object)"No signature object found");
                throw new OAException(1);
            }
            StringBuffer sbSignatureData = new StringBuffer();
            TreeSet<String> sortedSet = new TreeSet<String>(mapRequest.keySet());
            for (String sKey : sortedSet) {
                sbSignatureData.append(mapRequest.get(sKey));
            }
            PrivateKey keyPrivate = this._cryptoManager.getPrivateKey();
            if (keyPrivate == null) {
                _logger.error((Object)"No private key available");
                throw new OAException(1);
            }
            signature.initSign(keyPrivate);
            signature.update(sbSignatureData.toString().getBytes(CHARSET));
            byte[] baSignature = signature.sign();
            byte[] baEncSignature = Base64.encodeBase64((byte[])baSignature);
            sSignature = new String(baEncSignature, CHARSET);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)("Could not create signature for data: " + mapRequest), (Throwable)e);
            throw new OAException(1);
        }
        return sSignature;
    }

    private Hashtable<String, String> convertCGI(String sMessage) throws OAException {
        Hashtable<String, String> htResult = new Hashtable<String, String>();
        try {
            if (sMessage.trim().length() == 0) {
                return htResult;
            }
            String[] saMessage = sMessage.split("&");
            for (int i = 0; i < saMessage.length; ++i) {
                String sPart = saMessage[i];
                int iIndex = sPart.indexOf(61);
                String sKey = sPart.substring(0, iIndex);
                sKey = sKey.trim();
                String sValue = sPart.substring(iIndex + 1);
                sValue = URLDecoder.decode(sValue.trim(), CHARSET);
                if (htResult.containsKey(sKey)) {
                    _logger.error((Object)("Key is not unique in message: " + sKey));
                    throw new OAException(1);
                }
                htResult.put(sKey, sValue);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during conversion of message: " + sMessage), (Throwable)e);
            throw new OAException(1);
        }
        return htResult;
    }
}

