/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.remote.aselect.selector;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.authentication.remote.aselect.Warnings;
import com.alfaariss.oa.authentication.remote.aselect.idp.storage.ASelectIDP;
import com.alfaariss.oa.authentication.remote.aselect.selector.ISelector;
import com.alfaariss.oa.engine.core.Engine;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class DefaultSelector
implements ISelector {
    private static final String DEFAULT_ID_PARAM = "organization_id";
    private static final String REQUEST_PARAM_ORGANIZATIONS = "organizations";
    private static final String DEFAULT_JSP_SELECTION = "/ui/sso/authn/remoteaselect/aselect.jsp";
    private Log _logger = LogFactory.getLog(DefaultSelector.class);
    private String _sTemplatePath;
    private String _sIdParameter;
    private boolean _bShowAlways;

    @Override
    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            this._sTemplatePath = DEFAULT_JSP_SELECTION;
            this._sIdParameter = DEFAULT_ID_PARAM;
            Element eTemplate = oConfigurationManager.getSection(eConfig, "template");
            if (eTemplate == null) {
                this._logger.warn((Object)"No optional 'template' section found in configuration, using defaults");
            } else {
                this._sTemplatePath = oConfigurationManager.getParam(eTemplate, "path");
                if (this._sTemplatePath == null) {
                    this._sTemplatePath = DEFAULT_JSP_SELECTION;
                    this._logger.warn((Object)"No optional 'path' parameter found in 'template' section in configuration, using default");
                }
                this._sIdParameter = oConfigurationManager.getParam(eTemplate, "id_param");
                if (this._sIdParameter == null) {
                    this._sIdParameter = DEFAULT_ID_PARAM;
                    this._logger.warn((Object)"No optional 'id_param' parameter found in 'template' section in configuration, using default");
                }
            }
            this._logger.info((Object)("Using JSP: " + this._sTemplatePath));
            this._logger.info((Object)("Using ID parameter: " + this._sIdParameter));
            this._bShowAlways = false;
            String sShowAlways = oConfigurationManager.getParam(eConfig, "always_show_select_form");
            if (sShowAlways != null) {
                if (sShowAlways.equalsIgnoreCase("TRUE")) {
                    this._bShowAlways = true;
                } else if (!sShowAlways.equalsIgnoreCase("FALSE")) {
                    this._logger.error((Object)("Invalid value for 'always_show_select_form' parameter found in in configuration: " + sShowAlways));
                    throw new OAException(17);
                }
            }
            this._logger.info((Object)("Forced show selection always: " + this._bShowAlways));
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during start", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ASelectIDP resolve(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, List<ASelectIDP> listOrganizations, String sMethodName, List<Warnings> oWarnings) throws OAException {
        ASelectIDP oSelectedOrganization = null;
        try {
            this._logger.debug((Object)"Resolving remote server id");
            String sOrganizationId = oRequest.getParameter(this._sIdParameter);
            if (sOrganizationId != null) {
                for (ASelectIDP oOrganization : listOrganizations) {
                    if (!oOrganization.getID().equals(sOrganizationId)) continue;
                    oSelectedOrganization = oOrganization;
                    break;
                }
            } else if (listOrganizations.size() == 1 && !this._bShowAlways) {
                return listOrganizations.get(0);
            }
            if (oSelectedOrganization == null) {
                oSession.persist();
                this.forwardUser(oRequest, oResponse, oSession, listOrganizations, sMethodName, oWarnings);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during resolve", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
        return oSelectedOrganization;
    }

    private void forwardUser(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, List<ASelectIDP> listOrganizations, String sMethodName, List<Warnings> oWarnings) throws OAException {
        try {
            oRequest.setAttribute("asid", (Object)oSession.getId());
            oRequest.setAttribute("sessionLocale", (Object)oSession.getLocale());
            oRequest.setAttribute(REQUEST_PARAM_ORGANIZATIONS, listOrganizations);
            if (oWarnings != null) {
                oRequest.setAttribute("details", oWarnings);
            }
            oRequest.setAttribute("methodFriendlyName", (Object)sMethodName);
            oRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
            RequestDispatcher oDispatcher = oRequest.getRequestDispatcher(this._sTemplatePath);
            if (oDispatcher == null) {
                this._logger.warn((Object)("There is no request dispatcher supported with name: " + this._sTemplatePath));
                throw new OAException(1);
            }
            this._logger.debug((Object)("Forward user to: " + this._sTemplatePath));
            oDispatcher.forward((ServletRequest)oRequest, (ServletResponse)oResponse);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during forward", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
    }
}

