/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.remote.aselect.idp.storage.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.authentication.remote.aselect.idp.storage.ASelectIDP;
import com.alfaariss.oa.engine.core.idp.storage.IIDP;
import com.alfaariss.oa.engine.idp.storage.jdbc.AbstractJDBCStorage;
import com.alfaariss.oa.util.database.DatabaseException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class IDPJDBCStorage
extends AbstractJDBCStorage {
    private static final String DEFAULT_ID = "aselect";
    private static final String DEFAULT_TABLE_NAME = "aselect_orgs";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_FRIENDLYNAME = "friendlyname";
    private static final String COLUMN_ENABLED = "enabled";
    private static final String COLUMN_SERVER_ID = "server_id";
    private static final String COLUMN_LEVEL = "level";
    private static final String COLUMN_SIGNING = "signing";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_COUNTRY = "country";
    private static final String COLUMN_LANGUAGE = "language";
    private static final String COLUMN_ASYNCHRONOUS_LOGOUT = "asynchronouslogout";
    private static final String COLUMN_SYNCHRONOUS_LOGOUT = "synchronouslogout";
    private static final String COLUMN_SEND_ARP_TARGET = "send_arp_target";
    private static Log _logger = LogFactory.getLog(IDPJDBCStorage.class);
    private String _sID;
    private String _sTable;
    private String _querySelectAll;
    private String _querySelect;
    private String _queryExist;

    public void start(IConfigurationManager configManager, Element config) throws OAException {
        this._sID = configManager.getParam(config, COLUMN_ID);
        if (this._sID == null) {
            _logger.info((Object)"No optional 'id' item for storage configured, using default");
            this._sID = DEFAULT_ID;
        }
        super.start(configManager, config);
        Element eResource = configManager.getSection(config, "resource");
        if (eResource == null) {
            this._sTable = DEFAULT_TABLE_NAME;
        } else {
            this._sTable = configManager.getParam(eResource, "table");
            if (this._sTable == null) {
                this._sTable = DEFAULT_TABLE_NAME;
            }
        }
        _logger.info((Object)("Using table: " + this._sTable));
        this.createQueries();
        _logger.info((Object)("Started storage with id: " + this._sID));
    }

    public boolean exists(String id) throws OAException {
        Connection connection = null;
        Statement pSelect = null;
        ResultSet resultSet = null;
        try {
            connection = this._dataSource.getConnection();
            pSelect = connection.prepareStatement(this._queryExist);
            pSelect.setString(1, id);
            resultSet = pSelect.executeQuery();
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during exist check for IDP: " + id), (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (pSelect != null) {
                    pSelect.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close select statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return false;
    }

    public List<IIDP> getAll() throws OAException {
        Connection connection = null;
        Statement pSelect = null;
        ResultSet resultSet = null;
        Vector<IIDP> listIDPs = new Vector<IIDP>();
        try {
            connection = this._dataSource.getConnection();
            pSelect = connection.prepareStatement(this._querySelectAll);
            pSelect.setBoolean(1, true);
            resultSet = pSelect.executeQuery();
            while (resultSet.next()) {
                ASelectIDP idp = new ASelectIDP(resultSet.getString(COLUMN_ID), resultSet.getString(COLUMN_FRIENDLYNAME), resultSet.getString(COLUMN_SERVER_ID), resultSet.getString(COLUMN_URL), resultSet.getInt(COLUMN_LEVEL), resultSet.getBoolean(COLUMN_SIGNING), resultSet.getString(COLUMN_COUNTRY), resultSet.getString(COLUMN_LANGUAGE), resultSet.getBoolean(COLUMN_ASYNCHRONOUS_LOGOUT), resultSet.getBoolean(COLUMN_SYNCHRONOUS_LOGOUT), resultSet.getBoolean(COLUMN_SEND_ARP_TARGET));
                listIDPs.add((IIDP)idp);
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during retrieval of all IDPs", (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (pSelect != null) {
                    pSelect.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close select statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return listIDPs;
    }

    public String getID() {
        return this._sID;
    }

    public IIDP getIDP(String id) throws OAException {
        Connection connection = null;
        Statement pSelect = null;
        ResultSet resultSet = null;
        ASelectIDP oASelectIDP = null;
        try {
            connection = this._dataSource.getConnection();
            pSelect = connection.prepareStatement(this._querySelect);
            pSelect.setBoolean(1, true);
            pSelect.setString(2, id);
            resultSet = pSelect.executeQuery();
            if (resultSet.next()) {
                oASelectIDP = new ASelectIDP(resultSet.getString(COLUMN_ID), resultSet.getString(COLUMN_FRIENDLYNAME), resultSet.getString(COLUMN_SERVER_ID), resultSet.getString(COLUMN_URL), resultSet.getInt(COLUMN_LEVEL), resultSet.getBoolean(COLUMN_SIGNING), resultSet.getString(COLUMN_COUNTRY), resultSet.getString(COLUMN_LANGUAGE), resultSet.getBoolean(COLUMN_ASYNCHRONOUS_LOGOUT), resultSet.getBoolean(COLUMN_SYNCHRONOUS_LOGOUT), resultSet.getBoolean(COLUMN_SEND_ARP_TARGET));
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during retrieval of IDP with id: " + id), (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (pSelect != null) {
                    pSelect.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close select statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return oASelectIDP;
    }

    public IIDP getIDP(Object id, String type) throws OAException {
        Connection connection = null;
        Statement pSelect = null;
        ResultSet resultSet = null;
        ASelectIDP oASelectIDP = null;
        try {
            connection = this._dataSource.getConnection();
            StringBuffer sbSelect = new StringBuffer(this._querySelectAll);
            sbSelect.append(" AND ");
            sbSelect.append(type);
            sbSelect.append("=?");
            pSelect = connection.prepareStatement(sbSelect.toString());
            pSelect.setBoolean(1, true);
            pSelect.setObject(2, id);
            resultSet = pSelect.executeQuery();
            if (resultSet.next()) {
                oASelectIDP = new ASelectIDP(resultSet.getString(COLUMN_ID), resultSet.getString(COLUMN_FRIENDLYNAME), resultSet.getString(COLUMN_SERVER_ID), resultSet.getString(COLUMN_URL), resultSet.getInt(COLUMN_LEVEL), resultSet.getBoolean(COLUMN_SIGNING), resultSet.getString(COLUMN_COUNTRY), resultSet.getString(COLUMN_LANGUAGE), resultSet.getBoolean(COLUMN_ASYNCHRONOUS_LOGOUT), resultSet.getBoolean(COLUMN_SYNCHRONOUS_LOGOUT), resultSet.getBoolean(COLUMN_SEND_ARP_TARGET));
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during retrieval of IDP with id: " + id), (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (pSelect != null) {
                    pSelect.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close select statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return oASelectIDP;
    }

    private void createQueries() throws OAException {
        Connection connection = null;
        Statement pVerify = null;
        try {
            StringBuffer sbSelectAllOrgs = new StringBuffer("SELECT ");
            sbSelectAllOrgs.append(COLUMN_ID).append(",");
            sbSelectAllOrgs.append(COLUMN_SERVER_ID).append(",");
            sbSelectAllOrgs.append(COLUMN_LEVEL).append(",");
            sbSelectAllOrgs.append(COLUMN_SIGNING).append(",");
            sbSelectAllOrgs.append(COLUMN_URL).append(",");
            sbSelectAllOrgs.append(COLUMN_FRIENDLYNAME).append(",");
            sbSelectAllOrgs.append(COLUMN_COUNTRY).append(",");
            sbSelectAllOrgs.append(COLUMN_LANGUAGE).append(",");
            sbSelectAllOrgs.append(COLUMN_ASYNCHRONOUS_LOGOUT).append(",");
            sbSelectAllOrgs.append(COLUMN_SYNCHRONOUS_LOGOUT).append(",");
            sbSelectAllOrgs.append(COLUMN_SEND_ARP_TARGET);
            sbSelectAllOrgs.append(" FROM ");
            sbSelectAllOrgs.append(this._sTable);
            StringBuffer sbVerify = new StringBuffer(sbSelectAllOrgs);
            sbVerify.append(" LIMIT 1");
            connection = this._dataSource.getConnection();
            pVerify = connection.prepareStatement(sbVerify.toString());
            try {
                pVerify.executeQuery();
            }
            catch (Exception e) {
                StringBuffer sbError = new StringBuffer("Invalid idp table '");
                sbError.append(this._sTable);
                sbError.append("' verified with query: ");
                sbError.append(sbVerify.toString());
                _logger.error((Object)sbError.toString(), (Throwable)e);
                throw new DatabaseException(2);
            }
            sbSelectAllOrgs.append(" WHERE ");
            sbSelectAllOrgs.append(COLUMN_ENABLED);
            sbSelectAllOrgs.append("=?");
            this._querySelectAll = sbSelectAllOrgs.toString();
            _logger.info((Object)("Using select all IDPs query: " + this._querySelectAll));
            StringBuffer sbSelectOnID = new StringBuffer(sbSelectAllOrgs);
            sbSelectOnID.append(" AND ");
            sbSelectOnID.append(COLUMN_ID);
            sbSelectOnID.append("=?");
            this._querySelect = sbSelectOnID.toString();
            _logger.info((Object)("Using IDP select query: " + this._querySelect));
            StringBuffer sbExist = new StringBuffer("SELECT COUNT(");
            sbExist.append(COLUMN_ID);
            sbExist.append(") FROM ");
            sbExist.append(this._sTable);
            sbExist.append(" WHERE ");
            sbExist.append(COLUMN_ID);
            sbExist.append("=?");
            this._queryExist = sbExist.toString();
            _logger.info((Object)("Using IDP exist query: " + this._queryExist));
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during query creation", (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (pVerify != null) {
                    pVerify.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close verification statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }
}

