/*
 * Decompiled with CFR 0.152.
 */
package org.asimba.authentication.remote.provisioning.aselect;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.engine.core.attribute.UserAttributes;
import com.alfaariss.oa.engine.core.user.UserException;
import com.alfaariss.oa.engine.user.provisioning.storage.external.IExternalStorage;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asimba.utility.attributes.AttributeHelper;
import org.w3c.dom.Element;

public class CredentialResponseUserStorage
implements IExternalStorage {
    private Log _oLogger;
    private Hashtable<String, String> _htResponse = null;
    protected IAttributes _oAttributes = new UserAttributes();

    public CredentialResponseUserStorage(Hashtable<String, String> htResponse) {
        this._oLogger = LogFactory.getLog(CredentialResponseUserStorage.class);
        this.setHtResponse(htResponse);
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws UserException {
    }

    protected void setHtResponse(Hashtable<String, String> htResponse) {
        this._htResponse = htResponse;
        this._oAttributes = new UserAttributes();
        try {
            if (this._htResponse != null && this._htResponse.containsKey("attributes")) {
                String sSerializedAttributes = this._htResponse.get("attributes");
                this._oAttributes = AttributeHelper.deserializeAttributes((String)sSerializedAttributes, (String)"UTF-8", (IAttributes)this._oAttributes);
            }
        }
        catch (OAException e) {
            this._oLogger.warn((Object)("Could not decode serialized attributes: " + e.getMessage()));
        }
    }

    public boolean exists(String sID) throws UserException {
        if (this._htResponse == null) {
            return false;
        }
        String sCredentialsUserId = this._htResponse.get("uid");
        if (sCredentialsUserId == null) {
            return false;
        }
        String sDecodedUserId = null;
        try {
            sDecodedUserId = URLDecoder.decode(sCredentialsUserId, "UTF-8");
            sDecodedUserId = URLDecoder.decode(sDecodedUserId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this._oLogger.warn((Object)("Could not decode user id: " + e.getMessage()));
            return false;
        }
        return sID.equals(sDecodedUserId);
    }

    public void stop() {
    }

    public Object getField(String sId, String sField) throws UserException {
        return this._oAttributes.get(sField);
    }

    public Hashtable<String, Object> getFields(String id, List<String> lFields) throws UserException {
        Hashtable<String, Object> htValues = new Hashtable<String, Object>();
        for (String sField : lFields) {
            Object o = this._oAttributes.get(sField);
            if (o == null) continue;
            htValues.put(sField, o);
        }
        return htValues;
    }
}

