/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.password.jndi;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.authentication.password.AbstractResourceHandler;
import com.alfaariss.oa.util.ldap.JNDIUtil;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JNDIProtocolResource
extends AbstractResourceHandler {
    private final Log _logger = LogFactory.getLog(JNDIProtocolResource.class);
    protected String _sJNDIUrl;
    protected String _sDriver;
    protected String _sBaseDn;
    protected String _sUserDn;
    protected String _sFilter;
    protected String _sPrincipalDn;
    protected String _sPrincipalPwd;
    protected boolean _bSSL;

    public void init(IConfigurationManager _configurationManager, Element eResourceSection) throws OAException {
        super.init(_configurationManager, eResourceSection);
        Element eDNSection = null;
        Element ePrincipalSection = null;
        this._sJNDIUrl = _configurationManager.getParam(eResourceSection, "url");
        if (this._sJNDIUrl == null || this._sJNDIUrl.equals("")) {
            this._logger.error((Object)("No url defined for realm: " + this._sResourceRealm));
            throw new OAException(17);
        }
        if (this._sJNDIUrl.length() >= 5 && this._sJNDIUrl.substring(0, 5).equalsIgnoreCase("ldaps")) {
            this._bSSL = true;
            this._logger.info((Object)"SSL enabled");
        } else {
            this._bSSL = false;
            this._logger.info((Object)"SSL disabled");
        }
        this._sDriver = _configurationManager.getParam(eResourceSection, "driver");
        if (this._sDriver == null || this._sDriver.equals("")) {
            this._logger.error((Object)("No driver defined for realm: " + this._sResourceRealm));
            throw new OAException(17);
        }
        eDNSection = _configurationManager.getSection(eResourceSection, "dn");
        if (eDNSection == null) {
            this._logger.error((Object)("No dn section defined for realm: " + this._sResourceRealm));
            throw new OAException(17);
        }
        this._sBaseDn = _configurationManager.getParam(eDNSection, "base");
        if (this._sBaseDn == null || this._sBaseDn.equals("")) {
            this._logger.error((Object)("No base dn defined for realm: " + this._sResourceRealm));
            throw new OAException(17);
        }
        this._sFilter = _configurationManager.getParam(eDNSection, "filter");
        this._sUserDn = _configurationManager.getParam(eDNSection, "user");
        if ((this._sUserDn == null || this._sUserDn.equals("")) && this._sFilter == null) {
            this._logger.error((Object)("No user dn defined for realm: " + this._sResourceRealm));
            throw new OAException(17);
        }
        ePrincipalSection = _configurationManager.getSection(eResourceSection, "security_principal");
        if (ePrincipalSection == null) {
            this._sPrincipalDn = "";
            this._sPrincipalPwd = "";
            this._logger.info((Object)("No 'security_principal' section configured for realm '" + this._sResourceRealm + "', using default"));
        } else {
            this._sPrincipalDn = _configurationManager.getParam(ePrincipalSection, "dn");
            if (this._sPrincipalDn == null) {
                this._sPrincipalDn = "";
                this._logger.info((Object)("No 'dn' item in 'security_principal' section configured for realm '" + this._sResourceRealm + "', using default"));
            }
            this._sPrincipalPwd = _configurationManager.getParam(ePrincipalSection, "password");
            if (this._sPrincipalPwd == null) {
                this._sPrincipalPwd = "";
                this._logger.info((Object)("No 'password' item in 'security_principal' section configured for realm '" + this._sResourceRealm + "', using default: empty"));
            }
        }
        if (this._sPrincipalDn.length() <= 0) {
            if (this._sUserDn == null) {
                this._logger.error((Object)"Invalid configuration: No security principal dn and user dn available; simple bind is not possible");
                throw new OAException(2);
            }
            this._logger.info((Object)("No security principal dn defined for realm '" + this._sResourceRealm + "'. Using simple binding"));
        } else if (this._sFilter != null) {
            if (this._sUserDn != null) {
                this._logger.error((Object)"Invalid configuration: Both user dn and filter are configured");
                throw new OAException(2);
            }
            this._logger.info((Object)("Using configured search filter: " + this._sFilter));
        }
    }

    public boolean authenticate(String password, String username) throws UserException, OAException {
        try {
            return this.doBind(this.constructUsername(username), password);
        }
        catch (UserException e) {
            this._logger.debug((Object)"Could not authenticate user");
            throw e;
        }
        catch (OAException e) {
            this._logger.error((Object)"Error occured during authentication", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Fatal error occured during authentication", (Throwable)e);
            throw new OAException(1);
        }
    }

    private boolean doBind(String sUserID, String sPassword) throws OAException, UserException {
        StringBuffer sbTemp = null;
        InitialDirContext oDirContext = null;
        String sQuery = null;
        String sRelUserDn = null;
        boolean bResult = false;
        NamingEnumeration<SearchResult> enumSearchResults = null;
        Hashtable<String, String> htEnvironment = new Hashtable<String, String>();
        htEnvironment.put("java.naming.provider.url", this._sJNDIUrl);
        htEnvironment.put("java.naming.factory.initial", this._sDriver);
        htEnvironment.put("java.naming.security.authentication", "simple");
        if (this._bSSL) {
            htEnvironment.put("java.naming.security.protocol", "ssl");
        }
        if (this._sPrincipalDn.length() <= 0) {
            String sEscUserID = JNDIUtil.escapeDN((String)sUserID);
            this._logger.debug((Object)("Escaped user: " + sEscUserID));
            sbTemp = new StringBuffer(this._sUserDn);
            sbTemp.append('=');
            sbTemp.append(sEscUserID);
            sbTemp.append(", ");
            sbTemp.append(this._sBaseDn);
            htEnvironment.put("java.naming.security.principal", sbTemp.toString());
            htEnvironment.put("java.naming.security.credentials", sPassword);
            try {
                oDirContext = new InitialDirContext(htEnvironment);
                bResult = true;
            }
            catch (AuthenticationException e) {
                this._logger.debug((Object)("Could not authenticate user (invalid password): " + sUserID), (Throwable)e);
            }
            catch (CommunicationException eC) {
                this._logger.warn((Object)"A communication error has occured", (Throwable)eC);
                throw new OAException(35);
            }
            catch (NamingException eN) {
                this._logger.warn((Object)"A naming error has occured", (Throwable)eN);
                throw new OAException(35);
            }
            finally {
                try {
                    if (oDirContext != null) {
                        oDirContext.close();
                    }
                }
                catch (Exception e) {
                    this._logger.warn((Object)("Could not close connection with '" + this._sJNDIUrl + '\''), (Throwable)e);
                }
            }
        } else {
            htEnvironment.put("java.naming.security.principal", this._sPrincipalDn);
            htEnvironment.put("java.naming.security.credentials", this._sPrincipalPwd);
            try {
                oDirContext = new InitialDirContext(htEnvironment);
            }
            catch (AuthenticationException eA) {
                this._logger.warn((Object)"Could not bind to LDAP server", (Throwable)eA);
                throw new OAException(33);
            }
            catch (CommunicationException eC) {
                this._logger.warn((Object)"A communication error has occured", (Throwable)eC);
                throw new OAException(35);
            }
            catch (NamingException eN) {
                this._logger.warn((Object)"A naming error has occured", (Throwable)eN);
                throw new OAException(35);
            }
            sQuery = this.resolveSearchQuery(sUserID);
            SearchControls oScope = new SearchControls();
            oScope.setSearchScope(2);
            try {
                enumSearchResults = oDirContext.search(this._sBaseDn, sQuery, oScope);
            }
            catch (NamingException eN) {
                this._logger.warn((Object)("User id not found in password backend for user: " + sUserID), (Throwable)eN);
                throw new UserException(UserEvent.AUTHN_METHOD_NOT_SUPPORTED);
            }
            finally {
                try {
                    oDirContext.close();
                    oDirContext = null;
                }
                catch (Exception e) {
                    this._logger.warn((Object)("Could not close connection with '" + this._sJNDIUrl + "'"), (Throwable)e);
                }
            }
            try {
                if (!enumSearchResults.hasMoreElements()) {
                    StringBuffer sb = new StringBuffer("User '");
                    sb.append(sUserID);
                    sb.append("' not found during LDAP search. The filter was: '");
                    sb.append(sQuery);
                    sb.append("'");
                    this._logger.warn((Object)sb.toString());
                    throw new UserException(UserEvent.AUTHN_METHOD_NOT_SUPPORTED);
                }
                SearchResult searchResult = enumSearchResults.next();
                sRelUserDn = searchResult.getName();
                if (sRelUserDn == null) {
                    this._logger.warn((Object)("no user dn was returned for '" + sUserID + "'."));
                    throw new OAException(35);
                }
            }
            catch (NamingException eN) {
                this._logger.warn((Object)("failed to fetch profile of user '" + sUserID + "'."), (Throwable)eN);
                throw new OAException(35);
            }
            sbTemp = new StringBuffer(sRelUserDn);
            sbTemp.append(",");
            sbTemp.append(this._sBaseDn);
            htEnvironment.put("java.naming.security.principal", sbTemp.toString());
            htEnvironment.put("java.naming.security.credentials", sPassword);
            try {
                oDirContext = new InitialDirContext(htEnvironment);
                bResult = true;
            }
            catch (AuthenticationException e) {
                this._logger.debug((Object)("Could not authenticate user (invalid password): " + sUserID), (Throwable)e);
            }
            catch (CommunicationException eC) {
                this._logger.warn((Object)"A communication error has occured", (Throwable)eC);
                throw new OAException(35);
            }
            catch (NamingException eN) {
                this._logger.warn((Object)"A naming error has occured", (Throwable)eN);
                throw new OAException(35);
            }
            finally {
                try {
                    if (oDirContext != null) {
                        oDirContext.close();
                    }
                }
                catch (Exception e) {
                    this._logger.warn((Object)("Could not close connection with '" + this._sJNDIUrl + "'."), (Throwable)e);
                }
            }
        }
        return bResult;
    }

    private String resolveSearchQuery(String user) {
        String escapedUser = JNDIUtil.escapeLDAPSearchFilter((String)user);
        if (this._sFilter != null) {
            return this._sFilter.replaceAll("\\?", escapedUser);
        }
        StringBuffer sbQuery = new StringBuffer();
        sbQuery.append("(");
        sbQuery.append(this._sUserDn);
        sbQuery.append("=");
        sbQuery.append(escapedUser);
        sbQuery.append(")");
        return sbQuery.toString();
    }
}

