/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.password.jndi;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.authentication.password.AbstractPasswordHandler;
import com.alfaariss.oa.authentication.password.IResourceHandler;
import com.alfaariss.oa.authentication.password.jndi.JNDIProtocolResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JNDIPasswordHandler
extends AbstractPasswordHandler {
    private final Log _logger = LogFactory.getLog(JNDIPasswordHandler.class);

    public void start(IConfigurationManager configManager, Element eConfig) throws OAException {
        super.start(configManager, eConfig);
        try {
            Element eResourceSection = configManager.getSection(eConfig, "resource");
            if (eResourceSection == null) {
                this._logger.error((Object)"no jndi resource defined");
                throw new OAException(17);
            }
            while (eResourceSection != null) {
                JNDIProtocolResource oProtocolHandler = new JNDIProtocolResource();
                oProtocolHandler.init(configManager, eResourceSection);
                if ("".equals(oProtocolHandler.getResourceRealm())) {
                    this.setResourceHandler((IResourceHandler)oProtocolHandler);
                } else {
                    this.addResourceHandler((IResourceHandler)oProtocolHandler);
                }
                eResourceSection = configManager.getNextSection(eResourceSection);
            }
            this.setDefault(configManager, eConfig);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during start of JNDIPasswordHandler", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
    }
}

